/*
 *  suse-blinux - Braille-display support for linux
 *  Author: Marco Skambraks <marco@suse.de>
 *  SuSE GmbH Nuernberg
 *
 *
 * suse-blinux based on brltty
 * special thanks to the Brltty-Team
 * Nicolas Pitre <nico@cam.org>
 * Stphane Doyon <s.doyon@videotron.ca>
 * Nikhil Nair <nn201@cus.cam.ac.uk>
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
*/

#include <termios.h>
#include "../brl.h"
extern struct brlinfo htdevs[];
extern int devnr;

/* unsigned char st_disp[4]; */

#ifndef VARIO_LOW_INCLUDE
#define VARIO_LOW_INCLUDE
	/*      Doesnt really know what this one does, seems to have no effect on the
	 *      display .. fishy! */
#define VARIO_RESET		0xff
	/*      Sent back from the display after a data display call */
#define VARIO_DISPLAY_DATA_ACK		0x7e
	/*      Header (and length of header) for sending the 40 display bytes */
#define VARIO_DISPLAY_DATA	"\001"
#define VARIO_DISPLAY_DATA_LEN	1
#define ST_MODULES 4
	/*      Cursor movement keys have codes in the range of 0x20-0x6f (left to right)
	 *      for press and 0xa0-0xef for release */
#define VARIO_CURSOR_BASE	0xa0
#define VARIO_CURSOR_COUNT	BRLCOLS
	/*      The six buttons press and release codes .. they are numbered from
	 *      top left to bottom right like:
	 *      1       4
	 *      2       5
	 *      3       6 */
#define VARIO_PUSHBUTTON_PRESS_1	0x04
#define VARIO_PUSHBUTTON_PRESS_2	0x03
#define VARIO_PUSHBUTTON_PRESS_3	0x08
#define VARIO_PUSHBUTTON_PRESS_4	0x07
#define VARIO_PUSHBUTTON_PRESS_5	0x0b
#define VARIO_PUSHBUTTON_PRESS_6	0x0f

#define VARIO_PUSHBUTTON_RELEASE_1	0x84
#define VARIO_PUSHBUTTON_RELEASE_2	0x83
#define VARIO_PUSHBUTTON_RELEASE_3	0x88
#define VARIO_PUSHBUTTON_RELEASE_4	0x87
#define VARIO_PUSHBUTTON_RELEASE_5	0x8b
#define VARIO_PUSHBUTTON_RELEASE_6	0x8f
#define B01_PRESS 0x03
#define B01_REL 0x83
#define B02_PRESS 0x07
#define B02_REL   0x87
#define B03_PRESS 0x0b
#define B03_REL  0x8b
#define B04_PRESS 0x0f
#define B04_REL   0x8f
#define B05_PRESS 0x04
#define B05_REL  0x84
#define B06_PRESS 0x08
#define B06_REL 0x88
#define B07_PRESS 0x13
#define B07_REL 0x93
#define B08_PRESS 0x17
#define B08_REL 0x97
#define B09_PRESS 0x1b
#define B09_REL 0x9b
#define B10_PRESS 0x1f
#define B10_REL  0x9f
/*
		bit		orig dot - 1
		0		0
		1		3
		2		1
		3		4
		4		2
		5		5
		6		6
		7		7
		
*/
#define CHAR_TO_VARIO_CHAR(a) (((a)&0xe1)|(((a)&0x02)<<2)|(((a)&0x04)>>1)|(((a)&0x08)<<1)|(((a)&0x10)>>2))

#define BRLCOLS htdevs[devnr].cols
#define BRL_ST_CELLS htdevs[devnr].st_cells

	/*      Open and set the serial port right */
int varioinit (char *dev);

	/*      Close the serial comm and flush buffers */
int varioclose ();

	/*      Send reset */
int varioreset ();

	/*      Send the ready formatted display byuffer to the vario */
int variodisplay (char *buff);

	/*      Check if any data available in the input buffers */
int variocheckwaiting ();

	/*      Get data from the varrio, block until available  */
int varioget ();

	/*      Translates the given buffer into vario special chars */
int variotranslate (unsigned char *frombuff, char *tobuff, int maxcnt);

#endif
