/*
 *  suse-blinux - Braille-display support for linux
 *  Author: Marco Skambraks <marco@suse.de>
 *  SuSE GmbH Nuernberg
 *
 *
 * suse-blinux based on brltty
 * special thanks to the Brltty-Team
 * Nicolas Pitre <nico@cam.org>
 * Stphane Doyon <s.doyon@videotron.ca>
 * Nikhil Nair <nn201@cus.cam.ac.uk>
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
*/

#include "../brl.h"
struct brlinfo fhpdevs[] = {
  {"el40s", "Braillex EL-40s", 40, 0, 0, 0, B57600},
  {"el66s", "Braillex EL-66s", 66, 0, 0, 0, B57600},
  {"el80s", "Braillex EL-80s", 80, 0, 0, 0, B57600},
  {"el2ds", "Braillex EL-2ds", 80, 20, 0, 20, B57600}
};

static int devnr = 0;

#define BRLCOLS	fhpdevs[devnr].cols
#define BRLROWS	1

#define FULLNAME	fhpdevs[devnr].fullname

#define BAUDRATE fhpdevs[devnr].baud

/* codes used in protocoll */
#define cSTX 02
#define cETX 03
#define cIdSend 'C'
#define cIdReceive 'K'
#define PRESSED 1

/* number of status cells */
#define PMSC fhpdevs[devnr].st_cells

/* offset within data structure */
#define offsetHorizontal fhpdevs[devnr].offhor
#define offsetVertical   fhpdevs[devnr].offvert
/* additional offset - use internal table */
#define offsetTable      512

/* debug output to /tmp/brltty.log */
#undef WR_DEBUG
#undef RD_DEBUG
/*
  #define WR_DEBUG
  #define RD_DEBUG
*/
