/*
 *  suse-blinux - Braille-display support for linux
 *  Author: Marco Skambraks <marco@suse.de>
 *  SuSE GmbH Nuernberg
 *
 *
 * suse-blinux based on brltty
 * special thanks to the Brltty-Team
 * Nicolas Pitre <nico@cam.org>
 * Stphane Doyon <s.doyon@videotron.ca>
 * Nikhil Nair <nn201@cus.cam.ac.uk>
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
*/

#include "../brl.h"
struct brlinfo fhpdevs[] = {
  {"tiny", "Braillex Tiny", 40, 1, 1, 0, B19200},
  {"2dlite", "Braillex 2d-Lite", 40, 13, 0, 13, B19200},
  {"2d", "Braillex 2d-screen", 80, 22, 0, 22, B19200},
  {"el80", "Braillex EL-80", 80, 2, 0, 2, B38400},
  {"el40", "Braillex EL-40", 40, 13, 0, 13, B38400},
  {"el40p", "Braillex el-40p", 40, 1, 1, 0, B38400},
  {"el66", "Braillex EL-66", 66, 13, 0, 13, B38400},
  {"el2d", "Braillex EL-2d", 80, 20, 0, 20, B38400}
};

static int devnr = 0;

#define BRLCOLS	fhpdevs[devnr].cols
#define BRLROWS	1

#define FULLNAME	fhpdevs[devnr].fullname

#define BAUDRATE fhpdevs[devnr].baud

/* codes used in protocoll */
#define cSTX 02
#define cETX 03
#define cIdSend 'S'
#define cIdReceive 'K'
#define PRESSED 1

/* number of status cells */
#define PMSC fhpdevs[devnr].st_cells

/* offset within data structure */
#define offsetHorizontal fhpdevs[devnr].offhor
#define offsetVertical   fhpdevs[devnr].offvert
/* additional offset - use internal table */
#define offsetTable      512

/* debug output to /tmp/brltty.log */
#undef WR_DEBUG
#undef RD_DEBUG
/*
  #define WR_DEBUG
  #define RD_DEBUG
*/
