#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <string.h>
#include <dlfcn.h>
#include "../libbrld.h"

brld_interface *brld = NULL;
void *libbrld = NULL;		/* handle to driver */

int main ()
{

  int pressed = 0, key = 0, keycnt = 0;
  int x = 0, y = 0;
  char tmpstr[MAX_MSG_LEN] = "";

  /* load libbrld */
  libbrld = dlopen ("libbrld.so", RTLD_LAZY);
  if (dlerror ())
   {
     fprintf (stderr, "libbrld open failed\n");
     return 1;
   }

/* load symbols */
  brld = (brld_interface *) dlsym (libbrld, "brld");

  brld->open ("localhost", 8888);
  brld->reg (TEXT, "default");

  brld->getxy (&x, &y);
  printf ("x=%d y=%d\n", x, y);

  if (!brld->getname (tmpstr))
    printf ("name=%s\n", tmpstr);

  if (!brld->getalias (tmpstr))
    printf ("alias=%s\n", tmpstr);

  do
   {
     key = 0;
     pressed = 0;
     key = brld->getkey (&pressed);

     if (key > 0)
      {
	printf ("key=%d %s\n", key, pressed ? "pressed" : "released");

/* now we ignore pressed keys  - only process keys if key is released */
	if (!pressed)
	 {
	   switch (keycnt)
	    {
	    case 0:
/* display "hello world" without a brl-cursor and without underlined text */
	      brld->write (-1, "hello world", NULL);
	      break;

	    case 1:
/* display "hello world" without brl-cursor and with an underlined "hello" */
	      brld->write (-1, "hello world", "-----      ");
	      break;

	    case 2:
/* display "hello world" with a brl-cursor between "hello" and "world"
 * without underlined text
 */
	      brld->write (5, "hello world", NULL);
	      break;

	    case 3:
/* display "hello world" without a brl-cursor and with an underlined "world" */
	      brld->write (-1, "hello world", "      -----");
	      break;
	    case 4:
/* display "hello world" wit a brl-cursor at first position
 * and with underlined "l" characters
 */
	      brld->write (0, "hello world", "  --     - ");
	      break;

	    }

	   keycnt++;

	 }
      }

     usleep (100);
   }
  while (keycnt < 5);

  usleep (5000);
  brld->close ();
  dlclose (libbrld);

  return 0;
}
