
/*
 * -*- mode: C; tab-width:8;  -*-
 * 
 *	aclX.c - ACL DD Mesa interface to Xlib
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * See the file aclMesa.c for more informations about authors
 */



#if defined(ACL)

#include "aclDrv.h"



#if 1
#define LOG_DEBUG
#endif

#define LOG_DBGINFO "<aclX>"
#include "log_debug.h"



ACLMesaXVidmode aclm_current_vidmode = NULL;



/*
 * Compare function for sorting video modes
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */
static int
aclXCompareVidModes(const void *first, const void *second)
{
    return ( ((XF86VidModeModeInfo *) first)->hdisplay -
	     ((XF86VidModeModeInfo *) second)->hdisplay);
}



/*
 * Setup DGA and screen resoultion (video modes)
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */
Tint
aclXInitVidModes(ACLMesaContext aclMesa, Display *dpy, GLuint needW,
	GLuint needH)
{
    Tuint scrW=0, scrH=0, scrBPP, virtualH, virtualW; 
    ACLScreen Scr = aclMesa->Scr;
    ACLMesaXVidmode vidmod;

LOG("aclXInitVidModes(): ###### ACLMesaXVidmode (malloc)\n");
    vidmod = (ACLMesaXVidmode) malloc(sizeof(struct aclmesa_xvidmode));
    if( !vidmod ) {
	return 1;
    }

/******************************************************************************
 * Get default screen data
 ******************************************************************************/

#if 0    
    scrBPP = DefaultDepth(dpy, XDefaultScreen(dpy));
#endif

    /*
     * better get the bpp value from pixmap formats
     */
    {
	XPixmapFormatValues *pmf;
	Tint count, i;
     
	/* get all pixmap formats */
	pmf = XListPixmapFormats (dpy, &count);

	/* initial bpp value */
	scrBPP = pmf[0].bits_per_pixel;      

	/* take the biggest bpp value */
	for (i=1; i<count; i++) {
	    if (pmf[i].bits_per_pixel > scrBPP)
	    scrBPP = pmf[i].bits_per_pixel;      
	}
LOG("aclXInitVidModes(): bpp=(%d)\n", scrBPP);
	XFree ((char *) pmf);
    }

    /*
     * Virtual Screen geometry
     */
    virtualW = DisplayWidth(dpy, XDefaultScreen(dpy));
    virtualH = DisplayHeight(dpy, XDefaultScreen(dpy));

    /*
     * we need the vidmode entries, not the screen entries; screenwidth
     * and screenheight are always the values of the biggest resolution
     * of all vidmodes
     */
    {
	XF86VidModeModeLine modeline;
	Tint dotclock;

	XF86VidModeGetModeLine(dpy,XDefaultScreen(dpy), &dotclock,&modeline);
      
	scrW = modeline.hdisplay;
	scrH = modeline.vdisplay;
LOG("aclXInitVidModes(): Current w,h=(%dx%d)\n", scrW, scrH);
    }

    /*
     * remember Display
     */
    vidmod->dpy = dpy;

/******************************************************************************
 * Switch to new video mode if required
 *****************************************************************************/
    if(aclMesa->acl_cfg & ACLOPT_VIDMODE_ON) {

	XF86VidModeModeInfo **vm_modelines;
	XF86VidModeModeInfo *new_vm_modelines;
	Tint vm_count, i;
      
	vidmod->vflags |= ACLOPT_VIDMODE_ON;

	/*
	 * change the current X11 video mode
	 */
	XF86VidModeGetAllModeLines(dpy,XDefaultScreen(dpy),
				 &vm_count,&vm_modelines);
      
	/*
	 * save current modeline
	 */
	vidmod->mode =
		(void *)malloc(sizeof(XF86VidModeModeInfo));
	if (!vidmod->mode) {
	    ERR("vidmod->mode (malloc)\n");
	    free( vidmod );  
	    return 1;
	}

	memcpy(vidmod->mode,(void *)(vm_modelines[0]),
		sizeof(XF86VidModeModeInfo));

#ifdef LOG_DEBUG
	MSG("VIDMODE: x11 modes (unsorted):\n");
	for (i = 0; i < vm_count; i++) {
	    if (i == 0) {
		MSG("VIDMODE: \t%d: %dx%d (current mode)\n", i,
			vm_modelines[i]->hdisplay,vm_modelines[i]->vdisplay);
	    }
	    else {
		MSG("VIDMODE: \t%d: %dx%d\n", i,vm_modelines[i]->hdisplay,
			vm_modelines[i]->vdisplay);
	    }
	}
#endif
      
	/*
	 * new array to be able to use qsort
	 */
	new_vm_modelines = (XF86VidModeModeInfo *) 
		malloc (vm_count * sizeof(XF86VidModeModeInfo));
	if (!new_vm_modelines) {
	    ERR("aclXInitVidModes() new_vm_modelines (malloc)\n");
	    free( vidmod->mode );
	    free( vidmod );  
	    return 1;
	}
      
	/*
	 * copy modeline entries to new array
	 */
	for (i = 0; i < vm_count; i++) 
	    memcpy(new_vm_modelines+i,*(vm_modelines+i),
		sizeof(XF86VidModeModeInfo));
      
	/*
	 * sort modelines ascending
	 */
	qsort(new_vm_modelines, vm_count, sizeof(XF86VidModeModeInfo), 
		aclXCompareVidModes);
      
	/*
	 * copy new modeline entries back to old array
	 */
	for (i = 0; i < vm_count; i++) 
	    memcpy(*(vm_modelines+i),new_vm_modelines+i,
		sizeof(XF86VidModeModeInfo));

#ifdef LOG_DEBUG
	MSG("VIDMODE: x11 modes (sorted):\n");
	for (i = 0; i < vm_count; i++) 
	    MSG("VIDMODE: \t%d: %dx%d\n", i,vm_modelines[i]->hdisplay,
		vm_modelines[i]->vdisplay);
#endif
      
	/*
	 * find best resolution
	 */
	for (i = 0; i < vm_count; i++) {
	    if ((needW <= vm_modelines[i]->hdisplay) &&
		(needH <= vm_modelines[i]->vdisplay)) {
LOG("aclXInitVidModes(): \tTo the best mode (%d)\n",i);
		XF86VidModeSwitchToMode(dpy,XDefaultScreen(dpy),
					vm_modelines[i]);
		scrW = vm_modelines[i]->hdisplay;
		scrH = vm_modelines[i]->vdisplay;
		break;
	    }

	    /*
	     * largest and last mode
	     */
	    if (i == vm_count-1) {
LOG("aclXInitVidModes(): \tTo the largest and last mode (%d)\n",i);
		XF86VidModeSwitchToMode(dpy,XDefaultScreen(dpy),
					vm_modelines[i]);
		scrW = vm_modelines[i]->hdisplay;
		scrH = vm_modelines[i]->vdisplay;
	    }
	}
    }

    XFlush(dpy);



/******************************************************************************
 * DGA setup
 *****************************************************************************/
    if(aclMesa->acl_cfg & ACLOPT_XDGA_OFF) {
	MSG("ACLOPT_XDGA_OFF set: X screen won't be saved!\n");
	vidmod->vflags |= ACLOPT_XDGA_OFF;
    }
    else while(1) {
	Tint event_base, error_base, flags;
	Tint viewport_width, viewport_height;
	Tint width, banksize, memsize;
	Tbyte dummy;
	
	/*
	 * check if DGA is available
	 */
	if (XF86DGAQueryExtension(dpy,&event_base,&error_base)) {
	    XF86DGAQueryDirectVideo(dpy,XDefaultScreen(dpy),&flags);
	    if( (flags & XF86DGADirectPresent) == 0) {
		MSG("DGA not present: X screen won't be saved!\n");
		vidmod->vflags |= ACLOPT_XDGA_OFF;
		break;
	    }
	}
	else {
	    MSG("DGA ext not present: X screen won't be saved!\n");
	    vidmod->vflags |= ACLOPT_XDGA_OFF;
	    break;
	}

	/*
	 * get visible screen area
	 */
	XF86DGAGetViewPortSize(dpy,XDefaultScreen(dpy),
			       &viewport_width, &viewport_height);

LOG("aclXInitVidModes(): Viewport (%dx%d)\n", viewport_width, viewport_height);
	/*
	 * move the viewport to the origin
	 */
	XF86DGASetViewPort(dpy,XDefaultScreen(dpy),0,0);
	
	/*
	 * enable DGA
	 */
	XF86DGADirectVideo(dpy,XDefaultScreen(dpy),
			   XF86DGADirectGraphics  
			/* XF86DGADirectMouse | XF86DGADirectKeyb */
	);

LOG("aclXInitVidModes(): DGA ENABLED\n");
	break;
    }

    aclm_current_vidmode = vidmod;

    Scr->VisibleWidth = scrW;
    Scr->VisibleHeight = scrH;
    Scr->VirtualWidth = virtualW;
    Scr->VirtualHeight = virtualH;
    Scr->ScreenBpp = scrBPP;

    return 0;
}

 

/*
 * Set screen into previous state
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */
void
aclXSetDefaultVidModes( void )
{
    Display *dpy;
    XF86VidModeModeInfo *mode;
    Tuint vflags;

LOG("aclXSetDefaultVidModes(): ######\n");

    if( !aclm_current_vidmode )
    	return;

    dpy = aclm_current_vidmode->dpy;
    mode = aclm_current_vidmode->mode;
    vflags = aclm_current_vidmode->vflags;

/******************************************************************************
 * disable DGA
 *****************************************************************************/
    if(!(vflags & ACLOPT_XDGA_OFF)) {
	XF86DGADirectVideo(dpy,XDefaultScreen(dpy),0);
LOG("aclXSetDefaultVidModes(): DGA DISABLED\n");
    }

/******************************************************************************
 * Switch to previous video mode if required
 *****************************************************************************/
    if (vflags & ACLOPT_VIDMODE_ON) {
	/*
	 * restore current modeline
	 */
	XF86VidModeSwitchToMode(dpy, XDefaultScreen(dpy), mode);
	XFlush(dpy);
	free(mode);
LOG("aclXSetDefaultVidModes(): (%dx%d)\n", mode->hdisplay, mode->vdisplay);
    }
}



#else

int aclX_dummy(void) { return 0; }

#endif /* ACL */

