
/*
 * -*- mode: C; tab-width:8;  -*-
 * 
 *	aclTex.c - Mesa device driver functions for texture mapping
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * See the file aclMesa.c for more informations about authors
 */

#if defined(ACL)

#include "aclDrv.h"



#if 0
#define LOG_DEBUG
#endif

#define LOG_DBGINFO "<aclTex>"
#include "log_debug.h"



#define ACLMESA_TEX_INITFUNC \
	ACLMesaContext aclMesa = (ACLMesaContext) ctx->DriverCtx; \
	ACLTexMod acltex_mod = aclMesa->acltex_mod; \
	ACLContext aclctx = aclMesa->aclctx



void
aclTexEnv(GLcontext *ctx, GLenum pname, const GLfloat *params)
{
    ACLMESA_TEX_INITFUNC;

LOG("aclTexEnv(): ######\n");
    acltex_mod->Env(aclctx, pname, params);
}



void
aclTexImage(GLcontext * ctx, GLenum target, struct gl_texture_object *tObj,
	GLint level, GLint internalFormat, const struct gl_texture_image *image)
{
    ACLMESA_TEX_INITFUNC;

LOG("aclTexImage(): ######\n");

    if(!tObj->DriverData)
	tObj->DriverData = acltex_mod->AllocTexObjData(aclctx);

    if(acltex_mod->TranslateImage(aclctx, (const ACLTexImage) image, level,
		internalFormat, tObj->Name, tObj->DriverData)) {
	acltex_mod->DownloadToTexMem(aclctx, level, tObj->DriverData);
    }
    else {
	ERR("aclTexImage(): format=(%d)\n", internalFormat);
    }
}



void
aclTexParam(GLcontext * ctx, GLenum target, struct gl_texture_object *tObj,
	GLenum pname, const GLfloat * params)
{
    ACLMESA_TEX_INITFUNC;

LOG("aclTexParam(): ######\n");

    if (!tObj->DriverData)
	tObj->DriverData = acltex_mod->AllocTexObjData(aclctx);

    acltex_mod->Param(aclctx, target, pname, params, tObj->DriverData);    
}



void
aclTexBind(GLcontext *ctx, GLenum target, struct gl_texture_object *tObj)
{
    ACLMESA_TEX_INITFUNC;

LOG("aclTexBind(): ######\n");

    if (!tObj->DriverData)
	tObj->DriverData = acltex_mod->AllocTexObjData(aclctx);

    acltex_mod->Bind(aclctx, tObj->Name, tObj->DriverData);
}



void
aclTexDel(GLcontext * ctx, struct gl_texture_object *tObj)
{
    ACLMESA_TEX_INITFUNC;

LOG("aclTexDel(): ######\n");

    if (tObj->DriverData)
	tObj->DriverData = acltex_mod->TexDel(aclctx, tObj->DriverData);
}



void
aclTexSubImage(GLcontext * ctx, GLenum target, struct gl_texture_object *tObj,
	GLint level, GLint xoffset, GLint yoffset, GLint width, GLint height,
	GLint internalFormat, const struct gl_texture_image *image)
{
    ACLMESA_TEX_INITFUNC;

LOG("aclTexSubImage(): ######\n");

    if (!tObj->DriverData)
	tObj->DriverData = acltex_mod->AllocTexObjData(aclctx);

    acltex_mod->SubImage(aclctx, target, tObj->DriverData, level,
	xoffset, yoffset, width, height, internalFormat,
	(const ACLTexImage) image);
}



void
aclTexUpdatePalette(GLcontext * ctx, struct gl_texture_object *tObj)
{
    ACLMESA_TEX_INITFUNC;

LOG("aclTexUpdatePalette(): ######\n");

    if (tObj) {
	if (!tObj->DriverData)
	    tObj->DriverData = acltex_mod->AllocTexObjData(aclctx);

	acltex_mod->Palette(aclctx, tObj->PaletteSize, (unsigned int *)
	    tObj->Palette, tObj->DriverData);
    }
    else {
	if (ctx->Texture.PaletteSize) {
	    acltex_mod->DownloadGlobalPalette(aclctx, ctx->Texture.PaletteSize,
		(unsigned int *) ctx->Texture.Palette, NULL);
	}
    }
}



void
aclTexUseGlobalPalette(GLcontext * ctx, GLboolean state)
{
    ACLMESA_TEX_INITFUNC;

LOG("aclTexUseGlobalPalette(): ######\n");
LOG("aclTexUseGlobalPalette(): state=(%d)!\n", state);

    if (state) {
	acltex_mod->SwitchToGlobalPalette(aclctx);
    }
    else {
	if (ctx->Texture.Set[0].Current) {
	    struct gl_texture_object *tObj = ctx->Texture.Set[0].Current;

	    if (!tObj->DriverData)
		tObj->DriverData = acltex_mod->AllocTexObjData(aclctx);

	    acltex_mod->DownloadGlobalPalette(aclctx, tObj->PaletteSize,
		(unsigned int *) tObj->Palette, tObj->DriverData);
	}
    }
}



#else

int aclTex_dummy(void) { return 0; }

#endif	/* ACL */
