
/*
 * -*- mode: C; tab-width:8;  -*-
 * 
 *	aclSetup.c -
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * See the file aclMesa.c for more informations about authors
 */



#if defined(ACL)

#include "aclDrv.h"



#if 0
#define LOG_DEBUG
#endif

#define LOG_DBGINFO "<aclSetup>"
#include "log_debug.h"



void
aclSetupTexture(GLcontext *ctx)
{
    ACLMesaContext aclMesa = ( ACLMesaContext ) ctx->DriverCtx;
LOG("aclSetupTexture(): ######\n");
}



void
aclSetupBlend(GLcontext *ctx)
{
    ACLMesaContext aclMesa = ( ACLMesaContext ) ctx->DriverCtx;
LOG("aclSetupBlend(): ######\n");

#if 0
    accelmod->SetBlend(aclMesa, ctx->Color.BlendEnabled, ctx->Color.BlendSrc,
		       ctx->Color.BlendDst);
#endif

}



void
aclSetupAlpha(GLcontext *ctx)
{
    ACLMesaContext aclMesa = ( ACLMesaContext ) ctx->DriverCtx;
LOG("aclSetupAlpha(): ######\n");

#if 0
    accelmod->SetAlpha(aclMesa, ctx->Color.AlphaEnabled, ctx->Color.AlphaFunc, 
		       ctx->Color.AlphaRef);
#endif

}



void
aclSetupDepth(GLcontext *ctx)
{
    ACLMesaContext aclMesa = ( ACLMesaContext ) ctx->DriverCtx;
    ACLLBMod acllb_mod = aclMesa->acllb_mod;
LOG("aclSetupDepth(): ######\n");

    if(ctx->Depth.Test) {
LOG("aclSetupDepth(): Depth.Test TRUE\n");
	acllb_mod->DepthFunc(aclMesa->aclctx, ctx->Depth.Func);
	if(ctx->Depth.Mask)
	    acllb_mod->DepthMask(aclMesa->aclctx, ACLGL_TRUE);
	else
	    acllb_mod->DepthMask(aclMesa->aclctx, ACLGL_FALSE);
	acllb_mod->EnableDepth(aclMesa->aclctx, 1);
    }
    else {
LOG("aclSetupDepth(): Depth.Test FALSE\n");
	acllb_mod->DepthFunc(aclMesa->aclctx, ACLGL_ALWAYS);
	acllb_mod->DepthMask(aclMesa->aclctx, ACLGL_FALSE);
	acllb_mod->EnableDepth(aclMesa->aclctx, 0);
    }
}



void
aclSetupStencil(GLcontext *ctx)
{
    ACLMesaContext aclMesa = ( ACLMesaContext ) ctx->DriverCtx;
    ACLLBMod acllb_mod = aclMesa->acllb_mod;
LOG("aclSetupStencil(): ######\n");

    if (ctx->Stencil.Enabled) {
LOG("aclSetupStencil(): Stencil.Enabled TRUE\n");
	acllb_mod->ClearStencil(aclMesa->aclctx,ctx->Stencil.Clear);

	acllb_mod->StencilFunc(aclMesa->aclctx, ctx->Stencil.Function,
						   ctx->Stencil.Ref, 
						   ctx->Stencil.ValueMask);
						   
	acllb_mod->StencilOp(aclMesa->aclctx, ctx->Stencil.FailFunc, 
						 ctx->Stencil.ZFailFunc, 
						 ctx->Stencil.ZPassFunc);
	acllb_mod->EnableStencil(aclMesa->aclctx, 1);
    }
    else {
LOG("aclSetupStencil(): Stencil.Enabled FALSE\n");
	acllb_mod->EnableStencil(aclMesa->aclctx, 0);
    }
}



void
aclSetupFog(GLcontext *ctx)
{
    ACLMesaContext aclMesa = ( ACLMesaContext ) ctx->DriverCtx;
LOG("aclSetupFog(): ######\n");

    if((ctx->Fog.Enabled) && (ctx->FogMode == FOG_FRAGMENT)) {

#if 0
    accelmod->SetFog(aclMesa, ctx->Fog.Enabled,
		     ctx->FogMode, ctx->Fog.Density,
		     ctx->Fog.Color[0], 
		     ctx->Fog.Color[1], 
		     ctx->Fog.Color[2],
		     ctx->Fog.Color[3]);
#endif

    }
}




void
aclSetupScissor(GLcontext *ctx)
{
    ACLMesaContext aclMesa = ( ACLMesaContext ) ctx->DriverCtx;
LOG("aclSetupScissor(): ######\n");
}



void
aclSetupPoints(GLcontext *ctx)
{
    ACLMesaContext aclMesa = ( ACLMesaContext ) ctx->DriverCtx;
    ACLContext aclctx = aclMesa->aclctx;
LOG("aclSetupPoints(): ######\n");

    aclctx->render_cfg.antialias = 0;

    if(ctx->Point.SmoothFlag)
	aclctx->render_cfg.antialias |= (ACLPRIM_POINTS);
}



void
aclSetupLine(GLcontext *ctx)
{
    ACLMesaContext aclMesa = ( ACLMesaContext ) ctx->DriverCtx;
    ACLContext aclctx = aclMesa->aclctx;
LOG("aclSetupLine(): ######\n");

    aclctx->render_cfg.stipple = 0;
    aclctx->render_cfg.antialias = 0;

    if(ctx->Line.StippleFlag)
	aclctx->render_cfg.stipple |= (ACLPRIM_LINE);

    if(ctx->Line.SmoothFlag)
	aclctx->render_cfg.antialias |= (ACLPRIM_LINE);
}



void
aclSetupPolygon(GLcontext *ctx)
{
    ACLMesaContext aclMesa = ( ACLMesaContext ) ctx->DriverCtx;
    ACLContext aclctx = aclMesa->aclctx;
LOG("aclSetupPolygon(): ######\n");

    aclctx->render_cfg.stipple = 0;
    aclctx->render_cfg.antialias = 0;

    if(ctx->Polygon.OffsetAny)
LOG("aclSetupPolygon(): OffsetAny not supported!\n");

    if(ctx->Polygon.StippleFlag)
	aclctx->render_cfg.stipple |= (ACLPRIM_TRIANGLE);

    if(ctx->Polygon.SmoothFlag)
	aclctx->render_cfg.antialias |= (ACLPRIM_TRIANGLE);
}



void
aclSetupUnits(GLcontext *ctx)
{
    ACLMesaContext aclMesa = ( ACLMesaContext ) ctx->DriverCtx;

LOG("aclSetupUnits(): ######\n");

    aclSetupTexture(ctx);
    aclSetupBlend(ctx);
    aclSetupAlpha(ctx);
    aclSetupDepth(ctx);
/*
    aclSetupStencil(ctx);
    aclSetupFog(ctx);
    aclSetupScissor(ctx);
*/
    aclSetupPoints(ctx);
    aclSetupLine(ctx);
    aclSetupPolygon(ctx);

    if(ctx->Color.ColorMask) {
	aclMesa->aclrgba_mod->ColorMask(aclMesa->aclctx,
	0xff, 0xff, 0xff, (aclMesa->is_alpha ? 0xff : 0x00));
    }
    else {
	aclMesa->aclrgba_mod->ColorMask(aclMesa->aclctx,
	0x0, 0x0, 0x0, 0x0);
    }
}



#else

int aclSetup_dummy(void) { return 0; }

#endif /* ACL */

