
/*
 * -*- mode: C; tab-width:8;  -*-
 * 
 *	aclSW.c - Pixel and span (software) functions
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * See the file aclMesa.c for more informations about authors
 */

#if defined(ACL)

#include "aclDrv.h"



#if 0
#define LOG_DEBUG
#endif

#define LOG_DBGINFO "<aclSW>"
#include "log_debug.h"



#define ACLMESA_SW_RGBA_INITFUNC \
	ACLMesaContext aclMesa = (ACLMesaContext) ctx->DriverCtx; \
	ACLColorRGBAMod aclrgba_mod = aclMesa->aclrgba_mod

#define ACLMESA_SW_CI_INITFUNC \
	ACLMesaContext aclMesa = (ACLMesaContext) ctx->DriverCtx; \
	ACLColorCIMod aclci_mod = aclMesa->aclci_mod

#define ACLMESA_SW_DEPTH_INITFUNC \
	ACLMesaContext aclMesa = (ACLMesaContext) ctx->DriverCtx; \
	ACLLBMod acllb_mod = aclMesa->acllb_mod



/******************************************************************************
 *                             SW span functions                              *
 ******************************************************************************/

static void
aclSWWriteRGBASpan(const GLcontext *ctx, GLuint n, GLint x, GLint y,
	const GLubyte rgba[][4], const GLubyte mask[])
{
    ACLMESA_SW_RGBA_INITFUNC;
LOG("aclSWWriteRGBASpan(): ######\n");
    aclrgba_mod->FBWriteRGBAPixels(aclMesa->aclctx, n, &x, &y,
	(const void **) rgba, mask, ACLFLAG_ALPHA | ACLFLAG_SPAN );
}



static void
aclSWWriteRGBSpan(const GLcontext *ctx, GLuint n, GLint x, GLint y,
	const GLubyte rgb[][3], const GLubyte mask[])
{
    ACLMESA_SW_RGBA_INITFUNC;
LOG("aclSWWriteRGBSpan(): ######\n");
    aclrgba_mod->FBWriteRGBAPixels(aclMesa->aclctx, n, &x, &y,
	(const void **) rgb, mask, ACLFLAG_SPAN );
}



static void
aclSWWriteMonoRGBASpan(const GLcontext *ctx, GLuint n, GLint x, GLint y,
	const GLubyte mask[])
{
    ACLMESA_SW_RGBA_INITFUNC;
LOG("aclSWWriteMonoRGBASpan(): ######\n");
    aclrgba_mod->FBWriteRGBAPixels(aclMesa->aclctx, n, &x, &y,
	NULL, mask, ACLFLAG_SPAN | ACLFLAG_ALPHA | ACLFLAG_MONO );
}



static void
aclSWReadRGBASpan(const GLcontext *ctx,
	GLuint n, GLint x, GLint y, GLubyte rgba[][4])
{
    ACLMESA_SW_RGBA_INITFUNC;
LOG("aclSWReadRGBASpan(): ######\n");
    aclrgba_mod->FBReadRGBAPixels(aclMesa->aclctx, n, &x, &y,
	(void **) rgba, NULL, ACLFLAG_ALPHA | ACLFLAG_SPAN );
}



/******************************************************************************
 *                            SW pixels functions                             *
 ******************************************************************************/

static void
aclSWWriteRGBAPixels(const GLcontext *ctx, GLuint n, const GLint x[],
	const GLint y[], CONST GLubyte rgba[][4], const GLubyte mask[])
{
    ACLMESA_SW_RGBA_INITFUNC;
LOG("aclSWWriteRGBAPixels(): ######\n");
    aclrgba_mod->FBWriteRGBAPixels(aclMesa->aclctx, n, x, y,
	(const void **) rgba, mask, ACLFLAG_ALPHA );
}



static void
aclSWWriteMonoRGBAPixels(const GLcontext *ctx, GLuint n, const GLint x[],
	const GLint y[], const GLubyte mask[])
{
    ACLMESA_SW_RGBA_INITFUNC;
LOG("aclSWWriteMonoRGBAPixels(): ######\n");
    aclrgba_mod->FBWriteRGBAPixels(aclMesa->aclctx, n, x, y,
	NULL, mask, ACLFLAG_ALPHA | ACLFLAG_MONO );
}



static void
aclSWReadRGBAPixels(const GLcontext *ctx, GLuint n, const GLint x[],
	const GLint y[], GLubyte rgba[][4], const GLubyte mask[])
{
    ACLMESA_SW_RGBA_INITFUNC;
LOG("aclSWReadRGBAPixels(): ######\n");
    aclrgba_mod->FBReadRGBAPixels(aclMesa->aclctx, n, x, y,
	(void **) rgba, mask, ACLFLAG_ALPHA );
}



/******************************************************************************
 *                            SW depth functions                              *
 ******************************************************************************/

static void
aclSWReadDepthSpanFloat(GLcontext *ctx, GLuint n, GLint x, GLint y,
	GLfloat depth[])
{
    ACLMESA_SW_DEPTH_INITFUNC;
    GLuint i;
    Tuint data[MAX_WIDTH];
    
LOG("aclSWReadDepthSpanFloat(): ######\n");

    acllb_mod->LBReadPixels(aclMesa->aclctx, n, &x, &y,
	data, NULL, NULL, ACLFLAG_DEPTH | ACLFLAG_SPAN);

    /*
     *convert the read values to float values [0.0 .. 1.0].
     */
    for(i=0;i<n;i++)
	depth[i]=data[i]/65535.0f;
}



static void
aclSWReadDepthSpanInt(GLcontext *ctx, GLuint n, GLint x, GLint y,
	GLdepth depth[])
{
    ACLMESA_SW_DEPTH_INITFUNC;
    GLuint i;
    Tuint data[MAX_WIDTH];

LOG("aclSWReadDepthSpanInt(): ######\n");

    acllb_mod->LBReadPixels(aclMesa->aclctx, n, &x, &y,
	data, NULL, NULL, ACLFLAG_DEPTH | ACLFLAG_SPAN);

    /*
     * copy the read values to short values
     */
    for(i=0;i<n;i++)
	depth[i] = (GLdepth) data[i];
}



static GLuint
aclSWDepthTestSpan(GLcontext *ctx, GLuint n, GLint x, GLint y,
	const GLdepth z[], GLubyte mask[])
{
    ACLMESA_SW_DEPTH_INITFUNC;
    GLubyte *m=mask;
    GLuint i;
    GLuint passed=0;
    Tuint *depthdata = (Tuint *)malloc(n * sizeof(Tuint));
    Tuint *zptr=depthdata;

LOG("aclSWDepthTestSpan(): ######\n");

    acllb_mod->LBReadPixels(aclMesa->aclctx, n, &x, &y,
	depthdata, NULL, NULL, ACLFLAG_DEPTH | ACLFLAG_SPAN);

  /* switch cases ordered from most frequent to less frequent */
  switch (ctx->Depth.Func) {
  case GL_LESS:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0; i<n; i++,zptr++,m++) {
	if (*m) {
	  if (z[i] < *zptr) {
	    /* pass */
	    *zptr = z[i];
	    passed++;
	  } else {
	    /* fail */
	    *m = 0;
	  }
	}
      }
    } else {
      /* Don't update Z buffer */
      for (i=0; i<n; i++,zptr++,m++) {
	if (*m) {
	  if (z[i] < *zptr) {
	    /* pass */
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    }
    break;
  case GL_LEQUAL:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] <= *zptr) {
	    *zptr = z[i];
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    } else {
      /* Don't update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] <= *zptr) {
	    /* pass */
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    }
    break;
  case GL_GEQUAL:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] >= *zptr) {
	    *zptr = z[i];
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    } else {
      /* Don't update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] >= *zptr) {
	    /* pass */
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    }
    break;
  case GL_GREATER:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] > *zptr) {
	    *zptr = z[i];
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    } else {
      /* Don't update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] > *zptr) {
	    /* pass */
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    }
    break;
  case GL_NOTEQUAL:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] != *zptr) {
	    *zptr = z[i];
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    } else {
      /* Don't update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] != *zptr) {
	    /* pass */
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    }
    break;
  case GL_EQUAL:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] == *zptr) {
	    *zptr = z[i];
	    passed++;
	  } else {
	    *m =0;
	  }
	}
      }
    } else {
      /* Don't update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] == *zptr) {
	    /* pass */
	    passed++;
	  } else {
	    *m =0;
	  }
	}
      }
    }
    break;
  case GL_ALWAYS:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  *zptr = z[i];
	  passed++;
	}
      }
    } else {
      /* Don't update Z buffer or mask */
      passed = n;
    }
    break;
  case GL_NEVER:
    for (i=0;i<n;i++) {
      mask[i] = 0;
    }
    break;
  default:
    ;
  } /*switch*/


    if(passed) acllb_mod->LBWritePixels(aclMesa->aclctx, n, &x, &y,
	depthdata, NULL, NULL, ACLFLAG_DEPTH);

    free(depthdata);
    return passed;
}



static void
aclSWDepthTestPixels(GLcontext* ctx, GLuint n, const GLint x[],
	const GLint y[], const GLdepth z[], GLubyte mask[])
{
    ACLMESA_SW_DEPTH_INITFUNC;
    GLubyte *m=mask;
    GLuint i;
    GLuint passed=0;

    Tuint *depthdata = (Tuint *)malloc(n * sizeof(Tuint));
    Tuint *zptr=depthdata;

LOG("aclSWDepthTestPixels(): ######\n");

    acllb_mod->LBReadPixels(aclMesa->aclctx, n, x, y,
	depthdata, NULL, NULL, ACLFLAG_DEPTH);

  /* switch cases ordered from most frequent to less frequent */

  switch (ctx->Depth.Func) {
  case GL_LESS:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0; i<n; i++,zptr++,m++) {
	if (*m) {
	  if (z[i] < *zptr) {
	    /* pass */
	    *zptr = z[i];
	    passed++;
	  } else {
	    /* fail */
	    *m = 0;
	  }
	}
      }
    } else {
      /* Don't update Z buffer */
      for (i=0; i<n; i++,zptr++,m++) {
	if (*m) {
	  if (z[i] < *zptr) {
	    /* pass */
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    }
    break;
  case GL_LEQUAL:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] <= *zptr) {
	    *zptr = z[i];
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    } else {
      /* Don't update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] <= *zptr) {
	    /* pass */
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    }
    break;
  case GL_GEQUAL:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] >= *zptr) {
	    *zptr = z[i];
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    } else {
      /* Don't update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] >= *zptr) {
	    /* pass */
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    }
    break;
  case GL_GREATER:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] > *zptr) {
	    *zptr = z[i];
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    } else {
      /* Don't update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] > *zptr) {
	    /* pass */
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    }
    break;
  case GL_NOTEQUAL:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] != *zptr) {
	    *zptr = z[i];
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    } else {
      /* Don't update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] != *zptr) {
	    /* pass */
	    passed++;
	  } else {
	    *m = 0;
	  }
	}
      }
    }
    break;
  case GL_EQUAL:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] == *zptr) {
	    *zptr = z[i];
	    passed++;
	  } else {
	    *m =0;
	  }
	}
      }
    } else {
      /* Don't update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  if (z[i] == *zptr) {
	    /* pass */
	    passed++;
	  } else {
	    *m =0;
	  }
	}
      }
    }
    break;
  case GL_ALWAYS:
    if (ctx->Depth.Mask) {
      /* Update Z buffer */
      for (i=0;i<n;i++,zptr++,m++) {
	if (*m) {
	  *zptr = z[i];
	  passed++;
	}
      }
    } else {
      /* Don't update Z buffer or mask */
      passed = n;
    }
    break;
  case GL_NEVER:
    for (i=0;i<n;i++) {
      mask[i] = 0;
    }
    break;
  default:
    ;
  } /*switch*/


    if(passed) acllb_mod->LBWritePixels(aclMesa->aclctx, n, x, y,
	depthdata, NULL, NULL, ACLFLAG_DEPTH);

    free(depthdata);
    return;
}



/******************************************************************************
 ******************************************************************************/

void
aclSWSetupDDDepthPointers(GLcontext *ctx)
{

LOG("aclSWSetupDDDepthPointers(): ######\n");

    ctx->Driver.DepthTestSpan = aclSWDepthTestSpan;
    ctx->Driver.DepthTestPixels = aclSWDepthTestPixels;
    ctx->Driver.ReadDepthSpanFloat = aclSWReadDepthSpanFloat;
    ctx->Driver.ReadDepthSpanInt = aclSWReadDepthSpanInt;
}



void
aclSWSetupDDPointers(GLcontext *ctx)
{
    ACLMesaContext aclMesa = (ACLMesaContext) ctx->DriverCtx;

LOG("aclSWSetupDDPointers(): ######\n");

/* RGBA */
    ctx->Driver.WriteRGBASpan = aclSWWriteRGBASpan;
    ctx->Driver.WriteRGBSpan = aclSWWriteRGBSpan;
    ctx->Driver.WriteMonoRGBASpan = aclSWWriteMonoRGBASpan;
    ctx->Driver.WriteRGBAPixels = aclSWWriteRGBAPixels;
    ctx->Driver.WriteMonoRGBAPixels = aclSWWriteMonoRGBAPixels;
    ctx->Driver.ReadRGBASpan = aclSWReadRGBASpan;
    ctx->Driver.ReadRGBAPixels = aclSWReadRGBAPixels;

/* CI */
    ctx->Driver.WriteCI8Span = NULL;
    ctx->Driver.WriteCI32Span = NULL;
    ctx->Driver.WriteMonoCISpan = NULL;
    ctx->Driver.WriteCI32Pixels = NULL;
    ctx->Driver.WriteMonoCIPixels = NULL;
    ctx->Driver.ReadCI32Span = NULL;
    ctx->Driver.ReadCI32Pixels = NULL;
}



#else

int aclSW_dummy(void) { return 0; }

#endif /* ACL */
