
/*
 * -*- mode: C; tab-width:8;  -*-
 * 
 *	aclPoints.c -
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * See the file aclMesa.c for more informations about authors
 */



#if defined(ACL)

#include "aclDrv.h"



#if 0
#define LOG_DEBUG
#endif

#define LOG_DBGINFO "<aclPoints>"
#include "log_debug.h"



static void
aclPointsDraw(GLcontext *ctx, GLuint first, GLuint last)
{
}



static void
aclPointsDrawFrontBack(GLcontext *ctx, GLuint first, GLuint last)
{
}



points_func aclPointsChooseFunction(GLcontext *ctx)
{
    ACLMesaContext aclMesa = (ACLMesaContext) ctx->DriverCtx;

LOG("aclPointsChooseFunction():  ######\n");

    if(aclMesa->no_primitive & ACLPRIM_POINTS)
	return NULL;

    if( (ctx->Point.Size!=1.0f) ||
	!(ctx->Point.Params[0] == 1.0 &&
	  ctx->Point.Params[1] == 0.0 &&
	  ctx->Point.Params[2] == 0.0) )
    {
LOG("Not supported: ===> Point params\n");
	return NULL;
    }

    if(ctx->RasterMask & FRONT_AND_BACK_BIT) {
	return aclPointsDrawFrontBack;
    }
    return aclPointsDraw;
}



#else

int aclPoints_dummy(void) { return 0; }

#endif /* ACL */

