
/*
 * -*- mode: C; tab-width:8;  -*-
 *
 *	aclDrv.h - driver types
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * See the file aclMesa.c for more informations about authors
 */

#ifndef ACLDRV_H
#define ACLDRV_H

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <assert.h>
#include <unistd.h>
#include <signal.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdarg.h>

#include "context.h"
#include "macros.h"
#include "matrix.h"
#include "texture.h"
#include "types.h"
#include "vb.h"
#include "xform.h"
#include "clip.h"
#include "vbrender.h"

#include <X11/Xlib.h>
#include <X11/extensions/xf86dga.h>
#include <X11/extensions/xf86vmode.h>

#include <GL/aclmesa.h>



typedef struct aclmesa_xvidmode	*ACLMesaXVidmode;

typedef void (*ACLMesaSighandler)(int);

typedef GLboolean (*ACLMesaRenderVBFunc)(GLcontext *, GLboolean);

typedef void (*ACLMesaRSetupFunc)(GLcontext *, GLuint, GLuint);



/*
 * Texture node
 */
typedef struct aclmesa_tm_node {
    Tint priority;			/* priority of the node - low/high */
    Tbool is_insert;			/* insertation point for the new ? */
    struct aclmesa_tm_node *next;	/* list of nodes in TM ordered */
    struct aclmesa_tm_node *prev;
    struct aclmesa_tm_node *hwleft;	/* list of nodes in tex RAM ordered */
    struct aclmesa_tm_node *hwright;
    Tulong start;			/* position of the block in hw */
    Tulong end;
} ACLMesaTMNode;



/*
 * The nodes are organized in two lists: first, the priority list, which sorts
 * nodes after their usage, and second, the allocated blocks list, which sorts
 * nodes in the way they are physicaly stored in texture ram.
 */
typedef struct {
    Tint bindNumber;			/* currently bound image */
    Tint freeTexMem;			/* amount of free tex memory in hw */
    ACLMesaTMNode *firstFreeNode;	/* first free block */
    ACLMesaTMNode *firstFreeNodeHw;	/* first free block in hardware */
    ACLMesaTMNode *firstUsedNode;	/* loaded nodes, lowest priority */
    ACLMesaTMNode *insertNode;		/* last node allocated, not bound yet */
    ACLMesaTMNode *lastUsedNode;	/* loaded nodes, highest priority */
} ACLMesaTMContext;



typedef struct {
    GLsizei width;
    GLsizei height;
    void *data;
} ACLMesaTexMipMapLevel;



/*
 * This structure is pointed gl_texture_object->DriverData and includes several
 * driver information related to the texture object
 */
typedef struct {
    Tbool is_valid;		/* hardware support already checked ? */
    Tbool is_supported;		/* supported in hardware ? */
    Tbool is_loaded;		/* loaded into hardware ? */
    Tbool is_translated;	/* translated into hardware format ? */

    Tuint texunit;		/* which hardware tex-unit is used ? */

    ACLMesaTexMipMapLevel *mml[ACLDIM_MAX_LODS];	/* the image data */

    ACLMesaTMNode *node;	/* the corresponding node in list of nodes */

    ACLglenum sClampMode;	/* ACLGL_CLAMP or ACLGL_REPEAT */
    ACLglenum tClampMode;

    ACLglenum minFilterMode;	/* ACLGL_NEAREST or ACLGL_LINEAR */
    ACLglenum magFilterMode;
} ACLMesaTexDriverData;



struct aclmesa_context {
    ACLAccelMod aclaccel_mod;	/* accel module */
    ACLLBMod acllb_mod;		/* local buffer module */
    ACLTexMod acltex_mod;	/* tex module */

    ACLModules aclmod;		/* ACL modules */
    ACLContext aclctx;		/* low-level renderer context */

    GLcontext *glCtx;		/* the core Mesa context */
    GLvisual *glVis;		/* describes the color buffer */
    GLframebuffer *glBuffer;	/* the ancillary buffers */

    ACLColorRGBAMod aclrgba_mod; /* color RGBA module */
    ACLColorCIMod aclci_mod;	/* color CI module */
    
    struct acl_features hwf;	/* the 3d features supported in hardware */

    Tint board;			/* the board used for this context */
    Tint width, height;		/* size of color buffer */

    GLenum front_face;

    ACLMesaTMContext *TMCtx;	/* texture manager context */

    struct acl_vertices vb_pointers;

    points_func fpoints;
    line_func fline;
    triangle_func ftriangle;
    quad_func fquad;
    rect_func frect;
    ACLMesaRenderVBFunc frendervb;
    ACLMesaRSetupFunc frsetup;

    Tbool is_alpha;
    Tbool is_dbuffer;
    Tbool is_globtexpal;

    Tbool verbose;

    ACLScreen Scr;
    ACLflags acl_cfg;
    ACLflags no_primitive;
    
    ACLglenum current_buffer;
};



struct aclmesa_xvidmode {
    Display *dpy;
    XF86VidModeModeInfo *mode;
    Tuint vflags;
};



/*** aclDD.c *****************************************************************/
extern void aclDDSetupDDPointers
	(GLcontext *ctx);

extern void aclDDBufferSize
	(GLcontext *ctx, GLuint *width, GLuint *height);



/*** aclTM.c *****************************************************************/
extern void aclTMCreateContext
	(ACLMesaContext aclMesa);



/*** aclTex.c ****************************************************************/
extern void aclTexEnv
	(GLcontext *ctx, GLenum pname, const GLfloat *params);

extern void aclTexImage
	(GLcontext *ctx, GLenum target, struct gl_texture_object *tobj,
	 GLint level, GLint internalFormat, const struct gl_texture_image *img);

extern void aclTexParam
	(GLcontext * ctx, GLenum target, struct gl_texture_object *tObj,
	 GLenum pname, const GLfloat * params);

extern void aclTexBind
	(GLcontext *ctx, GLenum target, struct gl_texture_object *tObj);

extern void aclTexDel
	(GLcontext * ctx, struct gl_texture_object *tObj);

extern void aclTexSubImage
	(GLcontext * ctx, GLenum target, struct gl_texture_object *tObj,
	 GLint level, GLint xoffset, GLint yoffset, GLint width, GLint height,
	 GLint internalFormat, const struct gl_texture_image *image);

extern void aclTexUpdatePalette
	(GLcontext * ctx, struct gl_texture_object *tObj);

extern void aclTexUseGlobalPalette
	(GLcontext * ctx, GLboolean state);



/*** aclX.c ******************************************************************/
extern GLint aclXInitVidModes
	(ACLMesaContext aclctx, Display *dpy, GLuint needW, GLuint needH);

extern void aclXSetDefaultVidModes
	(void);



/*** aclSetup.c **************************************************************/
extern void aclSetupTexture
	(GLcontext *ctx);

extern void aclSetupUnits
	(GLcontext *ctx);



/*** Miscelaneous: ***********************************************************/
extern points_func aclPointsChooseFunction
	(GLcontext *ctx);

extern line_func aclLineChooseFunction
	(GLcontext *ctx);

extern triangle_func aclTriangleChooseFunction
	(GLcontext *ctx);

extern quad_func aclQuadChooseFunction
	(GLcontext *ctx);

extern rect_func aclRectChooseFunction
	(GLcontext *ctx);

extern ACLMesaRenderVBFunc aclRenderVBChooseFunction
	(GLcontext *ctx);

extern ACLMesaRSetupFunc aclRSetupChooseFunction
	(GLcontext *ctx);

extern void aclSWSetupDDPointers
	(GLcontext *ctx);

extern void aclSWSetupDDDepthPointers
	(GLcontext *ctx);

#endif

