/* -*- mode: C; tab-width:8;  -*-

	aclmesa.h - ACL driver public declarations
*/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef ACLMESA_H
#define ACLMESA_H

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "ACL/aclapi.h"

#ifdef __cplusplus
extern "C" {
#endif



typedef struct aclmesa_context		*ACLMesaContext;
typedef struct aclmesa_attribs		*ACLMesaAttribs;

/*
 * information transfer to the aclMesa driver context
 */
struct aclmesa_attribs {
	GLboolean	rgba, dbuff, stereo;
	GLint		r, g, b, a, i;
	GLint		accum, depth, stencil;
	GLboolean	frontalpha, backalpha;
};



extern ACLMesaContext APIENTRY aclMesaCreateContext
	(Display* dpy, Window win, GLint width, GLint height,
	 ACLMesaAttribs attribs);

extern void APIENTRY aclMesaDestroyContext
	(ACLMesaContext aclMesa);

extern void APIENTRY aclMesaSwapBuffers
	(ACLMesaContext aclMesa);

extern void APIENTRY aclMesaMakeCurrent
	(ACLMesaContext aclMesa);



#ifdef __cplusplus
}
#endif

#endif
