
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*****************************************************************************
 *****************************************************************************
		    GENERIC FUNCTION PROTOTYPES FOR DRIVER
 *****************************************************************************
 *****************************************************************************/

#define GENPROTO_DRIVER_INIT_MAIN( shortex ) \
\
extern Tbool	shortex ## InitACLAPIModules(ACLContext); \
\
extern Tbool	shortex ## Init(ACLContext);



#define GENPROTO_DRIVER_INIT_MODULES( shortex ) \
\
extern Tbool	shortex ## InitACLAPIColorRGBAMod(ACLContext); \
\
extern Tbool	shortex ## InitACLAPIColorCIMod(ACLContext); \
\
extern Tbool	shortex ## InitACLAPIAccelMod(ACLContext); \
\
extern Tbool	shortex ## InitACLAPILBMod(ACLContext); \
\
extern Tbool	shortex ## InitACLAPITexMod(ACLContext);



#define GENPROTO_DRIVER_SETUP( shortex ) \
\
extern Tbool	shortex ## InitRenderingContext(ACLContext); \
\
extern void	shortex ## SetRenderingContext(ACLContext); \
\
extern void	shortex ## DownloadRenderingContext(ACLContext); \
\
extern void	shortex ## Sync(ACLContext); \
\
extern Tbool	shortex ## InitLBFormats(ACLContext); \
\
extern Tbool	shortex ## InitFBFormats(ACLContext); \
\
extern void	shortex ## SetWindow(ACLContext, Tbool); \
\
extern void	shortex ## SetLBUnits(ACLContext, Tbool); \
\
extern void	shortex ## SetFBUnits(ACLContext, Tbool); \
\
extern void	shortex ## SetScreenScissor(ACLContext, Tbool); \
\
extern void	shortex ## FillVisibleScreen(ACLContext, Tuint);

/*
 * What are the above DRIVER_SETUP functions for ?
 *
 * ----------------------------------------------------------------------------
 * InitRenderingContext(ACLContext aclctx)
 *	- preloads rendering context into host buffer/context record
 *	  acording to client requirements
 *
 *	RETURNS
 *	=======
 *		Tbool: - 0 on success, 1 if init failed
 *
 * ----------------------------------------------------------------------------
 * SetRenderingContext(ACLContext aclctx)
 *	- sets the most used, default context for rendering, like FB write,
 *	  or some other values which are DEFAULT (without explicit call to
 *	  upper layer function)
 *
 * ----------------------------------------------------------------------------
 * DownloadRenderingContext(ACLContext aclctx)
 *	- sends required card state to hardware
 *
 * ----------------------------------------------------------------------------
 * Sync(ACLContext aclctx)
 *	- synchronizes with hardware through OutFIFO
 *
 * ----------------------------------------------------------------------------
 * InitLBFormats(ACLContext aclctx)
 *	- looks for local buffer read/write format (depth, stencil, GID,...)
 *
 *	RETURNS
 *	=======
 *		Tbool: - 0 on success, 1 if format not found
 *
 * ----------------------------------------------------------------------------
 * InitFBFormats(ACLContext aclctx)
 *	- looks for frame buffer format (r,g,b,a, front/back planes)
 *
 *	RETURNS
 *	=======
 *		Tbool: - 0 on success, 1 if format not found
 *
 * ----------------------------------------------------------------------------
 * SetWindow(ACLContext aclctx, Tbool send)
 *	- sets window base address of client
 *
 *	PARAMETERS
 *	==========
 *		send: - write the register immediately (0 or 1)
 *
 * ----------------------------------------------------------------------------
 * SetScreenScissor(ACLContext aclctx, Tbool send)
 *	- sets screen scissor for the rendering screen
 *
 *	PARAMETERS
 *	==========
 *		send: - write the register immediately (0 or 1)
 *
 * ----------------------------------------------------------------------------
 * SetColorFormatting(ACLContext aclctx, Tbool is_rgb, Tbool send)
 *	- sets the color formatting unit
 *
 *	PARAMETERS
 *	==========
 *		is_rgb: - color order for color formatting unit (0 bgr, 1 rgb)
 *		send: - write the register immediately (0 or 1)
 *
 * ----------------------------------------------------------------------------
 * FillVisibleScreen(ACLContext aclctx, Tuint block_color)
 *	- performs block fill of the visible screen with some block color
 *
 *	PARAMETERS
 *	==========
 *		block_color: - 32 bit color in raw FB format
 *
 */
