
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _MLX_H_
#define _MLX_H_

#include <stdio.h>
#include <stdlib.h>
#include "ACL/aclapi.h"
#include "client_gpm.h"



/**************************************
 Record for up to 10 characters infos
 **************************************/
typedef struct mlx_info_rec {
	Tint		id1;
	Tint		id2;
	Tubyte		info[10];
} MLXInfoRec;



/**************************************
 The driver information record
 **************************************/
typedef struct mlx_driver_rec {
/* index of driver in the drivers array */
	Tint		drvidx;

/* unique card/driver type identifier */
	Tint		card_type;

/* short driver message/prefix */
	Tubyte		*drvmsg;

/* short info about driver */
	Tubyte		*drvinfo;

/* INIT FUNCTION - init and bind the driver with ACLContext */
	Tbool		(*init)(ACLContext);

/* which modules are implemented ? */
	ACLflags	modflags;

/* which features driver/hardware supports ? */
	struct acl_features features;
} MLXDriverRec;



typedef struct mlx_screen_context {

	Tuint		VisibleW;
	Tuint		VisibleH;
	Tuint		VirtualW;
	Tuint		VirtualH;
	Tubyte		ScreenBpp;

	Tubyte		BytesPP;
	Tuint		ScreenSize;
	Tint		ScreenPProd;

	Tuint		FrontBuffOffset;
	Tuint		FrontBuffAddrOffset;
	Tuint		BackBuffOffset;
	Tuint		BackBuffAddrOffset;
	Tuint		FrontBackOffset;
	Tuint		DepthBuffOffset;
	Tuint		TexBuffOffset;
	Tuint		TexBuffMin;
	Tuint		TexBuffMax;

} MLXScreenCtx;



/**************************************
 Current state of graphic hardware
 **************************************/
typedef struct mlx_card_context {

/* index of the last used rendering context (aclctx) */
	Tint		aclctx_index;

/*====================*
 * Driver information *
 *====================*/
	Tint		drvidx;
	Tint		card_type;

/*====================*
 * Screen Information *
 *====================*/
/* card used for the full-screen rendering ? */
	Tbool		is_full_screen;
	
/* points to either FullScr or XScr, is_full_screen gives info */
 	MLXScreenCtx	*Screen;

	MLXScreenCtx	FullScreen;
	
	MLXScreenCtx	WinScreen;
	Tbool		win_back_set;
	Tbool		win_depth_set;

/* size in bytes of video and local RAM (if any) */
	Tuint		VidMemSize;
	Tuint		LocMemSize;

/* RAM type */
	Tint		MemType;

/* External RAMDAC type, or RD_NONE if none */
	Tint		ExtDacType;

/*======================*
 * Misc important infos *
 *======================*/
/* number of clients or rendering contexts on card */
	Tint		nr_clients;

/* card access info already set ? */
	Tbool		lock;

/* VGA core enabled ? */
	Tbool		is_vga;

} MLXCardCtx;



/**************************************
 A box record
 **************************************/
typedef struct mlx_box{
	Tuint x1,y1,x2,y2;
	struct mlx_box *next;
} MLXBox;



/******************************************************************************

 Access macros:
 --------------

 MLX_INIT_ACCESS_CARD		- to access hardware data context

 MLX_INIT_ACCESS_GCBUFF		- for sending tags to graphic core
 MLX_INIT_ACCESS_INBUFF		- for receiving data from card

 MLX_INIT_ACCESS_MMCTL		- for accessing mmapped card's ctl region
 MLX_INIT_ACCESS_MMFB		- for accessing mmapped card's fb memory
 MLX_INIT_ACCESS_MMLB		- for accessing mmapped card's lb memory
 MLX_INIT_ACCESS_MMTEX;		- for accessing mmapped card's tex memory
 MLX_INIT_ACCESS_HTEX		- for accessing mmaped host's tex memory
  
 *****************************************************************************/

#define MLX_INIT_ACCESS_CARD \
    MLXCardCtx *cctx = mlx_cards[aclctx->hwidx]; \
    MLXScreenCtx *sctx = cctx->Screen

#define MLX_INIT_ACCESS_GCBUFF

/*
 * REGPtr is driver specific type and it should be defined in every driver
 * before usage of this macro
 */
#define MLX_INIT_ACCESS_MMCTL \
    volatile void *MMIOBASE = aclctx->CardCTL

/*****************************************************************************/

#define CCTX(arg)	(cctx->arg)



extern MLXCardCtx	*mlx_cards[];
extern MLXDriverRec	*mlx_drivers[];



#endif
