
#ifndef _MGACOMMON_H_
#define _MGACOMMON_H_



#include "mlx.h"
#include "mlxgen.h"



#if 0
  #define PCI_DISCONNECT
#endif

#if 1
#define MLXCLIP
#endif



/*
 * Clipp boxes definition for test purposes
 ********************************************/
#define TEST_CLIPP_4(cb,w,h,o) \
{ \
    MLXBox *r = cb = (MLXBox *)malloc(sizeof(MLXBox)); \
    r->x1=0; r->y1=0; r->x2=w/2-o; r->y2=h/2-o; \
    r = r->next = (MLXBox *)malloc(sizeof(MLXBox)); \
    r->x1=w/2+o; r->y1=0; r->x2=w; r->y2=h/2-o; \
    r = r->next = (MLXBox *)malloc(sizeof(MLXBox)); \
    r->x1=0; r->y1=h/2+o; r->x2=w/2-o; r->y2=h; \
    r = r->next = (MLXBox *)malloc(sizeof(MLXBox)); \
    r->x1=w/2+o; r->y1=h/2+o; r->x2=w; r->y2=h; \
    r->next = NULL; \
}

#define TEST_CLIPP_2(cb,w,h,o) \
{ \
    MLXBox *r = cb = (MLXBox *)malloc(sizeof(MLXBox)); \
    r->x1=0; r->y1=0; r->x2=w/2-o; r->y2=h; \
    r = r->next = (MLXBox *)malloc(sizeof(MLXBox)); \
    r->x1=w/2+o; r->y1=0; r->x2=w; r->y2=h; \
    r->next = NULL; \
}

/*
 * The VAL(clip_enable) switches clipping for MLX_DRAW_CLIPPED on/off
 * BITPLANE db requires clipping for both planes.
 * SCREEN OFFSET/FULLSCREEN doesn't require clipping, as there should be
 * only one client which runs.
 */

#if defined(MLXCLIP)
#define MLX_DRAW_CLIPPED \
{ \
    MLXBox *pBox = VAL(clip_boxes); \
    if(pBox && VAL(clip_enable)) { \
    /* ************* enable scissor registers here *******************/ \
	MLX_DRAW_INIT; \
	while((pBox = pBox->next)) { \
    /* ************* and here too  *******************/ \
	    MLX_DRAW_REPEAT; \
	} \
    /* ************* disable scissor registers here *******************/ \
    } \
    else { \
	MLX_DRAW_INIT; \
    } \
}
#else
#define MLX_DRAW_CLIPPED \
{ \
    MLX_DRAW_INIT; \
}
#endif



typedef struct {
	Tuint		draw_color;
	Tuint		clear_color;
	Tuint		clear_depth;
	Tuint		clear_stencil;
	Tuint		clear_alpha;
	Tubyte		depth_bits;
	Tubyte		stencil_bits;
	Tubyte		fclear_bits;
	Tubyte		gid_bits;
	Tuint		depth_range;
	Tuint		depth_par_range;
	Tubyte		cformat_idx;
	Tuint		cformat_front;
	Tuint		cformat_back;
	Tuint		cformat_ext;
	Tbool		order_rgb;
	Tubyte		alpha_bits;
	Tuint		window_base;
	Tuint		win_x, win_y, win_w, win_h;
	Tbool		clip_enable;
	MLXBox		*clip_boxes;
	Tuint		back_offset;
} MGARenderingValues;



/*
 * 	This should be also changed...
 */
#define COLORSHIFT 23

#define VAL_R(vx)	((VB->Color[vx][0] << COLORSHIFT))
#define VAL_G(vx)	((VB->Color[vx][1] << COLORSHIFT))
#define VAL_B(vx)	((VB->Color[vx][2] << COLORSHIFT))
#define VAL_A(vx)	((VB->Color[vx][3] << COLORSHIFT))

#define VAL_S(vx)	(VB->TexCoord[vx][0])
#define VAL_T(vx)	(VB->TexCoord[vx][1])
#define VAL_Re(vx)	(VB->TexCoord[vx][2])
#define VAL_Q(vx)	(VB->TexCoord[vx][3])

#define VAL_X(vx)	(VB->Win[vx][0])
#define VAL_Y(vx)	(VB->Win[vx][1])
/* #define VAL_Z(vx)	(VB->Win[vx][2] / VAL(_DepthRange) ) */
#define VAL_Z(vx)	(VB->Win[vx][2] * (1.0 / 65535.0))
#define VAL_W(vx)	(VB->Clip[vx][3])



#define PACKED_VERTEX_COLOR(vx) ( \
	((VB->Color[vx][3])<<24) | \
	((VB->Color[vx][2] & 0xff)<<16) | \
	((VB->Color[vx][1] & 0xff)<<8) | \
	 (VB->Color[vx][0] & 0xff) )

#define PACKED_COLOR(r,g,b,a) ( \
	 (a<<24) | \
	((r & 0xff)<<16) | \
	((g & 0xff)<<8) | \
	 (b & 0xff) )

#define UNPACKED_COLOR(r,g,b,a,bc) \
{ \
    a = (bc >> 24) & 0xff; \
    r = (bc >> 16) & 0xff; \
    g = (bc >> 8) & 0xff; \
    b = bc & 0xff; \
}




/*
	The register mnemonics should be changed here...
*/


#ifdef RDEBUG
#define REGLOG(f, a...)		{ fprintf(stderr, f, ## a); }
#else
#define REGLOG(f, a...)
#endif

#define GLINT_INIT_ACCESS_FIFO \
    volatile REGPtr FIFOBASE = (REGPtr)((char*)aclctx->CardCTL+InOutFIFO); \
    volatile REGPtr FIFOWRITE = FIFOBASE; \
    Tuint FIFOSIZE = 0x1000

#define REG_READ(r) \
    (*(REGPtr)((char*)MMIOBASE + r)) \

#define REG_READ_IN(v,r) \
{ \
    v = *(REGPtr)((char*)MMIOBASE + r); \
    REGLOG("Read reg Ox%x: value 0x%x\n", r, v); \
}

#define REG_WRITE(v,r) \
{ \
    * (REGPtr) ((char*)MMIOBASE + r) = v; \
    REGLOG("Write reg 0x%x: value 0x%x \n", r, v); \
}
  
#define REG_CWRITE(v,r) \
{ \
    * (REGPtr) ((char*)MMIOBASE + r) = *( (REGPtr) &v); \
    REGLOG("Write casted reg 0x%x: value 0x%x\n", r, v); \
}
  
#define REG_WRITE_SLOW(v,r) \
{ \
    while(!REG_READ(InFIFOSpace)); \
    *(REGPtr)((char*)MMIOBASE + r) = v; \
    REGLOG("Single wait/write reg 0x%x: value 0x%x\n", r, v); \
}
  
#define REG_CWRITE_SLOW(v,r) \
{ \
    while(!REG_READ(InFIFOSpace)); \
    *(REGPtr)((char*)MMIOBASE + r) = *((REGPtr)&v); \
    REGLOG("Single wait/write reg 0x%x: value 0x%x\n", r, v); \
}
  
#ifdef PCI_DISCONNECT
#define WAIT_FIFO(v)
#else
#define WAIT_FIFO(v) \
{ \
    REGLOG("\n********** WAITING FOR %d in FIFO...\n", v); \
    while(REG_READ(InFIFOSpace) < v) { \
	REGLOG("------> InFIFOSpace = %d\n", REG_READ(InFIFOSpace)); \
    } \
}
#endif
  


#endif
