
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */

/*****************************************************************************/
/*****************************************************************************/
/* Permedia2 OpenGL/Mesa driver                                              */
/* (c) 1997, 1998, 1999 SuSE GmbH                                            */
/* ------------------------------------------------------------------------- */
/* Contributors:                                                             */
/*      simon pogarcic, sim@suse.de                                          */
/*      Stefan Dirsch, sndirsch@suse.de                                      */
/*      Helmut Fahrion, hefa@artis.de                                        */
/*      Jeff Millar, jeff@wa1hco.mv.com                                      */
/*****************************************************************************/
/*****************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pm2.h"



GENPROTO_DRIVER_SETUP(PM2) 



#if 1
  #define LOG_DEBUG
#endif

#define LOG_DBGINFO "<pm2_setup>"
#include "log_debug.h"



Tbool
PM2InitRenderingContext(ACLContext aclctx)
{
LOG("PM2InitRenderingContext(): ######\n");

    CTX(AreaStippleMode)=0;
    CTX(DepthMode)=0;
    CTX(StencilMode)=0;
    CTX(TextureAddressMode)=0;

    CTX(TextureReadMode)=0;
    CTX(TexelLUTMode)=0;
    CTX(YUVMode)=0;
    CTX(ColorDDAMode)=0;

    CTX(TextureColorMode)=0;
    CTX(FogMode)=0;
    CTX(AlphaBlendMode)=0;
    CTX(LogicOpMode)=0;

    CTX(StatisticMode)=0;
    CTX(AlphaTestMode)=0;
    CTX(LineStippleMode)=0;
    CTX(ScissorMode)=0;

    CTX(AntialiasMode)=0;
    CTX(PatternRamMode)=0;
    CTX(RasterizerMode)=0;
    CTX(FilterMode)=0;

    CTX(FBSourceOffset)=0;
    CTX(FBPixelOffset)=0;
    CTX(LBSourceOffset)=0;

    CTX(Window)=0;

LOG("PM2InitRenderingContext(): ______\n");

    return 0;
}



void
PM2SetRenderingContext(ACLContext aclctx)
{
    CTX(DeltaMode) =
	DM_ClampEN |
	DM_SubPixelCorrEN;

    /* FBReadPixel, formats for DitherMode */
    PM2InitFBFormats(aclctx);

    /* LBReadFormat, LBWriteFormat */
    PM2InitLBFormats(aclctx);

    /* FBWindowBase, LBWindowBase */
    PM2SetWindow(aclctx, 0);

    /* DitherMode, ColorDDAMode, FBReadMode, FBWriteMode */
    PM2SetFBUnits(aclctx, 0);

    /* DeltaMode, LBReadMode, LBWriteMode */
    PM2SetLBUnits(aclctx, 0);

    /* this should be also figured out how to setup... */
    CTX(FBHardwareWriteMask) = 0xffffffff;
    CTX(FBSoftwareWriteMask) = 0xffffffff;
    CTX(Xlimits) = 0x7fff8000;
    CTX(Ylimits) = 0x7fff8000;
}



void
PM2DownloadRenderingContext(ACLContext aclctx)
{
    MLX_INIT_ACCESS_MMCTL;

LOG("PM2DownloadRenderingContext(): ######\n");

    PM2Sync(aclctx);

    WAIT_FIFO(34);

    REG_WRITE(CTX(AreaStippleMode), AreaStippleModeOff);
    REG_WRITE(CTX(DepthMode), DepthModeOff);
    REG_WRITE(CTX(StencilMode), StencilModeOff);
    REG_WRITE(CTX(TextureAddressMode), TextureAddressModeOff);

    REG_WRITE(CTX(TextureReadMode), TextureReadModeOff);
    REG_WRITE(CTX(TexelLUTMode), TexelLUTModeOff);
    REG_WRITE(CTX(YUVMode), YUVModeOff);
    REG_WRITE(CTX(ColorDDAMode), ColorDDAModeOff);

    REG_WRITE(CTX(TextureColorMode), TextureColorModeOff);
    REG_WRITE(CTX(FogMode), FogModeOff);
    REG_WRITE(CTX(AlphaBlendMode), AlphaBlendModeOff);
    REG_WRITE(CTX(LogicOpMode), LogicOpModeOff);

    REG_WRITE(CTX(StatisticMode), StatisticModeOff);
    REG_WRITE(CTX(AlphaTestMode), AlphaTestModeOff);
    REG_WRITE(CTX(LineStippleMode), LineStippleModeOff);
    REG_WRITE(CTX(ScissorMode), ScissorModeOff);

    REG_WRITE(CTX(AntialiasMode), AntialiasModeOff);
    REG_WRITE(CTX(PatternRamMode), PatternRamModeOff);
    REG_WRITE(CTX(RasterizerMode), RasterizerModeOff);
    REG_WRITE(CTX(FilterMode), FilterModeOff);

    REG_WRITE(CTX(LBReadFormat), LBReadFormatOff);
    REG_WRITE(CTX(LBWriteFormat), LBWriteFormatOff);
    REG_WRITE(CTX(DeltaMode), DeltaModeOff);

    REG_WRITE(CTX(FBSourceOffset), FBSourceOffsetOff);
    REG_WRITE(CTX(FBPixelOffset), FBPixelOffsetOff);
    REG_WRITE(CTX(LBSourceOffset), LBSourceOffsetOff);

    REG_WRITE(CTX(LBReadMode), LBReadModeOff);
    REG_WRITE(CTX(LBWriteMode), LBWriteModeOff);
    REG_WRITE(CTX(FBReadMode), FBReadModeOff);
    REG_WRITE(CTX(FBWriteMode), FBWriteModeOff);

    REG_WRITE(CTX(FBHardwareWriteMask), FBHardwareWriteMaskOff);
    REG_WRITE(CTX(FBSoftwareWriteMask), FBSoftwareWriteMaskOff);
    REG_WRITE(CTX(Xlimits), XlimitsOff);
    REG_WRITE(CTX(Ylimits), YlimitsOff);

    REG_WRITE(CTX(FBWindowBase), FBWindowBaseOff);
    REG_WRITE(CTX(LBWindowBase), LBWindowBaseOff);

    REG_WRITE(CTX(DitherMode), DitherModeOff);
    REG_WRITE(CTX(FBBlockColor), FBBlockColorOff);

    REG_WRITE(CTX(FBReadPixel), FBReadPixelOff);
    REG_WRITE(CTX(Window), WindowOff);

LOG("PM2DownloadRenderingContext(): ______\n");
}



void
PM2Sync(ACLContext aclctx)
{
    MLX_INIT_ACCESS_MMCTL;

    Tint cnt;
    volatile Tuint tmp;

LOG("PM2Sync(): ###### (InDMACount = %d)\n", REG_READ(InDMACount));

    /* this little wait is sometimes required, don't ask me why */
    /* {int tmp=100000;while(tmp--);} */

    /* wait until DMA transfer finished */
    while(REG_READ(InDMACount) != 0);

LOG("PM2Sync(): Send Sync...\n");
    WAIT_FIFO(2);
    REG_WRITE(FM_SyncTagPass | FM_SyncDataPass, FilterModeOff);
    REG_WRITE(0xaa, SyncOff);

LOG("PM2Sync(): Wait for Out FIFO\n");
    do {
	while(REG_READ(OutFIFOWords) == 0);
    } while (REG_READ(InOutFIFO) != SyncTag);

    if((cnt = REG_READ(OutFIFOWords))) {
LOG("PM2Sync(): OutputFIFO was not empty (0x%x) !!!\n", cnt);
	while(cnt--) {
	    tmp = REG_READ(InOutFIFO);
LOG("PM2Sync(): ===> 0x%x\n", tmp);
	}
    }

    WAIT_FIFO(1);
    REG_WRITE(0, FilterModeOff);

LOG("PM2Sync(): ______ END SYNC\n");
}



Tbool
PM2InitLBFormats(ACLContext aclctx)
{
    ACLVisual vis = aclctx->Vis;
    Tubyte zbits=0, sbits=0, restbits;

LOG("PM2InitLBFormats(): ######\n");

    /* 0: LBRF_DepthWidth16 | LBRF_StencilWidth0 */
    CTX(LBWriteFormat) = CTX(LBReadFormat) = 0;

    VAL(depth_bits)=0;
    VAL(stencil_bits)=0;
    VAL(depth_range)=0;

    restbits = 16;
    if((sbits = vis->StencilBits) > 0) {
	restbits = 15;
	VAL(stencil_bits) = 1;
	if(sbits > 1)
	    MSG("WARNING: stencil=%d bits (1 supported)!\n", sbits);
	CTX(LBReadFormat) |= LBRF_StencilWidth1;
    }

    if((zbits = vis->DepthBits) > 0) {
	if(zbits > 16)
	    MSG("WARNING: depth=%d bits (16 supported)!\n", zbits);
	if(zbits != restbits)
	    MSG("WARNING: depth=%d bits, %d bits format!\n", zbits, restbits)
	if(zbits <= 15 || restbits == 15) {
	    VAL(depth_bits) = 15;
	    CTX(LBReadFormat) |= LBRF_DepthWidth15;
	}
	else {
	    VAL(depth_bits) = 16;
	}
	VAL(depth_range) = (1 << VAL(depth_bits)) - 1;
	VAL(depth_par_range) = (1 << zbits) - 1;
    }

    CTX(LBWriteFormat) = CTX(LBReadFormat);

LOG("PM2InitLBFormats(): depth=%d, stencil=%d, par.range=%d\n",
	VAL(depth_bits), VAL(stencil_bits), VAL(depth_par_range));
LOG("PM2InitLBFormats(): ______ LBFormats = 0x%x\n", CTX(LBWriteFormat));

    return 0;
}



Tbool
PM2InitFBFormats(ACLContext aclctx)
{
    Tbyte alpha = -1;
    Tuint fmtf=0, fmtb=0;
    ACLVisual vis = aclctx->Vis;
    Tubyte r=vis->RedBits, g=vis->GreenBits, b=vis->BlueBits, a=vis->AlphaBits;

LOG("PM2InitFBFormats(): ###### set format %d %d %d %d (RGBA)\n", r,g,b,a);

    VAL(cformat_ext) = 0;

    switch (g) {
    case 8:
	fmtf = COLOR_PM2_Format8888;
	fmtb = COLOR_PM2_Format8888;
	VAL(cformat_idx) = GLINT_CFORMAT_8888;
	CTX(FBReadPixel) = FBRP_Bits32;
	alpha = 8;
LOG("PM2InitFBFormats(): format 888 a=8\n");
	break;
    case 6:
	fmtf = COLOR_PM2_Format565F;
	fmtb = COLOR_PM2_Format565B;
	VAL(cformat_idx) = GLINT_CFORMAT_565;
	VAL(cformat_ext) = COLOR_PM2_ExtEN;
	CTX(FBReadPixel) = FBRP_Bits16;
	alpha = 0;
LOG("PM2InitFBFormats(): format 565 a=0, front and back\n");
	break;
    case 5:
	fmtf = COLOR_PM2_Format5551F;
	fmtb = COLOR_PM2_Format5551B;
	VAL(cformat_idx) = GLINT_CFORMAT_5551;
	CTX(FBReadPixel) = FBRP_Bits16;
	alpha = 1;
LOG("PM2InitFBFormats(): format 555 a=1, front and back\n");
	break;
    case 4:
	fmtf = COLOR_PM2_Format4444;
	fmtb = COLOR_PM2_Format4444;
	VAL(cformat_idx) = GLINT_CFORMAT_4444;
	CTX(FBReadPixel) = FBRP_Bits16;
	alpha = 4;
LOG("PM2InitFBFormats(): format 444 a=4\n");
	break;
    case 3:
	/*
	 * this doesn't work...
	 ***********************/
	if (r == 3) {
	    fmtf = COLOR_PM2_Format332F;
	    fmtb = COLOR_PM2_Format332B;
	    CTX(FBReadPixel) = FBRP_Bits8;
	    VAL(cformat_idx) = GLINT_CFORMAT_332;
	    alpha = 0;
LOG("PM2InitFBFormats(): format 332 a=0, front and back\n");
	}
	else if (r == 2) {
	    fmtf = COLOR_PM2_Format2321F;
	    fmtb = COLOR_PM2_Format2321B;
	    CTX(FBReadPixel) = FBRP_Bits8;
	    VAL(cformat_idx) = GLINT_CFORMAT_2321;
	    alpha = 1;
LOG("PM2InitFBFormats(): format 232 a=1, front and back\n");
	}
	break;
    }

    if (alpha == -1) {
	ERR("CANNOT SET REQUIRED COLOR FORMAT!!!\n");
	return 1;
    }

    if (alpha != a)
	MSG("WARNING: Required alpha=%d (but set=%d)\n", a, alpha);

    VAL(cformat_front) = fmtf;
    VAL(cformat_back) = fmtb;
    VAL(alpha_bits) = alpha;

LOG("PM2InitFBFormats(): ______ FBReadPixel == 0x%x\n", CTX(FBReadPixel));

    return 0;
}



void
PM2SetWindow(ACLContext aclctx, Tbool send)
{
    MLX_INIT_ACCESS_CARD;

LOG("PM2SetWindow(): ###### x=%d, y=%d, w=%d, h=%d\n",
	VAL(win_x), VAL(win_y), VAL(win_w), VAL(win_h));

    /*
     * this converts top-left win_x and win_y coordinates of window into
     * address of the bottom-left window origin.
     */
    VAL(window_base) = (VAL(win_y)+VAL(win_h))*sctx->VirtualW + VAL(win_x);
    CTX(FBWindowBase) = sctx->FrontBuffOffset + VAL(window_base);
    CTX(LBWindowBase) = sctx->DepthBuffOffset + VAL(window_base);

    if(send) {
	MLX_INIT_ACCESS_MMCTL;
	WAIT_FIFO(2);
	REG_WRITE(CTX(FBWindowBase), FBWindowBaseOff);
	REG_WRITE(CTX(LBWindowBase), LBWindowBaseOff);
    }
LOG("PM2SetWindow():        FBWindowBase = %d\n", CTX(FBWindowBase));
LOG("PM2SetWindow(): ______ LBWindowBase = %d\n", CTX(LBWindowBase));
}



void
PM2SetFBUnits(ACLContext aclctx, Tbool send)
{
    MLX_INIT_ACCESS_CARD;

LOG("PM2SetFBUnits(): ######\n");

    /* let's say, the color order is bgr */
    VAL(order_rgb) = 0;

    CTX(DitherMode) = UNIT_ENABLE |
		      (VAL(cformat_front) << 2) |
		      VAL(cformat_ext) |
		      (VAL(order_rgb) ? DTM_PM2_ColorOrderRGB : 0);

    CTX(ColorDDAMode) = UNIT_ENABLE;

    CTX(FBWriteMode) = FBWM_WriteEN;
    CTX(FBReadMode) = sctx->ScreenPProd | FBRM_WinOriginBottom;

    if(send) {
	MLX_INIT_ACCESS_MMCTL;
	WAIT_FIFO(5);
	REG_WRITE(CTX(DitherMode), DitherModeOff);
	REG_WRITE(CTX(ColorDDAMode), ColorDDAModeOff);
	REG_WRITE(CTX(FBWriteMode), FBWriteModeOff);
	REG_WRITE(CTX(FBReadMode), FBReadModeOff);
    }

LOG("PM2SetFBUnits():        DitherMode=0x%x\n", CTX(DitherMode));
LOG("PM2SetFBUnits():        ColorDDAMode=0x%x\n", CTX(ColorDDAMode));
LOG("PM2SetFBUnits():        FBWriteMode=0x%x\n", CTX(FBWriteMode));
LOG("PM2SetFBUnits(): ______ FBReadMode=0x%x\n", CTX(FBReadMode));
}



void
PM2SetLBUnits(ACLContext aclctx, Tbool send)
{
    MLX_INIT_ACCESS_CARD;

LOG("PM2SetLBUnits(): ######\n");

    CTX(LBReadMode) =
	sctx->ScreenPProd |
	LBRM_WinOriginBottom;

    CTX(LBWriteMode) = 0;

    if(VAL(depth_bits) > 0) {

	CTX(LBWriteMode) = LBWM_WriteEN;
	CTX(LBReadMode) |= LBRM_DestEN;
	CTX(DeltaMode) |= DM_DepthEN;

	if(VAL(depth_bits) >= 16)
	    CTX(DeltaMode) |= DM_DepthFormat16;
    }

    if(send) {
	MLX_INIT_ACCESS_MMCTL;
	WAIT_FIFO(4);
	REG_WRITE(CTX(DeltaMode), DeltaModeOff);
	REG_WRITE(CTX(LBWriteMode), LBWriteModeOff);
	REG_WRITE(CTX(LBReadMode), LBReadModeOff);
    }

LOG("PM2SetLBUnits():        DeltaMode=0x%x\n", CTX(DeltaMode));
LOG("PM2SetLBUnits():        LBWriteMode=0x%x\n", CTX(LBWriteMode));
LOG("PM2SetLBUnits(): ______ LBReadMode=0x%x\n", CTX(LBReadMode));
}



#if 0
/*
 * Scissor hardware setup, not implemented in upper layers, yet
 * jeff 1/13/99
 *
 */ 
void
PM2SetScreenScissor(ACLContext aclctx, Tbool send)
{
    MLX_INIT_ACCESS_MMCTL;

 ACLint x, ACLint y, ACLsizei width, ACLsizei heigth)

    CRC(_ScissorMaxXY) = (((y + heigth) & 0x0fff) << 16) + ((x + width) & 0x0fff);
    CRC(_ScissorMinXY) = ((y & 0x0fff) << 16) + (x & 0x0fff);
    if ( x == 0 && y == 0 ) 
       CRC(_ScissorMode) &= SCM_UserScissorMASK;
    else
       CRC(_ScissorMode) |= SCM_UserScissorEN; 

    WAIT_FIFO(4);
    REG_WRITE(CRC(_ScissorMaxXY), ScissorMaxXYOff);
    REG_WRITE(CRC(_ScissorMinXY), ScissorMinXYOff);
    REG_WRITE(CRC(_ScissorMode), ScissorModeOff);

}
#endif



void
PM2FillVisibleScreen(ACLContext aclctx, Tuint block_color)
{
    MLX_INIT_ACCESS_CARD;
    MLX_INIT_ACCESS_MMCTL;

#define RENDER_SETUP (\
	R_PrimitiveRectangle | \
	R_XPositiveEN | \
	R_YPositiveEN | \
	R_FastFillEN )

#define FBREADMODE_SETUP ( \
	sctx->ScreenPProd | \
	FBRM_SrcEN | \
	FBRM_WinOriginTop )

LOG("PM2FillVisibleScreen() ######\n");

    WAIT_FIFO(22);
    REG_WRITE(LBWM_WriteDIS, LBWriteModeOff);
    REG_WRITE(UNIT_DISABLE, DepthModeOff);
    REG_WRITE(UNIT_DISABLE, StencilModeOff);
    REG_WRITE(UNIT_DISABLE, ColorDDAModeOff);
    REG_WRITE(sctx->FrontBuffOffset, FBWindowBaseOff);
    REG_WRITE(0, FBPixelOffsetOff);
    REG_WRITE(FBWM_WriteEN, FBWriteModeOff);
    REG_WRITE(FBREADMODE_SETUP, FBReadModeOff);
    REG_WRITE(block_color, FBBlockColorOff);

    REG_WRITE(0, RectangleOriginOff);
    REG_WRITE((sctx->VisibleH << 16) | sctx->VisibleW, RectangleSizeOff);
    REG_WRITE(RENDER_SETUP, RenderOff);
    
    REG_WRITE(CTX(LBWriteMode), LBWriteModeOff);
    REG_WRITE(CTX(DepthMode), DepthModeOff);
    REG_WRITE(CTX(StencilMode), StencilModeOff);
    REG_WRITE(CTX(ColorDDAMode), ColorDDAModeOff);
    REG_WRITE(CTX(FBWindowBase), FBWindowBaseOff);
    REG_WRITE(CTX(FBPixelOffset), FBPixelOffsetOff);
    REG_WRITE(CTX(FBWriteMode), FBWriteModeOff);
    REG_WRITE(CTX(FBReadMode), FBReadModeOff);
    REG_WRITE(CTX(FBBlockColor), FBBlockColorOff);

LOG("PM2FillVisibleScreen() ______\n");

#undef RENDER_SETUP
}
