
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */

/*****************************************************************************/
/*****************************************************************************/
/* Permedia2 OpenGL/Mesa driver                                              */
/* (c) 1997, 1998, 1999 SuSE GmbH                                            */
/* ------------------------------------------------------------------------- */
/* Authors:                                                                  */
/*	Simon Pogarcic, sim@suse.de                                          */
/*	Stefan Dirsch, sndirsch@suse.de                                      */
/*	Helmut Fahrion, hefa@artis.de                                        */
/*****************************************************************************/
/*****************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pm2.h"



GENPROTO_DRIVER_SETUP(PM2)



#undef FSCOPE
#define FSCOPE static



#if 0
  #define LOG_DEBUG
#endif

#define LOG_DBGINFO "<pm2_rgba>"
#include "log_debug.h"



/*****************************************************************************
                  MACROS USED FOR SPAN AND PIXEL PRIMITIVES
 *****************************************************************************/

#define PM2_RECTANGLE_1 (\
	R_PrimitiveRectangle | \
	R_XPositiveEN | \
	R_YPositiveEN \
	)

#define MONO_SPAN_LOOP_MASK(n) \
{ \
	Tuint i; \
	for (i=0; i < n; i++) { \
	    if (mask[i]) { \
		WAIT_FIFO(3); \
		REG_WRITE((xx + i) << 16, StartXDomOff); \
		REG_WRITE(R_PrimitivePoint, RenderOff); \
	    } \
	} \
}

#define RGBA_SPAN_LOOP_MASK(n) \
{ \
	Tuint i; \
	for (i=0; i < n; i++) { \
	    if (mask[i]) { \
		WAIT_FIFO(4);\
		REG_WRITE(PACKED_COLOR(rgba[i][0], rgba[i][1], \
			rgba[i][2], ALPHA_VAL), ConstantColorOff); \
		REG_WRITE((xx + i) << 16, StartXDomOff); \
		REG_WRITE(R_PrimitivePoint, RenderOff); \
	    } \
	} \
}

#define RGBA_SPAN_LOOP(n) \
{ \
	Tuint i; \
	for (i=0; i < n; i++) { \
		WAIT_FIFO(4); \
		REG_WRITE(PACKED_COLOR(rgba[i][0], rgba[i][1], \
			rgba[i][2], ALPHA_VAL), ConstantColorOff); \
		REG_WRITE((xx + i) << 16, StartXDomOff); \
		REG_WRITE(R_PrimitivePoint, RenderOff); \
	} \
}

#define RGBA_PIXEL_LOOP_MASK(n) \
{ \
	Tuint i; \
	for (i=0; i<n; i++) { \
	    if(mask[i]) { \
		WAIT_FIFO(5);\
		REG_WRITE(PACKED_COLOR(rgba[i][0], rgba[i][1], \
			rgba[i][2], ALPHA_VAL), ConstantColorOff); \
		REG_WRITE(x[i] << 16, StartXDomOff); \
                REG_WRITE(y[i] << 16, StartYOff); \
		REG_WRITE(R_PrimitivePoint, RenderOff); \
	    } \
	} \
}

#define RGBA_PIXEL_LOOP(n) \
{ \
	Tuint i; \
	for (i=0; i<n; i++) { \
	    WAIT_FIFO(5); \
	    REG_WRITE(PACKED_COLOR(rgba[i][0], rgba[i][1], \
			rgba[i][2], ALPHA_VAL), ConstantColorOff); \
	    REG_WRITE(x[i] << 16, StartXDomOff); \
	    REG_WRITE(y[i] << 16, StartYOff);\
	    REG_WRITE(R_PrimitivePoint, RenderOff); \
	} \
}

#define MONO_PIXEL_LOOP_MASK(n) \
{ \
	Tuint i; \
	for (i=0; i < n; i++) { \
	    if (mask[i]) { \
		WAIT_FIFO(5); \
		REG_WRITE(y[i] << 16, StartYOff); \
		REG_WRITE(x[i] << 16, StartXDomOff); \
		REG_WRITE(R_PrimitivePoint, RenderOff); \
	    } \
	} \
}

#define MONO_PIXEL_LOOP(n) \
{ \
	Tuint i; \
	for (i=0; i < n; i++) { \
	    WAIT_FIFO(5); \
	    REG_WRITE(y[i] << 16, StartYOff); \
	    REG_WRITE(x[i] << 16, StartXDomOff); \
	    REG_WRITE(R_PrimitivePoint, RenderOff); \
	} \
}

/*****************************************************************************/

#define READ_RGBA_PIXEL_LOOP_MASK(n) \
{ \
	Tuint i; \
	Tuint volatile bc; \
	for (i = 0; i < n; i++) { \
	    if (mask[i]) { \
		WAIT_FIFO(4); \
		REG_WRITE(y[i] << 16, StartYOff); \
		REG_WRITE(x[i] << 16, StartXDomOff); \
		REG_WRITE(R_PrimitivePoint, RenderOff); \
		while(REG_READ(OutFIFOWords) == 0); \
		while(REG_READ(OutFIFOWords) > 0) { \
		    bc = REG_READ(InOutFIFO); \
		    UNPACKED_COLOR(rgba[i][0],rgba[i][1],rgba[i][2], \
			ALPHA_VAL, bc); \
		} \
	    } \
	} \
}

#define READ_RGBA_PIXEL_LOOP(n) \
{ \
	Tuint i; \
	Tuint volatile bc; \
	for (i = 0; i < n; i++) { \
		WAIT_FIFO(4); \
		REG_WRITE(y[i] << 16, StartYOff); \
		REG_WRITE(x[i] << 16, StartXDomOff); \
		REG_WRITE(R_PrimitivePoint, RenderOff); \
		while(REG_READ(OutFIFOWords) == 0); \
		while(REG_READ(OutFIFOWords) > 0) { \
		    bc = REG_READ(InOutFIFO); \
		    UNPACKED_COLOR(rgba[i][0],rgba[i][1],rgba[i][2], \
			ALPHA_VAL, bc); \
		} \
	} \
}

/*****************************************************************************
 *****************************************************************************/



FSCOPE void
aclPM2ClearColor(ACLContext aclctx, Tubyte r, Tubyte g, Tubyte b, Tubyte a)
{
LOG("ClearColor(): ++++++\n");
    VAL(clear_color) = PACKED_COLOR(r, g, b, a);
}



FSCOPE void
aclPM2Color(ACLContext aclctx, Tubyte r, Tubyte g, Tubyte b, Tubyte a)
{
    MLX_INIT_ACCESS_MMCTL;

LOG("Color(): ++++++\n");
    VAL(draw_color) = PACKED_COLOR(r, g, b, a);

    WAIT_FIFO(1);
    REG_WRITE(VAL(draw_color), ConstantColorOff);
}



FSCOPE void
aclPM2ColorMask(ACLContext aclctx, Tubyte r, Tubyte g, Tubyte b, Tubyte a)
{
LOG("ColorMask(): ++++++\n");
}



FSCOPE void
aclPM2FBWriteRGBAPixels(const ACLContext aclctx, Tuint n, const Tint x[],
    const Tint y[], const void **rgba_ptr, const Tubyte mask[], ACLflags fl)
{
    MLX_INIT_ACCESS_MMCTL;

    if (mask) {
      if(fl & ACLFLAG_MONO) {
	if(fl & ACLFLAG_SPAN) {
	    Tint xx = x[0];
/********************************************************** mono, span, mask */
LOG("FBWriteRGBAPixels(): ++++++ mono, span, mask\n");
	    WAIT_FIFO(2);
	    REG_WRITE(UNIT_ENABLE, ColorDDAModeOff);
	    REG_WRITE(y[0] << 16, StartYOff);
	    #undef MLX_DRAW_REPEAT_CNT
	    #undef MLX_DRAW_INIT
	    #undef MLX_DRAW_REPEAT
	    #define MLX_DRAW_REPEAT_CNT 0
	    #define MLX_DRAW_INIT	MONO_SPAN_LOOP_MASK(n)
	    #define MLX_DRAW_REPEAT	MLX_DRAW_INIT
	    MLX_DRAW_CLIPPED
	}
	else {
/******************************************************** mono, pixels, mask */
LOG("FBWriteRGBAPixels(): ++++++ mono, pixels, mask\n");
	    WAIT_FIFO(1);
	    REG_WRITE(UNIT_ENABLE, ColorDDAModeOff);
	    #undef MLX_DRAW_REPEAT_CNT
	    #undef MLX_DRAW_INIT
	    #undef MLX_DRAW_REPEAT
	    #define MLX_DRAW_REPEAT_CNT 0
	    #define MLX_DRAW_INIT	MONO_PIXEL_LOOP_MASK(n)
	    #define MLX_DRAW_REPEAT	MLX_DRAW_INIT
	    MLX_DRAW_CLIPPED
	}
      }
      else {
	#undef ALPHA_VAL
	#define ALPHA_VAL rgba[i][3]
	if((fl & ACLFLAG_SPAN) && (fl & ACLFLAG_ALPHA)) {
	    Tubyte (*rgba)[4] = (Tubyte (*)[4]) rgba_ptr;
	    Tint xx = x[0];
/********************************************************** rgba, span, mask */
LOG("FBWriteRGBAPixels(): ++++++ rgba, span, mask\n");
	    WAIT_FIFO(2);
	    REG_WRITE(UNIT_ENABLE, ColorDDAModeOff);
	    REG_WRITE(y[0] << 16, StartYOff);
	    #undef MLX_DRAW_REPEAT_CNT
	    #undef MLX_DRAW_INIT
	    #undef MLX_DRAW_REPEAT
	    #define MLX_DRAW_REPEAT_CNT 0
	    #define MLX_DRAW_INIT	RGBA_SPAN_LOOP_MASK(n);
	    #define MLX_DRAW_REPEAT	MLX_DRAW_INIT
	    MLX_DRAW_CLIPPED
	}
	else if(fl & ACLFLAG_ALPHA) {
	    Tubyte (*rgba)[4] = (Tubyte (*)[4]) rgba_ptr;
/******************************************************** rgba, pixels, mask */
LOG("FBWriteRGBAPixels(): ++++++ rgba, pixels, mask\n");
	    WAIT_FIFO(1);
	    REG_WRITE(UNIT_ENABLE, ColorDDAModeOff);
	    #undef MLX_DRAW_REPEAT_CNT
	    #undef MLX_DRAW_INIT
	    #undef MLX_DRAW_REPEAT
	    #define MLX_DRAW_REPEAT_CNT 0
	    #define MLX_DRAW_INIT	RGBA_PIXEL_LOOP_MASK(n);
	    #define MLX_DRAW_REPEAT	MLX_DRAW_INIT
	    MLX_DRAW_CLIPPED
	}
	#undef ALPHA_VAL
	#define ALPHA_VAL 0xff
	else if(fl & ACLFLAG_SPAN) {
	    Tubyte (*rgba)[3] = (Tubyte (*)[3]) rgba_ptr;
	    Tint xx = x[0];
/*********************************************************** rgb, span, mask */
LOG("FBWriteRGBAPixels(): ++++++ rgb, span, mask\n");
	    WAIT_FIFO(2);
	    REG_WRITE(UNIT_ENABLE, ColorDDAModeOff);
	    REG_WRITE(y[0] << 16, StartYOff);
	    #undef MLX_DRAW_REPEAT_CNT
	    #undef MLX_DRAW_INIT
	    #undef MLX_DRAW_REPEAT
	    #define MLX_DRAW_REPEAT_CNT 0
	    #define MLX_DRAW_INIT	RGBA_SPAN_LOOP_MASK(n);
	    #define MLX_DRAW_REPEAT	MLX_DRAW_INIT
	    MLX_DRAW_CLIPPED
	}
	else {
	    Tubyte (*rgba)[3] = (Tubyte (*)[3]) rgba_ptr;
/********************************************************* rgb, pixels, mask */
LOG("FBWriteRGBAPixels(): ++++++ rgb, pixels, mask\n");
	    WAIT_FIFO(1);
	    REG_WRITE(UNIT_ENABLE, ColorDDAModeOff);
	    #undef MLX_DRAW_REPEAT_CNT
	    #undef MLX_DRAW_INIT
	    #undef MLX_DRAW_REPEAT
	    #define MLX_DRAW_REPEAT_CNT 0
	    #define MLX_DRAW_INIT	RGBA_PIXEL_LOOP_MASK(n);
	    #define MLX_DRAW_REPEAT	MLX_DRAW_INIT
	    MLX_DRAW_CLIPPED
	}
      }
    }
    else {
      if(fl & ACLFLAG_MONO) {
	if(fl & ACLFLAG_SPAN) {
/**************************************************************** mono, span */
LOG("FBWriteRGBAPixels(): ++++++ mono, span\n");
	    WAIT_FIFO(4);
	    REG_WRITE(0, ColorDDAModeOff);
	    REG_WRITE((y[0] << 16) | x[0], RectangleOriginOff);
	    REG_WRITE((1 << 16) | n, RectangleSizeOff);
	    REG_WRITE(VAL(draw_color), ColorOff);
	    #undef MLX_DRAW_REPEAT_CNT
	    #undef MLX_DRAW_INIT
	    #undef MLX_DRAW_REPEAT
	    #define MLX_DRAW_REPEAT_CNT 0
	    #define MLX_DRAW_INIT	REG_WRITE(PM2_RECTANGLE_1, RenderOff);
	    #define MLX_DRAW_REPEAT	MLX_DRAW_INIT
	    MLX_DRAW_CLIPPED
	}
	else {
/************************************************************** mono, pixels */
LOG("FBWriteRGBAPixels(): ++++++ mono, pixels\n");
	    WAIT_FIFO(1);
	    REG_WRITE(UNIT_ENABLE, ColorDDAModeOff);
	    #undef MLX_DRAW_REPEAT_CNT
	    #undef MLX_DRAW_INIT
	    #undef MLX_DRAW_REPEAT
	    #define MLX_DRAW_REPEAT_CNT 0
	    #define MLX_DRAW_INIT	MONO_PIXEL_LOOP(n)
	    #define MLX_DRAW_REPEAT	MLX_DRAW_INIT
	    MLX_DRAW_CLIPPED
	}
      }
      else {
	#undef ALPHA_VAL
	#define ALPHA_VAL rgba[i][3]
	if((fl & ACLFLAG_SPAN) && (fl & ACLFLAG_ALPHA)) {
	    Tubyte (*rgba)[4] = (Tubyte (*)[4]) rgba_ptr;
	    Tint xx = x[0];
/**************************************************************** rgba, span */
LOG("FBWriteRGBAPixels(): ++++++ rgba, span\n");
	    WAIT_FIFO(2);
	    REG_WRITE(UNIT_ENABLE, ColorDDAModeOff);
	    REG_WRITE(y[0] << 16, StartYOff);
	    #undef MLX_DRAW_REPEAT_CNT
	    #undef MLX_DRAW_INIT
	    #undef MLX_DRAW_REPEAT
	    #define MLX_DRAW_REPEAT_CNT 0
	    #define MLX_DRAW_INIT	RGBA_SPAN_LOOP(n);
	    #define MLX_DRAW_REPEAT	MLX_DRAW_INIT
	    MLX_DRAW_CLIPPED
	}
	else if(fl & ACLFLAG_ALPHA) {
	    Tubyte (*rgba)[4] = (Tubyte (*)[4]) rgba_ptr;
/************************************************************** rgba, pixels */
LOG("FBWriteRGBAPixels(): ++++++ rgba, pixels\n");
	    WAIT_FIFO(1);
	    REG_WRITE(UNIT_ENABLE, ColorDDAModeOff);
	    #undef MLX_DRAW_REPEAT_CNT
	    #undef MLX_DRAW_INIT
	    #undef MLX_DRAW_REPEAT
	    #define MLX_DRAW_REPEAT_CNT 0
	    #define MLX_DRAW_INIT	RGBA_PIXEL_LOOP(n);
	    #define MLX_DRAW_REPEAT	MLX_DRAW_INIT
	    MLX_DRAW_CLIPPED
	}
	#undef ALPHA_VAL
	#define ALPHA_VAL 0xff
	else if(fl & ACLFLAG_SPAN) {
	    Tubyte (*rgba)[3] = (Tubyte (*)[3]) rgba_ptr;
	    Tint xx = x[0];
/***************************************************************** rgb, span */
LOG("FBWriteRGBAPixels(): ++++++ rgb, span\n");
	    WAIT_FIFO(2);
	    REG_WRITE(UNIT_ENABLE, ColorDDAModeOff);
	    REG_WRITE(y[0] << 16, StartYOff);
	    #undef MLX_DRAW_REPEAT_CNT
	    #undef MLX_DRAW_INIT
	    #undef MLX_DRAW_REPEAT
	    #define MLX_DRAW_REPEAT_CNT 0
	    #define MLX_DRAW_INIT	RGBA_SPAN_LOOP(n);
	    #define MLX_DRAW_REPEAT	MLX_DRAW_INIT
	    MLX_DRAW_CLIPPED
	}
	else {
	    Tubyte (*rgba)[3] = (Tubyte (*)[3]) rgba_ptr;
/*************************************************************** rgb, pixels */
LOG("FBWriteRGBAPixels(): ++++++ rgb, pixels\n");
	    WAIT_FIFO(1);
	    REG_WRITE(UNIT_ENABLE, ColorDDAModeOff);
	    #undef MLX_DRAW_REPEAT_CNT
	    #undef MLX_DRAW_INIT
	    #undef MLX_DRAW_REPEAT
	    #define MLX_DRAW_REPEAT_CNT 0
	    #define MLX_DRAW_INIT	RGBA_PIXEL_LOOP(n);
	    #define MLX_DRAW_REPEAT	MLX_DRAW_INIT
	    MLX_DRAW_CLIPPED
	}
      }
    }

    WAIT_FIFO(1);
    REG_WRITE(CTX(ColorDDAMode), ColorDDAModeOff);
}



/*****************************************************************************
 * this doesn't work. Have to figure out the conversion of raw pixel format
 * to the rgba[][4] fitting format
 ****************************************************************************/

FSCOPE void
aclPM2FBReadRGBAPixels(const ACLContext aclctx, Tuint n, const Tint x[],
	const Tint y[], void ** rgba_ptr, const Tubyte mask[], ACLflags flags )
{
    MLX_INIT_ACCESS_CARD;
    MLX_INIT_ACCESS_MMCTL;

#define FBREADMODE_SETUP ( \
	sctx->ScreenPProd | \
	FBRM_DestEN | \
	FBRM_DataFBColor | \
	FBRM_WinOriginBottom )

LOG("ReadRGBAPixels(): ++++++\n");

    WAIT_FIFO(6);
    REG_WRITE(FBREADMODE_SETUP, FBReadModeOff);
    REG_WRITE(0, FBWriteModeOff);
    REG_WRITE(0, ColorDDAModeOff);
    REG_WRITE(0, LogicOpModeOff);
    REG_WRITE(0, DepthModeOff);
    REG_WRITE(0, WaitForCompletionOff);

    PM2Sync(aclctx);

    WAIT_FIFO(1);
    REG_WRITE(FM_ColorDataPass, FilterModeOff);

    if(mask) {
    }
    else {
    }

    WAIT_FIFO(6);
    REG_WRITE(CTX(FBReadMode), FBReadModeOff);
    REG_WRITE(CTX(FBWriteMode), FBWriteModeOff);
    REG_WRITE(CTX(ColorDDAMode), ColorDDAModeOff);
    REG_WRITE(CTX(LogicOpMode), LogicOpModeOff);
    REG_WRITE(CTX(DepthMode), DepthModeOff);
    REG_WRITE(CTX(FilterMode), FilterModeOff);
}



Tbool
PM2InitACLAPIColorRGBAMod(ACLContext aclctx)
{
    ACLColorRGBAMod rgba = aclctx->Mod->ColorRGBA;

LOG("PM2InitACLAPIColorRGBAMod(): ######\n");

    rgba->ClearColor = aclPM2ClearColor;
    rgba->Color = aclPM2Color;
    rgba->ColorMask = aclPM2ColorMask;
    rgba->FBWriteRGBAPixels = aclPM2FBWriteRGBAPixels;
    rgba->FBReadRGBAPixels = aclPM2FBReadRGBAPixels;

LOG("PM2InitACLAPIColorRGBAMod(): ______\n");
    return 0;
}
