
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */



/*****************************************************************************/
/*****************************************************************************/
/* G200 OpenGL/Mesa driver                                                   */
/* ------------------------------------------------------------------------- */
/*****************************************************************************/
/*****************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if 0
  #define LOG_DEBUG
#endif

#define LOG_DBGINFO "<g200_mod>"
#include "log_debug.h"



#include "g200.h"



GENPROTO_DRIVER_INIT_MODULES(G200)
GENPROTO_DRIVER_SETUP(G200)



static void
aclG200StartRender(ACLContext aclctx)
{
    MLX_INIT_ACCESS_CARD;

LOG("aclG200StartRender(): ######\n");

    if(CCTX(is_full_screen)) {
	VAL(clip_enable) = 0;
#if 0
/* function from g200_setup.c */
	G200FillVisibleScreen(aclctx, 0x00003f00);
#endif
    }

#if 0
/* functions from g200_setup.c */
    G200InitRenderingContext(aclctx);
    G200SetRenderingContext(aclctx);
    G200DownloadRenderingContext(aclctx);
#endif

/* ===>
 * this should be the state of the default rendering context, as required by
 * the most of drawing primitives. All other functions, which require some
 * other state of graphic hardware for doing their job, should return the
 * state maschine into this default state.
 * <===
 */
    
    /* simulate some clip boxess, before we get real ones from X ;) */
    TEST_CLIPP_4(VAL(clip_boxes), VAL(win_w), VAL(win_h), 10);

    /* for test purposes, always clip */
    VAL(clip_enable) = 1;

LOG("aclG200StartRender(): ______\n");
}



static void
aclG200FinishRender(ACLContext aclctx)
{
    MLX_INIT_ACCESS_CARD;
    MLX_INIT_ACCESS_MMCTL;

LOG("aclG200FinishRender(): ######\n");
#if 0
/* function from g200_setup.c */
    G200Sync(aclctx);
#endif

LOG("aclG200FinishRender(): ______\n");
}



static Tuint
aclG200DrawBuffer(ACLContext aclctx, ACLglenum buffer)
{
    MLX_INIT_ACCESS_CARD;
    MLX_INIT_ACCESS_MMCTL;

LOG("aclG200DrawBuffer(): ###### (%d)\n", buffer);
/*
    if(buffer == ACLGL_BACK)
	CTX(FBPixelOffset) = sctx->FrontBackOffset;
    else if(buffer == ACLGL_FRONT || buffer == ACLGL_FRONT_AND_BACK)
	CTX(FBPixelOffset) = 0;
    else 
	return ACLGL_FALSE;
*/
LOG("aclG200DrawBuffer(): ______\n");

    return ACLGL_TRUE;
}



static void
aclG200SwapBufferBitBlt(ACLContext aclctx)
{
    MLX_INIT_ACCESS_CARD;
    MLX_INIT_ACCESS_MMCTL;

LOG("aclG200SwapBufferBitBlt() ######\n");


LOG("aclG200SwapBufferBitBlt() ______\n");
}



static void
aclG200SwapBufferScreen(ACLContext aclctx)
{
    MLX_INIT_ACCESS_CARD;
    MLX_INIT_ACCESS_MMCTL;

    /* we can put here static: only ONE client is alowed to swap screen */
    static Tbool buff = 0;

LOG("aclG200SwapBufferScreen(): ######\n")

#if 0
    if(buff) {
	buff = 0;
	/* draw into the back buffer */
	CTX(FBPixelOffset) = sctx->FrontBackOffset;
	/* show front buffer */
    }
    else {
	buff = 1;
	/* draw into the front buffer */
	CTX(FBPixelOffset) = 0;
	REG_WRITE(0, FBPixelOffsetOff);
	/* show back buffer */
    }
#endif

LOG("aclG200SwapBufferScreen(): ______\n")
}



static void
aclG200SwapBufferBitPlane(ACLContext aclctx)
{
LOG("aclG200SwapBufferBitPlane(): ###### EMPTY !!!\n");
LOG("aclG200SwapBufferBitPlane(): ______\n");
}



static Tuint
aclG200ClearBuffer(ACLContext aclctx, Tuint mask, Tbool all, Tint x, Tint y,
	Tint width, Tint height )
{
    MLX_INIT_ACCESS_MMCTL;
    Tuint orig_mask=mask, fastfill=0; /* does g200 supports fast fill ??? */

LOG("aclG200Clear(): ######\n");

    if(!mask) return 0;

    /* first, common setup: */

    /* stencil clear setup */
    if((mask & ACLGL_STENCIL_BUFFER_BIT)) {
LOG("aclG200Clear(): ACLGL_STENCIL_BUFFER_BIT, val=%d\n", VAL(clear_stencil));
	mask &= ~ACLGL_STENCIL_BUFFER_BIT;
	fastfill = 0;
    }
    else {
    }

    /* depth clear setup */
    if((mask & ACLGL_DEPTH_BUFFER_BIT)) {
LOG("aclG200Clear(): ACLGL_DEPTH_BUFFER_BIT, val=0x%x\n", VAL(clear_depth));
	mask &= ~ACLGL_DEPTH_BUFFER_BIT;
	fastfill = 0;
    }
    else {
    }

    /* color clear setup */
    if((mask & ACLGL_COLOR_BUFFER_BIT)) {
LOG("aclG200Clear(): ACLGL_COLOR_BUFFER_BIT, val=0x%x\n", VAL(clear_color));
	mask &= ~ACLGL_COLOR_BUFFER_BIT;
	/* only frame buffer, use fast clear */
	if(fastfill) {
LOG("aclG200Clear(): ----------------------> fast fill\n");
	}
	/* normal clear */
	else {
	}
    }
    else {
    }

    if(orig_mask == mask) {
	MSG("Clear: NOTHING TO CLEAR (Not supported 0x%x)\n", mask);
	return mask;
    }

    return mask;
}



Tbool
G200InitACLAPIModules(ACLContext aclctx)
{
    Tbool ret = 0;
    ACLModules mod = aclctx->Mod;
    ACLflags mf = mod->modflags;

LOG("G200InitACLAPIModules() ###### modflags=0x%x\n", mf);

#if 0

    if(!(mf & (ACLMOD_RGBA | ACLMOD_CI)))
	return 1;

    if(mf & ACLMOD_RGBA)
	ret |= G200InitACLAPIColorRGBAMod(aclctx);

#if 0
    if(mf & ACLMOD_CI)
	ret |= G200InitACLAPIColorCIMod(aclctx);
#endif

    if(mf & ACLMOD_LB)
	ret |= G200InitACLAPILBMod(aclctx);

    if(mf & ACLMOD_ACCEL)
	ret |= G200InitACLAPIAccelMod(aclctx);

    if(mf & ACLMOD_TEX)
	ret |= G200InitACLAPITexMod(aclctx);

#endif

    mod->StartRender = aclG200StartRender;
    mod->FinishRender = aclG200FinishRender;
    mod->DrawBuffer = aclG200DrawBuffer;
    mod->ClearBuffer = aclG200ClearBuffer;

    if(aclctx->acl_cfg & ACLOPT_DBUFF_SCREEN)
	mod->SwapBuffer = aclG200SwapBufferScreen;
    else if(aclctx->acl_cfg & ACLOPT_DBUFF_BITPLANE)
	mod->SwapBuffer = aclG200SwapBufferBitPlane;
    else
	mod->SwapBuffer = aclG200SwapBufferBitBlt;

LOG("G200InitACLAPIModules(): ______\n");

    return ret;
}

