
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */

/*****************************************************************************/
/*****************************************************************************/
/* Permedia2 OpenGL/Mesa driver                                              */
/* (c) 1997, 1998, 1999 SuSE GmbH                                            */
/* ------------------------------------------------------------------------- */
/* Authors:                                                                  */
/*	Simon Pogarcic, sim@suse.de                                          */
/*	Stefan Dirsch, sndirsch@suse.de                                      */
/*	Helmut Fahrion, hefa@artis.de                                        */
/*****************************************************************************/
/*****************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pm2.h"

#undef FSCOPE
#define FSCOPE static



#if 0
  #define LOG_DEBUG
#endif

#define LOG_DBGINFO "<pm2_accel>"
#include "log_debug.h"



#if 0

/******************************************************************************
                              ACCELERATOR SETUP
 ******************************************************************************/

FSCOPE ACLvoid acl_PM2_set_dither(ACLContext aclctx, ACLbool enable,
				  ACLbool modeline)
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;


    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    if (enable) {
	CRC(_DitherMode) = CRC(_DitherMode) | DTM_PM2_DitherEN | UNIT_ENABLE;

	if (modeline) {
	    CRC(_DitherMode) |= DTM_PM2_DitherMethodLine;
	}
	WAIT_FIFO(1);
	REG_WRITE(CRC(_DitherMode), DitherModeOff);
    } else {
	CRC(_DitherMode) = CRC(_DitherMode) & ~DTM_PM2_DitherEN;
	WAIT_FIFO(1);
	REG_WRITE(CRC(_DitherMode), DitherModeOff);
    }
}

FSCOPE ACLvoid acl_PM2_set_alpha(ACLContext aclctx,
				 ACLbool enable, ACLint func, ACLint ref)
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    /* durch blend wir geklippte textue nicht mehr
     gezeichnet */

    if (enable) {
	switch (func) {
	case GL_ALWAYS:
	    break;
	case GL_NEVER:
	case GL_LESS:
	case GL_EQUAL:
	case GL_LEQUAL:
	case GL_GREATER:
	case GL_NOTEQUAL:
	case GL_GEQUAL:
	default:
	    /* MSG("Undefined AlphaFunc!\n"); */
	    break;
	}

	WAIT_FIFO(2);
	CRC(_AlphaBlendMode) |= (VAL(_ColorFormatFront) << 8)
	    | VAL(_ColorFormatExt) |
	    UNIT_ENABLE;
	LOG("acl_PM2_set_alpha: CRC(_AlphaBlendMode) = %x\n", CRC(_AlphaBlendMode) );
	/* Turned off frame buffer read mode - should be handled by enable/disable
	   not by a mode change.  */
	/* CRC(_FBReadMode) |= FBRM_DestEN; */

	 /* REG_WRITE(CRC(_FBReadMode), FBReadModeOff); */
	REG_WRITE(CRC(_AlphaBlendMode), AlphaBlendModeOff);
    } else {
	/* disable alpha unit */
	WAIT_FIFO(2);
	CRC(_AlphaBlendMode) &= ~UNIT_ENABLE;
	REG_WRITE(CRC(_AlphaBlendMode), AlphaBlendModeOff);
    }
}


FSCOPE ACLvoid acl_PM2_set_blend(ACLContext aclctx,
				 ACLbool enable, ACLint src, ACLint dst)
{
    static int glone;

    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    if (olddrvidx ^ aclctx->drvidx) {
 	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }
    glone = 0;

    /* durch blend wir geklippte textue nicht mehr
     gezeichnet */

    if (enable) {

	/* Visualinfo stimmt nicht
	   if (aclctx->vis->AlphaBits == 0) {
	     glone = 1; 
	     printf("Alpha=0 GL_ONE!\n");
	   } else 
	*/

	switch (src) {
	case GL_ZERO:
	    if (VAL(_QuakeBlend))
		glone = GL_ONE; 
	    /* MSG("Undefined Blend SRC GL_ZERO Function defined.\n"); */
	    break;
	case GL_DST_COLOR:
	case GL_ONE_MINUS_DST_COLOR:
	case GL_ONE_MINUS_SRC_ALPHA:
	case GL_DST_ALPHA:
	case GL_ONE_MINUS_DST_ALPHA:
	case GL_SRC_ALPHA_SATURATE:
	case GL_SRC_COLOR:
	case GL_ONE_MINUS_SRC_COLOR:
	    /* MSG("Undefined Blend SRC Function defined.\n"); */
	    break;
	case GL_SRC_ALPHA:
	    break;
	case GL_ONE:
	    glone = GL_ONE;
	    break;
	default:
	    break;
	}	    
#if 0
  Hat kein Sinn beim Permedia 2.
	switch (dst) {
	    case GL_ONE_MINUS_SRC_ALPHA:
		break;
	case GL_ONE_MINUS_DST_ALPHA:
	case GL_ONE:
	case GL_ZERO:
	case GL_DST_COLOR:
	case GL_ONE_MINUS_DST_COLOR:
	case GL_DST_ALPHA:
	case GL_SRC_ALPHA_SATURATE:
	case GL_SRC_COLOR:
	case GL_ONE_MINUS_SRC_COLOR:
	case GL_SRC_ALPHA:
	    /* MSG("Undefined Blend DST Function defined.\n"); */
	default:
	    break;
	}
#endif

	CRC(_AlphaBlendMode) = ABM_PM2_OperationBlend 
			    | (VAL(_ColorFormatFront) << 8) 
			    | VAL(_ColorFormatExt) 
			    | ((glone == GL_ONE)? ABM_PM2_AlphaBuffNotPresent:0) 
			    | ABM_PM2_ColorOrderRGB
			    | UNIT_ENABLE;

	CRC(_FBReadMode) |= FBRM_DestEN;

	WAIT_FIFO(2);

	REG_WRITE(CRC(_AlphaBlendMode), AlphaBlendModeOff);
    } else {
	WAIT_FIFO(2);
	CRC(_AlphaBlendMode) &= ABM_PM2_OperationMASK;

	/* ### Quake Hack da kein GL_ZERO mglich ist, Icons ! ### */
	if (glone != GL_ONE)
	    CRC(_AlphaBlendMode) |= ABM_PM2_OperationBlend;

	CRC(_FBReadMode) &= ~FBRM_DestEN;
	REG_WRITE(CRC(_AlphaBlendMode), AlphaBlendModeOff);
    }
}
 
FSCOPE ACLvoid acl_PM2_set_fog(ACLContext aclctx,
			       ACLbool enable, ACLint mode, ACLfloat density,
			       ACLfloat r, ACLfloat g, ACLfloat b, ACLfloat a)
{
    int color;
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    VAL(_FogMode) = enable;	/* Umschaltung fr Dreieck */

    if (enable) {
	CRC(_DeltaMode) |= DM_FogEN;
	WAIT_FIFO(3);
	REG_WRITE(CRC(_DeltaMode), DeltaModeOff);
	color = BLOCKCOLOR_RGBA_8888_abgr((int) (r * 255.0),
					  (int) (g * 255.0),
					  (int) (b * 255.0),
					  (int) (a * 255.0));
	REG_WRITE(color, FogColorOff);
	REG_WRITE(FOG_FogTestEN | UNIT_ENABLE, FogModeOff);
    } else {
	CRC(_DeltaMode) &= DM_FogMASK;
	WAIT_FIFO(2);
	REG_WRITE(CRC(_DeltaMode), DeltaModeOff);
	REG_WRITE(UNIT_ZERO, FogModeOff);
    }
}

FSCOPE ACLvoid
 acl_PM2_set_logop(ACLContext aclctx, ACLbool enable, ACLint logop)
{
    int x;

    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }
    if (enable) {
	WAIT_FIFO(3);

	switch (logop) {
	case GL_CLEAR:
	    x = LOP__Clear;
	    break;
	case GL_AND:
	    x = LOP__And;
	    break;
	case GL_AND_REVERSE:
	    x = LOP__AndRev;
	    break;
	case GL_COPY:
	    x = LOP__Copy;
	    break;
	case GL_AND_INVERTED:
	    x = LOP__AndInv;
	    break;
	case GL_NOOP:
	    x = LOP__Noop;
	    break;
	case GL_XOR:
	    x = LOP__Xor;
	    break;
	case GL_OR:
	    x = LOP__Or;
	    break;
	case GL_NOR:
	    x = LOP__Nor;
	    break;
	case GL_EQUIV:
	    x = LOP__Equ;
	    break;
	case GL_INVERT:
	    x = LOP__Invert;
	    break;
	case GL_OR_REVERSE:
	    x = LOP__OrRev;
	    break;
	case GL_COPY_INVERTED:
	    x = LOP__CopyInv;
	    break;
	case GL_NAND:
	    x = LOP__Nand;
	    break;
	case GL_SET:
	    x = LOP__Set;
	    break;
	default:
	    x = LOP__Set;
	}

	CRC(_LogicalOpMode) = x | UNIT_ENABLE;
	REG_WRITE(CRC(_LogicalOpMode), LogicalOpModeOff);

	if (!(CRC(_ColorDDAMode) & 1)) {
	    CRC(_ColorDDAMode) |= UNIT_ENABLE; 
	    REG_WRITE(CRC(_ColorDDAMode), ColorDDAModeOff);
	}
	CRC(_FBReadMode) |= FBRM_DestEN;
	REG_WRITE(CRC(_FBReadMode), FBReadModeOff);
    } else {
	WAIT_FIFO(2);
	CRC(_LogicalOpMode) = UNIT_ZERO;
	CRC(_LogicalOpMode) &= FBRM_DestMASK; /* ?? BlendMode ? */
	REG_WRITE(CRC(_LogicalOpMode), LogicalOpModeOff);
	REG_WRITE(CRC(_FBReadMode), FBReadModeOff);
    }
}

#endif



/*****************************************************************************
 *****************************************************************************
 
                              DRAWING PRIMITIVES

 *****************************************************************************
 *****************************************************************************/

#define SET_TRIANGLE \
	R_PrimitiveTrapezoid | \
	R_SubPixelCorrEN

#define SET_QUAD \
	R_PrimitiveTrapezoid | \
	R_SubPixelCorrEN

#define SET_LINE \
	R_PrimitiveLine | \
	R_SubPixelCorrEN

#define SET_POINT \
	R_PrimitivePoint | \
	R_SubPixelCorrEN

#if 0
/*============================================================================
                                   POINTS
 ============================================================================*/
FSCOPE void
aclPM2PointsFlat(ACLContext hctx, Tuint first, Tuint last)
{
    ACLContext aclctx = (ACLContext) hctx->DriverCtx;

    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    ACLVertexBuffer VB = hctx->VB;
    ACLfloat depth;
    ACLuint x;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    TLOG("_points_flat\n");

    for (x = first; x <= last; x++) {
	WAIT_FIFO(5);
	REG_WRITE(VAL(_Color) = VALCOLOR(x), ConstantColorOff);
	depth = VAL_Z(x);
	REG_CWRITE(VAL_X(x), VFLOoff_x(0));
	REG_CWRITE(VAL_Y(x), VFLOoff_y(0));
	REG_CWRITE(depth, VFLOoff_z(0));

	#define ACL_CLIPP_INIT_COMMANDS \
	    REG_WRITE(SET_POINT, DrawLine01Off)
	#define ACL_CLIPP_REPEAT_COMMANDS \
	    REG_WRITE(0, RepeatLineOff)

	ACL_CLIPP_DRAW

	#undef ACL_CLIPP_INIT_COMMANDS
	#undef ACL_CLIPP_REPEAT_COMMANDS
    }
}



FSCOPE ACLvoid
 acl_PM2_points_smooth(ACLHyperContext hctx, ACLuint first, ACLuint last)
{
    ACLContext aclctx = (ACLContext) hctx->DriverCtx;

    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    ACLuint x;

    ACLVertexBuffer VB = hctx->VB;
    ACLfloat depth;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }
    TLOG("_points_smooth\n");

    for (x = first; x <= last; x++) {
	WAIT_FIFO(5);
	REG_WRITE(VALCOLOR(x), VFIXoff_pc(0));
	depth = VAL_Z(x);
	REG_CWRITE(VAL_X(x), VFLOoff_x(0));
	REG_CWRITE(VAL_Y(x), VFLOoff_y(0));
	REG_CWRITE(depth, VFLOoff_z(0));

	#define ACL_CLIPP_INIT_COMMANDS \
	    REG_WRITE(SET_POINT, DrawLine01Off)
	#define ACL_CLIPP_REPEAT_COMMANDS \
	    REG_WRITE(0, RepeatLineOff)

	ACL_CLIPP_DRAW

	#undef ACL_CLIPP_INIT_COMMANDS
	#undef ACL_CLIPP_REPEAT_COMMANDS
    }
}



FSCOPE ACLvoid
 acl_PM2_points_texture(ACLHyperContext hctx, ACLuint first, ACLuint last)
{
    ACLContext aclctx = (ACLContext) hctx->DriverCtx;

    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    ACLuint x;
    ACLVertexBuffer VB = hctx->VB;
    ACLfloat z, s, t, q, w, ws, hs;
    ACLuint comm;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }
    comm = SET_POINT | R_TextureEN;

    TLOG("_points_texture\n");

    ws = 1.0 / (float) (1 << ((int) (11 - VAL(_Triwl2))));
    hs = 1.0 / (float) (1 << ((int) (11 - VAL(_Trihl2))));

    for (x = first; x <= last; x++) {
	WAIT_FIFO(8);
	REG_WRITE(VALCOLOR(x), VFIXoff_pc(0));

	z = VAL_Z(x);
	w = VAL_W(x);
	q = VAL_Q(x) / w;
	s = VAL_S(x) * q * ws;
	t = VAL_T(x) * q * hs;

	REG_CWRITE(s, VFLOoff_s(0));
	REG_CWRITE(t, VFLOoff_t(0));
	REG_CWRITE(q, VFLOoff_q(0));
	REG_CWRITE(VAL_X(x), VFLOoff_x(0));
	REG_CWRITE(VAL_Y(x), VFLOoff_y(0));
	REG_CWRITE(z, VFLOoff_z(0));

	#define ACL_CLIPP_INIT_COMMANDS \
	    REG_WRITE(comm, DrawLine01Off)
	#define ACL_CLIPP_REPEAT_COMMANDS \
	    REG_WRITE(0, RepeatLineOff)

	ACL_CLIPP_DRAW

	#undef ACL_CLIPP_INIT_COMMANDS
	#undef ACL_CLIPP_REPEAT_COMMANDS
    }
}

/*****************************************************************************
	LINE PRIMITIVES
 *****************************************************************************/

FSCOPE ACLvoid
 acl_PM2_line_flat(ACLHyperContext hctx, ACLuint v1, ACLuint v2, ACLuint pv)
{
    ACLContext aclctx = (ACLContext) hctx->DriverCtx;

    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    ACLVertexBuffer VB = hctx->VB;
    ACLfloat depth;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }
    TLOG("_line_flat\n");

    WAIT_FIFO(3 * 2 + 2);

    REG_WRITE(VAL(_Color) = VALCOLOR(pv), ConstantColorOff);

    depth = VAL_Z(v1);
    REG_CWRITE(VAL_X(v1), VFLOoff_x(0));
    REG_CWRITE(VAL_Y(v1), VFLOoff_y(0));
    REG_CWRITE(depth, VFLOoff_z(0));

    depth = VAL_Z(v2);
    REG_CWRITE(VAL_X(v2), VFLOoff_x(1));
    REG_CWRITE(VAL_Y(v2), VFLOoff_y(1));
    REG_CWRITE(depth, VFLOoff_z(1));

	#define ACL_CLIPP_INIT_COMMANDS \
	REG_WRITE(SET_LINE, DrawLine01Off)
	#define ACL_CLIPP_REPEAT_COMMANDS \
	REG_WRITE(0, RepeatLineOff)

    ACL_CLIPP_DRAW

	#undef ACL_CLIPP_INIT_COMMANDS
	#undef ACL_CLIPP_REPEAT_COMMANDS
}



FSCOPE ACLvoid
 acl_PM2_line_smooth(ACLHyperContext hctx, ACLuint v1, ACLuint v2, ACLuint pv)
{
    ACLContext aclctx = (ACLContext) hctx->DriverCtx;

    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    ACLVertexBuffer VB = hctx->VB;
    ACLfloat depth;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }
    TLOG("_line_smooth\n");

    WAIT_FIFO(4 * 2 + 1);

    REG_WRITE(VALCOLOR(v1), VFIXoff_pc(0));
    depth = VAL_Z(v1);
    REG_CWRITE(VAL_X(v1), VFLOoff_x(0));
    REG_CWRITE(VAL_Y(v1), VFLOoff_y(0));
    REG_CWRITE(depth, VFLOoff_z(0));

    REG_WRITE(VALCOLOR(v2), VFIXoff_pc(1));
    depth = VAL_Z(v2);
    REG_CWRITE(VAL_X(v2), VFLOoff_x(1));
    REG_CWRITE(VAL_Y(v2), VFLOoff_y(1));
    REG_CWRITE(depth, VFLOoff_z(1));

	#define ACL_CLIPP_INIT_COMMANDS \
	REG_WRITE(SET_LINE, DrawLine01Off)
	#define ACL_CLIPP_REPEAT_COMMANDS \
	REG_WRITE(0, RepeatLineOff)

    ACL_CLIPP_DRAW

	#undef ACL_CLIPP_INIT_COMMANDS
	#undef ACL_CLIPP_REPEAT_COMMANDS
}

FSCOPE ACLvoid
 acl_PM2_line_texture(ACLHyperContext hctx, ACLuint v1, ACLuint v2, ACLuint pv)
{
    ACLContext aclctx = (ACLContext) hctx->DriverCtx;

    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    ACLVertexBuffer VB = hctx->VB;
    ACLfloat s, t, q, z, w, ws, hs;
    ACLuint comm;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }
    TLOG("_line_texture\n");

    if (VAL(_TexEN)) {
	comm = SET_LINE | R_TextureEN;
    } else {
	comm = SET_LINE;
    }

    ws = 1.0 / (float) (1 << ((int) (11 - VAL(_Triwl2))));
    hs = 1.0 / (float) (1 << ((int) (11 - VAL(_Trihl2))));


    z = VAL_Z(v1);
    w = VAL_W(v1);
    q = VAL_Q(v1) / w;
    s = VAL_S(v1) * q * ws;
    t = VAL_T(v1) * q * hs;

    WAIT_FIFO(7 * 3);

    REG_WRITE(VALCOLOR(v1), VFIXoff_pc(0));
    REG_CWRITE(s, VFLOoff_s(0));
    REG_CWRITE(t, VFLOoff_t(0));
    REG_CWRITE(q, VFLOoff_q(0));
    REG_CWRITE(VAL_X(v1), VFLOoff_x(0));
    REG_CWRITE(VAL_Y(v1), VFLOoff_y(0));
    REG_CWRITE(z, VFLOoff_z(0));

    REG_WRITE(VALCOLOR(v2), VFIXoff_pc(1));
    z = VAL_Z(v1);
    w = VAL_W(v1);
    q = VAL_Q(v1) / w;
    s = VAL_S(v1) * q * ws;
    t = VAL_T(v1) * q * hs;
    REG_CWRITE(s, VFLOoff_s(1));
    REG_CWRITE(t, VFLOoff_t(1));
    REG_CWRITE(q, VFLOoff_q(1));
    REG_CWRITE(VAL_X(v2), VFLOoff_x(1));
    REG_CWRITE(VAL_Y(v2), VFLOoff_y(1));
    REG_CWRITE(z, VFLOoff_z(1));

	#define ACL_CLIPP_INIT_COMMANDS \
	REG_WRITE(comm, DrawLine01Off)
	#define ACL_CLIPP_REPEAT_COMMANDS \
	REG_WRITE(0, RepeatLineOff)

    ACL_CLIPP_DRAW

	#undef ACL_CLIPP_INIT_COMMANDS
	#undef ACL_CLIPP_REPEAT_COMMANDS
}

/*****************************************************************************
	Quad PRIMITIVE
 *****************************************************************************/
FSCOPE ACLvoid
 acl_PM2_quad_texture(ACLHyperContext hctx,
			  ACLuint v1, ACLuint v2, ACLuint v3, ACLuint v4, ACLuint pv)
{
    ACLContext aclctx = (ACLContext) hctx->DriverCtx;
    register ACLVertexBuffer VB = hctx->VB;
    ACLuint comm;
    ACLuint tl_ver, tr_ver, bl_ver, br_ver;
    ACLuint StartXDom,dXDom,StartXSub,dXSub,StartY,dY,Count;
    ACLuint Sstart, dSdx, dSdyDom, Tstart, dTdx, dTdyDom, Qstart, dQdx, dQdyDom;

    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }
    TLOG("_quad_texture\n");


    if (VAL(_TexEN)) {
	comm = SET_QUAD | R_TextureEN;
    } else {
	comm = SET_QUAD;
    }

	/* sort vertices into bottom left, bottom right, top right, top left, 
	   assumes CCW vertices */

	if ( VAL_X(v1) < VAL_X(v3) ) 
	{ if( VAL_Y(v1) < VAL_Y(v3) ) 
		{ bl_ver=v1; br_ver=v4; tr_ver=v3; tl_ver=v2;
		} else
		{ tl_ver=v1; bl_ver=v2; br_ver=v3; tr_ver=v4;
		}
	} else
	{ if( VAL_Y(v1) < VAL_Y(v3) ) 
		{ br_ver=v1; tr_ver=v2; tl_ver=v3; bl_ver=v4;
		} else
		{ tr_ver=v1; tl_ver=v2; bl_ver=v3; br_ver=v4;
		}
	}

	LOG("VAL_X %f %f %f %f\n", VAL_X(v1), VAL_X(v2), VAL_X(v3), VAL_X(v4) );	
	LOG("VAL_Y %f %f %f %f\n", VAL_Y(v1), VAL_Y(v2), VAL_Y(v3), VAL_Y(v4) );	

		/* Check for horizontally aligned trapezoids */

#if 1
		if(  
			( ( VAL_Y(bl_ver) - VAL_Y(br_ver) ) >= 0.0000001 ) 
		     || ( ( VAL_Y(tl_ver) - VAL_Y(tr_ver) ) >= 0.0000001 ) )
#else
		if( 1 )
#endif

		{
		  acl_PM2_triangle_texture (hctx,v1,v2,v4,pv);
		  acl_PM2_triangle_texture (hctx,v2,v3,v4,pv);
		  return;
		/* ugly exit from routine */
		} 

		/* Check for special case rectangle */

		if(
			( ( VAL_X(bl_ver) - VAL_X(tl_ver) ) >= 0.0000001 ) 
		     || ( ( VAL_X(br_ver) - VAL_X(tr_ver) ) >= 0.0000001 ) )
		{
	  	  acl_PM2_triangle_texture (hctx,v1,v2,v4,pv);
		  acl_PM2_triangle_texture (hctx,v2,v3,v4,pv);
		  return;
		/* ugly exit from routine */
		} 

	StartXDom = (int) ( ( 1 << 16 ) * VAL_X(bl_ver) );
	dXDom = 0;
	StartXSub = (int) ( ( 1 << 16 ) * VAL_X(br_ver) );
	dXSub = 0;
	StartY =    (int) ( ( 1 << 16 ) * VAL_Y(bl_ver) );
	dY= 1<<16;
	Count =    abs((int) ( VAL_Y(tr_ver) - VAL_Y(bl_ver) ));

	Sstart = (int) ( ( 1 << 20 ) * VAL_S(bl_ver) );
	dSdx = 1 << 20;
	dSdyDom = 0;
	Tstart = (int) ( ( 1 << 20 ) * VAL_T(bl_ver) );
	dTdx = 0;
	dTdyDom = 1 << 20;

	Qstart = 1 << 30 ;
	dQdx = 0 ;
	dQdyDom = 0 ;
        
	{
	  LOG("StartXDom = %f, dXDom = %d\n", ((float) StartXDom) / (1 << 16), dXDom );
	  LOG("StartXSub = %f, dXSub = %d\n", ((float) StartXSub) / (1 << 16), dXSub );
	  LOG("StartY    = %f, dY    = %d\n", (float) ( StartY / (1 << 16) ), dY );
	  LOG("Count     = %d\n", Count);

	  LOG("Sstart    = %f, dSdx  = %f, dSdyDom = %f\n", 
			(float) ( Sstart   / (1 << 20) ), 
			(float)	( dSdx     / (1 << 20) ), 
			(float) ( dSdyDom  / (1 << 20) ) );
	

	  LOG("Tstart    = %f, dTdx  = %f, dTdyDom = %f\n", 
			(float) ( Tstart   / ( 1 << 20) ), 
			(float) ( dTdx     / ( 1 << 20) ), 
			(float) ( dTdyDom  / ( 1 << 20) ) );
	
	  LOG("Qstart = %f, dQdx = %f, dQdyDom = %f\n", 
			(float) ( Qstart    / (1 << 30) ),
			(float) ( dQdx      / (1 << 30) ),
			(float) ( dQdyDom   / (1 << 30) ) );
	}   

 
    WAIT_FIFO(7 + 9);

    REG_WRITE(StartXDom, StartXDomOff);
    REG_WRITE(dXDom, dXDomOff);
    REG_WRITE(StartXSub, StartXSubOff);
    REG_WRITE(dXSub, dXSubOff);
    REG_WRITE(StartY, StartYOff);
    REG_WRITE(dY, dYOff);
    REG_WRITE(Count, CountOff);


    REG_WRITE(Sstart, SStartOff);
    REG_WRITE(dSdx, dSdxOff);
    REG_WRITE(dSdyDom, dSdyDomOff);
    REG_WRITE(Tstart, TStartOff);
    REG_WRITE(dTdx, dTdxOff);
    REG_WRITE(dTdyDom, dTdyDomOff);
    REG_WRITE(Qstart, QStartOff);
    REG_WRITE(dQdx, dQdxOff);
    REG_WRITE(dQdyDom, dQdyDomOff);


    if (VAL(_QuakeBlend)) 
    {
        WAIT_FIFO(1);
        REG_WRITE(comm, RenderOff);
        return;
    } else 
    {
      #define ACL_CLIPP_INIT_COMMANDS          REG_WRITE(comm, RenderOff)
      /* #define ACL_CLIPP_REPEAT_COMMANDS     REG_WRITE(0, RepeatquadOff) */
        /*
         * if (aclctx->TwoSide) {
         * REG_WRITE (SET_quad | RejectNegativeFace, Drawquad);
         * }
         */

        ACL_CLIPP_DRAW

      #undef ACL_CLIPP_INIT_COMMANDS
        
      /* #undef ACL_CLIPP_REPEAT_COMMANDS */
    }	/* if quakeblend */

    #if 1
    {
       static int count=1, cum_space=0;
       if(count % 100 == 0) cum_space += REG_READ(InFIFOSpace);
       /* turn on/off fifo fullness printing */
	  if ( count % 10000 == 0 ) 
	     {
       	     LOG("average quad InFIFOSpace = %d\n", cum_space/100 );
	     cum_space = 0;
	     }
       count++; 
    }
    #endif

} /* texture_quad */

#endif



/*============================================================================
                                 TRIANGLES
 ============================================================================*/
FSCOPE void
aclPM2TriangleFlat(ACLContext aclctx, ACLVertices vb,
	Tuint v0, Tuint v1, Tuint v2, Tuint pv)
{
    MLX_INIT_ACCESS_MMCTL;

    Tfloat (*Win)[3] = vb->win;
    Tfloat *win0=Win[v0], *win1=Win[v1], *win2=Win[v2];
    Tubyte *color = vb->color[pv];
    Tfloat depth0, depth1, depth2;

LOG("aclPM2TriangleFlat ######\n");

    depth0 = win0[2] * (1.0 / VAL(depth_par_range));
    depth1 = win1[2] * (1.0 / VAL(depth_par_range));
    depth2 = win2[2] * (1.0 / VAL(depth_par_range));

    WAIT_FIFO(12);

    REG_WRITE(CTX(ColorDDAMode), ColorDDAModeOff);
    REG_WRITE(CTX(DeltaMode), DeltaModeOff);

    REG_CWRITE(win0[0], VFLOoff_x(0));
    REG_CWRITE(win0[1], VFLOoff_y(0));
    REG_CWRITE(depth0, VFLOoff_z(0));

    REG_CWRITE(win1[0], VFLOoff_x(1));
    REG_CWRITE(win1[1], VFLOoff_y(1));
    REG_CWRITE(depth1, VFLOoff_z(1));

    REG_CWRITE(win2[0], VFLOoff_x(2));
    REG_CWRITE(win2[1], VFLOoff_y(2));
    REG_CWRITE(depth2, VFLOoff_z(2));

    REG_WRITE(PACKED_COLOR(color[0], color[1], color[2], color[3]),
	ConstantColorOff);

    #undef MLX_DRAW_REPEAT_CNT
    #undef MLX_DRAW_INIT
    #undef MLX_DRAW_REPEAT
    #define MLX_DRAW_REPEAT_CNT 1
    #define MLX_DRAW_INIT	REG_WRITE(SET_TRIANGLE, DrawTriangleOff)
    #define MLX_DRAW_REPEAT	REG_WRITE(0, RepeatTriangleOff)
    MLX_DRAW_CLIPPED
}



FSCOPE void
aclPM2TriangleSmooth(ACLContext aclctx, ACLVertices vb,
	Tuint v0, Tuint v1, Tuint v2, Tuint pv)
{
    MLX_INIT_ACCESS_MMCTL;

    Tfloat (*Win)[3] = vb->win;
    Tfloat *win0=Win[v0], *win1=Win[v1], *win2=Win[v2];
    Tubyte (*Color)[4] = vb->color;
    Tubyte *color0=Color[v0], *color1=Color[v1], *color2=Color[v2];
    Tfloat depth0, depth1, depth2;

LOG("aclPM2TriangleSmooth ######\n");

    depth0 = win0[2] * (1.0 / VAL(depth_par_range));
    depth1 = win1[2] * (1.0 / VAL(depth_par_range));
    depth2 = win2[2] * (1.0 / VAL(depth_par_range));

    WAIT_FIFO(18);

    REG_WRITE(CTX(DeltaMode) | DM_SmoothShadingEN, DeltaModeOff);
    REG_WRITE(CTX(ColorDDAMode) | DDA_ShadingGouraud, ColorDDAModeOff);

    REG_CWRITE(win0[0], VFLOoff_x(0));
    REG_CWRITE(win0[1], VFLOoff_y(0));
    REG_CWRITE(depth0, VFLOoff_z(0));
    REG_WRITE(PACKED_COLOR(color0[0], color0[1], color0[2], color0[3]),
	VFIXoff_pc(0));

    REG_CWRITE(win1[0], VFLOoff_x(1));
    REG_CWRITE(win1[1], VFLOoff_y(1));
    REG_CWRITE(depth1, VFLOoff_z(1));
    REG_WRITE(PACKED_COLOR(color1[0], color1[1], color1[2], color1[3]),
	VFIXoff_pc(1));

    REG_CWRITE(win2[0], VFLOoff_x(2));
    REG_CWRITE(win2[1], VFLOoff_y(2));
    REG_CWRITE(depth2, VFLOoff_z(2));
    REG_WRITE(PACKED_COLOR(color2[0], color2[1], color2[2], color2[3]),
	VFIXoff_pc(2));

    #undef MLX_DRAW_REPEAT_CNT
    #undef MLX_DRAW_INIT
    #undef MLX_DRAW_REPEAT
    #define MLX_DRAW_REPEAT_CNT 1
    #define MLX_DRAW_INIT	REG_WRITE(SET_TRIANGLE, DrawTriangleOff)
    #define MLX_DRAW_REPEAT	REG_WRITE(0, RepeatTriangleOff)
    MLX_DRAW_CLIPPED
}



#if 0
FSCOPE ACLvoid
 acl_PM2_triangle_texture(ACLHyperContext hctx,
	ACLuint v1, ACLuint v2, ACLuint v3, ACLuint pv)
{
    ACLContext aclctx = (ACLContext) hctx->DriverCtx;

#if 0
    ACLfloat *Win1=vx1->Win, *Win2=vx2->Win, *Win3=vx3->Win;
    ACLubyte *Color1=vx1->Color, *Color2=vx2->Color, *Color3=vx3->Color;
    ACLfloat *TexCoord1=vx1->TexCoord, *TexCoord2=vx2->TexCoord,
    	*TexCoord3=vx3->TexCoord;

    ACLfloat z, s, t, fog, q;
    register float ws, hs;
    ACLuint comm;

    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }
    TLOG("_triangle_texture\n");


    ws = 1.0 / (float) (1 << ((int) (11 - VAL(_Triwl2))));
    hs = 1.0 / (float) (1 << ((int) (11 - VAL(_Trihl2))));

    WAIT_FIFO(7 * 3);


/* 0 turns off all textured triangles */
#if 1
/* move some register write up front to get Pentium write buffer going */
    REG_CWRITE(VAL_X(v1), VFLOoff_x(0));
    REG_CWRITE(VAL_Y(v1), VFLOoff_y(0));
    REG_CWRITE(VAL_X(v2), VFLOoff_x(1));
    REG_CWRITE(VAL_Y(v2), VFLOoff_y(1));
    REG_CWRITE(VAL_X(v3), VFLOoff_x(2));
    REG_CWRITE(VAL_Y(v3), VFLOoff_y(2));

    z = VAL_Z(v1);
    q = VAL_Q(v1) / VAL_W(v1);
    s = VAL_S(v1) * q * ws;
    t = VAL_T(v1) * q * hs;
    REG_WRITE(VALCOLOR(v1), VFIXoff_pc(0));
    REG_CWRITE(s, VFLOoff_s(0));
    REG_CWRITE(t, VFLOoff_t(0));
    REG_CWRITE(q, VFLOoff_q(0));
    REG_CWRITE(z, VFLOoff_z(0));

    z = VAL_Z(v2);
    q = VAL_Q(v2) / VAL_W(v2);
    s = VAL_S(v2) * q * ws;
    t = VAL_T(v2) * q * hs;
    REG_WRITE(VALCOLOR(v2), VFIXoff_pc(1));
    REG_CWRITE(s, VFLOoff_s(1));
    REG_CWRITE(t, VFLOoff_t(1));
    REG_CWRITE(q, VFLOoff_q(1));
    REG_CWRITE(z, VFLOoff_z(1));

    z = VAL_Z(v3);
    q = VAL_Q(v3) / VAL_W(v3);
    s = VAL_S(v3) * q * ws;
    t = VAL_T(v3) * q * hs;
    REG_WRITE(VALCOLOR(v3), VFIXoff_pc(2));
    REG_CWRITE(s, VFLOoff_s(2));
    REG_CWRITE(t, VFLOoff_t(2));
    REG_CWRITE(q, VFLOoff_q(2));
    REG_CWRITE(z, VFLOoff_z(2));

    if (VAL(_TexEN)) {
	comm = SET_TRIANGLE | R_TextureEN;
    } else {
	comm = SET_TRIANGLE;
    }

    if (VAL(_QuakeBlend)) {
	WAIT_FIFO(1);
	REG_WRITE(comm, DrawTriangleOff);
	return;
    } else {

	if (VAL(_FogMode)) {
	    comm |= R_FogEN;

	    WAIT_FIFO(3);

	    fog = 1.0 / hctx->Fog.Density;
	    /* fog=hctx->Fog.Density; */
	    /* berlagert sich mit Mesa Software-
	       Rendering
	    */
	    REG_CWRITE(fog, VFLOoff_f(0));
	    REG_CWRITE(fog, VFLOoff_f(1));
	    REG_CWRITE(fog, VFLOoff_f(2));
	}

#define ACL_CLIPP_INIT_COMMANDS \
	REG_WRITE(comm, DrawTriangleOff)
#define ACL_CLIPP_REPEAT_COMMANDS \
	REG_WRITE(0, RepeatTriangleOff)
	/*
	 * if (aclctx->TwoSide) {
	 * REG_WRITE (SET_TRIANGLE | RejectNegativeFace, DrawTriangle);
	 * }
	 */

	ACL_CLIPP_DRAW

#undef ACL_CLIPP_INIT_COMMANDS
#undef ACL_CLIPP_REPEAT_COMMANDS
	}
#endif
 
 
     #if 1
     {
        static int count=1, cum_space=0;
        /* add 21 because we just put 21 entries in the fifo */
        if(count % 100 == 0) cum_space += REG_READ(InFIFOSpace) + 21;
        /* turn on/off fifo fullness printing */
 	  if ( count % 100000 == 0 ) 
        	     LOG("average InFIFOSpace = %d\n", cum_space/1000 );
 	    
        count++; 
     }
     #endif

}

#endif
#endif



FSCOPE ACLflags
aclPM2UpdateFuncPointers(ACLContext aclctx, ACLflags fmask, ACLRender fflags)
{
    ACLAccelMod am = aclctx->Mod->Accel;
    ACLflags ffl, rmask = 0;

LOG("aclPM2UpdateFuncPointers(): ###### update pointers: 0x%x\n", fmask);

    while(fmask & ACLPRIM_POINTS) {
	ffl = fflags->points;
	if(ffl & ACLRENDER_TEX) {
	}
	else if(ffl & ACLRENDER_SMOOTH) {
	}
	else if(ffl & ACLRENDER_FLAT) {
	}
	else if(!ffl) {
	    break;
	}
LOG("NULL primitive ACLPRIM_POINTS\n");
	rmask |= ACLPRIM_POINTS;
	am->Points = NULL;
	break;
    }

    while(fmask & ACLPRIM_LINE) {
	ffl = fflags->line;
	if(ffl & ACLRENDER_TEX) {
	}
	else if(ffl & ACLRENDER_SMOOTH) {
	}
	else if(ffl & ACLRENDER_FLAT) {
	}
	else if(!ffl) {
	    break;
	}
LOG("NULL primitive ACLPRIM_LINE\n");
	rmask |= ACLPRIM_LINE;
	am->Line = NULL;
	break;
    }

    while(fmask & ACLPRIM_TRIANGLE) {
	ffl = fflags->triangle;
	if(ffl & ACLRENDER_TEX) {
	}
	else if(ffl & ACLRENDER_SMOOTH) {
	    am->Triangle = aclPM2TriangleSmooth;
	    break;
	}
	else if(ffl & ACLRENDER_FLAT) {
	    am->Triangle = aclPM2TriangleFlat;
	    break;
	}
	else if(!ffl) {
	    break;
	}
LOG("NULL primitive ACLPRIM_TRIANGLE\n");
	rmask |= ACLPRIM_TRIANGLE;
	am->Triangle = NULL;
	break;
    }

    while(fmask & ACLPRIM_QUAD) {
	ffl = fflags->quad;
	if(ffl & ACLRENDER_TEX) {
	}
	else if(ffl & ACLRENDER_SMOOTH) {
	}
	else if(ffl & ACLRENDER_FLAT) {
	}
	else if(!ffl) {
	    break;
	}
LOG("NULL primitive ACLPRIM_QUAD\n");
	rmask |= ACLPRIM_QUAD;
	am->Quad = NULL;
	break;
    }
    
    while(fmask & ACLPRIM_RECT) {
	ffl = fflags->rect;
	if(ffl & ACLRENDER_TEX) {
	}
	else if(ffl & ACLRENDER_SMOOTH) {
	}
	else if(ffl & ACLRENDER_FLAT) {
	}
	else if(!ffl) {
	    break;
	}
LOG("NULL primitive ACLPRIM_RECT\n");
	rmask |= ACLPRIM_RECT;
	am->Rect = NULL;
	break;
    }

    while(fmask & ACLPRIM_VB_LINES) {
	ffl = fflags->vblines;
	if(ffl & ACLRENDER_TEX) {
	}
	else if(ffl & ACLRENDER_SMOOTH) {
	}
	else if(ffl & ACLRENDER_FLAT) {
	}
	else if(!ffl) {
	    break;
	}
LOG("NULL primitive ACLPRIM_VB_LINES\n");
	rmask |= ACLPRIM_VB_LINES;
	am->LinesVB = NULL;
	break;
    }

    while(fmask & ACLPRIM_VB_TRIANGLES) {
	ffl = fflags->vbtriangles;
	if(ffl & ACLRENDER_TEX) {
	}
	else if(ffl & ACLRENDER_SMOOTH) {
	}
	else if(ffl & ACLRENDER_FLAT) {
	}
	else if(!ffl) {
	    break;
	}
LOG("NULL primitive ACLPRIM_VB_TRIANGLES\n");
	rmask |= ACLPRIM_VB_TRIANGLES;
	am->TrianglesVB = NULL;
	break;
    }

    while(fmask & ACLPRIM_VB_QUADS) {
	ffl = fflags->vbquads;
	if(ffl & ACLRENDER_TEX) {
	}
	else if(ffl & ACLRENDER_SMOOTH) {
	}
	else if(ffl & ACLRENDER_FLAT) {
	}
	else if(!ffl) {
	    break;
	}
LOG("NULL primitive ACLPRIM_VB_QUADS\n");
	rmask |= ACLPRIM_VB_QUADS;
	am->QuadsVB = NULL;
	break;
    }

    while(fmask & ACLPRIM_VB_RECTS) {
	ffl = fflags->vbrects;
	if(ffl & ACLRENDER_TEX) {
	}
	else if(ffl & ACLRENDER_SMOOTH) {
	}
	else if(ffl & ACLRENDER_FLAT) {
	}
	else if(!ffl) {
	    break;
	}
LOG("NULL primitive ACLPRIM_VB_RECTS\n");
	rmask |= ACLPRIM_VB_RECTS;
	am->RectsVB = NULL;
	break;
    }

LOG("aclPM2UpdateFuncPointers(): ______ NOT updated: 0x%x\n", rmask);

    return rmask;
}



#if 0
	CTX(DeltaMode) |= DM_TextureEN;
	CTX(DeltaMode) &= DM_TextureMASK;
	WAIT_FIFO(1);
	REG_WRITE(CTX(DeltaMode), DeltaModeOff);

	CTX(DeltaMode) |= DM_SmoothShadingEN;
	CTX(ColorDDAMode) |= DDA_ShadingGouraud;
	CTX(DeltaMode) &= DM_SmoothShadingMASK;
	CTX(ColorDDAMode) &= DDA_ShadingMASK;
	WAIT_FIFO(2);
	REG_WRITE(CTX(DeltaMode), DeltaModeOff);
	REG_WRITE(CTX(ColorDDAMode), ColorDDAModeOff);
#endif



Tbool
PM2InitACLAPIAccelMod(ACLContext aclctx)
{
    ACLAccelMod am = aclctx->Mod->Accel;

    am->UpdateFuncPointers = aclPM2UpdateFuncPointers;

    am->Points = NULL;
    am->Line = NULL;
    am->Triangle = NULL;
    am->Quad = NULL;
    am->Rect = NULL;

    am->LinesVB = NULL;
    am->TrianglesVB = NULL;
    am->QuadsVB = NULL;
    am->RectsVB = NULL;

    return 0;
}

