


#include "pm2.h"



#if 0



#if 1
  #define LOG_DEBUG
#endif

#define LOG_DBGINFO "<pm2_tex>"
#include "log_debug.h"



extern MLXDriverCtxPtr MLXdriverctx[];
extern MLXValuesCtx    ClientValCtx;
extern PM2_HwContext_t OrigRegCtx;
extern PM2_HwContext_t ClientRegCtx;


void acl_PM2_tex_SetDefaultTex
		(texture * dd, GLuint widthLog2, GLuint heightLog2,   
		 GLuint depthLog2,GLuint comps, GLuint OneCompFormat, 
		 GLuint * adrmode, GLuint * treadmode,
		 GLuint * lbreadmode,  GLuint * format, 
		 GLuint * colormode, GLuint * baseaddress);

void setnewname(ACLContext ctx, texture * dd);



/* 
   Testimplementatin des SubImage,
   wird nicht gerufen, sondern in MesaDD wird SubImage auf
   NULL gesetzt. Somit berechnet Mesa das SubImage, dieser
   Teiber downloadet dann das Image als neues Image der schon
   vorhandenen Texture.
   Das funktioniert prima! :-). Um die Funktionalitt zu testen
   kann man einfach Quake aufrufen und einen Schu abgeben, die
   Reflektion des Projektiels an den Wnden mu schon  r u n d
   aussehen, das sind tausende von Subimages.
*/
FSCOPE ACLvoid acl_PM2_subimage(ACLContext * ctx, ACLenum target,
	 ACLvoid *dd, ACLint level,
	 ACLint xoffset, ACLint yoffset, ACLint width, ACLint height,
	 ACLint internalFormat, ACLTexImage image)
{
}

/* Setzt die Parameter einer Texture in der Datenstruktur. */
FSCOPE ACLvoid acl_PM2_tex_param(ACLContext ctx, ACLglenum target, ACLglenum pname,
				 const ACLfloat * param, ACLvoid * dd)
{
    GLenum par = (GLenum) (GLint) param[0];

    if (dd) {
	switch (target) {
	case GL_TEXTURE_1D:
	    /* supported TStart, dTdx and dTdyDom to 0 */
	    break;
	case GL_TEXTURE_2D:
	    break;
	case GL_TEXTURE_3D_EXT:
	    /* wird nicht supported, gehe zurck zu Spanfunktionen */
	    break;
	default:
	    return;
	}

	switch (pname) {
	case GL_TEXTURE_MIN_FILTER:
	    break;

	case GL_TEXTURE_MAG_FILTER:
	    if (par == GL_NEAREST)
		((texture *) dd)->treadmode &= TexRMPM2_FilterModeMASK;
	    else if (par == GL_LINEAR)
	    	((texture *) dd)->treadmode |= TexRMPM2_FilterModeEN;
	    break;

	case GL_TEXTURE_WRAP_S:
	    ((texture *) dd)->treadmode &= TexRMPM2_SWarpModeMASK;
	    switch (par) {
	    case GL_CLAMP:
		((texture *) dd)->treadmode |= TexRMPM2_SWarpModeClamp;
		break;
	    case GL_REPEAT:
		((texture *) dd)->treadmode |= TexRMPM2_SWarpModeRepeat;
		break;
		/*  case GL_MIRROR: *treadmode |= TexRMPM2_SWarpModeMirror;
		    break;  */
	    default:
		break;
	    }
	    break;
	case GL_TEXTURE_WRAP_T:
	    ((texture *) dd)->treadmode &= TexRMPM2_TWarpModeMASK;
	    switch (par) {
	    case GL_CLAMP:
		((texture *) dd)->treadmode |= TexRMPM2_TWarpModeClamp;
		break;
	    case GL_REPEAT:
		((texture *) dd)->treadmode |= TexRMPM2_TWarpModeRepeat;
		break;
		/*   case GL_MIRROR: *treadmode |= TexRMPM2_TWarpModeMirror;
		     break; */
	    default:
		break;
	    }
	    break;

	case GL_TEXTURE_WRAP_R_EXT:
	    break;

	case GL_TEXTURE_BORDER_COLOR:
	    break;

	default:
	    LOG("aclSetParam undefined pname!\n");
	    break;
	}
    } else {
	ERR("aclSetParam pp=NULL internal Error!\n");
    }
}

/* Schaltet das Texturing ein. */
ACLvoid acl_PM2_tex_enable(ACLContext aclctx, ACLbool state)
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    if (state) {	
	CRC(_DeltaMode) |= DM_TextureEN;
	
	if (!VAL(_LastBind)) {
	    acl_PM2_tex_bind(aclctx, ((texture*)VAL(_DDLast))->n, VAL(_DDLast));
	    VAL(_LastBind)=1;
	}
	
	VAL(_TexEN) = 1;

	/* reine Optimierung */
	WAIT_FIFO(1);
	REG_WRITE(TexAddrM_PerCorrEN | UNIT_ENABLE, TextureAddressModeOff);

    } else {

	WAIT_FIFO(1);
	REG_WRITE(UNIT_ZERO, TextureAddressModeOff);

	VAL(_TexEN) = 0;
	CRC(_DeltaMode) &= DM_TextureParMASK;
    }
}

/* Berechnet die Position einer Texture im Local Buffer. */
unsigned int acl_PM2_tex_getpos(ACLContext aclctx)
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    if (!VAL(_LastAdr)) {
	VAL(_LastAdr) = DRVCTX(TexBuffOffset);
    }
    return VAL(_LastAdr);
}


/* Setzt die letzte Position auf die erste und gibt diese zurck. */
unsigned int acl_PM2_tex_resetpos(ACLContext aclctx)
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    VAL(_LastAdr) = DRVCTX(TexBuffOffset);
    return VAL(_LastAdr);
}

unsigned int acl_PM2_initredownload(ACLContext aclctx)
{
    int x;

    /* markiere die zu downloadenden Texturen */
    for (x=0; x<VAL(_AnzN); x++) {
	((texture*)VAL(_Names)[x])->isd = NLB;

	/* Indexe nicht vergessen */
	if (((texture*)VAL(_Names)[x])->index.anz > 0)
	    ((texture*)VAL(_Names)[x])->index.isd = NLB;
    }

    /* auch nicht mehr im LB */
    VAL(_GlbIndex).isd = NLB;

    x = acl_PM2_tex_resetpos(aclctx);

    return x;
}


/* Diese Funktion bertrgt die Indexe sowie die Texturen in den Local Buffer */
FSCOPE ACLvoid
 acl_PM2_tex_download_lb(ACLContext aclctx, ACLint level, ACLvoid * dd)
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    unsigned int x, z, idxsize, idxpos, pos, size, d;
    const maxfifo = 256;

    MLX_TextureIdx *idx = &((texture *) dd)->index;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }
    idxsize = idx->anz;
    idxpos = idx->adr;

    VAL(_DDLast) = dd;

    if (level) {
	/* MSG("acl_PM2_tex_download_lb: PM not supported MipMapLevels!\n"); */
	((texture *) dd)->isd = NLB;
	return;
    }

    size = ((texture *) dd)->leveldata[level].size;
    pos  = acl_PM2_tex_getpos(aclctx);

    if ((size + idxsize) > (DRVCTX(TexBuffMax) - DRVCTX(TexBuffOffset))) {
	((texture *) dd)->isd = BUS;
	ERR("acl_PM2_tex_download_lb BUS: pos=%d size=%d!\n", pos, size);
	return;
    }

    WAIT_FIFO(3);
    REG_WRITE(UNIT_ZERO, FBWriteModeOff);
    REG_WRITE(1, LBWriteModeOff);
    REG_WRITE(0, WaitForCompletionOff);

    /* download idx */
    if (VAL(_GlbPal) && (VAL(_GlbIndex).isd == NLB)) {
	if (VAL(_GlbIndex).adr) {
	    if ((VAL(_GlbIndex).adr + VAL(_GlbIndex).anz) <= 
		DRVCTX(TexBuffMax)) {
		WAIT_FIFO(1);
 		REG_WRITE(VAL(_GlbIndex).adr, TextureDownloadOffsetOff);
		for (x = 0; x < VAL(_GlbIndex).anz; x++) {
		    WAIT_FIFO(1);
		    REG_WRITE(VAL(_GlbIndex).index[x], TextureDataOff);
		}
		VAL(_LastAdr) += VAL(_GlbIndex).anz;
		VAL(_GlbIndex).isd = LB;
	    }
	}
    } else {
	if (idxpos)
	    if ((idxpos + idxsize) <= DRVCTX(TexBuffMax)) {
		WAIT_FIFO(1);
		REG_WRITE(idxpos, TextureDownloadOffsetOff);
		for (x = 0; x < idxsize; x++) {
		    WAIT_FIFO(1);
		    REG_WRITE(((texture *) dd)->index.index[x], TextureDataOff);
		}
		VAL(_LastAdr) += idxsize;
		((texture *) dd)->index.isd = LB;

		/* Korrektur fr Indexe */
		((texture *) dd)->baseaddress[level] = pos + idxsize;
		pos = ((texture *) dd)->baseaddress[level];
	    }
    }

    /* download image */

 nochmal:
    /* NLB oder BUS nicht bei SUBIMG, das wird in bind behandelt */
    if (((texture *) dd)->isd == NLB) {

	size = ((texture *) dd)->leveldata[level].size;
	pos  = acl_PM2_tex_getpos(aclctx);

	if ((pos + size) <=  DRVCTX(TexBuffMax)) {
	    if (VAL(_QuakeBlend))
		if (((texture *) dd)->txtdataLR[0] == NULL) {
		    switch (((texture *) dd)->dataformat) {
		        case GL_RGB:
			    konvert888to8888scale
			      (&((texture *) dd)->txtdataLR[0],
			       &((texture *) dd)->leveldata[0].size,
			       ((texture *) dd)->image);
			    break;
		        case GL_RGBA:
			    konvert8888to8888scale
			      (&((texture *) dd)->txtdataLR[0],
			       &((texture *) dd)->leveldata[0].size,
			       ((texture *) dd)->image);
			    break;
		        case GL_RGBA4:
			    convert8888to4444scale
			      (&((texture *) dd)->txtdataLR[0],
			       &((texture *) dd)->leveldata[0].size,
			       ((texture *) dd)->image);
			    break;
		    } /* End switch */
		} /* End if(((texture *) dd)->txtdataLR[0] == NULL) 
		     **AND**   VAL(_QuakeBlend)  */ 

	    WAIT_FIFO(2);
	    REG_WRITE(0, WaitForCompletionOff);
	    REG_WRITE(pos, TextureDownloadOffsetOff);
	    
	    /* 
	       Durch diese Schleife wird der FIFO maximal ausgenutzt.
	       Es wird immer in Portionen zu 256 Words gewartet.
	     */
	    x = 0;
	    d = size;
	    while (d) {
		if (d < maxfifo) {
		    WAIT_FIFO(d);
		    for ( ; x < size; x++, d--) {
			REG_WRITE(((texture *) dd)->txtdataLR[0][x], TextureDataOff);
		    }
		} else {
		    WAIT_FIFO(maxfifo);
		    for (z=0 ; z < maxfifo; z++, x++, d--) {
			REG_WRITE(((texture *) dd)->txtdataLR[0][x], TextureDataOff);
		    }
		}
	    } /* End while */

	    WAIT_FIFO(3);
	    REG_WRITE(0, WaitForCompletionOff);
	    REG_WRITE(CRC(_FBWriteMode), FBWriteModeOff);
	    REG_WRITE(CRC(_LBWriteMode), LBWriteModeOff);
	
	    /* Positionen werden nur hier gesetzt */
	    /* LOG("download adr=%d nr=%d\n", pos, ((texture *) dd)->n); */
	    ((texture *) dd)->baseaddress[level] = pos;
	    ((texture *) dd)->isd = LB;
	    VAL(_LastAdr) += size;

	    /* #### eigentlich nur ein Quake Hack #### */
	    if (VAL(_QuakeBlend)) {
		free(((texture *) dd)->txtdataLR[0]);
		((texture *) dd)->txtdataLR[0] = NULL;
	    }

	    return;
	} /* End if not too big for texture memory */ 
	else {
	    /* Platz reicht nicht mehr ! */
	    acl_PM2_initredownload(aclctx);
	    /* LOG("init Redownload Nr: %d\n", ((texture *) dd)->n); */
	    goto nochmal;
	}
    } /* End if.. == NLB */
    else {
	/* ERR("interner downloaderror! Textur nicht NLB!\n"); */
	if (((texture *) dd)->isd == SUBIMG)
	    {
		/* es ist sichergestellt das Platz im LB ist */
		size = ((texture *) dd)->leveldata[level].size;
		pos  = ((texture *) dd)->baseaddress[level];

		if ((pos + size) <=  DRVCTX(TexBuffMax)) {

		    /* #### eigentlich nur ein Quake Hack #### */
		    if (VAL(_QuakeBlend))
			if (((texture *) dd)->txtdataLR[0] == NULL) {
			    switch (((texture *) dd)->dataformat) {
			        case GL_RGB:
				    konvert888to8888scale
				      (&((texture *) dd)->txtdataLR[0],
				       &((texture *) dd)->leveldata[0].size,
				       ((texture *) dd)->image);
				    break;
			         case GL_RGBA:
				    konvert8888to8888scale
				      (&((texture *) dd)->txtdataLR[0],
				       &((texture *) dd)->leveldata[0].size,
				       ((texture *) dd)->image);
				    break;
			         case GL_RGBA4:
				    convert8888to4444scale
				      (&((texture *) dd)->txtdataLR[0],
				       &((texture *) dd)->leveldata[0].size,
				       ((texture *) dd)->image);
				    break;
			    } /* End switch */
			} /* End if dd)->txtdataLR[0] == NULL **AND**
			     VAL(_QuakeBlend)  */

		    WAIT_FIFO(2);
		    REG_WRITE(0, WaitForCompletionOff);
		    REG_WRITE(pos, TextureDownloadOffsetOff);

		    /* 
		       Durch diese Schleife wird der FIFO maximal ausgenutzt.
		       Es wird immer in Portionen zu 256 Words gewartet.
		    */
		    x = 0;
		    d = size;
		    while (d) {
			if (d < maxfifo) {
			    WAIT_FIFO(d);
			    for ( ; x < size; x++, d--) {
				REG_WRITE(((texture *) dd)->txtdataLR[0][x], TextureDataOff);
			    }
			} else {
			    WAIT_FIFO(maxfifo);
			    for (z=0 ; z < maxfifo; z++, x++, d--) {
				REG_WRITE(((texture *) dd)->txtdataLR[0][x], TextureDataOff);
			    }
			}
		    }


		    WAIT_FIFO(3);
		    REG_WRITE(0, WaitForCompletionOff);
		    REG_WRITE(CRC(_FBWriteMode), FBWriteModeOff);
		    REG_WRITE(CRC(_LBWriteMode), LBWriteModeOff);
		    
		    /* LOG("download Subimg=%d nr=%d\n", pos, ((texture *) dd)->n); */
		    ((texture *) dd)->isd = LB;

		    /* #### eigentlich nur ein Quake Hack #### */
		    if (VAL(_QuakeBlend)) {
			free(((texture *) dd)->txtdataLR[0]);
			((texture *) dd)->txtdataLR[0] = NULL;
		    }

		    return;
		} else {
		    ERR("cannot download subimg! \n");
		}
	    }
	if (((texture *) dd)->isd == LB) {
	    return;
	}
    }

    ((texture *) dd)->isd = NLB;
}

/* eine PMII spezifische Konvertierungsfunktion fr die Indexed Texturen */
int konvertIMGscalePM2(unsigned int **data, unsigned int *size,
	     ACLint internalFormat, const ACLTexImage image)
{
    unsigned int t[32];
    int x, y, count;
    int ret;
    unsigned int sca[32 * 32];
    int f, sx;

    unsigned char *srcc;
    srcc = (unsigned char *) image->Data;

    ret = 0;

    switch (internalFormat) {
    case GL_COLOR_INDEX1_EXT:	/* Texel Width 1 Bit */
    case GL_COLOR_INDEX2_EXT:	/* Texel Width 2 Bit */
    case GL_COLOR_INDEX4_EXT:	/* Texel Width 4 Bit */

	if (image->Width > 31) {
	    f = 0;
	    count = *size = image->Height * image->Width / 8;
	} else {
	    f = 32 / image->Width;
	    count = *size = image->Height * image->Width * f / 8;
	}

	/* *data = (unsigned int *) malloc(sizeof(unsigned int) * count); */
	/* Sonst entsteht bei den Subimages ein Speicherleck. */
	if (*data == NULL) {
	    *data = (unsigned int *) malloc(sizeof(unsigned int) * count);
	    VAL(_MallocZ)++;
	} else {
	    /* MSG("free Texture Data, konvertIMGscalePM2!\n"); */
	    /* free(*data); */
	    /* *data = (unsigned int *) malloc(sizeof(unsigned int) * count); */
	}

	if (!(*data)) {
	    ERR("konvertIMGscalePM2: malloc faild!\n");
	    return GL_FALSE;
	}

	if (data) {
	    if (!f) {
		for (x = 0; x < count; x++) {
		    for (y = 0; y < 8; y++)
			t[y] = *srcc++;

		    for ((*data)[x] = y = 0; y < 8; y++)
			(*data)[x] |= t[y] << (y * 4);
		}
	    } else {
		for (x = 0; x < image->Height * image->Width / 8; x++) {
		    for (y = 0; y < 8; y++)
			t[y] = *srcc++;

		    for (sca[x] = y = 0; y < 8; y++)
			sca[x] |= t[y] << (y * 4);
		}

		for (sx = y = x = 0; x < image->Height * image->Width / 8 * f; x++) {
		    (*data)[x] = sca[y];
		    if (!(x % f))
			y++;
		}
	    }
	} else {
	    ERR("konvertINDEXscalePM2: GL_COLOR_INDEX: malloc failed!\n");
	    return 0;
	}
	ret = 4;
	break;
    case GL_COLOR_INDEX8_EXT:	/* Texel Width 8 Bit */
	if (image->Width > 31) {
	    f = 0;
	    count = *size = image->Height * image->Width / 4;
	} else {
	    f = 32 / image->Width;
	    count = *size = image->Height * image->Width * f / 4;
	}

	/* Sonst entsteht bei den Subimages ein Speicherleck. */
	if (*data == NULL) {
	    *data = (unsigned int *) malloc(sizeof(unsigned int) * count);
	    VAL(_MallocZ)++;
	} else {
	    /* MSG("free Texture Data, konvertIMGscalePM2!\n"); */
	    /* free(*data); */
	    /* *data = (unsigned int *) malloc(sizeof(unsigned int) * count); */
	}

	if (!(*data)) {
	    ERR("konvertIMGscalePM2: malloc faild!\n");
	    return GL_FALSE;
	}

	if (data) {
	    if (!f) {
		for (x = 0; x < count; x++) {
		    for (y = 0; y < 4; y++)
			t[y] = *srcc++;

		    for ((*data)[x] = y = 0; y < 4; y++)
			(*data)[x] |= t[y] << (y * 8);
		}
	    } else {
		for (x = 0; x < image->Height * image->Width / 4; x++) {
		    for (y = 0; y < 4; y++)
			t[y] = *srcc++;

		    for (sca[x] = y = 0; y < 4; y++)
			sca[x] |= t[y] << (y * 8);
		}
		for (sx = y = x = 0; x < image->Height * image->Width / 4 * f; x++) {
		    (*data)[x] = sca[y];
		    if (!(x % f))
			y++;
		}
	    }
	} else {
	    ERR("konvertINDEXscalePM2: GL_COLOR_INDEX: malloc failed!\n");
	    return 0;
	}
	ret = 8;
	break;

    case GL_COLOR_INDEX12_EXT:
    case GL_COLOR_INDEX16_EXT:
	break;
    default:
	ERR("konvertINDEXscalePM2: unknown INDEXSize!\n");
	break;
    }

    return ret;
}


/* Das OpenGL Format der Images ist leider etwas abweichend von dem Format der
Grafikkarte, mit dieser Funktion werden die Formate bersetzt und die 
Texturestruktur wird mit den ,,default'' Werten gefllt. */
FSCOPE ACLbool
 acl_PM2_tex_translate_image(ACLContext ctx,
			     const ACLTexImage image, ACLint level,
			     GLint internalFormat, ACLuint name, ACLvoid * dd)
{
    unsigned int w;

    if (!dd) {
	ERR("acl_PM2_tex_translate_image: dd=NULL! internal Error!\n");
	return 0;
    }

    if (!level) {
	VAL(_DDLast) = dd; /* one texture ? */

	((texture *) dd)->n = name;
	((texture *) dd)->bordercolor = 0xff000000;
	((texture *) dd)->leveldata[0].wl2 = log2(image->Width);
	((texture *) dd)->leveldata[0].hl2 = log2(image->Height);

	((texture *) dd)->image = image;

	switch (decode_internal_format(internalFormat)) {
	case GL_ALPHA:
	    break;
	case GL_INTENSITY:
	    break;
	case GL_LUMINANCE:
	    break;
	case GL_LUMINANCE_ALPHA:
	    break;
	case GL_RGB:
#if 0
	    MSG("pm2_tex: translage_image case: GL_RGB\n");
#endif
	    konvert888to8888scale(&((texture *) dd)->txtdataLR[0],
				  &((texture *) dd)->leveldata[0].size,
				  image);
	    ((texture *) dd)->levels = 1;
	    ((texture *) dd)->leveldata[0].dl2 = log2(32);
	    ((texture *) dd)->dataformat = GL_RGB;
	    acl_PM2_tex_SetDefaultTex((texture *)dd,  
				      log2(image->Width), log2(image->Height),
				      log2(32), 4, 0,
				      &((texture *) dd)->adrmode, 
				      &((texture *) dd)->treadmode,
				      &((texture *) dd)->lbreadmode,
				      &((texture *) dd)->format, 
				      &((texture *) dd)->colormode,
				      ((texture *) dd)->baseaddress);
	    break;
	case GL_RGBA:
#if 0
	    MSG("pm2_tex: translage_image case: GL_RGBA\n");
#endif
	    konvert8888to8888scale(&((texture *) dd)->txtdataLR[0],
				   &((texture *) dd)->leveldata[0].size,
				   image);
	    ((texture *) dd)->levels = 1;
	    ((texture *) dd)->leveldata[0].dl2 = log2(32);
	    ((texture *) dd)->dataformat = GL_RGBA;
	    acl_PM2_tex_SetDefaultTex((texture *)dd,
				      log2(image->Width), log2(image->Height),
				      log2(32), 4, 0,
				      &((texture *) dd)->adrmode, 
				      &((texture *) dd)->treadmode,
				      &((texture *) dd)->lbreadmode,
				      &((texture *) dd)->format, 
				      &((texture *) dd)->colormode,
				      ((texture *) dd)->baseaddress);
	    break;
	case GL_RGBA4:
#if 0
	    MSG("pm2_tex: translage_image case: GL_RGBA4\n");
#endif
	    convert8888to4444scale(&((texture *) dd)->txtdataLR[0],
				   &((texture *) dd)->leveldata[0].size,
				   image);
	    ((texture *) dd)->levels = 1;
	    ((texture *) dd)->leveldata[0].dl2 = log2(32);
	    ((texture *) dd)->dataformat = GL_RGBA4;
	    acl_PM2_tex_SetDefaultTex((texture *)dd,
				      log2(image->Width), log2(image->Height),
				      log2(32), 4, 0,
				      &((texture *) dd)->adrmode, 
				      &((texture *) dd)->treadmode,
				      &((texture *) dd)->lbreadmode,
				      &((texture *) dd)->format, 
				      &((texture *) dd)->colormode,
				      ((texture *) dd)->baseaddress);
	    break;
	case GL_COLOR_INDEX:
#if 0
	    MSG("pm2_tex: translage_image case: GL_COLOR_INDEX\n");
#endif
	    w = konvertIMGscalePM2(&((texture *) dd)->txtdataLR[0],
				   &((texture *) dd)->leveldata[0].size,
				   internalFormat, image);
	    ((texture *) dd)->levels = 1;
	    ((texture *) dd)->leveldata[0].dl2 = log2(w);
	    ((texture *) dd)->dataformat = GL_COLOR_INDEX;
	    acl_PM2_tex_SetDefaultTex((texture *)dd, 
				      log2(image->Width), log2(image->Height),
				      log2(w),
				      0,	/* comps = 0 */
				      w,
				      &((texture *) dd)->adrmode, 
				      &((texture *) dd)->treadmode,
				      &((texture *) dd)->lbreadmode,
				      &((texture *) dd)->format, 
				      &((texture *) dd)->colormode,
				      ((texture *) dd)->baseaddress);
	    break;
	}

	/* nach der Konvertierung testen ob es als Subimg oder
	 als normale Texture gedownloadet wird */
	setnewname(ctx, dd);

	/* MSG("Texture Name Translate =%d %d!\n", name, ((texture *) dd)->n); */
    }

    return GL_TRUE;
}

/* Die Positionen im LB werden berechnet und fr das Laden in den LB
   vorbereitet, falls kein Platz im LB ist werden die Indexe in die Indexregister
   geladen  */
FSCOPE ACLvoid acl_PM2_tex_Palette(ACLContext aclctx, ACLuint size,
				   ACLuint * data, ACLvoid * dd)
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    unsigned int pos, lbsize, x;
    unsigned char r, g, b, a;
    unsigned char *srcc;
    MLX_Downloadt dl;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    /* mu formatiert werden! */
    ((texture *) dd)->index.anz = size;
    ((texture *) dd)->index.index = malloc(sizeof(unsigned int) * size);
    ((texture *) dd)->index.isd = NLB;

    srcc = (unsigned char *)data;
    for (x=0; x<size; x++)
	{
	    r = *srcc++;
	    g = *srcc++;
	    b = *srcc++;
	    a = *srcc++;
	    ((texture *) dd)->index.index[x] = 
		(a << 24) | (r << 16) | (g << 8) | b;
	}


    pos = acl_PM2_tex_getpos(aclctx);

    lbsize = size;

    if ((pos + lbsize) <= DRVCTX(TexBuffMax)) {
	((texture *) dd)->index.adr = pos;
    } else {
	((texture *) dd)->index.adr = pos = 0;	/* download over FIFO */
    }

    dl = NLB;

    if (!pos)
	acl_PM2_tex_SetLUT(aclctx, size, data, 0, &dl);
}


/* Setzt die LUT, hier gibt es verschiedene Mglichkeiten:
   1. Die LUT kann wie eine Texture in den Local Buffer geladen
      werden. Die Beste Variante.
   2. Die LUT kann ber den BUS aus dem Hauptspeicher geladen
      werden. Die langsamste Variante. Bentigt aber keinen Speicher.
   3. Die LUT wird ber Index und Data Register durch den FIFO geladen.
      Die schnellere Variante wenn wenig Speicher zur Verfgung steht.
   4. Die LUT wird direkt in die 16 vorhandenen Register geladen.
      Auch sehr schnell geht aber wirklich nur bei einer LUT die nur
      16 Eintrge hat.
*/
ACLvoid
acl_PM2_tex_SetLUT(ACLContext aclctx, ACLuint anz, ACLuint * index,
		   ACLuint adr, MLX_Downloadt * isd)
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    int x;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    WAIT_FIFO(1);
    REG_WRITE(UNIT_ENABLE, TexelLUTModeOff);
 
    if (*isd == LB) {
	WAIT_FIFO(2);
	REG_WRITE(adr, TexelLUTAddressOff);
	REG_WRITE((anz << 8), TexelLUTTransferOff);
    } else {
	if (*isd == BUS) {
	    /* download over bus */
	} else {
	    /* NLB */
	    if (anz <= 16) {	/* not downl. < 16 */
		WAIT_FIFO(anz);
		for (x = 0; x < anz; x++) {
		    REG_WRITE(index[x], TAG_REG(0x1d, x));
		}
	    } else {
		for (x = 0; x < anz; x++) {	/* not downl. > 16 */
		    WAIT_FIFO(2);
		    REG_WRITE(x, TexelLUTIndexOff);
		    REG_WRITE(index[x], TexelLUTDataOff);
		}
	    }
	}
    }
}

/* Setze den Colormode Parameter. */
FSCOPE ACLbool
 acl_PM2_tex_env(ACLContext ctx, ACLglenum pname, const ACLfloat * param)
{
    if (pname == GL_TEXTURE_ENV_MODE) {
	GLenum mode = (GLenum) (GLint) * param;
	switch (mode) {
	case GL_MODULATE:
	    VAL(_ColorMode) = TexCM_OGLAppModeModulate;
	    break;
	case GL_BLEND:
	    VAL(_ColorMode) = 0;
	    ERR("GL_BLEND: not supported by Permedia!\n");
	    return GL_FALSE;
	    break;
	case GL_DECAL:
	    VAL(_ColorMode) = TexCM_OGLAppModeDecal;
	    break;
	case GL_REPLACE:
	    VAL(_ColorMode) = TexCM_OGLAppModeCopy;
	    break;
	default:
	    return GL_FALSE;
	}
    } else if (pname == GL_TEXTURE_ENV_COLOR) {
	ERR("ENV_COLOR: not supported by Permedia!\n");
	return GL_FALSE;
    }
    return GL_TRUE;
}

/* Das Binden der Texture, es werden die notwendigen Register gesetzt und
dann wird das nchste Dreieck mit einer Texture gerendert.

Falls die Texture sich nicht im LB befindet gibt es 3 Mglichkeiten
     diese Texture trotzdem zu rendern:
     1. ich lade diese in einen freien Bereich in den LB,
     2. ich lade diese in einen nicht freien Bereich in den LB oder
     3. ich rendere durch den BUS aus dem Hauptspeicher heraus.   */
FSCOPE ACLvoid
 acl_PM2_tex_bind(ACLContext aclctx, ACLuint name, ACLvoid * dd)
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    int format;
    register texture* td;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    td = dd;

    if (td) {

	/* nur einmal bei enable wird automatisch gebunden */
	VAL(_LastBind) = 1;

	if (td->leveldata[0].size == 0) {
	    /* MSG("bind size == 0!\n"); */
	    return;
	}

	if (td->isd == NLB) {
	    acl_PM2_tex_download_lb(aclctx, 0, dd);
	    /* MSG("bind Texture isd==NLB redownload adr=%d\n", */
	    /* 	    	td->baseaddress[0]); */
	}

	/* 	MSG("bind Texture isd==LB redownload adr=%d\n",  */
	/* 	    td->baseaddress[0]); */

	if (td->isd == LB) {

	    if (td->baseaddress[0] >= acl_PM2_tex_getpos(aclctx)) {
		ERR("internal error: baseaddress[0]=%d >= getpos=%d!\n",
		    td->baseaddress[0], acl_PM2_tex_getpos(aclctx));
		return;
	    }

	    /* nur solange download ber Bus nicht implementiert ist */
	busdemo:
	    VAL(_Triwl2) = td->leveldata[0].wl2;
	    VAL(_Trihl2) = td->leveldata[0].hl2;

	    WAIT_FIFO(8);
	    /* ist konstant */
	    /*REG_WRITE(td->adrmode, TextureAddressModeOff);*/
	    REG_WRITE(td->treadmode, TextureReadModePM2Off);
	    REG_WRITE(td->format, TextureMapFormatOff);
	    REG_WRITE(td->colormode, TextureColorModeOff);

	    REG_WRITE(CRC(_DeltaMode), DeltaModeOff);

	    REG_WRITE(td->lbreadmode, TextureDataFormatOff);

	    if (VAL(_QuakeBlend)) {
		REG_WRITE(td->baseaddress[0],
			  TextureBaseAddressOff);
		return;
	    } else {
		format = (td->format) & ~TexMF_TexelSizeMASK;
		if (format == TexMF_TexelSize32bits) {
		    REG_WRITE(td->baseaddress[0],
			      TextureBaseAddressOff);
		} else {
		    if (format == TexMF_TexelSize8bits) {
			REG_WRITE(td->baseaddress[0] * 4,
				  TextureBaseAddressOff);
		    } else {
			if (format == TexMF_TexelSize4bits) {
			    REG_WRITE(td->baseaddress[0] * 8,
				      TextureBaseAddressOff);
			} else {
			    REG_WRITE(td->baseaddress[0] * 2,
				      TextureBaseAddressOff);
			}
		    }
		}
	    }
	    CRC(_FBReadMode) |= FBRM_DestEN;
	    REG_WRITE(CRC(_FBReadMode), FBReadModeOff);
	} else {
	    /* if (dd==NULL) LOG("Texture bindimg=0, dd==NULL!\n"); */

	    if (td->isd == BUS) {
		td->baseaddress[0] = DRVCTX(TexBuffOffset);
		/* LOG("Texture BUS, not implemented yet!\n"); */
		goto busdemo;
	    }

	    ERR("bind != LB!\n");
	}

	/* bind index */
	if (VAL(_GlbPal)) {
	    acl_PM2_tex_SetLUT(aclctx,
			       VAL(_GlbIndex).anz,
			       VAL(_GlbIndex).index,
			       VAL(_GlbIndex).adr,
			       &VAL(_GlbIndex).isd);
	} else {
	    if (td->index.anz) {
		acl_PM2_tex_SetLUT(aclctx,
				   td->index.anz,
				   td->index.index,
				   td->index.adr,
				   &td->index.isd);
	    } else {
		WAIT_FIFO(1);
		REG_WRITE(UNIT_ZERO, TexelLUTModeOff);
	    }
	}
    } else {
 	ERR("bind dd=NULL internal Error!\n");
    }
}

FSCOPE ACLvoid *
 acl_PM2_tex_alloc(ACLContext aclMesa)
{
    void *txt = (void *) malloc(sizeof(texture));
    VAL(_MallocZ)++;
    if (txt) {
	memset(txt, 0, sizeof(texture));
	return txt;
    } else {
	ERR("acl_PM2_AllocTexObjData: out of memory !\n");
    }

    return NULL;
}

/* Gibt allocierten Speicher wieder frei. */
FSCOPE ACLvoid *acl_PM2_tex_free(ACLContext aclMesa, ACLvoid * dd)
{

    if (dd) {
	/*
	for (x = 0; x < ((texture *) dd)->levels; x++) {
	    free(((texture *) dd)->txtdataLR[x]);
	    ((texture *) dd)->txtdataLR[x] = NULL;
	    VAL(_MallocZ)--;
	}
	*/

	free(dd);
	dd=NULL;
	VAL(_MallocZ)--;

	/* lsche aus Texturenarray */
	/*
	  geht so nicht 
	tx = malloc (sizeof(texture*) * (VAL(_AnzN)-1));

	for (y=x=0; x<VAL(_AnzN); x++) {
	    if ((texture*)VAL(_Names)[x] != dd)
		tx[x] = (texture*)VAL(_Names)[y++];
	}

	free((texture*)VAL(_Names));
	VAL(_MallocZ)--;

	VAL(_Names) = (void*)tx;
	*/

	/*
	  indexe fehlen auch noch
	 */


    }
    return NULL;
}

void setnewname(ACLContext ctx, texture * dd)
{
    const  step = 512;
    static int satz;
    int oldsatz, x;
    void ** oldarray;

    /* Ist eine Liste besser ? */
    if (!VAL(_Names)) {
	satz = step;
	VAL(_AnzN)++;
	/*  nur Testweise, spter wird hier eine einfache
	    Liste mit Indexwerten programmiert. */
	VAL(_Names) = malloc (sizeof(texture*) * satz);
	memset(VAL(_Names), 0, sizeof(texture*) * satz);
	VAL(_Names)[(VAL(_AnzN)-1)] = (void*)dd;
    } else {
	/* Behandele Subimages wie neue Texturen, aber speichere den
	   Zeiger nicht doppelt */
	for (x=0; x<VAL(_AnzN); x++) {

	    if (VAL(_Names)[x] == (void*)dd) {

		if ( ((texture*)VAL(_Names)[x])->leveldata[0].size < 
		     ((texture *) dd)->leveldata[0].size )
		    ERR("internal error Subimage val->size < dd->size \n");

		if (((texture*)dd)->isd == LB) {
		    /* LOG("Subimg Names = dd Nr:%d LB! ", ((texture*)dd)->n); */
		    ((texture*)dd)->isd = SUBIMG;
		} else {
		    /* LOG("Subimg Names = dd Nr:%d NLB! ", ((texture*)dd)->n); */
		    ((texture*)dd)->isd = NLB;
		}

		VAL(_Names)[x] = (void*)dd;
		return;
	    }
	}

	VAL(_AnzN)++;

	if (VAL(_AnzN) <= satz) {
	    VAL(_Names)[(VAL(_AnzN)-1)] = (void*)dd;
	} else {
	    /* vergrere Array */
	    oldsatz = satz;
	    satz += step;
	    oldarray = VAL(_Names);

	    VAL(_Names) = malloc(sizeof(texture*) * satz);
			
	    if (VAL(_Names)==NULL) {
		ERR("malloc failed!");
	    }

	    memset(VAL(_Names), 0, sizeof(texture*) * satz);
	    /*
	      memcpy(VAL(_Names), oldarray,
	      sizeof(sizeof(texture*) * oldsatz));
	    */
	    for (x=0; x<oldsatz; x++)
		VAL(_Names)[x] = oldarray[x];

	    free(oldarray);

	    VAL(_Names)[(VAL(_AnzN)-1)] = (void*)dd;
	}
    }
}

/* Die Texturedatenstruktur wird mit den Standartwerten belegt, so kann eine
Textur ohne Parameterangabe gezeichnet werden. */
ACLvoid
acl_PM2_tex_SetDefaultTex(texture * dd,
	      GLuint widthLog2,
	      GLuint heightLog2,
	      GLuint depthLog2,
	      GLuint comps, GLuint OneCompFormat,
	      GLuint * adrmode,
	      GLuint * treadmode,
	      GLuint * texdataformat,
	      GLuint * format,
	      GLuint * colormode,
	      GLuint * baseaddress)
{
    int ppc;

    *adrmode = TexAddrM_PerCorrEN | UNIT_ENABLE;

    *treadmode = (widthLog2 << 9) | (heightLog2 << 13) |
	TexRMPM2_TWarpModeRepeat | TexRMPM2_SWarpModeRepeat |
	TexRMPM2_FilterModeEN | UNIT_ENABLE;

    if (widthLog2 < 5) {
	ppc = 32;
    } else
	ppc = 1 << widthLog2;

    VAL(_Triwl2) = widthLog2;
    VAL(_Trihl2) = heightLog2;

    *format = gpprod(1, ppc) | (gpprod(2, ppc) << 3) | (gpprod(3, ppc) << 6);

    switch (OneCompFormat) {
    case 0:
	switch (comps) {
	case 4:
	    *format |= TexMF_TexelSize32bits;
	    /* RGB mode set, explict about other values */
#if 1
	    *texdataformat |= TexDF_TextureFormat8888 
			   | TexDF_NoAlphaBufferDIS
			   | TexDF_ColorOrderRGBEN
			   | TexDF_FormatExtensionDIS
			   | TexDF_AlphaMapNone;
/* ARRRRGH!  the glintregs.pl script generates this wrong! */
/*			   | TexDF_SpanFormatFlipDIS; */
#endif
	    break;
	case 3:
	    *format |= TexMF_TexelSize16bits;
	    break;
	case 2:
	    *format |= TexMF_TexelSize8bits;
	    break;
	case 1:
	    *format |= TexMF_TexelSize4bits;
	    break;
	}
	break;
    case 1:
    case 2:
	ERR("Permedia not supported 1 or 2bit bit LUT, used 4bit!\n");
    case 4:
	LOG("pm2_acl: 4 bit color index texture mode\n");
	*format |= TexMF_TexelSize4bits;
	*texdataformat = TexDF_TextureFormatCI4;
	break;
    case 8:
	*format |= TexMF_TexelSize8bits;
	*texdataformat = TexDF_TextureFormatCI8;
	break;
    default:
    case 12:
    case 16:
	ERR("Permedia not supported 12 or 16 bit LUT, Software: ToDo!\n");
	break;
    }

    *colormode = VAL(_ColorMode) | UNIT_ENABLE;

}

ACLvoid acl_PM2_tex_SwitchToGlobalPalette(ACLContext aclctx)
{
    VAL(_GlbPal) = 1;
}

/* Die Positionen im LB werden berechnet und fr das Laden in den LB
vorbereitet, falls kein Platz im LB ist werden die Indexe in die Indexregister
geladen  */
ACLvoid acl_PM2_tex_DownloadGlobalPalette(ACLContext aclctx, ACLuint size,
					  ACLuint * data, ACLvoid * dd)
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    unsigned int pos, lbsize;
    MLX_Downloadt dl;

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    VAL(_GlbPal) = 0;
    VAL(_GlbIndex).anz = size;
    VAL(_GlbIndex).index = data;
    VAL(_GlbIndex).isd = NLB;

    pos = acl_PM2_tex_getpos(aclctx);

    lbsize = size;

    if ((pos + lbsize) <= DRVCTX(TexBuffMax)) {
	VAL(_GlbIndex).adr = pos;
    } else {
	VAL(_GlbIndex).adr = pos = 0;	/* download over FIFO */
    }

    dl=NLB;
    if (!pos)
	acl_PM2_tex_SetLUT(aclctx, size, data, 0, &dl);
}

#endif


Tbool
PM2InitACLAPITexMod(ACLContext aclctx)
{
#if 0
    ACLTexMod tm = aclctx->Mod->Tex;

    tm->Enabled = acl_PM2_tex_enable;
    tm->AllocTexObjData = acl_PM2_tex_alloc;
    tm->TexDel = acl_PM2_tex_free;
    tm->Bind = acl_PM2_tex_bind;
    tm->Env = acl_PM2_tex_env;
    tm->Param = acl_PM2_tex_param;
    tm->TranslateImage = acl_PM2_tex_translate_image;
    tm->DownloadToTexMem = acl_PM2_tex_download_lb;
    tm->Palette = acl_PM2_tex_Palette;
    tm->SwitchToGlobalPalette = acl_PM2_tex_SwitchToGlobalPalette;
    tm->DownloadGlobalPalette = acl_PM2_tex_DownloadGlobalPalette;
    tm->SubImage = acl_PM2_subimage;
#endif
    return 0;
}

