
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */

/*****************************************************************************/
/*****************************************************************************/
/* Permedia2 OpenGL/Mesa driver                                              */
/* (c) 1997, 1998, 1999 SuSE GmbH                                            */
/* ------------------------------------------------------------------------- */
/* Contributors:                                                             */
/*      simon pogarcic, sim@suse.de                                          */
/*      Stefan Dirsch, sndirsch@suse.de                                      */
/*      Helmut Fahrion, hefa@artis.de                                        */
/*      Jeff Millar, jeff@wa1hco.mv.com                                      */
/*****************************************************************************/
/*****************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if 0
  #define LOG_DEBUG
#endif

#define LOG_DBGINFO "<pm2_mod>"
#include "log_debug.h"



#include "pm2.h"



GENPROTO_DRIVER_INIT_MODULES(PM2)
GENPROTO_DRIVER_SETUP(PM2)



static void
aclPM2StartRender(ACLContext aclctx)
{
    MLX_INIT_ACCESS_CARD;

LOG("aclPM2StartRender(): ######\n");

    if(CCTX(is_full_screen)) {
	VAL(clip_enable) = 0;
	PM2FillVisibleScreen(aclctx, 0x00003f00);
    }

    PM2InitRenderingContext(aclctx);
    PM2SetRenderingContext(aclctx);
    PM2DownloadRenderingContext(aclctx);

/* ===>
 * this should be the state of the default rendering context, as required by
 * the most of drawing primitives. All other functions, which require some
 * other state of graphic hardware for doing their job, should return the
 * state maschine into this default state.
 * <===
 */
    
    /* simulate some clip boxess, before we get real ones from X ;) */
    TEST_CLIPP_4(VAL(clip_boxes), VAL(win_w), VAL(win_h), 10);

    /* for test purposes, always clip */
    VAL(clip_enable) = 1;

	VAL(_Triwl2) =
	VAL(_Trihl2) =
	VAL(_ColorMode) =
	VAL(_AnzN) =
	VAL(_GlbPal) =
	VAL(_MallocZ) = 0;
	VAL(_LastAdr) = sctx->TexBuffOffset;
	VAL(_TexEN) = 1;
	VAL(_Names) =
	VAL(_DDLast) = NULL;

LOG("aclPM2StartRender(): ______\n");
}



static void
aclPM2FinishRender(ACLContext aclctx)
{
    MLX_INIT_ACCESS_CARD;
    MLX_INIT_ACCESS_MMCTL;

LOG("aclPM2FinishRender(): ######\n");
    PM2Sync(aclctx);

    WAIT_FIFO(1);
    REG_WRITE(sctx->FrontBuffAddrOffset, SuspendUntilFrameBlankOff);

LOG("aclPM2FinishRender(): ______\n");
}



static Tuint
aclPM2DrawBuffer(ACLContext aclctx, ACLglenum buffer)
{
    MLX_INIT_ACCESS_CARD;
    MLX_INIT_ACCESS_MMCTL;

LOG("aclPM2DrawBuffer(): ###### (%d)\n", buffer);
    if(buffer == ACLGL_BACK)
	CTX(FBPixelOffset) = sctx->FrontBackOffset;
    else if(buffer == ACLGL_FRONT || buffer == ACLGL_FRONT_AND_BACK)
	CTX(FBPixelOffset) = 0;
    else 
	return ACLGL_FALSE;

    WAIT_FIFO(2);
    REG_WRITE(0, WaitForCompletionOff);
    REG_WRITE(CTX(FBPixelOffset), FBPixelOffsetOff);

LOG("aclPM2DrawBuffer(): ______\n");

    return ACLGL_TRUE;
}



static void
aclPM2SwapBufferBitBlt(ACLContext aclctx)
{
    MLX_INIT_ACCESS_CARD;
    MLX_INIT_ACCESS_MMCTL;

LOG("aclPM2SwapBufferBitBlt() ######\n");

#define RENDER_SETUP ( \
	R_PrimitiveRectangle | \
	R_XPositiveEN | \
	R_YPositiveEN )

#define FBREADMODE_SETUP ( \
	sctx->ScreenPProd | \
	FBRM_SrcEN | \
	FBRM_WinOriginBottom )

    WAIT_FIFO(11);
    REG_WRITE(sctx->FrontBuffAddrOffset, SuspendUntilFrameBlankOff);

    REG_WRITE(UNIT_DISABLE, DepthModeOff);
    REG_WRITE(UNIT_DISABLE, StencilModeOff);
    REG_WRITE(UNIT_DISABLE, ColorDDAModeOff);
    REG_WRITE(LBWM_WriteDIS, LBWriteModeOff);

    REG_WRITE(0, FBPixelOffsetOff);
    REG_WRITE(sctx->FrontBackOffset, FBSourceOffsetOff);
    REG_WRITE(FBREADMODE_SETUP, FBReadModeOff);

    REG_WRITE(0, RectangleOriginOff);
    REG_WRITE((VAL(win_h) << 16) | VAL(win_w), RectangleSizeOff);

#define MLX_DRAW_REPEAT_CNT 1
#define MLX_DRAW_INIT	REG_WRITE(RENDER_SETUP, RenderOff);
#define MLX_DRAW_REPEAT MLX_DRAW_INIT

    MLX_DRAW_CLIPPED

#undef MLX_DRAW_INIT
#undef MLX_DRAW_REPEAT

    WAIT_FIFO(7)
    REG_WRITE(CTX(DepthMode), DepthModeOff);
    REG_WRITE(CTX(StencilMode), StencilModeOff);
    REG_WRITE(CTX(ColorDDAMode), ColorDDAModeOff);
    REG_WRITE(CTX(LBWriteMode), LBWriteModeOff);

    REG_WRITE(CTX(FBPixelOffset), FBPixelOffsetOff);
    REG_WRITE(0, FBSourceOffsetOff);
    REG_WRITE(CTX(FBReadMode), FBReadModeOff);

#undef RENDER_SETUP
#undef FBREADMODE_SETUP

LOG("aclPM2SwapBufferBitBlt() ______\n");
}



static void
aclPM2SwapBufferScreen(ACLContext aclctx)
{
    MLX_INIT_ACCESS_CARD;
    MLX_INIT_ACCESS_MMCTL;

    /* we can put here static: only ONE client is alowed to swap screen */
    static Tbool buff = 0;

LOG("aclPM2SwapBufferScreen(): ######\n")

    WAIT_FIFO(2);
    if(buff) {
	buff = 0;
	/* draw into the back buffer */
	CTX(FBPixelOffset) = sctx->FrontBackOffset;
	REG_WRITE(CTX(FBPixelOffset), FBPixelOffsetOff);
	/* show front buffer */
	REG_WRITE(sctx->FrontBuffAddrOffset, SuspendUntilFrameBlankOff);
    }
    else {
	buff = 1;
	/* draw into the front buffer */
	CTX(FBPixelOffset) = 0;
	REG_WRITE(0, FBPixelOffsetOff);
	/* show back buffer */
	REG_WRITE(sctx->BackBuffAddrOffset, SuspendUntilFrameBlankOff);
    }


LOG("aclPM2SwapBufferScreen(): ______\n")
}



static void
aclPM2SwapBufferBitPlane(ACLContext aclctx)
{
LOG("aclPM2SwapBufferBitPlane(): ###### EMPTY !!!\n");
LOG("aclPM2SwapBufferBitPlane(): ______\n");
}



static Tuint
aclPM2ClearBuffer(ACLContext aclctx, Tuint mask, Tbool all, Tint x, Tint y,
	Tint width, Tint height )
{
    MLX_INIT_ACCESS_MMCTL;
    Tuint orig_mask=mask, fastfill=R_FastFillEN;

#define RENDER_SETUP ( \
	R_PrimitiveRectangle | \
	R_XPositiveEN | \
	R_YPositiveEN )

#define DEPTH_MODE ( \
	UNIT_ENABLE | \
	DPM_WriteEN | \
	DPM_SrcRegister | \
	DPM_FuncALWAYS )

#define STENCIL_MODE ( \
	UNIT_ENABLE | \
	STM_SrcStencilReg | \
	STM_CompareFuncALWAYS | \
	STM_UpdateZPassREPLACE )

LOG("aclPM2Clear(): ######\n");

    if(!mask) return 0;

    /* first, common setup: */
    WAIT_FIFO(2);
    REG_WRITE(0, RectangleOriginOff);
    REG_WRITE((VAL(win_h) << 16) | VAL(win_w), RectangleSizeOff);

    /* stencil clear setup */
    if((mask & ACLGL_STENCIL_BUFFER_BIT)) {
LOG("aclPM2Clear(): ACLGL_STENCIL_BUFFER_BIT, val=%d\n", VAL(clear_stencil));
	mask &= ~ACLGL_STENCIL_BUFFER_BIT;
	WAIT_FIFO(3);
	REG_WRITE(VAL(clear_stencil), StencilOff);
	REG_WRITE(STENCIL_MODE, StencilModeOff);
	REG_WRITE(1 | (1<<8) | (1<<16), StencilDataOff);
	fastfill = 0;
    }
    else {
	WAIT_FIFO(1);
	REG_WRITE(UNIT_DISABLE, StencilModeOff);
    }

    /* depth clear setup */
    if((mask & ACLGL_DEPTH_BUFFER_BIT)) {
LOG("aclPM2Clear(): ACLGL_DEPTH_BUFFER_BIT, val=0x%x\n", VAL(clear_depth));
	mask &= ~ACLGL_DEPTH_BUFFER_BIT;
	WAIT_FIFO(2);
	REG_WRITE(VAL(clear_depth), DepthOff);
	REG_WRITE(DEPTH_MODE, DepthModeOff);
	fastfill = 0;
    }
    else {
	WAIT_FIFO(1);
	REG_WRITE(UNIT_DISABLE, DepthModeOff);
    }

    /* color clear setup */
    if((mask & ACLGL_COLOR_BUFFER_BIT)) {
LOG("aclPM2Clear(): ACLGL_COLOR_BUFFER_BIT, val=0x%x\n", VAL(clear_color));
	mask &= ~ACLGL_COLOR_BUFFER_BIT;
	/* only frame buffer, use fast clear */
	if(fastfill) {
LOG("aclPM2Clear(): ----------------------> fast fill\n");
	    WAIT_FIFO(3);
	    REG_WRITE(LBWM_WriteDIS, LBWriteModeOff);
	    REG_WRITE(UNIT_DISABLE, ColorDDAModeOff);
	    REG_WRITE(VAL(clear_color), FBBlockColorOff);
	}
	/* normal clear (pm2 doesn't support fast clear depth) */
	else {
	    WAIT_FIFO(2);
	    REG_WRITE(VAL(clear_color), ConstantColorOff);
	    REG_WRITE(UNIT_ENABLE, ColorDDAModeOff);
	}
    }
    else {
	WAIT_FIFO(1);
	REG_WRITE(FBWM_WriteDIS, FBWriteModeOff);
    }

    if(orig_mask == mask) {
	MSG("Clear: NOTHING TO CLEAR (Not supported 0x%x)\n", mask);
	return mask;
    }

#define MLX_DRAW_INIT \
	REG_WRITE_SLOW(RENDER_SETUP | fastfill, RenderOff);

#define MLX_DRAW_REPEAT \
	REG_WRITE(RENDER_SETUP | fastfill, RenderOff);

#define MLX_DRAW_REPEAT_CNT 1

    MLX_DRAW_CLIPPED

#undef MLX_DRAW_INIT
#undef MLX_DRAW_REPEAT
#undef MLX_DRAW_REPEAT_CNT

    WAIT_FIFO(5);
    REG_WRITE(CTX(FBWriteMode), FBWriteModeOff);
    REG_WRITE(CTX(LBWriteMode), LBWriteModeOff);
    REG_WRITE(CTX(DepthMode), DepthModeOff);
    REG_WRITE(CTX(ColorDDAMode), ColorDDAModeOff);
    REG_WRITE(CTX(StencilMode), StencilModeOff);

#undef DEPTH_MODE
#undef STENCIL_MODE
#undef RENDER_SETUP

    return mask;
}



Tbool
PM2InitACLAPIModules(ACLContext aclctx)
{
    Tbool ret = 0;
    ACLModules mod = aclctx->Mod;
    ACLflags mf = mod->modflags;

LOG("PM2InitACLAPIModules() ###### modflags=0x%x\n", mf);

    if(!(mf & (ACLMOD_RGBA | ACLMOD_CI)))
	return 1;

    if(mf & ACLMOD_RGBA)
	ret |= PM2InitACLAPIColorRGBAMod(aclctx);

#if 0
    if(mf & ACLMOD_CI)
	ret |= PM2InitACLAPIColorCIMod(aclctx);
#endif

    if(mf & ACLMOD_LB)
	ret |= PM2InitACLAPILBMod(aclctx);

    if(mf & ACLMOD_ACCEL)
	ret |= PM2InitACLAPIAccelMod(aclctx);

    if(mf & ACLMOD_TEX)
	ret |= PM2InitACLAPITexMod(aclctx);

    mod->StartRender = aclPM2StartRender;
    mod->FinishRender = aclPM2FinishRender;
    mod->DrawBuffer = aclPM2DrawBuffer;
    mod->ClearBuffer = aclPM2ClearBuffer;

    if(aclctx->acl_cfg & ACLOPT_DBUFF_SCREEN)
	mod->SwapBuffer = aclPM2SwapBufferScreen;
    else if(aclctx->acl_cfg & ACLOPT_DBUFF_BITPLANE)
	mod->SwapBuffer = aclPM2SwapBufferBitPlane;
    else
	mod->SwapBuffer = aclPM2SwapBufferBitBlt;

LOG("PM2InitACLAPIModules(): ______\n");

    return ret;
}

