
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */

/*****************************************************************************/
/*****************************************************************************/
/* Permedia2 OpenGL/Mesa driver                                              */
/* (c) 1997, 1998, 1999 SuSE GmbH                                            */
/* ------------------------------------------------------------------------- */
/* Authors:                                                                  */
/*	Simon Pogarcic, sim@suse.de                                          */
/*	Stefan Dirsch, sndirsch@suse.de                                      */
/*	Helmut Fahrion, hefa@artis.de                                        */
/*****************************************************************************/
/*****************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pm2.h"

#undef FSCOPE
#define FSCOPE static



#if 0
  #define LOG_DEBUG
#endif

#define LOG_DBGINFO "<pm2_lb>"
#include "log_debug.h"



/******************************************************************************
                   NON-ACCELERATED RENDERING DEPTH FUNCTIONS
 ******************************************************************************/
FSCOPE void
aclPM2LBWritePixels(const ACLContext aclctx, Tuint n, const Tint x[],
	const Tint y[], const Tuint lvalue[], const Tuint hvalue[],
	const Tubyte mask[], Tubyte flags )
{

}



FSCOPE void
aclPM2LBReadPixels(const ACLContext aclctx, Tuint n, const Tint x[],
	const Tint y[], Tuint lvalue[], Tuint hvalue[], const Tubyte mask[],
	Tubyte flags )
{

}



/******************************************************************************
                     ACCELERATED RENDERING DEPTH FUNCTIONS
 ******************************************************************************/
FSCOPE void
aclPM2EnableDepth(ACLContext aclctx, Tbool state)
{
    MLX_INIT_ACCESS_MMCTL;

LOG("aclPM2EnableDepth(): ###### state=%d\n", state);

    if (state) {
	CTX(DeltaMode) |= DM_DepthEN;
	CTX(DepthMode) |= UNIT_ENABLE;
    }
    else {
	CTX(DeltaMode) &= DM_DepthMASK;
	CTX(DepthMode) &= UNIT_MASK;
    }

    WAIT_FIFO(2);
    REG_WRITE(CTX(DeltaMode), DeltaModeOff);
    REG_WRITE(CTX(DepthMode), DepthModeOff);

LOG("aclPM2EnableDepth(): ______ DeltaMode: 0x%x\n", CTX(DeltaMode));
LOG("aclPM2EnableDepth(): ______ DepthMode: 0x%x\n", CTX(DepthMode));
}



FSCOPE void
aclPM2ClearDepth(ACLContext aclctx, Tfloat depth)
{
LOG("aclPM2ClearDepth() ######\n");

    depth = (depth > 1.0 ? 1.0 : depth);
    depth = (depth < 0.0 ? 0.0 : depth);
    VAL(clear_depth) = (Tuint) (depth * VAL(depth_range));

LOG("aclPM2ClearDepth() ______ clear_depth: 0x%x\n", VAL(clear_depth));
}



FSCOPE void
aclPM2DepthFunc(ACLContext aclctx, ACLglenum func)
{
    MLX_INIT_ACCESS_MMCTL;

    Tuint fn = 0;

LOG("aclPM2DepthFunc(): ###### func=0x%x\n", func);

    switch (func) {
    case ACLGL_NEVER:
	fn = DPM_FuncNEVER;
	break;
    case ACLGL_LESS:
	fn = DPM_FuncLESS;
	break;
    case ACLGL_EQUAL:
	fn = DPM_FuncEQ;
	break;
    case ACLGL_LEQUAL:
	fn = DPM_FuncLEQ;
	break;
    case ACLGL_GREATER:
	fn = DPM_FuncGREATER;
	break;
    case ACLGL_NOTEQUAL:
	fn = DPM_FuncNEQ;
	break;
    case ACLGL_GEQUAL:
	fn = DPM_FuncGEQ;
	break;
    case ACLGL_ALWAYS:
	fn = DPM_FuncALWAYS;
	break;
    default:
	ERR("DepthFunc: UNKNOWN (0x%x)\n", func);
	break;
    }

    CTX(DepthMode) = (CTX(DepthMode) & DPM_FuncMASK) | fn;

    WAIT_FIFO(1);
    REG_WRITE(CTX(DepthMode), DepthModeOff);

LOG("aclPM2DepthFunc(): ______ DepthMode = 0x%x\n", CTX(DepthMode));
}



FSCOPE void
aclPM2DepthMask(ACLContext aclctx, ACLglenum mask)
{
    MLX_INIT_ACCESS_MMCTL;

LOG("aclPM2DepthMask(): ###### mask=%d\n", mask);

    if(mask) {
	CTX(DepthMode) |= DPM_WriteEN;
    }
    else {
	CTX(DepthMode) &= DPM_WriteMASK;
    }

    WAIT_FIFO(1);
    REG_WRITE(CTX(DepthMode), DepthModeOff);

LOG("aclPM2DepthMask(): ______ DepthMode = 0x%x\n", CTX(DepthMode));
}



#if 0
******************************************************************************
/* Stencil Operationen */

FSCOPE ACLvoid acl_PM2_clear_stencil(ACLContext aclctx, ACLint s)
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    TLOG("_clear_stencil\n");

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    /* es gibt leider nur 1 bit Stencildaten beim PM2 */
    CRC(_Stencil) = (s)? 1 : 0;
    WAIT_FIFO(2);
    REG_WRITE(CRC(_StencilData), StencilDataOff);
    REG_WRITE(CRC(_Stencil), StencilOff);
}

FSCOPE ACLvoid acl_PM2_stencil_func(ACLContext aclctx, ACLenum func, 
				    ACLint ref, ACLuint mask)
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    TLOG("_stencil_func\n");

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    CRC(_StencilMode) &= STM_CompareFunctionMASK;
    
    switch (func) {
    case GL_NEVER: 
	CRC(_StencilMode) |= STM_CompareFunctionNEVER; 
	break;
    case GL_LESS: 
	CRC(_StencilMode) |= STM_CompareFunctionLESS; 
	break;
    case GL_LEQUAL:
	CRC(_StencilMode) |= STM_CompareFunctionLEQUAL; 
	break;
    case GL_GREATER:
	CRC(_StencilMode) |= STM_CompareFunctionGREATER; 
	break;
    case GL_GEQUAL:
	CRC(_StencilMode) |= STM_CompareFunctionGEQUAL; 
	break;
    case GL_EQUAL:
	CRC(_StencilMode) |= STM_CompareFunctionEQUAL; 
	break;
    case GL_NOTEQUAL:
	CRC(_StencilMode) |= STM_CompareFunctionNOTEQUAL; 
	break;
    case GL_ALWAYS:
	CRC(_StencilMode) |= STM_CompareFunctionALWAYS; 
	break;
    default:
	ERR("glStencilFunc illegal value!\n" );
	return;
    }

    CRC(_StencilData) |= STD_CompareMaskEN;
    if (ref || mask) {
	if (ref)
	    CRC(_StencilData) |= STD_ReferenceStencilEN;
	else
	    CRC(_StencilData) &= STD_ReferenceStencilMASK;

	if (mask) 
	    CRC(_StencilData) |= STD_WriteMaskEN;
	else
	    CRC(_StencilData) &= STD_WriteMaskMASK;

	WAIT_FIFO(2);
	REG_WRITE(CRC(_StencilData), StencilDataOff);
	REG_WRITE(CRC(_StencilMode), StencilModeOff);
    } else {
	CRC(_StencilData) &= STD_ReferenceStencilMASK;
	CRC(_StencilData) &= STD_WriteMaskMASK;
	WAIT_FIFO(2);
	REG_WRITE(CRC(_StencilMode), StencilModeOff);
	REG_WRITE(CRC(_StencilData), StencilDataOff);
    }
}


FSCOPE ACLvoid acl_PM2_stencil_enable(ACLContext aclctx, ACLbool enable )
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    TLOG("_stencil_enable\n");

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    if (enable) {
	CRC(_StencilMode) |= UNIT_ENABLE;
    } else {
	CRC(_StencilMode) &= ~UNIT_ENABLE;
    }
    WAIT_FIFO(1);
    REG_WRITE(CRC(_StencilMode), StencilModeOff);
}


FSCOPE ACLvoid
 acl_PM2_stencil_op(ACLContext aclctx, ACLenum fail, ACLenum zfail, ACLenum zpass )
{
    MLX_INIT_ACCESS_DRIVERCTX;
    MLX_INIT_ACCESS_CTL;
    MLX_INIT_ACCESS_DMA;

    TLOG("_stencil_op\n");

    if (olddrvidx ^ aclctx->drvidx) {
	MLX_SET_NEW_DRIVERCTX(aclctx);
	MLX_SET_ACCESS_CTL;
	MLX_SET_ACCESS_DMA;
    }

    CRC(_StencilMode) &= STM_UpdateMethodesfailMASK;

    switch (fail) {
      case GL_KEEP:
	  CRC(_StencilMode) |= STM_UpdateMethodesfailKEEP; 
	  break;
      case GL_ZERO:
	  CRC(_StencilMode) |= STM_UpdateMethodesfailZERO; 
	  break;
      case GL_REPLACE:
	  CRC(_StencilMode) |= STM_UpdateMethodesfailREPLACE; 
	  break;
      case GL_INCR:
	  CRC(_StencilMode) |= STM_UpdateMethodesfailINC; 
	  break;
      case GL_DECR:
	  CRC(_StencilMode) |= STM_UpdateMethodesfailDEC;
      case GL_INVERT:
	  CRC(_StencilMode) |= STM_UpdateMethodesfailINV; 
	  break;
         break;
      default:
         ERR("invalid glStencilOp fail!\n");
         return;
   }

   switch (zfail) {
      case GL_KEEP:
	  CRC(_StencilMode) |= STM_UpdateMethodedpfailKEEP; 
	  break;
      case GL_ZERO:
	  CRC(_StencilMode) |= STM_UpdateMethodedpfailZERO; 
	  break;
      case GL_REPLACE:
	  CRC(_StencilMode) |= STM_UpdateMethodedpfailREPLACE; 
	  break;
      case GL_INCR:
	  CRC(_StencilMode) |= STM_UpdateMethodedpfailINC; 
	  break;
      case GL_DECR:
	  CRC(_StencilMode) |= STM_UpdateMethodedpfailDEC; 
	  break;
      case GL_INVERT:
	  CRC(_StencilMode) |= STM_UpdateMethodedpfailINV; 
	  break;
         break;
      default:
         ERR("invalid glStencilOp zfail!\n");
         return;
   }

   switch (zpass) {
      case GL_KEEP:
	  CRC(_StencilMode) |= STM_UpdateMethodedppassKEEP; 
	  break;
      case GL_ZERO:
	  CRC(_StencilMode) |= STM_UpdateMethodedppassZERO; 
	  break;
      case GL_REPLACE:
	  CRC(_StencilMode) |= STM_UpdateMethodedppassREPLACE; 
	  break;
      case GL_INCR:
	  CRC(_StencilMode) |= STM_UpdateMethodedppassINC; 
	  break;
      case GL_DECR:
	  CRC(_StencilMode) |= STM_UpdateMethodedppassDEC; 
	  break;
      case GL_INVERT:
	  CRC(_StencilMode) |= STM_UpdateMethodedppassINV; 
	  break;
         break;
      default:
         ERR("invalid glStencilOp zpass!\n");
         return;
   }

   WAIT_FIFO(1);
   REG_WRITE(CRC(_StencilMode), StencilModeOff);
}
******************************************************************************
#endif



Tbool
PM2InitACLAPILBMod(ACLContext aclctx)
{
    ACLLBMod lbm = aclctx->Mod->LB;

    lbm->LBWritePixels = aclPM2LBWritePixels;
    lbm->LBReadPixels = aclPM2LBReadPixels;

    lbm->EnableDepth = aclPM2EnableDepth;
    lbm->ClearDepth = aclPM2ClearDepth;
    lbm->DepthFunc = aclPM2DepthFunc;
    lbm->DepthMask = aclPM2DepthMask;

    return 0;
}

