
#ifndef _PM2_H_
#define _PM2_H_

/*
 * these defines must be placed _before_ include of glintcommon.h; they are
 * required there for some pre-configuration of particular driver
 */
#if 0
  #define PCI_DISCONNECT
#endif

#include "glintcommon.h"



#define	CTX(arg)	pm2_hwctx.arg
#define VAL(arg)	pm2_values.arg



#define REGtype		Tuint
#define REGPtr		Tuint *

typedef struct {
	REGtype	AreaStippleMode;
	REGtype	DepthMode;
	REGtype	StencilMode;
	REGtype	TextureAddressMode;

	REGtype	TextureReadMode;
	REGtype	TexelLUTMode;
	REGtype	YUVMode;
	REGtype	ColorDDAMode;

	REGtype	TextureColorMode;
	REGtype	FogMode;
	REGtype	AlphaBlendMode;
	REGtype	LogicOpMode;

	REGtype	StatisticMode;
	REGtype	AlphaTestMode;
	REGtype	LineStippleMode;
	REGtype	ScissorMode;

	REGtype	AntialiasMode;
	REGtype	PatternRamMode;
	REGtype	RasterizerMode;
	REGtype	FilterMode;

	REGtype LBReadFormat;
	REGtype LBWriteFormat;
	REGtype DeltaMode;

	REGtype FBSourceOffset;
	REGtype	FBPixelOffset;
	REGtype	LBSourceOffset;

	REGtype	LBReadMode;
	REGtype LBWriteMode;
	REGtype	FBReadMode;
	REGtype	FBWriteMode;

	REGtype	FBHardwareWriteMask;
	REGtype FBSoftwareWriteMask;
	REGtype Xlimits;
	REGtype Ylimits;

        REGtype	FBWindowBase;
	REGtype	LBWindowBase;

	REGtype DitherMode;
	REGtype FBBlockColor;
	REGtype FBReadPixel;
	REGtype Window;

} PM2HardwareContext;



extern PM2HardwareContext	pm2_hwctx;
extern GLINTRenderingValues	pm2_values;



#endif
