
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _GLINTCOMMON_H_
#define _GLINTCOMMON_H_



#if 1
#define PCI_DISCONNECT
#endif

#if 1
#define MLXCLIP
#endif



#include "mlx.h"
#include "mlxgen.h"
#include "glintregs.h"



#define TXLBSize(v)		(1024*1024*((1 << ((v>>24) & 7)) & 127))
#define TXFBSize(v)		(1024*1024*((1 << ((v>>29) & 7)) & 127))
#define TXFBEDO_DRAM(v)		((v>>22) & 1)
#define PMFBSize(v)		(1024*2048*(((v>>29) & 3) + 1))



/*
 * Clipp boxes definition for test purposes
 ********************************************/
#define TEST_CLIPP_4(cb,w,h,o) \
{ \
    MLXBox *r = cb = (MLXBox *)malloc(sizeof(MLXBox)); \
    r->x1=0; r->y1=0; r->x2=w/2-o; r->y2=h/2-o; \
    r = r->next = (MLXBox *)malloc(sizeof(MLXBox)); \
    r->x1=w/2+o; r->y1=0; r->x2=w; r->y2=h/2-o; \
    r = r->next = (MLXBox *)malloc(sizeof(MLXBox)); \
    r->x1=0; r->y1=h/2+o; r->x2=w/2-o; r->y2=h; \
    r = r->next = (MLXBox *)malloc(sizeof(MLXBox)); \
    r->x1=w/2+o; r->y1=h/2+o; r->x2=w; r->y2=h; \
    r->next = NULL; \
}

#define TEST_CLIPP_2(cb,w,h,o) \
{ \
    MLXBox *r = cb = (MLXBox *)malloc(sizeof(MLXBox)); \
    r->x1=0; r->y1=0; r->x2=w/2-o; r->y2=h; \
    r = r->next = (MLXBox *)malloc(sizeof(MLXBox)); \
    r->x1=w/2+o; r->y1=0; r->x2=w; r->y2=h; \
    r->next = NULL; \
}

/*
 * The VAL(clip_enable) switches clipping for MLX_DRAW_CLIPPED on/off
 * BITPLANE db requires clipping for both planes.
 * SCREEN OFFSET/FULLSCREEN doesn't require clipping, as there should be
 * only one client which runs.
 */

#if defined(MLXCLIP)
#define MLX_DRAW_CLIPPED \
{ \
    MLXBox *pBox = VAL(clip_boxes); \
    if(pBox && VAL(clip_enable)) { \
	WAIT_FIFO(5); \
	REG_WRITE(pBox->y1<<16 | pBox->x1, ScissorMinXYOff); \
	REG_WRITE(pBox->y2<<16 | pBox->x2, ScissorMaxXYOff); \
	REG_WRITE(SCM_UserScissorEN, ScissorModeOff); \
	MLX_DRAW_INIT; \
	while((pBox = pBox->next)) { \
	    WAIT_FIFO(3 + MLX_DRAW_REPEAT_CNT); \
	    REG_WRITE(pBox->y1<<16 | pBox->x1, ScissorMinXYOff); \
	    REG_WRITE(pBox->y2<<16 | pBox->x2, ScissorMaxXYOff); \
	    MLX_DRAW_REPEAT; \
	} \
	WAIT_FIFO(2); \
	REG_WRITE(UNIT_DISABLE, ScissorModeOff); \
    } \
    else { \
	MLX_DRAW_INIT; \
    } \
}
#else
#define MLX_DRAW_CLIPPED \
{ \
    MLX_DRAW_INIT; \
}
#endif



/*****************************************************************************/
typedef enum mlx_downloadt
{
    NLB,       /* is in localbuffer */
    LB,      /* not in localbuffer */
    SUBIMG,
    /* NSUBIMG, */
    BUS       /* too big for localbuffer, render across AGP/PCI */
} MLX_Downloadt;

/* index data */
typedef struct mlx_textureindex
{
    unsigned int *index;   /* index data array to HS */
    unsigned int anz;      /* size of index */
    unsigned int adr;      /* LB address for indexed texture */
    MLX_Downloadt isd;     /* in localbuffer ? */
} MLX_TextureIdx;

/* Datenstruktur fr die MipMapLevels */
typedef struct mipmaplevel
{
    unsigned int size, wl2, hl2, dl2;
} mipmaplevel;

/* die Textur im Hauptspeicher */
typedef struct texture
{
    unsigned int
        n,			/* name */
	bordercolor,		/* color of border */
	adrmode,		/* register data, for glint chipset */
	treadmode, 
	lbreadmode, 
	format, 
	colormode, 
	baseaddress[12];	/* baseaddress of lb */

	MLX_TextureIdx index;	/* index or Pointer of index */

	Tuint	*txtdataLR[12];/* baseaddress of mem */
	mipmaplevel leveldata[12];

	MLX_Downloadt isd;	/* is lb or mem */
	Tuint levels;		/* counter of mipmaplevels */

	Tint dataformat;
	ACLTexImage image;
} texture;
/*****************************************************************************/



#define GLINT_CFORMAT_8888		0
#define GLINT_CFORMAT_5551		1
#define GLINT_CFORMAT_4444		2
#define GLINT_CFORMAT_332		3
#define GLINT_CFORMAT_2321		4
#define GLINT_CFORMAT_232Off		5
#define GLINT_CFORMAT_565		6
#define GLINT_CFORMAT_YUV444		7
#define GLINT_CFORMAT_YUV422		8
#define GLINT_CFORMAT_CI8		9
#define GLINT_CFORMAT_CI4		10



typedef struct {
	Tuint		draw_color;
	Tuint		clear_color;
	Tuint		clear_depth;
	Tuint		clear_stencil;
	Tuint		clear_alpha;
	Tubyte		depth_bits;
	Tubyte		stencil_bits;
	Tubyte		fclear_bits;
	Tubyte		gid_bits;
	Tuint		depth_range;
	Tuint		depth_par_range;
	Tubyte		cformat_idx;
	Tuint		cformat_front;
	Tuint		cformat_back;
	Tuint		cformat_ext;
	Tbool		order_rgb;
	Tubyte		alpha_bits;
	Tuint		window_base;
	Tuint		win_x, win_y, win_w, win_h;
	Tbool		clip_enable;
	MLXBox		*clip_boxes;
	Tuint		back_offset;

	Tint		_Triwl2, _Trihl2;
	Tint		_ColorMode;
	Tint		_AnzN;
	Tint		_GlbPal;
	Tint		_MallocZ;
	Tuint		_LastAdr;
	Tint		_TexEN;
	void**		_Names;
	void*		_DDLast;

	MLX_TextureIdx  _GlbIndex;
	Tbool		_LastBind;
        Tbool		_FogMode;
} GLINTRenderingValues;







/*
 * Delta Fixed Point reg has 1.30us format (31 bit),
 * with 8 bit color : 31 - 8 = 23
 * with 6 bit color : 31 - 6 = 25
 * with 5 bit color : 31 - 5 = 26
 * with 4 bit color : 31 - 4 = 27
 */
#define COLORSHIFT 23

#define VAL_R(vx)	((VB->Color[vx][0] << COLORSHIFT))
#define VAL_G(vx)	((VB->Color[vx][1] << COLORSHIFT))
#define VAL_B(vx)	((VB->Color[vx][2] << COLORSHIFT))
#define VAL_A(vx)	((VB->Color[vx][3] << COLORSHIFT))

#define VAL_S(vx)	(VB->TexCoord[vx][0])
#define VAL_T(vx)	(VB->TexCoord[vx][1])
#define VAL_Re(vx)	(VB->TexCoord[vx][2])
#define VAL_Q(vx)	(VB->TexCoord[vx][3])

#define VAL_X(vx)	(VB->Win[vx][0])
#define VAL_Y(vx)	(VB->Win[vx][1])
/* #define VAL_Z(vx)	(VB->Win[vx][2] / VAL(_DepthRange) ) */
#define VAL_Z(vx)	(VB->Win[vx][2] * (1.0 / 65535.0))
#define VAL_W(vx)	(VB->Clip[vx][3])



#define PACKED_VERTEX_COLOR(vx) ( \
	((VB->Color[vx][3])<<24) | \
	((VB->Color[vx][2] & 0xff)<<16) | \
	((VB->Color[vx][1] & 0xff)<<8) | \
	 (VB->Color[vx][0] & 0xff) )

#define PACKED_COLOR(r,g,b,a) ( \
	 (a<<24) | \
	((r & 0xff)<<16) | \
	((g & 0xff)<<8) | \
	 (b & 0xff) )

#define UNPACKED_COLOR(r,g,b,a,bc) \
{ \
    a = (bc >> 24) & 0xff; \
    r = (bc >> 16) & 0xff; \
    g = (bc >> 8) & 0xff; \
    b = bc & 0xff; \
}



#ifdef RDEBUG
#define REGLOG(f, a...)		{ fprintf(stderr, f, ## a); }
#else
#define REGLOG(f, a...)
#endif

#define GLINT_INIT_ACCESS_FIFO \
    volatile REGPtr FIFOBASE = (REGPtr)((char*)aclctx->CardCTL+InOutFIFO); \
    volatile REGPtr FIFOWRITE = FIFOBASE; \
    Tuint FIFOSIZE = 0x1000

#define REG_READ(r) \
    (*(REGPtr)((char*)MMIOBASE + r)) \

#define REG_READ_IN(v,r) \
{ \
    v = *(REGPtr)((char*)MMIOBASE + r); \
    REGLOG("Read reg Ox%x: value 0x%x\n", r, v); \
}

#define REG_WRITE(v,r) \
{ \
    * (REGPtr) ((char*)MMIOBASE + r) = v; \
    REGLOG("Write reg 0x%x: value 0x%x \n", r, v); \
}
  
#define REG_CWRITE(v,r) \
{ \
    * (REGPtr) ((char*)MMIOBASE + r) = *( (REGPtr) &v); \
    REGLOG("Write casted reg 0x%x: value 0x%x\n", r, v); \
}
  
#define REG_WRITE_SLOW(v,r) \
{ \
    while(!REG_READ(InFIFOSpace)); \
    *(REGPtr)((char*)MMIOBASE + r) = v; \
    REGLOG("Single wait/write reg 0x%x: value 0x%x\n", r, v); \
}
  
#define REG_CWRITE_SLOW(v,r) \
{ \
    while(!REG_READ(InFIFOSpace)); \
    *(REGPtr)((char*)MMIOBASE + r) = *((REGPtr)&v); \
    REGLOG("Single wait/write reg 0x%x: value 0x%x\n", r, v); \
}
  
#ifdef PCI_DISCONNECT
#define WAIT_FIFO(v)
#else
#define WAIT_FIFO(v) \
{ \
    REGLOG("\n********** WAITING FOR %d in FIFO...\n", v); \
    while(REG_READ(InFIFOSpace) < v) { \
	REGLOG("------> InFIFOSpace = %d\n", REG_READ(InFIFOSpace)); \
    } \
}
#endif
  


Tint		decode_internal_format (Tint format);
void		int_sync(ACLContext aclctx);

Tuint		log2(Tuint f);

Tint		konvert888to8888
	(Tuint **data, Tuint *size, const ACLTexImage image);

Tint		konvert888to8888scale
	(Tuint **data, Tuint *size, const ACLTexImage image);

Tint		konvert8888to8888
	(Tuint **data, Tuint *size, const ACLTexImage image);

Tint		konvert8888to8888scale
	(Tuint **data, Tuint *size, const ACLTexImage image);

Tint		convert8888to4444scale
	(Tuint **data, Tuint *size, const ACLTexImage image);

Tint		GlintProbeRamdac(volatile void *mmiobase);
const Tubyte *	GlintFindRamdac(Tint *id1, Tint id2);
const Tubyte *	GlintRamtypeString(Tint id);
Tint		GlintGetPProd(Tint card_type, Tuint width);
Tint		GlintCalcPProd(Tint card_type, Tuint width);

#endif
