
/*****************************************************************************
 *                                    M L X                                  *
 *                 Rendering Library for Accelerated 3d Hardware             *
 *                           (C) SuSE GmbH 1997, 1998                        *
 *****************************************************************************/
/* author: simon pogarcic, sim@suse.de */

/*****************************************************************************/
/*****************************************************************************/
/* Permedia2 OpenGL/Mesa driver                                              */
/* (c) 1997, 1998, 1999 SuSE GmbH                                            */
/* ------------------------------------------------------------------------- */
/* Authors:                                                                  */
/*	Simon Pogarcic, sim@suse.de                                          */
/*	Stefan Dirsch, sndirsch@suse.de                                      */
/*	Helmut Fahrion, hefa@artis.de                                        */
/*****************************************************************************/
/* Some code parts came from Xfree86 glint driver. More info about authors   */
/* could be found in /xc/programs/Xserver/hw/xfree86/drivers/glint directory */
/*****************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#include <float.h>
#include <math.h>
#include <malloc.h>

#include "glintcommon.h"



#if 1
  #define LOG_DEBUG
#endif

#define LOG_DBGINFO "<glintcommon>"
#include "log_debug.h"



Tint
GlintProbeRamdac(volatile void *mmiobase)
{
LOG("GLINTProbeRamdac(): ######\n");
    return -1;
}



/*
 * - *id1 != -1:
 *	find id1 and return string
 *
 * - *id1 == -1:
 *	find id2, set *id1 and return string
 */
const Tubyte *
GlintFindRamdac(Tint *id1, Tint id2)
{
    static MLXInfoRec infos[] = {
	{ RD_IBM_526DB, 	0x280,		"IBM 526DB"},
	{ RD_IBM_526, 		0x2c0,		"IBM 526"},
	{ RD_IBM_524, 		0x2f0,		"IBM 524"},
	{ RD_IBM_524, 		0x2e0,		"IBM 524"},
	{ RD_IBM_624,		0x30c0,	 	"IBM 624"},
	{ RD_IBM_640,		0x121c,		"IBM 640"},
	{ -1, 0, ""}
    };
    const MLXInfoRec *info = infos;
    const Tubyte *unknown = "UNKNOWN";
    Tint cid;

    if(*id1 != -1) {
	while((cid = info->id1) != -1) {
	    if(cid == *id1) return info->info;
	    info ++;
	}
    }
    else {
	while(info->id1 != -1) {
	    if(info->id2 == id2) { *id1 = info->id1; return info->info; }
	    info ++;
	}
	*id1 = RD_UNKNOWN;
    }
    return unknown;
}



const Tubyte *
GlintRamtypeString(Tint id)
{
    static MLXInfoRec infos[] = {
	{ RAM_UNKNOWN, 		0x0,		"UNKNOWN"},
	{ RAM_SDRAM,		0x0,		"SDRAM"},
	{ RAM_SGRAM,		0x0,		"SGRAM"},
	{ -1, 0, ""},
    };
    const MLXInfoRec *info = infos;
    Tint cid;

    while((cid = info->id1) != -1) {
	if(cid == id) return info->info;
	info++;
    }

    info = infos;
    return info->info; /* "UNKNOWN" */
}



#define PARTPROD(a,b,c) (((a)<<6) | ((b)<<3) | (c))

static Tint glint_pprod_txmx[] = {
	-1,
	PARTPROD(0,0,1), PARTPROD(0,0,2), PARTPROD(0,1,2), PARTPROD(0,0,3),
	PARTPROD(0,1,3), PARTPROD(0,2,3), PARTPROD(1,2,3), PARTPROD(0,0,4),
	PARTPROD(0,1,4), PARTPROD(0,2,4), PARTPROD(1,2,4), PARTPROD(0,3,4),
	PARTPROD(1,3,4), PARTPROD(2,3,4),              -1, PARTPROD(0,0,5), 
	PARTPROD(0,1,5), PARTPROD(0,2,5), PARTPROD(1,2,5), PARTPROD(0,3,5), 
	PARTPROD(1,3,5), PARTPROD(2,3,5),              -1, PARTPROD(0,4,5), 
	PARTPROD(1,4,5), PARTPROD(2,4,5), PARTPROD(3,4,5),              -1,
	             -1,              -1,              -1, PARTPROD(0,0,6), 
	PARTPROD(0,1,6), PARTPROD(0,2,6), PARTPROD(1,2,6), PARTPROD(0,3,6), 
	PARTPROD(1,3,6), PARTPROD(2,3,6),              -1, PARTPROD(0,4,6), 
	PARTPROD(1,4,6), PARTPROD(2,4,6),              -1, PARTPROD(3,4,6),
	             -1,              -1,              -1, PARTPROD(0,5,6), 
	PARTPROD(1,5,6), PARTPROD(2,5,6),              -1, PARTPROD(3,5,6), 
	             -1,              -1,              -1, PARTPROD(4,5,6), 
	             -1,              -1,              -1,              -1,
		     -1,              -1,              -1, PARTPROD(0,0,7), 
	             -1, PARTPROD(0,2,7), PARTPROD(1,2,7), PARTPROD(0,3,7), 
	PARTPROD(1,3,7), PARTPROD(2,3,7),              -1, PARTPROD(0,4,7),
	PARTPROD(1,4,7), PARTPROD(2,4,7),              -1, PARTPROD(3,4,7), 
	             -1,              -1,              -1, PARTPROD(0,5,7),
	PARTPROD(1,5,7), PARTPROD(2,5,7),              -1, PARTPROD(3,5,7), 
	             -1,              -1,              -1, PARTPROD(4,5,7),
	             -1,              -1,              -1,              -1,
		     -1,              -1,              -1, PARTPROD(0,6,7), 
	PARTPROD(1,6,7), PARTPROD(2,6,7),              -1, PARTPROD(3,6,7),
	             -1,              -1,              -1, PARTPROD(4,6,7), 
	             -1,              -1,              -1,              -1,
		     -1,              -1,              -1, PARTPROD(5,6,7), 
	             -1,              -1,              -1,              -1,
		     -1,              -1,              -1,              -1,
		     -1,              -1,              -1,              -1,
		     -1,              -1,              -1, PARTPROD(0,7,7),
		      0
};

static Tint glint_pprod_pm2[] = {
	-1,
	PARTPROD(0,0,1), PARTPROD(0,1,1), PARTPROD(1,1,1), PARTPROD(1,1,2),
	PARTPROD(1,2,2), PARTPROD(2,2,2), PARTPROD(1,2,3), PARTPROD(2,2,3),
	PARTPROD(1,3,3), PARTPROD(2,3,3),              -1, PARTPROD(3,3,3),
	PARTPROD(1,3,4), PARTPROD(2,3,4),              -1, PARTPROD(3,3,4), 
	PARTPROD(1,4,4), PARTPROD(2,4,4),              -1, PARTPROD(3,4,4), 
	             -1,              -1,              -1, PARTPROD(4,4,4), 
	PARTPROD(1,4,5), PARTPROD(2,4,5), PARTPROD(3,4,5),              -1,
	             -1,              -1,              -1, PARTPROD(4,4,5), 
	PARTPROD(1,5,5), PARTPROD(2,5,5),              -1, PARTPROD(3,5,5), 
	             -1,              -1,              -1, PARTPROD(4,5,5), 
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1, PARTPROD(5,5,5), 
	PARTPROD(1,5,6), PARTPROD(2,5,6),              -1, PARTPROD(3,5,6),
	             -1,              -1,              -1, PARTPROD(4,5,6),
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1, PARTPROD(5,5,6),
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
	             -1,              -1,              -1,              -1,
		     0
};



Tint 
GlintCalcPProd(Tint card_type, Tuint width)
{
    Tint MaxPartialProduct;
    Tint MinPartialProduct;
    Tint pp[3], ppn, j;

    switch(card_type) {
    case CARD_PERMEDIA2:
    case CARD_PERMEDIA_DELTA:
	if(width > 1536) return 0;	/* if biger values, segfault !!! */
	MaxPartialProduct = 9;
	MinPartialProduct = 5;
	break;
    case CARD_GLINT_MX_DELTA:
    case CARD_GLINT_500TX_DELTA:
	if(width > 4096) return 0;
	MaxPartialProduct = 11;
	MinPartialProduct = 5;
	break;
    default:
	return 0;
    }

    do {
	ppn = pp[0] = pp[1] = pp[2] = 0;
	if (width >= MaxPartialProduct) {
	    ppn = width >> (MaxPartialProduct);
	    for (j = 0; j < ppn; j++) {
		pp[j] = 1 + MaxPartialProduct - MinPartialProduct;
	    }
	}
	for (j = MinPartialProduct; j < MaxPartialProduct; j++) {
	    if (width & (1 << j)) {
		if (ppn < 3)
		    pp[ppn] = j + 1 - MinPartialProduct;
		ppn++;
	    }
	}
	width += 32;
    } while (ppn > 3);

    return PARTPROD(pp[2],pp[1],pp[0]);
}



Tint
GlintGetPProd(Tint card_type, Tuint width)
{
    Tint pprod, *data;
    
    switch(card_type) {
    case CARD_PERMEDIA2:
    case CARD_PERMEDIA_DELTA:
	if(width > 2048) return 0;
	data = glint_pprod_pm2;
	break;
    case CARD_GLINT_MX_DELTA:
    case CARD_GLINT_500TX_DELTA:
	if(width > 4096) return 0;
	data = glint_pprod_txmx;
	break;
    default:
	return 0;
    }

    while((pprod = data[width >> 5]) == -1)
	width += 32;

    return pprod;
}



#if 0

extern MLXValuesCtx    ClientValCtx;

/* decode format */
int 
decode_internal_format(GLint format)
{
    switch (format) {
    case GL_ALPHA:
    case GL_ALPHA4:
    case GL_ALPHA8:
    case GL_ALPHA12:
    case GL_ALPHA16:
	return GL_ALPHA;
    case 1:
    case GL_LUMINANCE:
    case GL_LUMINANCE4:
    case GL_LUMINANCE8:
    case GL_LUMINANCE12:
    case GL_LUMINANCE16:
	return GL_LUMINANCE;
    case 2:
    case GL_LUMINANCE_ALPHA:
    case GL_LUMINANCE4_ALPHA4:
    case GL_LUMINANCE6_ALPHA2:
    case GL_LUMINANCE8_ALPHA8:
    case GL_LUMINANCE12_ALPHA4:
    case GL_LUMINANCE12_ALPHA12:
    case GL_LUMINANCE16_ALPHA16:
	return GL_LUMINANCE_ALPHA;
    case GL_INTENSITY:
    case GL_INTENSITY4:
    case GL_INTENSITY8:
    case GL_INTENSITY12:
    case GL_INTENSITY16:
	return GL_INTENSITY;
    case 3:
    case GL_RGB:
    case GL_R3_G3_B2:
    case GL_RGB5:
    case GL_RGB8:
    case GL_RGB10:
    case GL_RGB12:
    case GL_RGB16:
	return GL_RGB;
    case 4:
    case GL_RGBA:
    case GL_RGBA2:
    case GL_RGB5_A1:
#if 0
    case GL_RGBA4:
#endif
    case GL_RGBA8:
    case GL_RGB10_A2:
    case GL_RGBA12:
    case GL_RGBA16:
	return GL_RGBA;
#if 1
    case GL_RGBA4:
        return GL_RGBA4;
#endif
    case GL_COLOR_INDEX1_EXT:
    case GL_COLOR_INDEX2_EXT:
    case GL_COLOR_INDEX4_EXT:
    case GL_COLOR_INDEX8_EXT:
    case GL_COLOR_INDEX12_EXT:
    case GL_COLOR_INDEX16_EXT:
	return GL_COLOR_INDEX;
    default:
	return -1;		/* error */
    }
}

/* log2 ohne numerik */
unsigned int 
log2(unsigned int f)
{
    int logVal = -1;
    while (f) {
	logVal++;
	f >>= 1;
    }
    return logVal;
}



/* Konvertierungsfunktion, von OpenGL Format in Hardwareformat,
   RGB in ARGB */
Tbool 
konvert888to8888(unsigned int **data, unsigned int *size,
		 const ACLTexImage image)
{
    unsigned int count;
    unsigned char *srcc;
    register unsigned int r, g, b, a, x;

    count = *size = image->Height * image->Width;
    srcc = (unsigned char *) image->Data;
    /* Sonst entsteht bei den Subimages ein Speicherleck. */
    if (*data == NULL) {
	*data = (unsigned int *) malloc(sizeof(unsigned int) * count);
	VAL(_MallocZ)++;
    }

    if (!(*data)) {
	MSG("konvert888to8888: malloc faild, konvert888to8888()!\n");
	return GL_FALSE;
    }
    a=255;
    for (x = 0; x < count; x++) {
	r = *srcc++;
	g = *srcc++;
	b = *srcc++;
	(*data)[x] = (a << 24) | (r << 16) | (g << 8) | b;
    }

    return GL_TRUE;
}

/* Konvertierungsfunktion, von OpenGL Format in Hardwareformat,
   RGB in ARGB + Permedia - Scallierung */
Tbool
konvert888to8888scale(unsigned int **data, unsigned int *size,
		      const ACLTexImage image)
{
    register int count, x, y, f;
    unsigned char *srcc;
    register unsigned char r, g, b, a;

    if (image->Width < 8)
	ERR("imagewidth < 8!");
    if (image->Height < 8)
	ERR("imageheight < 8!");

    f = (image->Width > 31) ? 1 : 32 / image->Width;
    count = *size = image->Height * f * image->Width * f;

    srcc = (unsigned char *) image->Data;

    /* Sonst entsteht bei den Subimages ein Speicherleck. */
    if (*data == NULL) {
	*data = (unsigned int *) malloc(sizeof(unsigned int) * count);
	VAL(_MallocZ)++;
    }

    if (!(*data)) {
	ERR("konvert888to8888scale: malloc faild in download8888toHS!\n");
 	return GL_FALSE;
    }

    a=255;
    for (y = 0; y < image->Height; y++) {
	for (x = 0; x < image->Width; x++) {
	    r = *srcc++;
	    g = *srcc++;
	    b = *srcc++;

	    if (VAL(_QuakeBlend)) {
		/* 
		   Das Blending ist eigentlich in der
		   Grundeinstellung:
		   Co = CsAs + CdAd

		   Die Karte kann nur 
		   Co = CsAs + Cd(1-Ad)

		   Quake will
		   Co = Cs0 + CdAd
		 */

		(*data)[y * (image->Width * f) + x]
		    = (255/4 << 24) | (r << 16) | (g << 8) | b;
	    } else {
		(*data)[y * (image->Width * f) + x]
		    = (a << 24) | (r << 16) | (g << 8) | b;
	    }
	}
    }

    return GL_TRUE;
}


/* Konvertierungsfunktion, von OpenGL Format in Hardwareformat,
   RGBA in ARGB */
Tbool 
konvert8888to8888(unsigned int **data, unsigned int *size,
		  const ACLTexImage image)
{
    unsigned int count, x;
    unsigned char *srcc;
    register unsigned int r, g, b, a;

    count = *size = image->Height * image->Width;
    srcc = (unsigned char *) image->Data;

    if (*data == NULL) {
	*data = (unsigned int *) malloc(sizeof(unsigned int) * count);
	VAL(_MallocZ)++;
    }

    if (!(*data)) {
	ERR("konvert888to8888: malloc faild in download888toHS!\n");
	return GL_FALSE;
    }

    for (x = 0; x < count; x++) {
	r = *srcc++;
	g = *srcc++;
	b = *srcc++;
	a = *srcc++;
	(*data)[x] = (a << 24) | (r << 16) | (g << 8) | b;
    }

    return GL_TRUE;
}

/* Konvertierungsfunktion, von OpenGL Format in Hardwareformat,
   RGBA in ARGB + Permedia - Scallierung */
Tbool
konvert8888to8888scale(unsigned int **data, unsigned int *size,
		       const ACLTexImage image)
{
    register int count, x, y, f;
    unsigned char *srcc;
    register unsigned char a, r, g, b;

    if (image->Width  < 8) ERR("imagewidth  < 8!!!!!!!");
    if (image->Height < 8) ERR("imageheight < 8!!!!!!!");

    f = (image->Width > 31) ? 1 : 32 / image->Width;
    count = *size = image->Height * f * image->Width * f;
    srcc = (unsigned char *) image->Data;

    /* Sonst entsteht bei den Subimages ein Speicherleck. */
    if (*data == NULL) {
	*data = (unsigned int *) malloc(sizeof(unsigned int) * count);
	VAL(_MallocZ)++;
    }
 
    if (!(*data)) {
	ERR("konvert8888to8888scale: malloc failed in download8888toHS!\n");
	return GL_FALSE;
    }

#if 0
    printf("konvert8888to8888scale: srcc = %x, data = %x\n", (int) srcc, (int) data);
    printf("  image->Height = %d, image->Width = %d\n", image->Height, image->Width);
	{ 
	  int i, j, k;
          printf("  image->Data = \n"); 
 	  k=0;
	  for (j=0; j < image->Height; j++)
	  {
	    for(i=1; i < image->Width*4; i+=4) 
	      {
	         printf("%3d ", srcc[k+1]);
	         k+=4;
	      }
	      printf("\n");
	  }
	  printf("\n");
	}
#endif
	
    for (y = 0; y < image->Height; y++) {
	for (x = 0; x < image->Width; x++) {
 	      r = *srcc++;
	      g = *srcc++;
	      b = *srcc++;
	      a = *srcc++;

	      if (VAL(_QuakeBlend)) {	
		(*data)[y * (image->Width * f) + x]
		    = (a << 24) | (r << 16) | (g << 8) | b;
	    } else {
		(*data)[y * (image->Width * f) + x]
		    = (a << 24) | (r << 16) | (g << 8) | b;
	    }
	}
    }

    return GL_TRUE;
}


Tbool
convert8888to4444scale(unsigned int **data, unsigned int *size,
		       const ACLTexImage image)
{
    register int count, x, y, f;
    unsigned char *srcc;
    register unsigned char a, r, g, b;

    if (image->Width < 8)
	ERR("imagewidth < 8!!!!!!!");
    if (image->Height < 8)
	ERR("imageheight < 8!!!!!!!");

    f = (image->Width > 31) ? 1 : 32 / image->Width;
    count = *size = image->Height * f * image->Width * f;
    srcc = (unsigned char *) image->Data;

    /* If data is not already allocated, allocate it. */
    if (*data == NULL) {
	*data = (unsigned int *) malloc(sizeof(unsigned int) * count);
	VAL(_MallocZ)++;
    }
 
    if (!(*data)) {
	ERR("convert8888to4444scale: malloc failed!\n");
	return GL_FALSE;
    }

#if 0
    LOG("konvert8888to4444scale: srcc = %x, data = %x\n", (int) srcc, (int) data);
    LOG("  image->Height = %d, image->Width = %d\n", image->Height, image->Width);
	{ 
	  int i;
          LOG("  image->Data = "); 
	  for(i=0; i<10; i++) LOG("%d ", image->Data[i]);
	  LOG("\n");
	}
#endif
	
    for (y = 0; y < image->Height; y++) {
	for (x = 0; x < image->Width; x++) {
	  /* Read the image data and crunch each value down to the 
	     most significant 4 bits */
	    r = *srcc++;  r = r >> 4;
	    g = *srcc++;  g = g >> 4;
	    b = *srcc++;  b = b >> 4;
	    a = *srcc++;  a = a >> 4;

	    if (VAL(_QuakeBlend)) {	
		(*data)[y * (image->Width * f) + x]
		    = (a << 12) | (r << 8) | (g << 4) | b;
	    } else {
		(*data)[y * (image->Width * f) + x]
		    = (a << 12) | (r << 8) | (g << 4) | b;
	    }
#if 0
	    r = *srcc++;  r = r >> 4;
	    g = *srcc++;  g = g >> 4;
	    b = *srcc++;  b = b >> 4;
	    a = *srcc++;  a = a >> 4;
#endif
	    if (VAL(_QuakeBlend)) {	
		(*data)[y * (image->Width * f) + x]
		   |= (a << 28) | (r << 24) | (g << 20) | (b << 16);
	    } else {
		(*data)[y * (image->Width * f) + x]
		   |= (a << 28) | (r << 24) | (g << 20) | (b << 16);
	    }
	}
    }

    return GL_TRUE;
}

Tbool
convert4444to4444scale(unsigned short **data, unsigned int *size,
		       const ACLTexImage image)
{
    register int count, x, y, f;
    unsigned char *srcc;
    register unsigned char r, g, b, a;

    if (image->Width < 8)
	ERR("imagewidth < 8!!!!!!!");
    if (image->Height < 8)
	ERR("imageheight < 8!!!!!!!");

    f = (image->Width > 31) ? 1 : 32 / image->Width;
    count = *size = image->Height * f * image->Width * f;
    srcc = (unsigned char *) image->Data;

    /* If data is not already allocated, allocate it. */
    if (*data == NULL) {
	*data = (unsigned short *) malloc(sizeof(unsigned short) * count);
	VAL(_MallocZ)++;
    }
 
    if (!(*data)) {
	ERR("convert4444to4444scale: malloc failed!\n");
	return GL_FALSE;
    }
#if 0
    LOG("konvert4444to4444scale: srcc = %x\n", *srcc);
#endif
    for (y = 0; y < image->Height; y++) {
	for (x = 0; x < image->Width; x++) {
	  /* Break up the data into four char values - extract
	     from packed data and move to lowest 4 bits of char */
	    r = *srcc++;
	    g = r;
	    r &= 0xF0; r = r >> 4;
	    g &= 0x0F;
	    b = *srcc++;
	    a = b;
	    b &= 0xF0; b = b >> 4;
	    a &= 0x0F;

	    if (VAL(_QuakeBlend)) {	
		(*data)[y * (image->Width * f) + x]
		    = (a << 12) | (r << 8) | (g << 4) | b;
	    } else {
		(*data)[y * (image->Width * f) + x]
		    = (a << 12) | (r << 8) | (g << 4) | b;
	    }
	}
    }

    return GL_TRUE;
}

#endif
