
/*
 * [take a look at tracker.h file for more informations]
 *
 * Author: Simon Pogarcic (sim@suse.de)
 */


#include <sys/time.h>
#include <string.h>
#include <stdio.h>

#include "tracker.h"

#ifndef TRACKER_MAXFUNC
#define TRACKER_MAXFUNC		100
#endif

#ifndef TRACKER_TEXTLEN
#define TRACKER_TEXTLEN		80
#endif

#ifndef TRACKER_INTERVAL
#define TRACKER_INTERVAL	3
#endif

#ifndef TRACKER_STARTSLOT
#define TRACKER_STARTSLOT	0
#endif

#ifndef TRACKER_ENDSLOT
#define TRACKER_ENDSLOT		TRACKER_MAXFUNC
#endif



#define TRACKERCode(pref)\
\
static int TrackBeginSlot = 0;\
static int TrackEndSlot = TRACKER_ENDSLOT;\
static int TrackInterval = TRACKER_INTERVAL;\
\
static long int TrackFCStart;\
static int Tinited = 0;\
static int Tper;\
\
static struct tdebug {\
    char *fname;\
    char text[TRACKER_TEXTLEN];\
    unsigned int fcount;\
} FuncSlots[TRACKER_MAXFUNC];\
\
\
\
void pref ## _track_init( int per )\
{\
    int cnt;\
\
    TrackFCStart = 0;\
    TrackInterval = per;\
\
    for (cnt = TrackBeginSlot; cnt < TrackEndSlot; cnt++)\
    {\
	FuncSlots[cnt].fname = NULL;\
	FuncSlots[cnt].fcount = 0;\
    }\
\
    Tinited = 1;\
\
    return;\
}\
\
\
\
void pref ## _track_print ( char *msg )\
{\
    int cnt;\
\
    fprintf(stderr,\
	"\n=== %i sec ===================================================================\n", Tper);\
\
    for (cnt = TrackEndSlot; cnt >= TrackBeginSlot; cnt--)\
	if ( FuncSlots[cnt].fcount )\
	{\
	    fprintf(stderr,"%s[%u CALLS]: %s", msg, FuncSlots[cnt].fcount,\
		FuncSlots[cnt].fname );\
	    FuncSlots[cnt].fcount = 0;\
	}\
\
    fprintf(stderr,"\n");\
\
    if (!Tper)\
	TrackFCStart = 0;\
\
    return;\
}\
\
\
\
/*\
 * Interval countdown starts from first call to one of functions being debuged.\
 */\
void pref ## _track_register( unsigned int slot, char * msg, char * text )\
{\
    struct timeval curr_time;\
    int tof=0;\
\
    if (!Tinited)\
	pref ## _track_init(TRACKER_INTERVAL);\
\
    if ( slot >= TRACKER_ENDSLOT || (tof = (slot < TRACKER_STARTSLOT)) )\
    {\
	fprintf(stderr,"< TRACKER ERROR > Slot %u out of boundaries!\n", slot);\
	if (tof) fprintf(stderr,\
		"                  Try to redefine TRACKER_STARTSLOT !!!\n");\
	else fprintf(stderr,\
		"                  Try to redefine TRACKER_ENDSLOT !!!\n");\
	return;\
    }\
\
    FuncSlots[slot].fcount++;\
\
    if ( ! FuncSlots[slot].fname )\
    {\
	strncpy( FuncSlots[slot].text, text, TRACKER_TEXTLEN-1 );\
	FuncSlots[slot].fname = FuncSlots[slot].text;\
	(FuncSlots[slot].text)[TRACKER_TEXTLEN-1] = 0;\
    }\
\
    gettimeofday( &curr_time, NULL );\
\
    if ( (Tper = curr_time.tv_sec - TrackFCStart) >= TrackInterval )\
    {\
	if ( ! TrackFCStart )\
	{\
	    TrackFCStart = curr_time.tv_sec;\
	    return;\
	}\
\
	pref ## _track_print( msg );\
\
	TrackFCStart = curr_time.tv_sec;\
    }\
\
    return;\
}\
\
\
\
void pref ## _tracker_dummy( void )\
{\
    return;\
}


/**************************************************************/
/* PUT SOME OTHER PREFIX HERE IF YOU GOT DOUBLE SYMBOL ERROR! */
/**************************************************************/
TRACKERCode( mesa )


