/*
 * -*- mode: C; tab-width:8;  -*-
 * 
 * aclDDTex.c - Mesa device driver functions for texture mapping
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#if defined(ACL)



#include "aclDrv.h"


/************************************************************************/
/*************************** Texture Mapping ****************************/
/************************************************************************/

void aclDDTexBind(GLcontext * ctx, GLenum target, struct gl_texture_object *tObj)
{
    ACLContext aclMesa = (ACLContext) ctx->DriverCtx;

    if (!tObj->DriverData)
	tObj->DriverData =
	    aclMesa->mod->Tex->AllocTexObjData(aclMesa);

    aclMesa->mod->Tex->Bind(aclMesa, tObj->Name, tObj->DriverData);
}

void aclDDTexEnv(GLcontext * ctx, GLenum pname, const GLfloat * params)
{
    ACLContext aclMesa = (ACLContext) ctx->DriverCtx;
    ACLTexMod texmod = aclMesa->mod->Tex;

    texmod->Env(aclMesa, pname, params);
}

void aclDDTexParam(GLcontext * ctx, GLenum target, struct gl_texture_object *tObj,
		   GLenum pname, const GLfloat * params)
{
    ACLContext aclMesa = (ACLContext) ctx->DriverCtx;
    ACLTexMod texmod = aclMesa->mod->Tex;

    if (!tObj->DriverData)
	tObj->DriverData = texmod->AllocTexObjData(aclMesa);

    texmod->Param(aclMesa, target, pname, params, tObj->DriverData);    
}


void aclDDTexDel(GLcontext * ctx, struct gl_texture_object *tObj)
{
    ACLContext aclMesa = (ACLContext) ctx->DriverCtx;
    ACLTexMod texmod = aclMesa->mod->Tex;

    if (tObj->DriverData)
	tObj->DriverData = texmod->TexDel(aclMesa, tObj->DriverData);
}

void aclDDTexSubImage(GLcontext * ctx, GLenum target,
		    struct gl_texture_object *tObj, GLint level,
		 GLint xoffset, GLint yoffset, GLint width, GLint height,
	      GLint internalFormat, const struct gl_texture_image *image)
{
    ACLContext aclMesa = (ACLContext) ctx->DriverCtx;
    ACLTexMod texmod = aclMesa->mod->Tex;

    if (!tObj->DriverData)
	tObj->DriverData = texmod->AllocTexObjData(aclMesa);

    texmod->SubImage(aclMesa, target, tObj->DriverData, level,
		     xoffset, yoffset, width, height, internalFormat,
		     (const ACLTexImage) image);
}

void aclDDUpdateTexturePalette(GLcontext * ctx, struct gl_texture_object *tObj)
{
    ACLContext aclMesa = (ACLContext) ctx->DriverCtx;
    ACLTexMod texmod = aclMesa->mod->Tex;

    if (tObj) {
	if (!tObj->DriverData)
	    tObj->DriverData = texmod->AllocTexObjData(aclMesa);
MSG("aclDDTexturePalette state=0!\n");
	texmod->Palette(aclMesa, tObj->PaletteSize, (unsigned int *) tObj->Palette,
			tObj->DriverData);
    } else {
	if (ctx->Texture.PaletteSize) {
	    texmod->DownloadGlobalPalette(aclMesa, ctx->Texture.PaletteSize,
				   (unsigned int *) ctx->Texture.Palette,
					  NULL);
	}
    }
}

void aclDDUseGlobalTexturePalette(GLcontext * ctx, GLboolean state)
{
    ACLContext aclMesa = (ACLContext) ctx->DriverCtx;
    ACLTexMod texmod = aclMesa->mod->Tex;

    if (state) {
	texmod->SwitchToGlobalPalette(aclMesa);
MSG("aclDDTexturePalette SwitchToGlobalPalette!\n");
    } else {
MSG("aclDDUseGlobalTexturePalette state=0!\n");
	if (ctx->Texture.Set[0].Current) {
	    struct gl_texture_object *tObj = ctx->Texture.Set[0].Current;

	    if (!tObj->DriverData)
		tObj->DriverData = texmod->AllocTexObjData(aclMesa);

	    texmod->DownloadGlobalPalette(aclMesa, tObj->PaletteSize,
					  (unsigned int *) tObj->Palette,
					  tObj->DriverData);
	}
    }
}

/**********************************************************************/
/*****                  Setup texture mapping                     *****/
/**********************************************************************/

void aclDDTexImg(GLcontext * ctx, GLenum target,
       struct gl_texture_object *tObj, GLint level, GLint internalFormat,
		 const struct gl_texture_image *image)
{
    ACLContext aclMesa = (ACLContext) ctx->DriverCtx;
    ACLTexMod texmod = aclMesa->mod->Tex;


    if (!tObj->DriverData)
	tObj->DriverData = texmod->AllocTexObjData(aclMesa);

    if (texmod->TranslateImage(aclMesa, (const ACLTexImage) image,
			       level, internalFormat, tObj->Name, 
			       tObj->DriverData)) {
	texmod->DownloadToTexMem(aclMesa, level, tObj->DriverData);
    } else {
	ERR("TranslateImage: not supported imageformat can't download!\n");
    }
}


/**********************************************************************/
/***** Initialize the Mesa DD function table for texture mapping  *****/
/**********************************************************************/

void aclSetupDDTexPointers(GLcontext * ctx)
{
TOFF
    ctx->Driver.TexEnv = aclDDTexEnv;
    ctx->Driver.TexImage = aclDDTexImg;
    ctx->Driver.TexParameter = aclDDTexParam;
    ctx->Driver.BindTexture = aclDDTexBind;
    ctx->Driver.DeleteTexture = aclDDTexDel; 
    ctx->Driver.TexSubImage = NULL;
    ctx->Driver.UpdateTexturePalette = aclDDUpdateTexturePalette;
    ctx->Driver.UseGlobalTexturePalette = aclDDUseGlobalTexturePalette;
}


#else

/*
 * Need this to provide at least one external definition.
 */

int gl_acl_dummy_function_ddtex(void)
{
    return 0;
}

#endif				/* ACL */
