
#ifndef _GLINTMACROS_H_
#define _GLINTMACROS_H_



#define TXLBSize(v)		(1024*1024*((1 << ((v>>24) & 7)) & 127))
#define TXFBSize(v)		(1024*1024*((1 << ((v>>29) & 7)) & 127))
#define TXFBEDO_DRAM(v)		((v>>22) & 1)
#define PMFBSize(v)		(1024*2048*(((v>>29) & 3) + 1))



#define REG_READ(r) \
	( *(unsigned int *)((char*)MMIOBASE+r) )

#ifdef RDEBUG
  #define REG_WRITE(v,r) \
  { \
  	*(unsigned int*)((char*)MMIOBASE+r)=v; \
  	printf("Write Register: 0x%x\n", v); \
  }
  
  #define REG_CWRITE(v,r) \
  { \
  	*(unsigned int*)((char*)MMIOBASE+r)=*((unsigned int*)&v); \
  	printf("Write (unsigned int) Register: 0x%x\n", v); \
  }
  
  #define REG_WRITE_SLOW(v,r) \
  { \
  	while( ! REG_READ(InFIFOSpace) ); \
  	*(unsigned int*)((char*)MMIOBASE+r)=v; \
  	printf("SINGLE Wait/Write Register: 0x%x\n", v); \
  }
  
  #define REG_READ_INTO(v,r) \
  { \
  	v=*(unsigned int *)((char*)MMIOBASE+r); \
  	printf("Read Register: Ox%x\n", v); \
  }
  
  #ifdef PCI_DISCONNECT
    #define WAIT_FIFO(v)
  #else
    #define WAIT_FIFO(v) \
    { \
    	  int space; \
  	  printf("\n ******** WAITING FOR %d in FIFO...\n", v); \
  	  while( (space = REG_READ(InFIFOSpace)) < v) \
  	      printf(" ------> InFIFOSpace = %d\n", space); \
    }
  #endif
  
#else

  #define REG_WRITE(v,r) \
  { \
  	*(unsigned int*)((char*)MMIOBASE+r)=v; \
  }
  
  #define REG_CWRITE(v,r) \
  { \
  	*(unsigned int*)((char*)MMIOBASE+r)=*((unsigned int*)&v); \
  }
  
  #define REG_WRITE_SLOW(v,r) \
  { \
  	while( ! REG_READ(InFIFOSpace) ); \
  	*(unsigned int*)((char*)MMIOBASE+r)=v; \
  }
  
  #define REG_READ_INTO(v,r) \
  { \
  	v=*(unsigned int *)((char*)MMIOBASE+r); \
  }
  
  #ifdef PCI_DISCONNECT
    #define WAIT_FIFO(v)
  #else
    #define WAIT_FIFO(v) \
    { \
  	while( REG_READ(InFIFOSpace) < v); \
    }
  #endif
  
#endif /* RDEBUG */



#endif /* _GLINTMACROS_H_ */

