/****************************************************************************
** Interface to the GUI.
**
**   Created : Mon July 4 22:48:00 20059
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
****************************************************************************/

#ifndef DIALOGOVERLAY_H
#define DIALOGOVERLAY_H

#include <qlabel.h>
#include <qiconview.h>

// the designer created GUI.
#include "uidialogoverlay.h"
#include "rgba.h"

class QScrollView;

class MenuObject;
class ImageObject;
class OverlayObject;

class DialogOverlay : public uiDialogOverlay
{
  Q_OBJECT

  class Preview : public QLabel
  {
    public:
      Preview ( DialogOverlay *, QWidget *p=NULL, const char *n=NULL, WFlags f=0 );
      virtual ~Preview ( );

    protected:
      void mouseReleaseEvent     ( QMouseEvent * );
      void mouseMoveEvent        ( QMouseEvent * );
      void mousePressEvent       ( QMouseEvent * );

      DialogOverlay *m_pDialog;
      QPoint         m_currentPos;
      int            m_iButton;
  };

protected:
    class Item : public QIconViewItem  {
    public:
      Item ( QIconView *, const QPixmap & );

    protected:
      virtual void calcRect ( const QString &s=QString::null );

    private:
      void refreshIcon ( );

    private:
      QPixmap m_pixmap;
    };

public:

           DialogOverlay ( QWidget *p=0, const char *n=0, bool m=false, WFlags fl=0 );
  virtual ~DialogOverlay ( );

  void initMe ( MenuObject *, QPixmap * );

protected:
  void drawOverlay ( );
  bool isChecked   ( QString & );
  void moveBy      ( int,  int );
  void zoomBy      ( int,  int );
  void shearBy     ( int,  int );
  void rotateBy    (       int );

protected slots:
  virtual void accept             ( );
  virtual void reject             ( );
  virtual void slotReset          ( );
  virtual void slotNoOverlay      ( );
  virtual void slotAnimation      ( );
  virtual void slotInitLibrary    ( );
  virtual void slotSliderPressed  ( );
  virtual void slotSliderReleased ( );
  virtual void slotRotate     ( int );
  virtual void slotShearX     ( int );
  virtual void slotShearY     ( int );
  virtual void slotScaleX     ( int );
  virtual void slotScaleY     ( int );
  virtual void slotOffsetX    ( int );
  virtual void slotOffsetY    ( int );
  virtual void slotRed        ( int );
  virtual void slotGreen      ( int );
  virtual void slotBlue       ( int );
  virtual void slotAlpha      ( int );
  virtual void slotClicked    ( int, QIconViewItem *, const QPoint & );

private:
  void keepStaticVariables ( );
  void setStaticVariables  ( );
  void setValues           ( );
  void setColor   ( Rgba   & );
  void setOffset  ( int, int );
  void setRotate  ( float    );
  void setScale ( float, float );
  void setShear ( float, float );

private:
  QPixmap       *m_pBackground;
  int            m_iThumbSize;
  QStringList    m_listEnabled;
  OverlayObject *m_pOverlay;
  OverlayObject *m_pOrigOverlay; // stores the original shadow in case we click cancel.
  MenuObject    *m_pMenuObject;
  ImageObject   *m_pNoOverlayObject;
  Preview       *m_pPreview;
  QScrollView   *m_pScrollView;

  bool m_bStoredActiveState; // the object is to be drawn in normal state.
  static Rgba m_keepColor;

  friend class Preview;
};

#endif // DIALOGOVERLAY_H

