/****************************************************************************
** DialogFrame class
**
**   Created : Tue Feb 18 22:48:00 2004
**        by : Varol Okan using Kate
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/
#include <qradiobutton.h>
#include <qcolordialog.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qgroupbox.h>
#include <qspinbox.h>
#include <qpainter.h>
#include <qtimer.h>
#include <qlabel.h>
#include <qpen.h>

#include "global.h"
#include "dialogframe.h"

DialogFrame::DialogFrame(QWidget *parent, const char *name, WFlags f )
	: uiDialogFrame (parent, name, f )
{
  m_pOrigFrame  = NULL;
  m_iFrameWidth = 4;
  m_iFrameStyle = Qt::SolidLine;
  m_iFrameJoin  = Qt::MiterJoin;
  m_colorFrame  = Rgba ( START_FRAME_COLOR );
}

DialogFrame::~DialogFrame()
{
}

void DialogFrame::initMe( int iStyle, int iWidth, int iJoin, Rgba rgb )
{
  m_pFrameSelect->hide    ( );
  m_pGroupGeometry->hide  ( );
  m_pGroupAnimation->hide ( );
  m_pGroupGeometry->setEnabled ( FALSE );

  m_pFrameColor->setPaletteBackgroundColor ( rgb.color ( ) );
  m_colorFrame  = rgb;
  m_iFrameWidth = iWidth;
  m_iFrameStyle = iStyle;
  m_iFrameJoin  = iJoin;

  initMe ( );
}

void DialogFrame::initMe ( FrameObject *pFrame )
{
  // Here we continue with the standard initialization.
  m_pFrameColor->setPaletteBackgroundColor ( pFrame->color ( ).color ( ) );
  m_colorFrame  = pFrame->color ( );
  m_iFrameWidth = pFrame->width ( );
  m_qsAnimation = pFrame->animation ( );
  m_pOrigFrame  = pFrame;

  m_pEditX->setText     (QString ("%1").arg(pFrame->rect().x()));
  m_pEditY->setText     (QString ("%1").arg(pFrame->rect().y()));
  m_pEditWidth->setText (QString ("%1").arg(pFrame->rect().width()));
  m_pEditHeight->setText(QString ("%1").arg(pFrame->rect().height()));

  initMe ( );
}

void DialogFrame::initMe ( )
{
  m_pComboStyle->insertItem ( QString ("SolidLine"      ) );
  m_pComboStyle->insertItem ( QString ("DashLine"       ) );
  m_pComboStyle->insertItem ( QString ("DashDotLine"    ) );
  m_pComboStyle->insertItem ( QString ("DashDotDotLine" ) );
	
  m_pComboJoin->insertItem  ( QString ("MiterJoin") );
  m_pComboJoin->insertItem  ( QString ("BevelJoin") );
  m_pComboJoin->insertItem  ( QString ("RoundJoin") );
  
  connect ( m_pButtonAnimation,SIGNAL ( clicked ( ) ), this, SLOT ( slotAnimation ( ) ) );
  connect ( m_pButtonColor,    SIGNAL ( clicked ( ) ), this, SLOT ( slotColor     ( ) ) );
  connect ( m_pButtonImage,    SIGNAL ( clicked ( ) ), this, SLOT ( slotImage     ( ) ) );
  connect ( m_pButtonPicture,  SIGNAL ( clicked ( ) ), this, SLOT ( slotPicture   ( ) ) );
  connect ( m_pRadioImage,     SIGNAL ( toggled(bool)),this, SLOT ( slotImage     ( bool ) ) );
  connect ( m_pRadioPicture,   SIGNAL ( toggled(bool)),this, SLOT ( slotPicture   ( bool ) ) );
  connect ( m_pSpinBoxWidth,   SIGNAL ( valueChanged(int)), this, SLOT(slotWidth  ( int  ) ) );
  connect ( m_pComboStyle,     SIGNAL ( highlighted (int)), this, SLOT(slotStyle  ( int  ) ) );
  connect ( m_pComboJoin,      SIGNAL ( highlighted (int)), this, SLOT(slotJoin   ( int  ) ) );
}

void DialogFrame::polish ( )
{
  uiDialogFrame::polish ( );
  //resize ( 250, 250 );
  //drawPreview ( );

  QTimer::singleShot ( 50, this, SLOT ( slotRefresh ( ) ) );
}

void DialogFrame::slotRefresh ( )
{
  //  resize ( 250, 250 );
  drawPreview ( );
}

void DialogFrame::slotColor ()
{
  bool bOkay;
//  Rgba transparentColor = Rgba ( TRANSPARENT_COLOR );
//  QRgb rgbColor = QColorDialog::getRgba ( transparentColor.rgb ( ), &bOkay, this );
  QRgb rgbColor = QColorDialog::getRgba ( m_colorFrame.rgb ( ), &bOkay, this );
  if ( ! bOkay )
    return;

  Rgba newColor ( rgbColor );
  m_pFrameColor->setPaletteBackgroundColor ( newColor.color ( ) );
  m_colorFrame = newColor;
  drawPreview ( );
}

void DialogFrame::slotImage()
{

}

void DialogFrame::slotPicture()
{

}

void DialogFrame::slotImage(bool)
{

}

void DialogFrame::slotPicture (bool)
{

}

void DialogFrame::slotAnimation ( )
{
  if ( m_pOrigFrame )
       m_pOrigFrame->animationDialog ( m_qsAnimation, DialogAnimation::TypeFrame );
}

QString &DialogFrame::animation ( )
{
  return m_qsAnimation;
}

void DialogFrame::slotWidth(int iNewValue)
{
	m_iFrameWidth = iNewValue;
	drawPreview();
}

void DialogFrame::slotJoin(int iNewValue)
{
	switch (iNewValue)	{
	case 1:
		m_iFrameJoin = Qt::BevelJoin;
	break;
	case 2:
		m_iFrameJoin = Qt::RoundJoin;
	break;
	default:
		m_iFrameJoin = Qt::MiterJoin;
	}
	drawPreview();
}

void DialogFrame::slotStyle(int iNewValue)
{
	switch (iNewValue)	{
	case 1:
		m_iFrameStyle = Qt::DashLine;
	break;
	case 2:
		m_iFrameStyle = Qt::DashDotLine;
	break;
	case 3:
		m_iFrameStyle = Qt::DashDotDotLine;
	break;
	default:
		m_iFrameStyle = Qt::SolidLine;
	}
	drawPreview();
}

void DialogFrame::drawPreview()
{
  //m_pPreview => QFrame
  QPainter thePainter (m_pPreview);
  QPen thePen ( color ( ).color ( ), frameWidth(), (Qt::PenStyle)style(), Qt::FlatCap, (Qt::PenJoinStyle)join());
  thePainter.setPen (thePen);
  thePainter.setBrush(Qt::NoBrush);
  m_pPreview->repaint();
  //m_pPreview->update();
	
  // Note: the drawing range is 32 pixels
  QRect theRect (16, 16, m_pPreview->width()-32, m_pPreview->height()-32);
  thePainter.drawRect (theRect);	
}

void DialogFrame::paintEvent (QPaintEvent *)
{
  // uiDialogFrame::paintEvent(pPainter);
  drawPreview ();
}

Rgba DialogFrame::color()
{
  return m_colorFrame;
}

int DialogFrame::style()
{
  return m_iFrameStyle;
}

int DialogFrame::join()
{
  return m_iFrameJoin;
}

int DialogFrame::frameWidth()
{
  return m_iFrameWidth;
}

