/****************************************************************************
** Class Previewer
**
**   Created : Tue Jun 3 09:13:25 2008
**        by : Varol Okan, using Kate
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** Previewer for the DialogFiles / DialogImages - classes
**
****************************************************************************/

#ifndef PREVIEWER_H
#define PREVIEWER_H

#include "cachethumbs.h"
#include "uipreviewer.h"

class QTimer;
class QIconView;
class QIconViewItem;

class MediaInterface;

namespace Input
{

class Previewer : public uiPreviewer
{  // Class to overlay on top of the QIconVIew
   //  to give a preview of the Image / Video
  Q_OBJECT
public:
   Previewer ( QWidget *, QIconView * );
  ~Previewer ( );

  // Sets the item to be displayed in more detail.
  void setItem ( Cache::Thumbs::Entry *, QIconViewItem * );
  void setItem ( QIconViewItem * );
  void clear   ( );

protected slots:
  virtual void slotFirst ( );
  virtual void slotLast  ( );
  virtual void slotNext  ( );
  virtual void slotPrev  ( );
  virtual void slotPlay  ( );
  virtual void slotStop  ( );
  virtual void slotLoadWholeImage ( );
  virtual void slotShowImageInfo  ( );
  virtual void slotAutoPlay       ( );
  virtual void slotResizeM        ( );

protected:
  virtual void mouseReleaseEvent  ( QMouseEvent * );

  void setButtonState ( );
  bool isImage        ( QString & );
  void setMovieFrame  ( );
  void stop           ( );

private:
  bool            m_bImageItem;
  bool            m_bPaused;
  QWMatrix       *m_pMatrix;
  QIconView      *m_pIconView;
  QString         m_qsFileName;
  QIconViewItem  *m_pCurrentItem;
  QTimer         *m_pTimerAutoPlay;
  MediaInterface *m_pMediaInterface;
  QValueList<QPixmap *> m_listOfThumbs;
  int m_iCurrentPix;
};

};  // End of namespace Input

#endif // DIALOGALIGN_H
