/*****************************************************************************
 ** Class Import::Srt
 **
 ** This class handles the import filter for srt (subtitle) files
 **
 **   Created : 
 **        by : Varol Okan using kate editor
 ** Copyright : (c) Varol Okan
 **   License : GPL v 2.0
 **
 ** 2
 ** 00:00:27,480 --> 00:00:31,480
 ** Une production SAMULI TORSSONEN
 ** (adaptée de STAR TREK & BABYLON 5)
 **
 ** 3
 ** 00:00:42,400 --> 00:00:45,880
 ** Un film de TIMO VUORENSOLA
 ** SOUS-TITRAGE & TRADUCTION : Fred CORNEC
 **
 **
 ** Lines 3 onward are the text of the subtitle. New lines are indicated by new lines (i.e. there's no "\n" code). The only formatting accepted are the following:
 **
 ** <b>text</b>: put text in boldface
 ** <i>text</i>: put text in italics
 ** <u>text</u>: underline text
 ** <font color="#00ff00">text</font>: apply green color formatting to the text (you can use the font tag only to change color)
 **
 *****************************************************************************/

#ifndef __IMPORT_SRT_H__
#define __IMPORT_SRT_H__

#include "sourcefileentry.h"

namespace Import
{

class BaseSubtitle
{
  public:
             BaseSubtitle ( );
    virtual ~BaseSubtitle ( );

    virtual bool readFile ( QString & ) = 0;
    virtual QValueList<Subtitles::entry *> takeSubtitles ( ) = 0;
    virtual QValueList<Subtitles::entry *> &getSubtitles ( ) = 0;
    QString getFileName ( );

  protected:
    QValueList<Subtitles::entry *> m_listOfEntries;
    QString m_qsFileName;
};

class Srt : public BaseSubtitle
{
public:

public:
           Srt ( );
  virtual ~Srt ( );

  virtual bool readFile ( QString & );
  virtual QValueList<Subtitles::entry *> takeSubtitles ( );
  virtual QValueList<Subtitles::entry *> &getSubtitles ( );

  bool    import      ( );
  QString readEntry   ( QTextStream *, Subtitles::entry * );

private:
  bool    isTimeStamp  ( QString &       );
  QString getTimeRange ( QString &, bool );
  long    getTimeFromString ( QString &  );
};

}

#endif // __IMPORT_SRT_H__
