/****************************************************************************
** Class DialogUndoStack
**
**   Created : Tue Dec 21 09:13:25 2004
**        by : The User Interface Compiler ($Id: dialogundostack.h,v 1.68 2009/08/01 13:23:20 qdvdauthor Exp $)
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class will display the undo-stack of the current DVDMenu.
** It will also group together all consecutive changes to one object
** in the tree-view, so that the user can undo the whole batch of changes 
** applied to one object at once.
**
****************************************************************************/

#ifndef DIALOGUNDOSTACK_H
#define DIALOGUNDOSTACK_H

#include <qlistview.h>
#include <qvariant.h>
#include <qdialog.h>

#define MAX_TREE_SIZE 51

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QPushButton;
class QListView;
class QListViewItem;

class UndoBuffer;
class UndoObject;
class DVDMenu;


class DialogUndoStack : public QDialog
{
  Q_OBJECT

  class Item : public QListViewItem  {
    public:
      Item ( QListView *, int, bool, QString, QString s=QString::null );
      Item ( QListViewItem *, int, bool, QString, QString s=QString::null );
      virtual ~Item ( );
      virtual void paintCell ( QPainter *, const QColorGroup &, int, int, int );

      int  counter   ( );
      bool alternate ( );
      static bool m_bStartAdjust;
    private:
      bool m_bAlternateColor;
      int  m_iCounter;
  };

public:
   DialogUndoStack ( UndoBuffer *, QWidget* p=0, const char* n=0, bool m=FALSE, WFlags fl=0 );
  ~DialogUndoStack ( );

   void buildUndoTree ( );
   void setUndoBuffer ( UndoBuffer * );

protected slots:
  virtual void languageChange ( );
  virtual void slotClickedOnList ( QListViewItem *, const QPoint &, int );
  virtual void slotUndo ( );
  virtual void slotRedo ( );

private:
  void appendUndoStep ( UndoObject *, UndoObject *, int );
  bool startAlternate ( );

protected:
    QPushButton* buttonHelp;
    QPushButton* buttonOk;
    QPushButton* buttonCancel;
    QListView* m_pListViewUndo;
    QGridLayout* DialogUndoStackLayout;
    QHBoxLayout* Layout1;
    QSpacerItem* Horizontal_Spacing2;

private:  // private member varaibles.
  UndoBuffer    *m_pUndoBuffer;
  int            m_iCounter;
  QListViewItem *m_pBaseItem;
  bool           m_bAlternate;
};

#endif // DIALOGUNDOSTACK_H
