<?php
/**
 * Define the messages structure in the messages file, for an automated rewriting.
 *
 * @file
 * @ingroup MaintenanceLanguage
 */

/** The structure of the messages, divided to blocks */
$wgMessageStructure = array(
	'sidebar' => array(
		'sidebar',
	),
	'toggles' => array(
		'tog-underline',
		'tog-highlightbroken',
		'tog-justify',
		'tog-hideminor',
		'tog-hidepatrolled',
		'tog-newpageshidepatrolled',
		'tog-extendwatchlist',
		'tog-usenewrc',
		'tog-numberheadings',
		'tog-showtoolbar',
		'tog-editondblclick',
		'tog-editsection',
		'tog-editsectiononrightclick',
		'tog-showtoc',
		'tog-rememberpassword',
		'tog-editwidth',
		'tog-watchcreations',
		'tog-watchdefault',
		'tog-watchmoves',
		'tog-watchdeletion',
		'tog-minordefault',
		'tog-previewontop',
		'tog-previewonfirst',
		'tog-nocache',
		'tog-enotifwatchlistpages',
		'tog-enotifusertalkpages',
		'tog-enotifminoredits',
		'tog-enotifrevealaddr',
		'tog-shownumberswatching',
		'tog-oldsig',
		'tog-fancysig',
		'tog-externaleditor',
		'tog-externaldiff',
		'tog-showjumplinks',
		'tog-uselivepreview',
		'tog-forceeditsummary',
		'tog-watchlisthideown',
		'tog-watchlisthidebots',
		'tog-watchlisthideminor',
		'tog-watchlisthideliu',
		'tog-watchlisthideanons',
		'tog-watchlisthidepatrolled',
		'tog-nolangconversion',
		'tog-ccmeonemails',
		'tog-diffonly',
		'tog-showhiddencats',
		'tog-noconvertlink',
		'tog-norollbackdiff',
	),
	'underline' => array(
		'underline-always',
		'underline-never',
		'underline-default',
	),
	'editfont' => array(
		'editfont-style',
		'editfont-default',
		'editfont-monospace',
		'editfont-sansserif',
		'editfont-serif',
	),
	'dates' => array(
		'sunday',
		'monday',
		'tuesday',
		'wednesday',
		'thursday',
		'friday',
		'saturday',
		'sun',
		'mon',
		'tue',
		'wed',
		'thu',
		'fri',
		'sat',
		'january',
		'february',
		'march',
		'april',
		'may_long',
		'june',
		'july',
		'august',
		'september',
		'october',
		'november',
		'december',
		'january-gen',
		'february-gen',
		'march-gen',
		'april-gen',
		'may-gen',
		'june-gen',
		'july-gen',
		'august-gen',
		'september-gen',
		'october-gen',
		'november-gen',
		'december-gen',
		'jan',
		'feb',
		'mar',
		'apr',
		'may',
		'jun',
		'jul',
		'aug',
		'sep',
		'oct',
		'nov',
		'dec',
	),
	'categorypages' => array(
		'pagecategories',
		'pagecategorieslink',
		'category_header',
		'subcategories',
		'category-media-header',
		'category-empty',
		'hidden-categories',
		'hidden-category-category',
		'category-subcat-count',
		'category-subcat-count-limited',
		'category-article-count',
		'category-article-count-limited',
		'category-file-count',
		'category-file-count-limited',
		'listingcontinuesabbrev',
		'index-category',
		'noindex-category',
	),
	'mainpage' => array(
		'linkprefix',
		'mainpagetext',
		'mainpagedocfooter',
	),
	'miscellaneous1' => array(
		'about',
		'article',
		'newwindow',
		'cancel',
		'moredotdotdot',
		'mypage',
		'mytalk',
		'anontalk',
		'navigation',
		'and',
	),
	'cologneblue' => array(
		'qbfind',
		'qbbrowse',
		'qbedit',
		'qbpageoptions',
		'qbpageinfo',
		'qbmyoptions',
		'qbspecialpages',
		'faq',
		'faqpage',
		'sitetitle',
		'sitesubtitle',
	),
	'vector' => array(
		'vector-action-addsection',
		'vector-action-delete',
		'vector-action-move',
		'vector-action-protect',
		'vector-action-undelete',
		'vector-action-unprotect',
		'vector-namespace-category',
		'vector-namespace-help',
		'vector-namespace-image',
		'vector-namespace-main',
		'vector-namespace-media',
		'vector-namespace-mediawiki',
		'vector-namespace-project',
		'vector-namespace-special',
		'vector-namespace-talk',
		'vector-namespace-template',
		'vector-namespace-user',
		'vector-view-create',
		'vector-view-edit',
		'vector-view-history',
		'vector-view-view',
		'vector-view-viewsource',
		'actions',
		'namespaces',
		'variants',
	),
	'miscellaneous2' => array(
		'errorpagetitle',
		'returnto',
		'tagline',
		'help',
		'search',
		'searchbutton',
		'go',
		'searcharticle',
		'history',
		'history_short',
		'updatedmarker',
		'info_short',
		'printableversion',
		'permalink',
		'print',
		'edit',
		'create',
		'editthispage',
		'create-this-page',
		'delete',
		'deletethispage',
		'undelete_short',
		'protect',
		'protect_change',
		'protectthispage',
		'unprotect',
		'unprotectthispage',
		'newpage',
		'talkpage',
		'talkpagelinktext',
		'specialpage',
		'personaltools',
		'postcomment',
		'addsection',
		'articlepage',
		'talk',
		'views',
		'toolbox',
		'userpage',
		'projectpage',
		'imagepage',
		'mediawikipage',
		'templatepage',
		'viewhelppage',
		'categorypage',
		'viewtalkpage',
		'otherlanguages',
		'redirectedfrom',
		'redirectpagesub',
		'talkpageheader',
		'lastmodifiedat',
		'viewcount',
		'protectedpage',
		'jumpto',
		'jumptonavigation',
		'jumptosearch',
		'view-pool-error',
	),
	'links' => array(
		'aboutsite',
		'aboutpage',
		'copyright',
		'copyrightpage',
		'currentevents',
		'currentevents-url',
		'disclaimers',
		'disclaimerpage',
		'edithelp',
		'edithelppage',
		'help',
		'helppage',
		'mainpage',
		'mainpage-description',
		'policy-url',
		'portal',
		'portal-url',
		'privacy',
		'privacypage',
	),
	'badaccess' => array(
		'badaccess',
		'badaccess-group0',
		'badaccess-groups',
	),
	'versionrequired' => array(
		'versionrequired',
		'versionrequiredtext',
	),
	'miscellaneous3' => array(
		'ok',
		'pagetitle',
		'pagetitle-view-mainpage',
		'retrievedfrom',
		'youhavenewmessages',
		'newmessageslink',
		'newmessagesdifflink',
		'youhavenewmessagesmulti',
		'newtalkseparator',
		'editsection',
		'editsection-brackets',
		'editold',
		'viewsourceold',
		'editlink',
		'viewsourcelink',
		'editsectionhint',
		'toc',
		'showtoc',
		'hidetoc',
		'thisisdeleted',
		'viewdeleted',
		'restorelink',
		'feedlinks',
		'feed-invalid',
		'feed-unavailable',
		'site-rss-feed',
		'site-atom-feed',
		'page-rss-feed',
		'page-atom-feed',
		'feed-atom',
		'feed-rss',
		'sitenotice',
		'anonnotice',
		'newsectionheaderdefaultlevel',
		'red-link-title',
	),
	'nstab' => array(
		'nstab-main',
		'nstab-user',
		'nstab-media',
		'nstab-special',
		'nstab-project',
		'nstab-image',
		'nstab-mediawiki',
		'nstab-template',
		'nstab-help',
		'nstab-category',
	),
	'main' => array(
		'nosuchaction',
		'nosuchactiontext',
		'nosuchspecialpage',
		'nospecialpagetext',
	),
	'errors' => array(
		'error',
		'databaseerror',
		'dberrortext',
		'dberrortextcl',
		'laggedslavemode',
		'readonly',
		'enterlockreason',
		'readonlytext',
		'missing-article',
		'missingarticle-rev',
		'missingarticle-diff',
		'readonly_lag',
		'internalerror',
		'internalerror_info',
		'fileappenderrorread',
		'fileappenderror',
		'filecopyerror',
		'filerenameerror',
		'filedeleteerror',
		'directorycreateerror',
		'filenotfound',
		'fileexistserror',
		'unexpected',
		'formerror',
		'badarticleerror',
		'cannotdelete',
		'badtitle',
		'badtitletext',
		'perfcached',
		'perfcachedts',
		'querypage-no-updates',
		'wrong_wfQuery_params',
		'viewsource',
		'viewsourcefor',
		'actionthrottled',
		'actionthrottledtext',
		'protectedpagetext',
		'viewsourcetext',
		'protectedinterface',
		'editinginterface',
		'sqlhidden',
		'cascadeprotected',
		'namespaceprotected',
		'customcssjsprotected',
		'ns-specialprotected',
		'titleprotected',
	),
	'virus' => array(
		'virus-badscanner',
		'virus-scanfailed',
		'virus-unknownscanner',
	),
	'login' => array(
		'logouttext',
		'welcomecreation',
		'yourname',
		'yourpassword',
		'yourpasswordagain',
		'remembermypassword',
		'yourdomainname',
		'externaldberror',
		'login',
		'nav-login-createaccount',
		'loginprompt',
		'userlogin',
		'userloginnocreate',
		'logout',
		'userlogout',
		'notloggedin',
		'nologin',
		'nologinlink',
		'createaccount',
		'gotaccount',
		'gotaccountlink',
		'createaccountmail',
		'badretype',
		'userexists',
		'loginerror',
		'createaccounterror',
		'nocookiesnew',
		'nocookieslogin',
		'noname',
		'loginsuccesstitle',
		'loginsuccess',
		'nosuchuser',
		'nosuchusershort',
		'nouserspecified',
		'login-userblocked',
		'wrongpassword',
		'wrongpasswordempty',
		'passwordtooshort',
		'password-name-match',
		'mailmypassword',
		'passwordremindertitle',
		'passwordremindertext',
		'noemail',
		'noemailcreate',
		'passwordsent',
		'blocked-mailpassword',
		'eauthentsent',
		'throttled-mailpassword',
		'loginstart',
		'loginend',
		'signupend',
		'mailerror',
		'acct_creation_throttle_hit',
		'emailauthenticated',
		'emailnotauthenticated',
		'noemailprefs',
		'emailconfirmlink',
		'invalidemailaddress',
		'accountcreated',
		'accountcreatedtext',
		'createaccount-title',
		'createaccount-text',
		'usernamehasherror',
		'login-throttled',
		'loginlanguagelabel',
		'loginlanguagelinks',
		'suspicious-userlogout',
	),
	'resetpass' => array(
		'resetpass',
		'resetpass_announce',
		'resetpass_text',
		'resetpass_header',
		'oldpassword',
		'newpassword',
		'retypenew',
		'resetpass_submit',
		'resetpass_success',
		'resetpass_forbidden',
		'resetpass-no-info',
		'resetpass-submit-loggedin',
		'resetpass-submit-cancel',
		'resetpass-wrong-oldpass',
		'resetpass-temp-password',
	),
	'toolbar' => array(
		'bold_sample',
		'bold_tip',
		'italic_sample',
		'italic_tip',
		'link_sample',
		'link_tip',
		'extlink_sample',
		'extlink_tip',
		'headline_sample',
		'headline_tip',
		'math_sample',
		'math_tip',
		'nowiki_sample',
		'nowiki_tip',
		'image_sample',
		'image_tip',
		'media_sample',
		'media_tip',
		'sig_tip',
		'hr_tip',
	),
	'edit' => array(
		'summary',
		'subject',
		'minoredit',
		'watchthis',
		'savearticle',
		'preview',
		'showpreview',
		'showlivepreview',
		'showdiff',
		'anoneditwarning',
		'missingsummary',
		'missingcommenttext',
		'missingcommentheader',
		'summary-preview',
		'subject-preview',
		'blockedtitle',
		'blockedtext',
		'autoblockedtext',
		'blockednoreason',
		'blockedoriginalsource',
		'blockededitsource',
		'whitelistedittitle',
		'whitelistedittext',
		'confirmedittext',
		'nosuchsectiontitle',
		'nosuchsectiontext',
		'loginreqtitle',
		'loginreqlink',
		'loginreqpagetext',
		'accmailtitle',
		'accmailtext',
		'newarticle',
		'newarticletext',
		'newarticletextanon',
		'talkpagetext',
		'anontalkpagetext',
		'noarticletext',
		'noarticletext-nopermission',
		'noarticletextanon',
		'userpage-userdoesnotexist',
		'userpage-userdoesnotexist-view',
		'blocked-notice-logextract',
		'clearyourcache',
		'usercssyoucanpreview',
		'userjsyoucanpreview',
		'usercsspreview',
		'userjspreview',
		'userinvalidcssjstitle',
		'updated',
		'note',
		'previewnote',
		'previewconflict',
		'session_fail_preview',
		'session_fail_preview_html',
		'token_suffix_mismatch',
		'editing',
		'editingsection',
		'editingcomment',
		'editconflict',
		'explainconflict',
		'yourtext',
		'storedversion',
		'nonunicodebrowser',
		'editingold',
		'yourdiff',
		'copyrightwarning',
		'copyrightwarning2',
		'editpage-tos-summary',
		'longpagewarning',
		'longpageerror',
		'readonlywarning',
		'protectedpagewarning',
		'semiprotectedpagewarning',
		'cascadeprotectedwarning',
		'titleprotectedwarning',
		'templatesused',
		'templatesusedpreview',
		'templatesusedsection',
		'template-protected',
		'template-semiprotected',
		'hiddencategories',
		'edittools',
		'nocreatetitle',
		'nocreatetext',
		'nocreate-loggedin',
		'sectioneditnotsupported-title',
		'sectioneditnotsupported-text',
		'permissionserrors',
		'permissionserrorstext',
		'permissionserrorstext-withaction',
		'recreate-moveddeleted-warn',
		'moveddeleted-notice',
		'log-fulllog',
		'edit-hook-aborted',
		'edit-gone-missing',
		'edit-conflict',
		'edit-no-change',
		'edit-already-exists',
		'addsection-preload',
		'addsection-editintro',
	),
	'parserwarnings' => array(
		'expensive-parserfunction-warning',
		'expensive-parserfunction-category',
		'post-expand-template-inclusion-warning',
		'post-expand-template-inclusion-category',
		'post-expand-template-argument-warning',
		'post-expand-template-argument-category',
		'parser-template-loop-warning',
		'parser-template-recursion-depth-warning',
		'language-converter-depth-warning',
	),
	'undo' => array(
		'undo-success',
		'undo-failure',
		'undo-norev',
		'undo-summary',
	),
	'cantcreateaccount' => array(
		'cantcreateaccounttitle',
		'cantcreateaccount-text',
		'cantcreateaccount-nonblock-text',
	),
	'history' => array(
		'viewpagelogs',
		'nohistory',
		'currentrev',
		'currentrev-asof',
		'revisionasof',
		'revision-info',
		'revision-info-current',
		'revision-nav',
		'previousrevision',
		'nextrevision',
		'currentrevisionlink',
		'cur',
		'next',
		'last',
		'page_first',
		'page_last',
		'histlegend',
		'history-fieldset-title',
		'history-show-deleted',
		'history_copyright',
		'histfirst',
		'histlast',
		'historysize',
		'historyempty',
	),
	'history-feed' => array(
		'history-feed-title',
		'history-feed-description',
		'history-feed-item-nocomment',
		'history-feed-empty',
	),
	'revdelete' => array(
		'rev-deleted-comment',
		'rev-deleted-user',
		'rev-deleted-event',
		'rev-deleted-user-contribs',
		'rev-deleted-text-permission',
		'rev-deleted-text-unhide',
		'rev-suppressed-text-unhide',
		'rev-deleted-text-view',
		'rev-suppressed-text-view',
		'rev-deleted-no-diff',
		'rev-suppressed-no-diff',
		'rev-deleted-unhide-diff',
		'rev-suppressed-unhide-diff',
		'rev-deleted-diff-view',
		'rev-suppressed-diff-view',
		'rev-delundel',
		'rev-showdeleted',
		'revisiondelete',
		'revdelete-nooldid-title',
		'revdelete-nooldid-text',
		'revdelete-nologtype-title',
		'revdelete-nologtype-text',
		'revdelete-nologid-title',
		'revdelete-nologid-text',
		'revdelete-no-file',
		'revdelete-show-file-confirm',
		'revdelete-show-file-submit',
		'revdelete-selected',
		'logdelete-selected',
		'revdelete-text',
		'revdelete-confirm',
		'revdelete-suppress-text',
		'revdelete-legend',
		'revdelete-hide-text',
		'revdelete-hide-image',
		'revdelete-hide-name',
		'revdelete-hide-comment',
		'revdelete-hide-user',
		'revdelete-hide-restricted',
		'revdelete-radio-same',
		'revdelete-radio-set',
		'revdelete-radio-unset',
		'revdelete-suppress',
		'revdelete-unsuppress',
		'revdelete-log',
		'revdelete-submit',
		'revdelete-logentry',
		'logdelete-logentry',
		'revdelete-logaction',
		'logdelete-logaction',
		'revdelete-success',
		'revdelete-failure',
		'logdelete-success',
		'logdelete-failure',
		'revdel-restore',
		'pagehist',
		'deletedhist',
		'revdelete-content',
		'revdelete-summary',
		'revdelete-uname',
		'revdelete-restricted',
		'revdelete-unrestricted',
		'revdelete-hid',
		'revdelete-unhid',
		'revdelete-log-message',
		'logdelete-log-message',
		'revdelete-hide-current',
		'revdelete-show-no-access',
		'revdelete-modify-no-access',
		'revdelete-modify-missing',
		'revdelete-no-change',
		'revdelete-concurrent-change',
		'revdelete-only-restricted',
		'revdelete-reason-dropdown',
		'revdelete-otherreason',
		'revdelete-reasonotherlist',
		'revdelete-edit-reasonlist',
		'revdelete-offender',
	),
	'suppression' => array(
		'suppressionlog',
		'suppressionlogtext',
	),
	'mergehistory' => array(
		'mergehistory',
		'mergehistory-header',
		'mergehistory-box',
		'mergehistory-from',
		'mergehistory-into',
		'mergehistory-list',
		'mergehistory-merge',
		'mergehistory-go',
		'mergehistory-submit',
		'mergehistory-empty',
		'mergehistory-success',
		'mergehistory-fail',
		'mergehistory-no-source',
		'mergehistory-no-destination',
		'mergehistory-invalid-source',
		'mergehistory-invalid-destination',
		'mergehistory-autocomment',
		'mergehistory-comment',
		'mergehistory-same-destination',
		'mergehistory-reason'
	),
	'mergelog' => array(
		'mergelog',
		'pagemerge-logentry',
		'revertmerge',
		'mergelogpagetext',
	),
	'diffs' => array(
		'history-title',
		'difference',
		'lineno',
		'compareselectedversions',
		'showhideselectedversions',
		'editundo',
		'diff-multi',
	),
	'search' => array(
		'search-summary',
		'searchresults',
		'searchresults-title',
		'searchresulttext',
		'searchsubtitle',
		'searchsubtitleinvalid',
		'toomanymatches',
		'titlematches',
		'notitlematches',
		'textmatches',
		'notextmatches',
		'prevn',
		'nextn',
		'prevn-title',
		'nextn-title',
		'shown-title',
		'viewprevnext',
		'searchmenu-legend',
		'searchmenu-exists',
		'searchmenu-new',
		'searchhelp-url',
		'searchmenu-prefix',
		'searchmenu-help',
		'searchprofile-articles',
		'searchprofile-project',
		'searchprofile-images',
		'searchprofile-everything',
		'searchprofile-advanced',
		'searchprofile-articles-tooltip',
		'searchprofile-project-tooltip',
		'searchprofile-images-tooltip',
		'searchprofile-everything-tooltip',
		'searchprofile-advanced-tooltip',
		'search-result-size',
		'search-result-score',
		'search-redirect',
		'search-section',
		'search-suggest',
		'search-interwiki-caption',
		'search-interwiki-default',
		'search-interwiki-custom',
		'search-interwiki-more',
		'search-mwsuggest-enabled',
		'search-mwsuggest-disabled',
		'search-relatedarticle',
		'mwsuggest-disable',
		'searcheverything-enable',
		'searchrelated',
		'searchall',
		'showingresults',
		'showingresultsnum',
		'showingresultsheader',
		'nonefound',
		'search-nonefound',
		'powersearch',
		'powersearch-legend',
		'powersearch-ns',
		'powersearch-redir',
		'powersearch-field',
		'powersearch-togglelabel',
		'powersearch-toggleall',
		'powersearch-togglenone',
		'search-external',
		'searchdisabled',
		'googlesearch',
	),
	'opensearch' => array(
		'opensearch-desc',
	),
	'quickbar' => array(
		'qbsettings',
		'qbsettings-none',
		'qbsettings-fixedleft',
		'qbsettings-fixedright',
		'qbsettings-floatingleft',
		'qbsettings-floatingright',
	),
	'preferences' => array(
		'preferences',
		'preferences-summary',
		'mypreferences',
		'prefs-edits',
		'prefsnologin',
		'prefsnologintext',
		'changepassword',
		'prefs-skin',
		'skin-preview',
		'prefs-math',
		'datedefault',
		'prefs-datetime',
		'prefs-personal',
		'prefs-rc',
		'prefs-watchlist',
		'prefs-watchlist-days',
		'prefs-watchlist-days-max',
		'prefs-watchlist-edits',
		'prefs-watchlist-edits-max',
		'prefs-watchlist-token',
		'prefs-misc', // continue checking if used from here on (r49916)
		'prefs-resetpass',
		'prefs-email',
		'prefs-rendering',
		'saveprefs',
		'resetprefs',
		'restoreprefs',
		'prefs-editing',
		'prefs-edit-boxsize',
		'rows',
		'columns',
		'searchresultshead',
		'resultsperpage',
		'contextlines',
		'contextchars',
		'stub-threshold',
		'recentchangesdays',
		'recentchangesdays-max',
		'recentchangescount',
		'prefs-help-recentchangescount',
		'prefs-help-watchlist-token',
		'savedprefs',
		'timezonelegend',
		'localtime',
		'timezoneuseserverdefault',
		'timezoneuseoffset',
		'timezoneoffset',
		'servertime',
		'guesstimezone',
		'timezoneregion-africa',
		'timezoneregion-america',
		'timezoneregion-antarctica',
		'timezoneregion-arctic',
		'timezoneregion-asia',
		'timezoneregion-atlantic',
		'timezoneregion-australia',
		'timezoneregion-europe',
		'timezoneregion-indian',
		'timezoneregion-pacific',
		'allowemail',
		'prefs-searchoptions',
		'prefs-namespaces',
		'defaultns',
		'default',
		'defaultns',
		'prefs-files',
		'prefs-custom-css',
		'prefs-custom-js',
		'prefs-reset-intro',
		'prefs-emailconfirm-label',
		'prefs-textboxsize',
		'youremail',
		'username',
		'uid',
		'prefs-memberingroups',
		'prefs-memberingroups-type',
		'prefs-registration',
		'prefs-registration-date-time',
		'yourrealname',
		'yourlanguage',
		'yourvariant',
		'yournick',
		'prefs-help-signature',
		'badsig',
		'badsiglength',
		'yourgender',
		'gender-unknown',
		'gender-male',
		'gender-female',
		'prefs-help-gender',
		'email',
		'prefs-help-realname',
		'prefs-help-email',
		'prefs-help-email-required',
		'prefs-info',
		'prefs-i18n',
		'prefs-signature',
		'prefs-dateformat',
		'prefs-timeoffset',
		'prefs-advancedediting',
		'prefs-advancedrc',
		'prefs-advancedrendering',
		'prefs-advancedsearchoptions',
		'prefs-advancedwatchlist',
		'prefs-display',
		'prefs-diffs',
	),
	'userrights' => array(
		'userrights',
		'userrights-summary',
		'userrights-lookup-user',
		'userrights-user-editname',
		'editusergroup',
		'editinguser',
		'userrights-editusergroup',
		'saveusergroups',
		'userrights-groupsmember',
		'userrights-groupsmember-auto',
		'userrights-groups-help',
		'userrights-reason',
		'userrights-no-interwiki',
		'userrights-nodatabase',
		'userrights-nologin',
		'userrights-notallowed',
		'userrights-changeable-col',
		'userrights-unchangeable-col',
		'userrights-irreversible-marker',
	),
	'group' => array(
		'group',
		'group-user',
		'group-autoconfirmed',
		'group-bot',
		'group-sysop',
		'group-bureaucrat',
		'group-suppress',
		'group-all',
	),
	'group-member' => array(
		'group-user-member',
		'group-autoconfirmed-member',
		'group-bot-member',
		'group-sysop-member',
		'group-bureaucrat-member',
		'group-suppress-member',
	),
	'grouppage' => array(
		'grouppage-user',
		'grouppage-autoconfirmed',
		'grouppage-bot',
		'grouppage-sysop',
		'grouppage-bureaucrat',
		'grouppage-suppress',
	),
	'right' => array(
		'right-read',
		'right-edit',
		'right-createpage',
		'right-createtalk',
		'right-createaccount',
		'right-minoredit',
		'right-move',
		'right-move-subpages',
		'right-move-rootuserpages',
		'right-movefile',
		'right-suppressredirect',
		'right-upload',
		'right-reupload',
		'right-reupload-own',
		'right-reupload-shared',
		'right-upload_by_url',
		'right-purge',
		'right-autoconfirmed',
		'right-bot',
		'right-nominornewtalk',
		'right-apihighlimits',
		'right-writeapi',
		'right-delete',
		'right-bigdelete',
		'right-deleterevision',
		'right-deletedhistory',
		'right-deletedtext',
		'right-browsearchive',
		'right-undelete',
		'right-suppressrevision',
		'right-suppressionlog',
		'right-block',
		'right-blockemail',
		'right-hideuser',
		'right-ipblock-exempt',
		'right-proxyunbannable',
		'right-protect',
		'right-editprotected',
		'right-editinterface',
		'right-editusercssjs',
		'right-editusercss',
		'right-edituserjs',
		'right-rollback',
		'right-markbotedits',
		'right-noratelimit',
		'right-import',
		'right-importupload',
		'right-patrol',
		'right-autopatrol',
		'right-patrolmarks',
		'right-unwatchedpages',
		'right-trackback',
		'right-mergehistory',
		'right-userrights',
		'right-userrights-interwiki',
		'right-siteadmin',
		'right-reset-passwords',
		'right-override-export-depth',
		'right-versiondetail',
		'right-sendemail',
	),
	'rightslog' => array(
		'rightslog',
		'rightslogtext',
		'rightslogentry',
		'rightsnone',
	),
	'action' => array(
		'action-read',
		'action-edit',
		'action-createpage',
		'action-createtalk',
		'action-createaccount',
		'action-minoredit',
		'action-move',
		'action-move-subpages',
		'action-move-rootuserpages',
		'action-movefile',
		'action-upload',
		'action-reupload',
		'action-reupload-shared',
		'action-upload_by_url',
		'action-writeapi',
		'action-delete',
		'action-deleterevision',
		'action-deletedhistory',
		'action-browsearchive',
		'action-undelete',
		'action-suppressrevision',
		'action-suppressionlog',
		'action-block',
		'action-protect',
		'action-import',
		'action-importupload',
		'action-patrol',
		'action-autopatrol',
		'action-unwatchedpages',
		'action-trackback',
		'action-mergehistory',
		'action-userrights',
		'action-userrights-interwiki',
		'action-siteadmin',
	),
	'recentchanges' => array(
		'nchanges',
		'recentchanges',
		'recentchanges-url',
		'recentchanges-legend',
		'recentchangestext',
		'recentchanges-feed-description',
		'recentchanges-label-legend',
		'recentchanges-legend-newpage',
		'recentchanges-label-newpage',
		'recentchanges-legend-minor',
		'recentchanges-label-minor',
		'recentchanges-legend-bot',
		'recentchanges-label-bot',
		'recentchanges-legend-unpatrolled',
		'recentchanges-label-unpatrolled',
		'rcnote',
		'rcnotefrom',
		'rclistfrom',
		'rcshowhideminor',
		'rcshowhidebots',
		'rcshowhideliu',
		'rcshowhideanons',
		'rcshowhidepatr',
		'rcshowhidemine',
		'rclinks',
		'diff',
		'hist',
		'hide',
		'show',
		'minoreditletter',
		'newpageletter',
		'boteditletter',
		'unpatrolledletter',
		'sectionlink',
		'number_of_watching_users_RCview',
		'number_of_watching_users_pageview',
		'rc_categories',
		'rc_categories_any',
		'rc-change-size',
		'newsectionsummary',
		'rc-enhanced-expand',
		'rc-enhanced-hide',
	),
	'recentchangeslinked' => array(
		'recentchangeslinked',
		'recentchangeslinked-feed',
		'recentchangeslinked-toolbox',
		'recentchangeslinked-title',
		'recentchangeslinked-backlink',
		'recentchangeslinked-noresult',
		'recentchangeslinked-summary',
		'recentchangeslinked-page',
		'recentchangeslinked-to',
	),
	'upload' => array(
		'upload',
		'uploadbtn',
		'reuploaddesc',
		'upload-tryagain',
		'uploadnologin',
		'uploadnologintext',
		'upload_directory_missing',
		'upload_directory_read_only',
		'uploaderror',
		'upload-summary',
		'uploadtext',
		'upload-permitted',
		'upload-preferred',
		'upload-prohibited',
		'uploadfooter',
		'uploadlog',
		'uploadlogpage',
		'uploadlogpagetext',
		'filename',
		'filedesc',
		'fileuploadsummary',
		'filereuploadsummary',
		'filestatus',
		'filesource',
		'uploadedfiles',
		'ignorewarning',
		'ignorewarnings',
		'minlength1',
		'illegalfilename',
		'badfilename',
		'filetype-mime-mismatch',
		'filetype-badmime',
		'filetype-bad-ie-mime',
		'filetype-unwanted-type',
		'filetype-banned-type',
		'filetype-missing',
		'large-file',
		'largefileserver',
		'emptyfile',
		'fileexists',
		'filepageexists',
		'fileexists-extension',
		'fileexists-thumbnail-yes',
		'file-thumbnail-no',
		'fileexists-forbidden',
		'fileexists-shared-forbidden',
		'file-exists-duplicate',
		'file-deleted-duplicate',
		'successfulupload',
		'uploadwarning',
		'uploadwarning-text',
		'savefile',
		'uploadedimage',
		'overwroteimage',
		'uploaddisabled',
		'uploaddisabledtext',
		'php-uploaddisabledtext',
		'uploadscripted',
		'uploadvirus',
		'upload-source',
		'sourcefilename',
		'sourceurl',
		'destfilename',
		'upload-maxfilesize',
		'upload-description',
		'upload-options',
		'watchthisupload',
		'filewasdeleted',
		'upload-wasdeleted',
		'filename-bad-prefix',
		'filename-prefix-blacklist',
	),
	'upload-errors' => array(
		'upload-proto-error',
		'upload-proto-error-text',
		'upload-file-error',
		'upload-file-error-text',
		'upload-misc-error',
		'upload-misc-error-text',
		'upload-too-many-redirects',
		'upload-unknown-size',
		'upload-http-error',
	),

	'img-auth' => array(
		'img-auth-accessdenied',
		'img-auth-desc',
		'img-auth-nopathinfo',
		'img-auth-notindir',
		'img-auth-badtitle',
		'img-auth-nologinnWL',
		'img-auth-nofile',
		'img-auth-isdir',
		'img-auth-streaming',
		'img-auth-public',
		'img-auth-noread',
	),

	'http-errors' => array(
		'http-invalid-url',
		'http-invalid-scheme',
		'http-request-error',
		'http-read-error',
		'http-timed-out',
		'http-curl-error',
		'http-host-unreachable',
		'http-bad-status',
	),

	'upload-curl-errors' => array(
		'upload-curl-error6',
		'upload-curl-error6-text',
		'upload-curl-error28',
		'upload-curl-error28-text',
	),
	'licenses' => array(
		'license',
		'license-header',
		'nolicense',
		'licenses',
		'license-nopreview',
		'upload_source_url',
		'upload_source_file',
	),
	'filelist' => array(
		'listfiles-summary',
		'listfiles_search_for',
		'imgfile',
		'listfiles',
		'listfiles_date',
		'listfiles_name',
		'listfiles_user',
		'listfiles_size',
		'listfiles_description',
		'listfiles_count',
	),
	'filedescription' => array(
		'file-anchor-link',
		'filehist',
		'filehist-help',
		'filehist-deleteall',
		'filehist-deleteone',
		'filehist-revert',
		'filehist-current',
		'filehist-datetime',
		'filehist-thumb',
		'filehist-thumbtext',
		'filehist-nothumb',
		'filehist-user',
		'filehist-dimensions',
		'filehist-filesize',
		'filehist-comment',
		'filehist-missing',
		'imagelinks',
		'linkstoimage',
		'linkstoimage-more',
		'nolinkstoimage',
		'morelinkstoimage',
		'redirectstofile',
		'duplicatesoffile',
		'sharedupload',
		'sharedupload-desc-there',
		'sharedupload-desc-here',
		'shareddescriptionfollows',
		'filepage-nofile',
		'filepage-nofile-link',
		'uploadnewversion-linktext',
		'shared-repo-from',
		'shared-repo',
		'shared-repo-name-wikimediacommons',
	),
	'filerevert' => array(
		'filerevert',
		'filerevert-backlink',
		'filerevert-legend',
		'filerevert-intro',
		'filerevert-comment',
		'filerevert-defaultcomment',
		'filerevert-submit',
		'filerevert-success',
		'filerevert-badversion',
	),
	'filedelete' => array(
		'filedelete',
		'filedelete-backlink',
		'filedelete-legend',
		'filedelete-intro',
		'filedelete-intro-old',
		'filedelete-comment',
		'filedelete-submit',
		'filedelete-success',
		'filedelete-success-old',
		'filedelete-nofile',
		'filedelete-nofile-old',
		'filedelete-otherreason',
		'filedelete-reason-otherlist',
		'filedelete-reason-dropdown',
		'filedelete-edit-reasonlist',
		'filedelete-maintenance',
	),
	'mimesearch' => array(
		'mimesearch',
		'mimesearch-summary',
		'mimetype',
		'download',
	),
	'unwatchedpages' => array(
		'unwatchedpages',
		'unwatchedpages-summary',
	),
	'listredirects' => array(
		'listredirects',
		'listredirects-summary',
	),
	'unusedtemplates' => array(
		'unusedtemplates',
		'unusedtemplates-summary',
		'unusedtemplatestext',
		'unusedtemplateswlh',
	),
	'randompage' => array(
		'randompage',
		'randompage-nopages',
		'randompage-url',
	),
	'randomredirect' => array(
		'randomredirect',
		'randomredirect-nopages',
	),
	'statistics' => array(
		'statistics',
		'statistics-summary',
		'statistics-header-pages',
		'statistics-header-edits',
		'statistics-header-views',
		'statistics-header-users',
		'statistics-header-hooks',
		'statistics-articles',
		'statistics-pages',
		'statistics-pages-desc',
		'statistics-files',
		'statistics-edits',
		'statistics-edits-average',
		'statistics-views-total',
		'statistics-views-peredit',
		'statistics-jobqueue',
		'statistics-users',
		'statistics-users-active',
		'statistics-users-active-desc',
		'statistics-mostpopular',
		'statistics-footer',
	),
	'disambiguations' => array(
		'disambiguations',
		'disambiguations-summary',
		'disambiguationspage',
		'disambiguations-text',
	),
	'doubleredirects' => array(
		'doubleredirects',
		'doubleredirects-summary',
		'doubleredirectstext',
		'double-redirect-fixed-move',
		'double-redirect-fixer',
	),
	'brokenredirects' => array(
		'brokenredirects',
		'brokenredirects-summary',
		'brokenredirectstext',
		'brokenredirects-edit',
		'brokenredirects-delete',
	),
	'withoutinterwiki' => array(
		'withoutinterwiki',
		'withoutinterwiki-summary',
		'withoutinterwiki-legend',
		'withoutinterwiki-submit',
	),
	'fewestrevisions' => array(
		'fewestrevisions',
		'fewestrevisions-summary',
	),
	'specialpages' => array(
		'nbytes',
		'ncategories',
		'nlinks',
		'nmembers',
		'nrevisions',
		'nviews',
		'nchanges',
		'specialpage-empty',
		'lonelypages',
		'lonelypages-summary',
		'lonelypagestext',
		'uncategorizedpages',
		'uncategorizedpages-summary',
		'uncategorizedcategories',
		'uncategorizedcategories-summary',
		'uncategorizedimages',
		'uncategorizedimages-summary',
		'uncategorizedtemplates',
		'uncategorizedtemplates-summary',
		'unusedcategories',
		'unusedimages',
		'popularpages',
		'popularpages-summary',
		'wantedcategories',
		'wantedcategories-summary',
		'wantedpages',
		'wantedpages-summary',
		'wantedpages-badtitle',
		'wantedfiles',
		'wantedfiles-summary',
		'wantedtemplates',
		'wantedtemplates-summary',
		'mostlinked',
		'mostlinked-summary',
		'mostlinkedcategories',
		'mostlinkedcategories-summary',
		'mostlinkedtemplates',
		'mostlinkedtemplates-summary',
		'mostcategories',
		'mostcategories-summary',
		'mostimages',
		'mostimages-summary',
		'mostrevisions',
		'mostrevisions-summary',
		'prefixindex',
		'prefixindex-summary',
		'shortpages',
		'shortpages-summary',
		'longpages',
		'longpages-summary',
		'deadendpages',
		'deadendpages-summary',
		'deadendpagestext',
		'protectedpages',
		'protectedpages-indef',
		'protectedpages-summary',
		'protectedpages-cascade',
		'protectedpagestext',
		'protectedpagesempty',
		'protectedtitles',
		'protectedtitles-summary',
		'protectedtitlestext',
		'protectedtitlesempty',
		'listusers',
		'listusers-summary',
		'listusers-editsonly',
		'listusers-creationsort',
		'usereditcount',
		'usercreated',
		'newpages',
		'newpages-summary',
		'newpages-username',
		'ancientpages',
		'ancientpages-summary',
		'move',
		'movethispage',
		'unusedimagestext',
		'unusedcategoriestext',
		'notargettitle',
		'notargettext',
		'nopagetitle',
		'nopagetext',
		'pager-newer-n',
		'pager-older-n',
		'suppress',
	),
	'booksources' => array(
		'booksources',
		'booksources-summary',
		'booksources-search-legend',
		'booksources-isbn',
		'booksources-go',
		'booksources-text',
		'booksources-invalid-isbn',
	),
	'magicwords' => array(
		'rfcurl',
		'pubmedurl',
	),
	'logpages' => array(
		'specialloguserlabel',
		'speciallogtitlelabel',
		'log',
		'all-logs-page',
		'alllogstext',
		'logempty',
		'log-title-wildcard',
	),
	'allpages' => array(
		'allpages',
		'allpages-summary',
		'alphaindexline',
		'nextpage',
		'prevpage',
		'allpagesfrom',
		'allpagesto',
		'allarticles',
		'allinnamespace',
		'allnotinnamespace',
		'allpagesprev',
		'allpagesnext',
		'allpagessubmit',
		'allpagesprefix',
		'allpagesbadtitle',
		'allpages-bad-ns',
	),
	'categories' => array(
		'categories',
		'categories-summary',
		'categoriespagetext',
		'categoriesfrom',
		'special-categories-sort-count',
		'special-categories-sort-abc',
	),
	'deletedcontribs' => array(
		'deletedcontributions',
		'deletedcontributions-title',
		'sp-deletedcontributions-contribs',
	),
	'linksearch' => array(
		'linksearch',
		'linksearch-pat',
		'linksearch-ns',
		'linksearch-ok',
		'linksearch-text',
		'linksearch-line',
		'linksearch-error',
	),
	'listusers' => array(
		'listusersfrom',
		'listusers-submit',
		'listusers-noresult',
		'listusers-blocked',
	),
	'activeusers' => array(
		'activeusers',
		'activeusers-summary',
		'activeusers-intro',
		'activeusers-count',
		'activeusers-from',
		'activeusers-hidebots',
		'activeusers-hidesysops',
		'activeusers-submit',
		'activeusers-noresult',
	),
	'newuserlog' => array(
		'newuserlogpage',
		'newuserlogpagetext',
		'newuserlogentry',
		'newuserlog-byemail',
		'newuserlog-create-entry',
		'newuserlog-create2-entry',
		'newuserlog-autocreate-entry',
	),
	'listgrouprights' => array(
		'listgrouprights',
		'listgrouprights-summary',
		'listgrouprights-key',
		'listgrouprights-group',
		'listgrouprights-rights',
		'listgrouprights-helppage',
		'listgrouprights-members',
		'listgrouprights-right-display',
		'listgrouprights-right-revoked',
		'listgrouprights-addgroup',
		'listgrouprights-removegroup',
		'listgrouprights-addgroup-all',
		'listgrouprights-removegroup-all',
		'listgrouprights-addgroup-self',
		'listgrouprights-removegroup-self',
		'listgrouprights-addgroup-self-all',
		'listgrouprights-removegroup-self-all',

	),
	'emailuser' => array(
		'mailnologin',
		'mailnologintext',
		'emailuser',
		'emailpage',
		'emailpagetext',
		'usermailererror',
		'defemailsubject',
		'noemailtitle',
		'noemailtext',
		'nowikiemailtitle',
		'nowikiemailtext',
		'email-legend',
		'emailfrom',
		'emailto',
		'emailsubject',
		'emailmessage',
		'emailsend',
		'emailccme',
		'emailccsubject',
		'emailsent',
		'emailsenttext',
		'emailuserfooter',
	),
	'watchlist' => array(
		'watchlist',
		'mywatchlist',
		'watchlistfor',
		'nowatchlist',
		'watchlistanontext',
		'watchnologin',
		'watchnologintext',
		'addedwatch',
		'addedwatchtext',
		'removedwatch',
		'removedwatchtext',
		'watch',
		'watchthispage',
		'unwatch',
		'unwatchthispage',
		'notanarticle',
		'notvisiblerev',
		'watchnochange',
		'watchlist-details',
		'wlheader-enotif',
		'wlheader-showupdated',
		'watchmethod-recent',
		'watchmethod-list',
		'watchlistcontains',
		'iteminvalidname',
		'wlnote',
		'wlshowlast',
		'watchlist-options',
	),
	'watching' => array(
		'watching',
		'unwatching',
	),
	'enotif' => array(
		'enotif_mailer',
		'enotif_reset',
		'enotif_newpagetext',
		'enotif_impersonal_salutation',
		'changed',
		'created',
		'enotif_subject',
		'enotif_lastvisited',
		'enotif_lastdiff',
		'enotif_anon_editor',
		'enotif_body',
	),
	'delete' => array(
		'deletepage',
		'confirm',
		'excontent',
		'excontentauthor',
		'exbeforeblank',
		'exblank',
		'delete-confirm',
		'delete-backlink',
		'delete-legend',
		'historywarning',
		'confirmdeletetext',
		'actioncomplete',
		'actionfailed',
		'deletedtext',
		'deletedarticle',
		'suppressedarticle',
		'dellogpage',
		'dellogpagetext',
		'deletionlog',
		'reverted',
		'deletecomment',
		'deleteotherreason',
		'deletereasonotherlist',
		'deletereason-dropdown',
		'delete-edit-reasonlist',
		'delete-toobig',
		'delete-warning-toobig',
	),
	'rollback' => array(
		'rollback',
		'rollback_short',
		'rollbacklink',
		'rollbackfailed',
		'cantrollback',
		'alreadyrolled',
		'editcomment',
		'revertpage',
		'revertpage-nouser',
		'rollback-success',
		'sessionfailure',
	),
	'protect' => array(
		'protectlogpage',
		'protectlogtext',
		'protectedarticle',
		'modifiedarticleprotection',
		'unprotectedarticle',
		'movedarticleprotection',
		'protect-title',
		'prot_1movedto2',
		'protect-backlink',
		'protect-legend',
		'protectcomment',
		'protectexpiry',
		'protect_expiry_invalid',
		'protect_expiry_old',
		'protect-unchain-permissions',
		'protect-text',
		'protect-locked-blocked',
		'protect-locked-dblock',
		'protect-locked-access',
		'protect-cascadeon',
		'protect-default',
		'protect-fallback',
		'protect-level-autoconfirmed',
		'protect-level-sysop',
		'protect-summary-cascade',
		'protect-expiring',
		'protect-expiry-indefinite',
		'protect-cascade',
		'protect-cantedit',
		'protect-othertime',
		'protect-othertime-op',
		'protect-existing-expiry',
		'protect-otherreason',
		'protect-otherreason-op',
		'protect-dropdown',
		'protect-edit-reasonlist',
		'protect-expiry-options',
		'restriction-type',
		'restriction-level',
		'minimum-size',
		'maximum-size',
		'pagesize',
	),
	'restrictions' => array(
		'restriction-edit',
		'restriction-move',
		'restriction-create',
		'restriction-upload',
	),
	'restriction-levels' => array(
		'restriction-level-sysop',
		'restriction-level-autoconfirmed',
		'restriction-level-all',
	),
	'undelete' => array(
		'undelete',
		'undeletepage',
		'undeletepagetitle',
		'viewdeletedpage',
		'undeletepagetext',
		'undelete-fieldset-title',
		'undeleteextrahelp',
		'undeleterevisions',
		'undeletehistory',
		'undeleterevdel',
		'undeletehistorynoadmin',
		'undelete-revision',
		'undeleterevision-missing',
		'undelete-nodiff',
		'undeletebtn',
		'undeletelink',
		'undeleteviewlink',
		'undeletereset',
		'undeleteinvert',
		'undeletecomment',
		'undeletedarticle',
		'undeletedrevisions',
		'undeletedrevisions-files',
		'undeletedfiles',
		'cannotundelete',
		'undeletedpage',
		'undelete-header',
		'undelete-search-box',
		'undelete-search-prefix',
		'undelete-search-submit',
		'undelete-no-results',
		'undelete-filename-mismatch',
		'undelete-bad-store-key',
		'undelete-cleanup-error',
		'undelete-missing-filearchive',
		'undelete-error-short',
		'undelete-error-long',
		'undelete-show-file-confirm',
		'undelete-show-file-submit',
	),
	'nsform' => array(
		'namespace',
		'invert',
		'blanknamespace',
	),
	'contributions' => array(
		'contributions',
		'contributions-title',
		'mycontris',
		'contribsub2',
		'nocontribs',
		'uctop',
		'month',
		'year',
	),
	'sp-contributions' => array(
		'sp-contributions-newbies',
		'sp-contributions-newbies-sub',
		'sp-contributions-newbies-title',
		'sp-contributions-blocklog',
		'sp-contributions-deleted',
		'sp-contributions-logs',
		'sp-contributions-talk',
		'sp-contributions-userrights',
		'sp-contributions-blocked-notice',
		'sp-contributions-search',
		'sp-contributions-username',
		'sp-contributions-submit',
		'sp-contributions-explain',
		'sp-contributions-footer',
		'sp-contributions-footer-anon',
	),
	'whatlinkshere' => array(
		'whatlinkshere',
		'whatlinkshere-title',
		'whatlinkshere-summary',
		'whatlinkshere-page',
		'whatlinkshere-backlink',
		'linkshere',
		'nolinkshere',
		'nolinkshere-ns',
		'isredirect',
		'istemplate',
		'isimage',
		'whatlinkshere-prev',
		'whatlinkshere-next',
		'whatlinkshere-links',
		'whatlinkshere-hideredirs',
		'whatlinkshere-hidetrans',
		'whatlinkshere-hidelinks',
		'whatlinkshere-hideimages',
		'whatlinkshere-filters',
	),
	'block' => array(
		'blockip',
		'blockip-title',
		'blockip-legend',
		'blockiptext',
		'ipaddress',
		'ipadressorusername',
		'ipbexpiry',
		'ipbreason',
		'ipbreasonotherlist',
		'ipbreason-dropdown',
		'ipbanononly',
		'ipbcreateaccount',
		'ipbemailban',
		'ipbenableautoblock',
		'ipbsubmit',
		'ipbother',
		'ipboptions',
		'ipbotheroption',
		'ipbotherreason',
		'ipbhidename',
		'ipbwatchuser',
		'ipballowusertalk',
		'ipb-change-block',
		'badipaddress',
		'blockipsuccesssub',
		'blockipsuccesstext',
		'ipb-edit-dropdown',
		'ipb-unblock-addr',
		'ipb-unblock',
		'ipb-blocklist-addr',
		'ipb-blocklist',
		'ipb-blocklist-contribs',
		'unblockip',
		'unblockiptext',
		'ipusubmit',
		'unblocked',
		'unblocked-id',
		'ipblocklist',
		'ipblocklist-legend',
		'ipblocklist-username',
		'ipblocklist-sh-userblocks',
		'ipblocklist-sh-tempblocks',
		'ipblocklist-sh-addressblocks',
		'ipblocklist-summary',
		'ipblocklist-submit',
		'ipblocklist-localblock',
		'ipblocklist-otherblocks',
		'blocklistline',
		'infiniteblock',
		'expiringblock',
		'anononlyblock',
		'noautoblockblock',
		'createaccountblock',
		'emailblock',
		'blocklist-nousertalk',
		'ipblocklist-empty',
		'ipblocklist-no-results',
		'blocklink',
		'unblocklink',
		'change-blocklink',
		'contribslink',
		'autoblocker',
		'blocklogpage',
		'blocklog-showlog',
		'blocklog-showsuppresslog',
		'blocklogentry',
		'reblock-logentry',
		'blocklogtext',
		'unblocklogentry',
		'block-log-flags-anononly',
		'block-log-flags-nocreate',
		'block-log-flags-noautoblock',
		'block-log-flags-noemail',
		'block-log-flags-nousertalk',
		'block-log-flags-angry-autoblock',
		'block-log-flags-hiddenname',
		'range_block_disabled',
		'ipb_expiry_invalid',
		'ipb_expiry_temp',
		'ipb_hide_invalid',
		'ipb_already_blocked',
		'ipb-needreblock',
		'ipb-otherblocks-header',
		'ipb_cant_unblock',
		'ipb_blocked_as_range',
		'ip_range_invalid',
		'ip_range_toolarge',
		'blockme',
		'proxyblocker',
		'proxyblocker-disabled',
		'proxyblockreason',
		'proxyblocksuccess',
		'sorbs',
		'sorbsreason',
		'sorbs_create_account_reason',
		'cant-block-while-blocked',
		'cant-see-hidden-user'
	),
	'developertools' => array(
		'lockdb',
		'unlockdb',
		'lockdbtext',
		'unlockdbtext',
		'lockconfirm',
		'unlockconfirm',
		'lockbtn',
		'unlockbtn',
		'locknoconfirm',
		'lockdbsuccesssub',
		'unlockdbsuccesssub',
		'lockdbsuccesstext',
		'unlockdbsuccesstext',
		'lockfilenotwritable',
		'databasenotlocked',
	),
	'movepage' => array(
		'move-page',
		'move-page-backlink',
		'move-page-legend',
		'movepagetext',
		'movepagetalktext',
		'movearticle',
		'moveuserpage-warning',
		'movenologin',
		'movenologintext',
		'movenotallowed',
		'movenotallowedfile',
		'cant-move-user-page',
		'cant-move-to-user-page',
		'newtitle',
		'move-watch',
		'movepagebtn',
		'pagemovedsub',
		'movepage-moved',
		'movepage-moved-redirect',
		'movepage-moved-noredirect',
		'articleexists',
		'cantmove-titleprotected',
		'talkexists',
		'movedto',
		'movetalk',
		'move-subpages',
		'move-talk-subpages',
		'movepage-page-exists',
		'movepage-page-moved',
		'movepage-page-unmoved',
		'movepage-max-pages',
		'1movedto2',
		'1movedto2_redir',
		'move-redirect-suppressed',
		'movelogpage',
		'movelogpagetext',
		'movesubpage',
		'movesubpagetext',
		'movenosubpage',
		'movereason',
		'revertmove',
		'delete_and_move',
		'delete_and_move_text',
		'delete_and_move_confirm',
		'delete_and_move_reason',
		'selfmove',
		'immobile-source-namespace',
		'immobile-target-namespace',
		'immobile-target-namespace-iw',
		'immobile-source-page',
		'immobile-target-page',
		'immobile_namespace',
		'imagenocrossnamespace',
		'imagetypemismatch',
		'imageinvalidfilename',
		'fix-double-redirects',
		'move-leave-redirect',
		'protectedpagemovewarning',
		'semiprotectedpagemovewarning',
		'move-over-sharedrepo',
		'file-exists-sharedrepo',
	),
	'export' => array(
		'export',
		'exporttext',
		'exportcuronly',
		'exportnohistory',
		'export-submit',
		'export-addcattext',
		'export-addcat',
		'export-addnstext',
		'export-addns',
		'export-download',
		'export-templates',
		'export-pagelinks',
	),
	'allmessages' => array(
		'allmessages',
		'allmessagesname',
		'allmessagesdefault',
		'allmessagescurrent',
		'allmessagestext',
		'allmessagesnotsupportedDB',
		'allmessages-filter-legend',
		'allmessages-filter',
		'allmessages-filter-unmodified',
		'allmessages-filter-all',
		'allmessages-filter-modified',
		'allmessages-prefix',
		'allmessages-language',
		'allmessages-filter-submit',
	),
	'thumbnails' => array(
		'thumbnail-more',
		'filemissing',
		'thumbnail_error',
		'djvu_page_error',
		'djvu_no_xml',
		'thumbnail_invalid_params',
		'thumbnail_dest_directory',
		'thumbnail_image-type',
		'thumbnail_gd-library',
		'thumbnail_image-missing',
	),
	'import' => array(
		'import',
		'importinterwiki',
		'import-interwiki-text',
		'import-interwiki-source',
		'import-interwiki-history',
		'import-interwiki-templates',
		'import-interwiki-submit',
		'import-interwiki-namespace',
		'import-upload-filename',
		'import-comment',
		'importtext',
		'importstart',
		'import-revision-count',
		'importnopages',
		'importfailed',
		'importunknownsource',
		'importcantopen',
		'importbadinterwiki',
		'importnotext',
		'importsuccess',
		'importhistoryconflict',
		'importnosources',
		'importnofile',
		'importuploaderrorsize',
		'importuploaderrorpartial',
		'importuploaderrortemp',
		'import-parse-failure',
		'import-noarticle',
		'import-nonewrevisions',
		'xml-error-string',
		'import-upload',
		'import-token-mismatch',
		'import-invalid-interwiki',
	),
	'importlog' => array(
		'importlogpage',
		'importlogpagetext',
		'import-logentry-upload',
		'import-logentry-upload-detail',
		'import-logentry-interwiki',
		'import-logentry-interwiki-detail',
	),
	'accesskeys' => array(
		'accesskey-pt-userpage',
		'accesskey-pt-anonuserpage',
		'accesskey-pt-mytalk',
		'accesskey-pt-anontalk',
		'accesskey-pt-preferences',
		'accesskey-pt-watchlist',
		'accesskey-pt-mycontris',
		'accesskey-pt-login',
		'accesskey-pt-anonlogin',
		'accesskey-pt-logout',
		'accesskey-ca-talk',
		'accesskey-ca-edit',
		'accesskey-ca-addsection',
		'accesskey-ca-viewsource',
		'accesskey-ca-history',
		'accesskey-ca-protect',
		'accesskey-ca-unprotect',
		'accesskey-ca-delete',
		'accesskey-ca-undelete',
		'accesskey-ca-move',
		'accesskey-ca-watch',
		'accesskey-ca-unwatch',
		'accesskey-search',
		'accesskey-search-go',
		'accesskey-search-fulltext',
		'accesskey-p-logo',
		'accesskey-n-mainpage',
		'accesskey-n-mainpage-description',
		'accesskey-n-portal',
		'accesskey-n-currentevents',
		'accesskey-n-recentchanges',
		'accesskey-n-randompage',
		'accesskey-n-help',
		'accesskey-t-whatlinkshere',
		'accesskey-t-recentchangeslinked',
		'accesskey-t-random',
		'accesskey-feed-rss',
		'accesskey-feed-atom',
		'accesskey-t-contributions',
		'accesskey-t-emailuser',
		'accesskey-t-permalink',
		'accesskey-t-print',
		'accesskey-t-upload',
		'accesskey-t-specialpages',
		'accesskey-ca-nstab-main',
		'accesskey-ca-nstab-user',
		'accesskey-ca-nstab-media',
		'accesskey-ca-nstab-special',
		'accesskey-ca-nstab-project',
		'accesskey-ca-nstab-image',
		'accesskey-ca-nstab-mediawiki',
		'accesskey-ca-nstab-template',
		'accesskey-ca-nstab-help',
		'accesskey-ca-nstab-category',
		'accesskey-minoredit',
		'accesskey-save',
		'accesskey-preview',
		'accesskey-diff',
		'accesskey-compareselectedversions',
		'accesskey-watch',
		'accesskey-upload',
	),
	'tooltips' => array(
		'tooltip-pt-userpage',
		'tooltip-pt-anonuserpage',
		'tooltip-pt-mytalk',
		'tooltip-pt-anontalk',
		'tooltip-pt-preferences',
		'tooltip-pt-watchlist',
		'tooltip-pt-mycontris',
		'tooltip-pt-login',
		'tooltip-pt-anonlogin',
		'tooltip-pt-logout',
		'tooltip-ca-talk',
		'tooltip-ca-edit',
		'tooltip-ca-addsection',
		'tooltip-ca-viewsource',
		'tooltip-ca-history',
		'tooltip-ca-protect',
		'tooltip-ca-unprotect',
		'tooltip-ca-delete',
		'tooltip-ca-undelete',
		'tooltip-ca-move',
		'tooltip-ca-watch',
		'tooltip-ca-unwatch',
		'tooltip-search',
		'tooltip-search-go',
		'tooltip-search-fulltext',
		'tooltip-p-logo',
		'tooltip-n-mainpage',
		'tooltip-n-mainpage-description',
		'tooltip-n-portal',
		'tooltip-n-currentevents',
		'tooltip-n-recentchanges',
		'tooltip-n-randompage',
		'tooltip-n-help',
		'tooltip-t-whatlinkshere',
		'tooltip-t-recentchangeslinked',
		'tooltip-t-random',
		'tooltip-feed-rss',
		'tooltip-feed-atom',
		'tooltip-t-contributions',
		'tooltip-t-emailuser',
		'tooltip-t-upload',
		'tooltip-t-specialpages',
		'tooltip-t-print',
		'tooltip-t-permalink',
		'tooltip-ca-nstab-main',
		'tooltip-ca-nstab-user',
		'tooltip-ca-nstab-media',
		'tooltip-ca-nstab-special',
		'tooltip-ca-nstab-project',
		'tooltip-ca-nstab-image',
		'tooltip-ca-nstab-mediawiki',
		'tooltip-ca-nstab-template',
		'tooltip-ca-nstab-help',
		'tooltip-ca-nstab-category',
		'tooltip-minoredit',
		'tooltip-save',
		'tooltip-preview',
		'tooltip-diff',
		'tooltip-compareselectedversions',
		'tooltip-watch',
		'tooltip-recreate',
		'tooltip-upload',
		'tooltip-rollback',
		'tooltip-undo',
	),
	'stylesheets' => array(
		'common.css',
		'standard.css',
		'nostalgia.css',
		'cologneblue.css',
		'monobook.css',
		'myskin.css',
		'chick.css',
		'simple.css',
		'modern.css',
		'vector.css',
		'print.css',
		'handheld.css',
	),
	'scripts' => array(
		'common.js',
		'standard.js',
		'nostalgia.js',
		'cologneblue.js',
		'monobook.js',
		'myskin.js',
		'chick.js',
		'simple.js',
		'modern.js',
		'vector.js',
	),
	'metadata_cc' => array(
		'nodublincore',
		'nocreativecommons',
		'notacceptable',
	),
	'attribution' => array(
		'anonymous',
		'siteuser',
		'anonuser',
		'lastmodifiedatby',
		'othercontribs',
		'others',
		'siteusers',
		'anonusers',
		'creditspage',
		'nocredits',
	),
	'spamprotection' => array(
		'spamprotectiontitle',
		'spamprotectiontext',
		'spamprotectionmatch',
		'spambot_username',
		'spam_reverting',
		'spam_blanking',
	),
	'info' => array(
		'infosubtitle',
		'numedits',
		'numtalkedits',
		'numwatchers',
		'numauthors',
		'numtalkauthors',
	),
	'skin' => array(
		'skinname-standard',
		'skinname-nostalgia',
		'skinname-cologneblue',
		'skinname-monobook',
		'skinname-myskin',
		'skinname-chick',
		'skinname-simple',
		'skinname-modern',
		'skinname-vector',
	),
	'math' => array(
		'mw_math_png',
		'mw_math_simple',
		'mw_math_html',
		'mw_math_source',
		'mw_math_modern',
		'mw_math_mathml',
	),
	'matherrors' => array(
		'math_failure',
		'math_unknown_error',
		'math_unknown_function',
		'math_lexing_error',
		'math_syntax_error',
		'math_image_error',
		'math_bad_tmpdir',
		'math_bad_output',
		'math_notexvc',
	),
	'patrolling' => array(
		'markaspatrolleddiff',
		'markaspatrolledlink',
		'markaspatrolledtext',
		'markedaspatrolled',
		'markedaspatrolledtext',
		'rcpatroldisabled',
		'rcpatroldisabledtext',
		'markedaspatrollederror',
		'markedaspatrollederrortext',
		'markedaspatrollederror-noautopatrol',
	),
	'patrol-log' => array(
		'patrol-log-page',
		'patrol-log-header',
		'patrol-log-line',
		'patrol-log-auto',
		'patrol-log-diff',
		'log-show-hide-patrol',
	),
	'imagedeletion' => array(
		'deletedrevision',
		'filedeleteerror-short',
		'filedeleteerror-long',
		'filedelete-missing',
		'filedelete-old-unregistered',
		'filedelete-current-unregistered',
		'filedelete-archive-read-only',
	),
	'browsediffs' => array(
		'previousdiff',
		'nextdiff',
	),
	'media-info' => array(
		'mediawarning',
		'imagemaxsize',
		'thumbsize',
		'widthheight',
		'widthheightpage',
		'file-info',
		'file-info-size',
		'file-nohires',
		'svg-long-desc',
		'show-big-image',
		'show-big-image-thumb',
		'file-info-gif-looped',
		'file-info-gif-frames',
	),
	'newfiles' => array(
		'newimages',
		'imagelisttext',
		'newimages-summary',
		'newimages-legend',
		'newimages-label',
		'showhidebots',
		'noimages',
		'ilsubmit',
		'bydate',
		'sp-newimages-showfrom',
	),
	'video-info' => array(
		'video-dims',
		'seconds-abbrev',
		'minutes-abbrev',
		'hours-abbrev',
	),
	'badimagelist' => array(
		'bad_image_list',
	),
	'variantname-zh' => array(
		'variantname-zh-hans',
		'variantname-zh-hant',
		'variantname-zh-cn',
		'variantname-zh-tw',
		'variantname-zh-hk',
		'variantname-zh-mo',
		'variantname-zh-sg',
		'variantname-zh-my',
		'variantname-zh',
	),
	'variantname-gan' => array(
		'variantname-gan-hans',
		'variantname-gan-hant',
		'variantname-gan',
	),
	'variantname-sr' => array(
		'variantname-sr-ec',
		'variantname-sr-el',
		'variantname-sr',
	),
	'variantname-kk' => array(
		'variantname-kk-kz',
		'variantname-kk-tr',
		'variantname-kk-cn',
		'variantname-kk-cyrl',
		'variantname-kk-latn',
		'variantname-kk-arab',
		'variantname-kk',
	),
	'variantname-ku' => array(
		'variantname-ku-arab',
		'variantname-ku-latn',
		'variantname-ku',
	),
	'variantname-tg' => array(
		'variantname-tg-cyrl',
		'variantname-tg-latn',
		'variantname-tg',
	),
	'metadata' => array(
		'metadata',
		'metadata-help',
		'metadata-expand',
		'metadata-collapse',
		'metadata-fields',
	),
	'exif' => array(
		'exif-imagewidth',
		'exif-imagelength',
		'exif-bitspersample',
		'exif-compression',
		'exif-photometricinterpretation',
		'exif-orientation',
		'exif-samplesperpixel',
		'exif-planarconfiguration',
		'exif-ycbcrsubsampling',
		'exif-ycbcrpositioning',
		'exif-xresolution',
		'exif-yresolution',
		'exif-resolutionunit',
		'exif-stripoffsets',
		'exif-rowsperstrip',
		'exif-stripbytecounts',
		'exif-jpeginterchangeformat',
		'exif-jpeginterchangeformatlength',
		'exif-transferfunction',
		'exif-whitepoint',
		'exif-primarychromaticities',
		'exif-ycbcrcoefficients',
		'exif-referenceblackwhite',
		'exif-datetime',
		'exif-imagedescription',
		'exif-make',
		'exif-model',
		'exif-software',
		'exif-artist',
		'exif-copyright',
		'exif-exifversion',
		'exif-flashpixversion',
		'exif-colorspace',
		'exif-componentsconfiguration',
		'exif-compressedbitsperpixel',
		'exif-pixelydimension',
		'exif-pixelxdimension',
		'exif-makernote',
		'exif-usercomment',
		'exif-relatedsoundfile',
		'exif-datetimeoriginal',
		'exif-datetimedigitized',
		'exif-subsectime',
		'exif-subsectimeoriginal',
		'exif-subsectimedigitized',
		'exif-exposuretime',
		'exif-exposuretime-format',
		'exif-fnumber',
		'exif-fnumber-format',
		'exif-exposureprogram',
		'exif-spectralsensitivity',
		'exif-isospeedratings',
		'exif-oecf',
		'exif-shutterspeedvalue',
		'exif-aperturevalue',
		'exif-brightnessvalue',
		'exif-exposurebiasvalue',
		'exif-maxaperturevalue',
		'exif-subjectdistance',
		'exif-meteringmode',
		'exif-lightsource',
		'exif-flash',
		'exif-focallength',
		'exif-focallength-format',
		'exif-subjectarea',
		'exif-flashenergy',
		'exif-spatialfrequencyresponse',
		'exif-focalplanexresolution',
		'exif-focalplaneyresolution',
		'exif-focalplaneresolutionunit',
		'exif-subjectlocation',
		'exif-exposureindex',
		'exif-sensingmethod',
		'exif-filesource',
		'exif-scenetype',
		'exif-cfapattern',
		'exif-customrendered',
		'exif-exposuremode',
		'exif-whitebalance',
		'exif-digitalzoomratio',
		'exif-focallengthin35mmfilm',
		'exif-scenecapturetype',
		'exif-gaincontrol',
		'exif-contrast',
		'exif-saturation',
		'exif-sharpness',
		'exif-devicesettingdescription',
		'exif-subjectdistancerange',
		'exif-imageuniqueid',
		'exif-gpsversionid',
		'exif-gpslatituderef',
		'exif-gpslatitude',
		'exif-gpslongituderef',
		'exif-gpslongitude',
		'exif-gpsaltituderef',
		'exif-gpsaltitude',
		'exif-gpstimestamp',
		'exif-gpssatellites',
		'exif-gpsstatus',
		'exif-gpsmeasuremode',
		'exif-gpsdop',
		'exif-gpsspeedref',
		'exif-gpsspeed',
		'exif-gpstrackref',
		'exif-gpstrack',
		'exif-gpsimgdirectionref',
		'exif-gpsimgdirection',
		'exif-gpsmapdatum',
		'exif-gpsdestlatituderef',
		'exif-gpsdestlatitude',
		'exif-gpsdestlongituderef',
		'exif-gpsdestlongitude',
		'exif-gpsdestbearingref',
		'exif-gpsdestbearing',
		'exif-gpsdestdistanceref',
		'exif-gpsdestdistance',
		'exif-gpsprocessingmethod',
		'exif-gpsareainformation',
		'exif-gpsdatestamp',
		'exif-gpsdifferential',
	),
	'exif-values' => array(
		'exif-make-value',
		'exif-model-value',
		'exif-software-value',
	),
	'exif-compression' => array(
		'exif-compression-1',
		'exif-compression-6',
	),
	'exif-photometricinterpretation' => array(
		'exif-photometricinterpretation-2',
		'exif-photometricinterpretation-6',
	),
	'exif-unknowndate' => array(
		'exif-unknowndate',
	),
	'exif-orientation' => array(
		'exif-orientation-1',
		'exif-orientation-2',
		'exif-orientation-3',
		'exif-orientation-4',
		'exif-orientation-5',
		'exif-orientation-6',
		'exif-orientation-7',
		'exif-orientation-8',
	),
	'exif-planarconfiguration' => array(
		'exif-planarconfiguration-1',
		'exif-planarconfiguration-2',
	),
	'exif-xyresolution' => array(
		'exif-xyresolution-i',
		'exif-xyresolution-c',
	),
	'exif-colorspace' => array(
		'exif-colorspace-1',
		'exif-colorspace-ffff.h',
	),
	'exif-componentsconfiguration' => array(
		'exif-componentsconfiguration-0',
		'exif-componentsconfiguration-1',
		'exif-componentsconfiguration-2',
		'exif-componentsconfiguration-3',
		'exif-componentsconfiguration-4',
		'exif-componentsconfiguration-5',
		'exif-componentsconfiguration-6',
	),
	'exif-exposureprogram' => array(
		'exif-exposureprogram-0',
		'exif-exposureprogram-1',
		'exif-exposureprogram-2',
		'exif-exposureprogram-3',
		'exif-exposureprogram-4',
		'exif-exposureprogram-5',
		'exif-exposureprogram-6',
		'exif-exposureprogram-7',
		'exif-exposureprogram-8',
	),
	'exif-subjectdistance-value' => array(
		'exif-subjectdistance-value',
	),
	'exif-meteringmode' => array(
		'exif-meteringmode-0',
		'exif-meteringmode-1',
		'exif-meteringmode-2',
		'exif-meteringmode-3',
		'exif-meteringmode-4',
		'exif-meteringmode-5',
		'exif-meteringmode-6',
		'exif-meteringmode-255',
	),
	'exif-lightsource' => array(
		'exif-lightsource-0',
		'exif-lightsource-1',
		'exif-lightsource-2',
		'exif-lightsource-3',
		'exif-lightsource-4',
		'exif-lightsource-9',
		'exif-lightsource-10',
		'exif-lightsource-11',
		'exif-lightsource-12',
		'exif-lightsource-13',
		'exif-lightsource-14',
		'exif-lightsource-15',
		'exif-lightsource-17',
		'exif-lightsource-18',
		'exif-lightsource-19',
		'exif-lightsource-20',
		'exif-lightsource-21',
		'exif-lightsource-22',
		'exif-lightsource-23',
		'exif-lightsource-24',
		'exif-lightsource-255',
	),
	'exif-flash' => array(
		'exif-flash-fired-0' ,
		'exif-flash-fired-1' ,
		'exif-flash-return-0' ,
		'exif-flash-return-2' ,
		'exif-flash-return-3' ,
		'exif-flash-mode-1' ,
		'exif-flash-mode-2' ,
		'exif-flash-mode-3' ,
		'exif-flash-function-1' ,
		'exif-flash-redeye-1' ,
	),
	'exif-focalplaneresolutionunit' => array(
		'exif-focalplaneresolutionunit-2',
	),
	'exif-sensingmethod' => array(
		'exif-sensingmethod-1',
		'exif-sensingmethod-2',
		'exif-sensingmethod-3',
		'exif-sensingmethod-4',
		'exif-sensingmethod-5',
		'exif-sensingmethod-7',
		'exif-sensingmethod-8',
	),
	'exif-filesource' => array(
		'exif-filesource-3',
	),
	'exif-scenetype' => array(
		'exif-scenetype-1',
	),
	'exif-customrendered' => array(
		'exif-customrendered-0',
		'exif-customrendered-1',
	),
	'exif-exposuremode' => array(
		'exif-exposuremode-0',
		'exif-exposuremode-1',
		'exif-exposuremode-2',
	),
	'exif-whitebalance' => array(
		'exif-whitebalance-0',
		'exif-whitebalance-1',
	),
	'exif-scenecapturetype' => array(
		'exif-scenecapturetype-0',
		'exif-scenecapturetype-1',
		'exif-scenecapturetype-2',
		'exif-scenecapturetype-3',
	),
	'exif-gaincontrol' => array(
		'exif-gaincontrol-0',
		'exif-gaincontrol-1',
		'exif-gaincontrol-2',
		'exif-gaincontrol-3',
		'exif-gaincontrol-4',
	),
	'exif-contrast' => array(
		'exif-contrast-0',
		'exif-contrast-1',
		'exif-contrast-2',
	),
	'exif-saturation' => array(
		'exif-saturation-0',
		'exif-saturation-1',
		'exif-saturation-2',
	),
	'exif-sharpness' => array(
		'exif-sharpness-0',
		'exif-sharpness-1',
		'exif-sharpness-2',
	),
	'exif-subjectdistancerange' => array(
		'exif-subjectdistancerange-0',
		'exif-subjectdistancerange-1',
		'exif-subjectdistancerange-2',
		'exif-subjectdistancerange-3',
	),
	'exif-gpslatitude' => array(
		'exif-gpslatitude-n',
		'exif-gpslatitude-s',
	),
	'exif-gpslongitude' => array(
		'exif-gpslongitude-e',
		'exif-gpslongitude-w',
	),
	'exif-gpsstatus' => array(
		'exif-gpsstatus-a',
		'exif-gpsstatus-v',
	),
	'exif-gpsmeasuremode' => array(
		'exif-gpsmeasuremode-2',
		'exif-gpsmeasuremode-3',
	),
	'exif-gpsspeed' => array(
		'exif-gpsspeed-k',
		'exif-gpsspeed-m',
		'exif-gpsspeed-n',
	),
	'exif-gpsdirection' => array(
		'exif-gpsdirection-t',
		'exif-gpsdirection-m',
	),
	'edit-externally' => array(
		'edit-externally',
		'edit-externally-help',
	),
	'all' => array(
		'recentchangesall',
		'imagelistall',
		'watchlistall2',
		'namespacesall',
		'monthsall',
		'limitall',
	),
	'confirmemail' => array(
		'confirmemail',
		'confirmemail_noemail',
		'confirmemail_text',
		'confirmemail_pending',
		'confirmemail_send',
		'confirmemail_sent',
		'confirmemail_oncreate',
		'confirmemail_sendfailed',
		'confirmemail_invalid',
		'confirmemail_needlogin',
		'confirmemail_success',
		'confirmemail_loggedin',
		'confirmemail_error',
		'confirmemail_subject',
		'confirmemail_body',
		'confirmemail_invalidated',
		'invalidateemail',
	),
	'scarytransclusion' => array(
		'scarytranscludedisabled',
		'scarytranscludefailed',
		'scarytranscludetoolong',
	),
	'trackbacks' => array(
		'trackbackbox',
		'trackback',
		'trackbackexcerpt',
		'trackbackremove',
		'trackbacklink',
		'trackbackdeleteok',
	),
	'deleteconflict' => array(
		'deletedwhileediting',
		'confirmrecreate',
		'recreate',
	),
	'unit-pixel' => array(
		'unit-pixel',
	),
	'purge' => array(
		'confirm_purge_button',
		'confirm-purge-top',
		'confirm-purge-bottom',
	),
	'separators' => array(
		'catseparator',
		'semicolon-separator',
		'comma-separator',
		'colon-separator',
		'autocomment-prefix',
		'pipe-separator',
		'word-separator',
		'ellipsis',
		'percent',
		'parentheses',
	),
	'imgmulti' => array(
		'imgmultipageprev',
		'imgmultipagenext',
		'imgmultigo',
		'imgmultigoto',
	),
	'tablepager' => array(
		'ascending_abbrev',
		'descending_abbrev',
		'table_pager_next',
		'table_pager_prev',
		'table_pager_first',
		'table_pager_last',
		'table_pager_limit',
		'table_pager_limit_submit',
		'table_pager_empty',
	),
	'autosumm' => array(
		'autosumm-blank',
		'autosumm-replace',
		'autoredircomment',
		'autosumm-new',
	),
	'autoblock_whitelist' => array(
		'autoblock_whitelist',
	),
	'sizeunits' => array(
		'size-bytes',
		'size-kilobytes',
		'size-megabytes',
		'size-gigabytes',
	),
	'livepreview' => array(
		'livepreview-loading',
		'livepreview-ready',
		'livepreview-failed',
		'livepreview-error',
	),
	'lagwarning' => array(
		'lag-warn-normal',
		'lag-warn-high',
	),
	'watchlisteditor' => array(
		'watchlistedit-numitems',
		'watchlistedit-noitems',
		'watchlistedit-normal-title',
		'watchlistedit-normal-legend',
		'watchlistedit-normal-explain',
		'watchlistedit-normal-submit',
		'watchlistedit-normal-done',
		'watchlistedit-raw-title',
		'watchlistedit-raw-legend',
		'watchlistedit-raw-explain',
		'watchlistedit-raw-titles',
		'watchlistedit-raw-submit',
		'watchlistedit-raw-done',
		'watchlistedit-raw-added',
		'watchlistedit-raw-removed',
	),
	'watchlisttools' => array(
		'watchlisttools-view',
		'watchlisttools-edit',
		'watchlisttools-raw',
	),
	'iranian-dates' => array(
		'iranian-calendar-m1',
		'iranian-calendar-m2',
		'iranian-calendar-m3',
		'iranian-calendar-m4',
		'iranian-calendar-m5',
		'iranian-calendar-m6',
		'iranian-calendar-m7',
		'iranian-calendar-m8',
		'iranian-calendar-m9',
		'iranian-calendar-m10',
		'iranian-calendar-m11',
		'iranian-calendar-m12',
	),
	'hijri-dates' => array(
		'hijri-calendar-m1',
		'hijri-calendar-m2',
		'hijri-calendar-m3',
		'hijri-calendar-m4',
		'hijri-calendar-m5',
		'hijri-calendar-m6',
		'hijri-calendar-m7',
		'hijri-calendar-m8',
		'hijri-calendar-m9',
		'hijri-calendar-m10',
		'hijri-calendar-m11',
		'hijri-calendar-m12',
	),
	'hebrew-dates' => array(
		'hebrew-calendar-m1',
		'hebrew-calendar-m2',
		'hebrew-calendar-m3',
		'hebrew-calendar-m4',
		'hebrew-calendar-m5',
		'hebrew-calendar-m6',
		'hebrew-calendar-m6a',
		'hebrew-calendar-m6b',
		'hebrew-calendar-m7',
		'hebrew-calendar-m8',
		'hebrew-calendar-m9',
		'hebrew-calendar-m10',
		'hebrew-calendar-m11',
		'hebrew-calendar-m12',
		'hebrew-calendar-m1-gen',
		'hebrew-calendar-m2-gen',
		'hebrew-calendar-m3-gen',
		'hebrew-calendar-m4-gen',
		'hebrew-calendar-m5-gen',
		'hebrew-calendar-m6-gen',
		'hebrew-calendar-m6a-gen',
		'hebrew-calendar-m6b-gen',
		'hebrew-calendar-m7-gen',
		'hebrew-calendar-m8-gen',
		'hebrew-calendar-m9-gen',
		'hebrew-calendar-m10-gen',
		'hebrew-calendar-m11-gen',
		'hebrew-calendar-m12-gen',
	),
	'signatures' => array(
		'signature',
		'signature-anon',
		'timezone-utc',
	),
	'CoreParserFunctions' => array(
		'unknown_extension_tag',
		'duplicate-defaultsort',
	),
	'version' => array(
		'version',
		'version-extensions',
		'version-specialpages',
		'version-parserhooks',
		'version-variables',
		'version-other',
		'version-mediahandlers',
		'version-hooks',
		'version-extension-functions',
		'version-parser-extensiontags',
		'version-parser-function-hooks',
		'version-skin-extension-functions',
		'version-hook-name',
		'version-hook-subscribedby',
		'version-version',
		'version-svn-revision',
		'version-license',
		'version-software',
		'version-software-product',
		'version-software-version',
	),
	'filepath' => array(
		'filepath',
		'filepath-page',
		'filepath-submit',
		'filepath-summary',
	),
	'fileduplicatesearch' => array(
		'fileduplicatesearch',
		'fileduplicatesearch-summary',
		'fileduplicatesearch-legend',
		'fileduplicatesearch-filename',
		'fileduplicatesearch-submit',
		'fileduplicatesearch-info',
		'fileduplicatesearch-result-1',
		'fileduplicatesearch-result-n',
	),
	'special-specialpages' => array(
		'specialpages',
		'specialpages-summary',
		'specialpages-note',
		'specialpages-group-maintenance',
		'specialpages-group-other',
		'specialpages-group-login',
		'specialpages-group-changes',
		'specialpages-group-media',
		'specialpages-group-users',
		'specialpages-group-highuse',
		'specialpages-group-pages',
		'specialpages-group-pagetools',
		'specialpages-group-wiki',
		'specialpages-group-redirects',
		'specialpages-group-spam',
	),
	'special-blank' => array(
		'blankpage',
		'intentionallyblankpage',
	),
	'external_images' => array(
		'external_image_whitelist',
	),
	'special-tags' => array(
		'tags',
		'tag-filter',
		'tag-filter-submit',
		'tags-title',
		'tags-intro',
		'tags-tag',
		'tags-display-header',
		'tags-description-header',
		'tags-hitcount-header',
		'tags-edit',
		'tags-hitcount',
	),
	'db-error-messages' => array(
		'dberr-header',
		'dberr-problems',
		'dberr-again',
		'dberr-info',
		'dberr-usegoogle',
		'dberr-outofdate',
		'dberr-cachederror',
	),
	'html-forms' => array(
		'htmlform-invalid-input',
		'htmlform-select-badoption',
		'htmlform-int-invalid',
		'htmlform-float-invalid',
		'htmlform-int-toolow',
		'htmlform-int-toohigh',
		'htmlform-submit',
		'htmlform-reset',
		'htmlform-selectorother-other',
	),
);

/** Comments for each block */
$wgBlockComments = array(
	'sidebar'             => "The sidebar for MonoBook is generated from this message, lines that do not
begin with * or ** are discarded, furthermore lines that do begin with ** and
do not contain | are also discarded, but do not depend on this behaviour for
future releases. Also note that since each list value is wrapped in a unique
XHTML id it should only appear once and include characters that are legal
XHTML id names.",
	'toggles'             => 'User preference toggles',
	'underline'           => '',
	'editfont'            => 'Font style option in Special:Preferences',
	'dates'               => 'Dates',
	'categorypages'       => 'Categories related messages',
	'mainpage'            => '',
	'miscellaneous1'      => '',
	'cologneblue'         => 'Cologne Blue skin',
	'vector'              => 'Vector skin',
	'miscellaneous2'      => '',
	'links'               => 'All link text and link target definitions of links into project namespace that get used by other message strings, with the exception of user group pages (see grouppage) and the disambiguation template definition (see disambiguations).',
	'badaccess'           => '',
	'versionrequired'     => '',
	'miscellaneous3'      => '',
	'nstab'               => "Short words for each namespace, by default used in the namespace tab in monobook",
	'main'                => 'Main script and global functions',
	'errors'              => 'General errors',
	'virus'               => 'Virus scanner',
	'login'               => 'Login and logout pages',
	'resetpass'           => 'Password reset dialog',
	'toolbar'             => 'Edit page toolbar',
	'edit'                => 'Edit pages',
	'parserwarnings'      => 'Parser/template warnings',
	'undo'                => '"Undo" feature',
	'cantcreateaccount'   => 'Account creation failure',
	'history'             => 'History pages',
	'history-feed'        => 'Revision feed',
	'revdelete'           => 'Revision deletion',
	'suppression'         => 'Suppression log',
	'mergehistory'        => 'History merging',
	'mergelog'            => 'Merge log',
	'diffs'               => 'Diffs',
	'search'              => 'Search results',
	'opensearch'          => 'OpenSearch description',
	'quickbar'            => 'Quickbar',
	'preferences'         => 'Preferences page',
	'userrights'          => 'User rights',
	'group'               => 'Groups',
	'group-member'        => '',
	'grouppage'           => '',
	'right'               => 'Rights',
	'action'              => 'Associated actions - in the sentence "You do not have permission to X"',
	'rightslog'           => 'User rights log',
	'recentchanges'       => 'Recent changes',
	'recentchangeslinked' => 'Recent changes linked',
	'upload'              => 'Upload',
	'upload-errors'       => '',
	'img-auth'            => 'img_auth script messages',
	'http-errors'         => 'HTTP errors',
	'upload-curl-errors'  => 'Some likely curl errors. More could be added from <http://curl.haxx.se/libcurl/c/libcurl-errors.html>',
	'licenses'            => '',
	'filelist'            => 'Special:ListFiles',
	'filedescription'     => 'File description page',
	'filerevert'          => 'File reversion',
	'filedelete'          => 'File deletion',
	'mimesearch'          => 'MIME search',
	'unwatchedpages'      => 'Unwatched pages',
	'listredirects'       => 'List redirects',
	'unusedtemplates'     => 'Unused templates',
	'randompage'          => 'Random page',
	'randomredirect'      => 'Random redirect',
	'statistics'          => 'Statistics',
	'disambiguations'     => '',
	'doubleredirects'     => '',
	'brokenredirects'     => '',
	'withoutinterwiki'    => '',
	'fewestrevisions'     => '',
	'specialpages'        => 'Miscellaneous special pages',
	'booksources'         => 'Book sources',
	'magicwords'          => 'Magic words',
	'logpages'            => 'Special:Log',
	'allpages'            => 'Special:AllPages',
	'categories'          => 'Special:Categories',
	'deletedcontribs'     => 'Special:DeletedContributions',
	'linksearch'          => 'Special:LinkSearch',
	'listusers'           => 'Special:ListUsers',
	'activeusers'         => 'Special:ActiveUsers',
	'newuserlog'          => 'Special:Log/newusers',
	'listgrouprights'     => 'Special:ListGroupRights',
	'emailuser'           => 'E-mail user',
	'watchlist'           => 'Watchlist',
	'watching'            => 'Displayed when you click the "watch" button and it is in the process of watching',
	'enotif'              => '',
	'delete'              => 'Delete',
	'rollback'            => 'Rollback',
	'protect'             => 'Protect',
	'restrictions'        => 'Restrictions (nouns)',
	'restriction-levels'  => 'Restriction levels',
	'undelete'            => 'Undelete',
	'nsform'              => 'Namespace form on various pages',
	'contributions'       => 'Contributions',
	'sp-contributions'    => '',
	'whatlinkshere'       => 'What links here',
	'block'               => 'Block/unblock',
	'developertools'      => 'Developer tools',
	'movepage'            => 'Move page',
	'export'              => 'Export',
	'allmessages'         => 'Namespace 8 related',
	'thumbnails'          => 'Thumbnails',
	'import'              => 'Special:Import',
	'importlog'           => 'Import log',
	'accesskeys'          => 'Keyboard access keys for power users',
	'tooltips'            => 'Tooltip help for the actions',
	'stylesheets'         => 'Stylesheets',
	'scripts'             => 'Scripts',
	'metadata_cc'         => 'Metadata',
	'attribution'         => 'Attribution',
	'spamprotection'      => 'Spam protection',
	'info'                => 'Info page',
	'skin'                => 'Skin names',
	'math'                => 'Math options',
	'matherrors'          => 'Math errors',
	'patrolling'          => 'Patrolling',
	'patrol-log'          => 'Patrol log',
	'imagedeletion'       => 'Image deletion',
	'browsediffs'         => 'Browsing diffs',
	'newfiles'           => 'Special:NewFiles',
	'video-info'          => 'Video information, used by Language::formatTimePeriod() to format lengths in the above messages',
	'badimagelist'        => 'Bad image list',
	'variantname-zh'      => "Short names for language variants used for language conversion links.
To disable showing a particular link, set it to 'disable', e.g.
'variantname-zh-sg' => 'disable',
Variants for Chinese language",
	'variantname-gan'      => 'Variants for Gan language',
	'variantname-sr'      => 'Variants for Serbian language',
	'variantname-kk'      => 'Variants for Kazakh language',
	'variantname-ku'      => 'Variants for Kurdish language',
	'variantname-tg'      => 'Variants for Tajiki language',
	'media-info'          => 'Media information',
	'metadata'            => 'Metadata',
	'exif'                           => 'EXIF tags',
	'exif-values'                    => 'Make & model, can be wikified in order to link to the camera and model name',
	'exif-compression'               => 'EXIF attributes',
	'exif-unknowndate'               => '',
	'exif-photometricinterpretation' => '',
	'exif-orientation'               => '',
	'exif-planarconfiguration'       => '',
	'exif-xyresolution'              => '',
	'exif-colorspace'                => '',
	'exif-componentsconfiguration'   => '',
	'exif-exposureprogram'           => '',
	'exif-subjectdistance-value'     => '',
	'exif-meteringmode'              => '',
	'exif-lightsource'               => '',
	'exif-flash'                     => 'Flash modes',
	'exif-focalplaneresolutionunit'  => '',
	'exif-sensingmethod'             => '',
	'exif-filesource'                => '',
	'exif-scenetype'                 => '',
	'exif-customrendered'            => '',
	'exif-exposuremode'              => '',
	'exif-whitebalance'              => '',
	'exif-scenecapturetype'          => '',
	'exif-gaincontrol'               => '',
	'exif-contrast'                  => '',
	'exif-saturation'                => '',
	'exif-sharpness'                 => '',
	'exif-subjectdistancerange'      => '',
	'exif-gpslatitude'               => 'Pseudotags used for GPSLatitudeRef and GPSDestLatitudeRef',
	'exif-gpslongitude'              => 'Pseudotags used for GPSLongitudeRef and GPSDestLongitudeRef',
	'exif-gpsstatus'                 => '',
	'exif-gpsmeasuremode'            => '',
	'exif-gpsspeed'                  => 'Pseudotags used for GPSSpeedRef',
	'exif-gpsdirection'              => 'Pseudotags used for GPSTrackRef, GPSImgDirectionRef and GPSDestBearingRef',
	'edit-externally'       => 'External editor support',
	'all'                   => "'all' in various places, this might be different for inflected languages",
	'confirmemail'          => 'E-mail address confirmation',
	'scarytransclusion'     => 'Scary transclusion',
	'trackbacks'            => 'Trackbacks',
	'deleteconflict'        => 'Delete conflict',
	'unit-pixel'            => '',
	'purge'                 => 'action=purge',
	'separators'            => 'Separators for various lists, etc.',
	'imgmulti'              => 'Multipage image navigation',
	'tablepager'            => 'Table pager',
	'autosumm'              => 'Auto-summaries',
	'autoblock_whitelist'   => 'Autoblock whitelist',
	'sizeunits'             => 'Size units',
	'livepreview'           => 'Live preview',
	'lagwarning'            => 'Friendlier slave lag warnings',
	'watchlisteditor'       => 'Watchlist editor',
	'watchlisttools'        => 'Watchlist editing tools',
	'iranian-dates'         => 'Iranian month names',
	'hijri-dates'           => 'Hijri month names',
	'hebrew-dates'          => 'Hebrew month names',
	'signatures'            => 'Signatures',
	'CoreParserFunctions'   => 'Core parser functions',
	'version'               => 'Special:Version',
	'filepath'              => 'Special:FilePath',
	'fileduplicatesearch'   => 'Special:FileDuplicateSearch',
	'special-specialpages'  => 'Special:SpecialPages',
	'special-blank'         => 'Special:BlankPage',
	'external_images'       => 'External image whitelist',
	'special-tags'          => 'Special:Tags',
	'db-error-messages'     => 'Database error messages',
	'html-forms'            => 'HTML forms',
);
