/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_libnetapi.h"

_PUBLIC_ enum ndr_err_code ndr_push_NET_API_STATUS(struct ndr_push *ndr, int ndr_flags, enum NET_API_STATUS r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NET_API_STATUS(struct ndr_pull *ndr, int ndr_flags, enum NET_API_STATUS *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NET_API_STATUS(struct ndr_print *ndr, const char *name, enum NET_API_STATUS r)
{
	const char *val = NULL;

	switch (r) {
		case NERR_Success: val = "NERR_Success"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_domsid(struct ndr_push *ndr, int ndr_flags, const struct domsid *r)
{
	uint32_t cntr_sub_auths_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sid_rev_num));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->num_auths));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->id_auth, 6));
		for (cntr_sub_auths_0 = 0; cntr_sub_auths_0 < MAXSUBAUTHS; cntr_sub_auths_0++) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sub_auths[cntr_sub_auths_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_domsid(struct ndr_pull *ndr, int ndr_flags, struct domsid *r)
{
	uint32_t cntr_sub_auths_0;
	TALLOC_CTX *_mem_save_sub_auths_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sid_rev_num));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->num_auths));
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->id_auth, 6));
		NDR_PULL_ALLOC_N(ndr, r->sub_auths, MAXSUBAUTHS);
		_mem_save_sub_auths_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->sub_auths, 0);
		for (cntr_sub_auths_0 = 0; cntr_sub_auths_0 < MAXSUBAUTHS; cntr_sub_auths_0++) {
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sub_auths[cntr_sub_auths_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sub_auths_0, 0);
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_domsid(struct ndr_print *ndr, const char *name, const struct domsid *r)
{
	uint32_t cntr_sub_auths_0;
	ndr_print_struct(ndr, name, "domsid");
	ndr->depth++;
	ndr_print_uint8(ndr, "sid_rev_num", r->sid_rev_num);
	ndr_print_uint8(ndr, "num_auths", r->num_auths);
	ndr_print_array_uint8(ndr, "id_auth", r->id_auth, 6);
	ndr->print(ndr, "%s: ARRAY(%d)", "sub_auths", (int)MAXSUBAUTHS);
	ndr->depth++;
	for (cntr_sub_auths_0=0;cntr_sub_auths_0<MAXSUBAUTHS;cntr_sub_auths_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_sub_auths_0) != -1) {
			ndr_print_uint32(ndr, "sub_auths", r->sub_auths[cntr_sub_auths_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_NetJoinFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NetJoinFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NetJoinFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_JOIN_DOMAIN", NETSETUP_JOIN_DOMAIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_ACCT_CREATE", NETSETUP_ACCT_CREATE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_ACCT_DELETE", NETSETUP_ACCT_DELETE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_WIN9X_UPGRADE", NETSETUP_WIN9X_UPGRADE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_DOMAIN_JOIN_IF_JOINED", NETSETUP_DOMAIN_JOIN_IF_JOINED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_JOIN_UNSECURE", NETSETUP_JOIN_UNSECURE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_MACHINE_PWD_PASSED", NETSETUP_MACHINE_PWD_PASSED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_DEFER_SPN_SET", NETSETUP_DEFER_SPN_SET, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_JOIN_DC_ACCOUNT", NETSETUP_JOIN_DC_ACCOUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_JOIN_WITH_NEW_NAME", NETSETUP_JOIN_WITH_NEW_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_INSTALL_INVOCATION", NETSETUP_INSTALL_INVOCATION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NETSETUP_IGNORE_UNSUPPORTED_FLAGS", NETSETUP_IGNORE_UNSUPPORTED_FLAGS, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_100(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_100 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv100_platform_id));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv100_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_100(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_100 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv100_platform_id));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv100_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_100(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_100 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_100");
	ndr->depth++;
	ndr_print_uint32(ndr, "sv100_platform_id", r->sv100_platform_id);
	ndr_print_string(ndr, "sv100_name", r->sv100_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_101(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_101 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv101_platform_id));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv101_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv101_version_major));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv101_version_minor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv101_type));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv101_comment));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_101(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_101 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv101_platform_id));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv101_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv101_version_major));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv101_version_minor));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv101_type));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv101_comment));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_101(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_101 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_101");
	ndr->depth++;
	ndr_print_uint32(ndr, "sv101_platform_id", r->sv101_platform_id);
	ndr_print_string(ndr, "sv101_name", r->sv101_name);
	ndr_print_uint32(ndr, "sv101_version_major", r->sv101_version_major);
	ndr_print_uint32(ndr, "sv101_version_minor", r->sv101_version_minor);
	ndr_print_uint32(ndr, "sv101_type", r->sv101_type);
	ndr_print_string(ndr, "sv101_comment", r->sv101_comment);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_102(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_102 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_platform_id));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv102_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_version_major));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_version_minor));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_type));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv102_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_users));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_disc));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->sv102_hidden));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_announce));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_anndelta));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sv102_licenses));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv102_userpath));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_102(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_102 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_platform_id));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv102_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_version_major));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_version_minor));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_type));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv102_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_users));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_disc));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->sv102_hidden));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_announce));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_anndelta));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sv102_licenses));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv102_userpath));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_102(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_102 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_102");
	ndr->depth++;
	ndr_print_uint32(ndr, "sv102_platform_id", r->sv102_platform_id);
	ndr_print_string(ndr, "sv102_name", r->sv102_name);
	ndr_print_uint32(ndr, "sv102_version_major", r->sv102_version_major);
	ndr_print_uint32(ndr, "sv102_version_minor", r->sv102_version_minor);
	ndr_print_uint32(ndr, "sv102_type", r->sv102_type);
	ndr_print_string(ndr, "sv102_comment", r->sv102_comment);
	ndr_print_uint32(ndr, "sv102_users", r->sv102_users);
	ndr_print_uint32(ndr, "sv102_disc", r->sv102_disc);
	ndr_print_uint8(ndr, "sv102_hidden", r->sv102_hidden);
	ndr_print_uint32(ndr, "sv102_announce", r->sv102_announce);
	ndr_print_uint32(ndr, "sv102_anndelta", r->sv102_anndelta);
	ndr_print_uint32(ndr, "sv102_licenses", r->sv102_licenses);
	ndr_print_string(ndr, "sv102_userpath", r->sv102_userpath);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVER_INFO_1005(struct ndr_push *ndr, int ndr_flags, const struct SERVER_INFO_1005 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->sv1005_comment));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVER_INFO_1005(struct ndr_pull *ndr, int ndr_flags, struct SERVER_INFO_1005 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->sv1005_comment));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVER_INFO_1005(struct ndr_print *ndr, const char *name, const struct SERVER_INFO_1005 *r)
{
	ndr_print_struct(ndr, name, "SERVER_INFO_1005");
	ndr->depth++;
	ndr_print_string(ndr, "sv1005_comment", r->sv1005_comment);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_DOMAIN_CONTROLLER_INFO(struct ndr_push *ndr, int ndr_flags, const struct DOMAIN_CONTROLLER_INFO *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_controller_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_controller_address));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->domain_controller_address_type));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->domain_guid));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->domain_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->dns_forest_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->dc_site_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->client_site_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_DOMAIN_CONTROLLER_INFO(struct ndr_pull *ndr, int ndr_flags, struct DOMAIN_CONTROLLER_INFO *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_controller_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_controller_address));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->domain_controller_address_type));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->domain_guid));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->domain_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->dns_forest_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->dc_site_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->client_site_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_DOMAIN_CONTROLLER_INFO(struct ndr_print *ndr, const char *name, const struct DOMAIN_CONTROLLER_INFO *r)
{
	ndr_print_struct(ndr, name, "DOMAIN_CONTROLLER_INFO");
	ndr->depth++;
	ndr_print_string(ndr, "domain_controller_name", r->domain_controller_name);
	ndr_print_string(ndr, "domain_controller_address", r->domain_controller_address);
	ndr_print_uint32(ndr, "domain_controller_address_type", r->domain_controller_address_type);
	ndr_print_GUID(ndr, "domain_guid", &r->domain_guid);
	ndr_print_string(ndr, "domain_name", r->domain_name);
	ndr_print_string(ndr, "dns_forest_name", r->dns_forest_name);
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr_print_string(ndr, "dc_site_name", r->dc_site_name);
	ndr_print_string(ndr, "client_site_name", r->client_site_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_0(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri0_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_0(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri0_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_0(struct ndr_print *ndr, const char *name, const struct USER_INFO_0 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_0");
	ndr->depth++;
	ndr_print_string(ndr, "usri0_name", r->usri0_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_password));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1_password_age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1_priv));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_script_path));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_password));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1_password_age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1_priv));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_script_path));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1(struct ndr_print *ndr, const char *name, const struct USER_INFO_1 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1");
	ndr->depth++;
	ndr_print_string(ndr, "usri1_name", r->usri1_name);
	ndr_print_string(ndr, "usri1_password", r->usri1_password);
	ndr_print_uint32(ndr, "usri1_password_age", r->usri1_password_age);
	ndr_print_uint32(ndr, "usri1_priv", r->usri1_priv);
	ndr_print_string(ndr, "usri1_home_dir", r->usri1_home_dir);
	ndr_print_string(ndr, "usri1_comment", r->usri1_comment);
	ndr_print_uint32(ndr, "usri1_flags", r->usri1_flags);
	ndr_print_string(ndr, "usri1_script_path", r->usri1_script_path);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_2(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_2 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_password));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_password_age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_priv));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_script_path));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_auth_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_parms));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_workstations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_last_logon));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_last_logoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_acct_expires));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_max_storage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri2_logon_hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_bad_pw_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_num_logons));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_logon_server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_country_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_code_page));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri2_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usri2_logon_hours));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_2(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_2 *r)
{
	uint32_t _ptr_usri2_logon_hours;
	TALLOC_CTX *_mem_save_usri2_logon_hours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_password));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_password_age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_priv));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_script_path));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_auth_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_parms));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_workstations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_last_logon));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_last_logoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_acct_expires));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_max_storage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri2_logon_hours));
		if (_ptr_usri2_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usri2_logon_hours);
		} else {
			r->usri2_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_bad_pw_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_num_logons));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_logon_server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_country_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_code_page));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri2_logon_hours) {
			_mem_save_usri2_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri2_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usri2_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri2_logon_hours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_2(struct ndr_print *ndr, const char *name, const struct USER_INFO_2 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_2");
	ndr->depth++;
	ndr_print_string(ndr, "usri2_name", r->usri2_name);
	ndr_print_string(ndr, "usri2_password", r->usri2_password);
	ndr_print_uint32(ndr, "usri2_password_age", r->usri2_password_age);
	ndr_print_uint32(ndr, "usri2_priv", r->usri2_priv);
	ndr_print_string(ndr, "usri2_home_dir", r->usri2_home_dir);
	ndr_print_string(ndr, "usri2_comment", r->usri2_comment);
	ndr_print_uint32(ndr, "usri2_flags", r->usri2_flags);
	ndr_print_string(ndr, "usri2_script_path", r->usri2_script_path);
	ndr_print_uint32(ndr, "usri2_auth_flags", r->usri2_auth_flags);
	ndr_print_string(ndr, "usri2_full_name", r->usri2_full_name);
	ndr_print_string(ndr, "usri2_usr_comment", r->usri2_usr_comment);
	ndr_print_string(ndr, "usri2_parms", r->usri2_parms);
	ndr_print_string(ndr, "usri2_workstations", r->usri2_workstations);
	ndr_print_uint32(ndr, "usri2_last_logon", r->usri2_last_logon);
	ndr_print_uint32(ndr, "usri2_last_logoff", r->usri2_last_logoff);
	ndr_print_uint32(ndr, "usri2_acct_expires", r->usri2_acct_expires);
	ndr_print_uint32(ndr, "usri2_max_storage", r->usri2_max_storage);
	ndr_print_uint32(ndr, "usri2_units_per_week", r->usri2_units_per_week);
	ndr_print_ptr(ndr, "usri2_logon_hours", r->usri2_logon_hours);
	ndr->depth++;
	if (r->usri2_logon_hours) {
		ndr_print_uint8(ndr, "usri2_logon_hours", *r->usri2_logon_hours);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usri2_bad_pw_count", r->usri2_bad_pw_count);
	ndr_print_uint32(ndr, "usri2_num_logons", r->usri2_num_logons);
	ndr_print_string(ndr, "usri2_logon_server", r->usri2_logon_server);
	ndr_print_uint32(ndr, "usri2_country_code", r->usri2_country_code);
	ndr_print_uint32(ndr, "usri2_code_page", r->usri2_code_page);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_3(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_3 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_password_age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_priv));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_script_path));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_auth_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_parms));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_workstations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_last_logon));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_last_logoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_acct_expires));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_max_storage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri3_logon_hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_bad_pw_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_num_logons));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_logon_server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_country_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_code_page));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_user_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_primary_group_id));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_profile));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri3_home_dir_drive));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri3_password_expired));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri3_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usri3_logon_hours));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_3(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_3 *r)
{
	uint32_t _ptr_usri3_logon_hours;
	TALLOC_CTX *_mem_save_usri3_logon_hours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_password_age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_priv));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_script_path));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_auth_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_parms));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_workstations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_last_logon));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_last_logoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_acct_expires));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_max_storage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri3_logon_hours));
		if (_ptr_usri3_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usri3_logon_hours);
		} else {
			r->usri3_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_bad_pw_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_num_logons));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_logon_server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_country_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_code_page));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_user_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_primary_group_id));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_profile));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri3_home_dir_drive));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri3_password_expired));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri3_logon_hours) {
			_mem_save_usri3_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri3_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usri3_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri3_logon_hours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_3(struct ndr_print *ndr, const char *name, const struct USER_INFO_3 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_3");
	ndr->depth++;
	ndr_print_string(ndr, "usri3_name", r->usri3_name);
	ndr_print_uint32(ndr, "usri3_password_age", r->usri3_password_age);
	ndr_print_uint32(ndr, "usri3_priv", r->usri3_priv);
	ndr_print_string(ndr, "usri3_home_dir", r->usri3_home_dir);
	ndr_print_string(ndr, "usri3_comment", r->usri3_comment);
	ndr_print_uint32(ndr, "usri3_flags", r->usri3_flags);
	ndr_print_string(ndr, "usri3_script_path", r->usri3_script_path);
	ndr_print_uint32(ndr, "usri3_auth_flags", r->usri3_auth_flags);
	ndr_print_string(ndr, "usri3_full_name", r->usri3_full_name);
	ndr_print_string(ndr, "usri3_usr_comment", r->usri3_usr_comment);
	ndr_print_string(ndr, "usri3_parms", r->usri3_parms);
	ndr_print_string(ndr, "usri3_workstations", r->usri3_workstations);
	ndr_print_uint32(ndr, "usri3_last_logon", r->usri3_last_logon);
	ndr_print_uint32(ndr, "usri3_last_logoff", r->usri3_last_logoff);
	ndr_print_uint32(ndr, "usri3_acct_expires", r->usri3_acct_expires);
	ndr_print_uint32(ndr, "usri3_max_storage", r->usri3_max_storage);
	ndr_print_uint32(ndr, "usri3_units_per_week", r->usri3_units_per_week);
	ndr_print_ptr(ndr, "usri3_logon_hours", r->usri3_logon_hours);
	ndr->depth++;
	if (r->usri3_logon_hours) {
		ndr_print_uint8(ndr, "usri3_logon_hours", *r->usri3_logon_hours);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usri3_bad_pw_count", r->usri3_bad_pw_count);
	ndr_print_uint32(ndr, "usri3_num_logons", r->usri3_num_logons);
	ndr_print_string(ndr, "usri3_logon_server", r->usri3_logon_server);
	ndr_print_uint32(ndr, "usri3_country_code", r->usri3_country_code);
	ndr_print_uint32(ndr, "usri3_code_page", r->usri3_code_page);
	ndr_print_uint32(ndr, "usri3_user_id", r->usri3_user_id);
	ndr_print_uint32(ndr, "usri3_primary_group_id", r->usri3_primary_group_id);
	ndr_print_string(ndr, "usri3_profile", r->usri3_profile);
	ndr_print_string(ndr, "usri3_home_dir_drive", r->usri3_home_dir_drive);
	ndr_print_uint32(ndr, "usri3_password_expired", r->usri3_password_expired);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_4(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_4 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_password));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_password_age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_priv));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_script_path));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_auth_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_parms));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_workstations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_last_logon));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_last_logoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_acct_expires));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_max_storage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri4_logon_hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_bad_pw_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_num_logons));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_logon_server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_country_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_code_page));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri4_user_sid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_primary_group_id));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_profile));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri4_home_dir_drive));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri4_password_expired));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri4_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usri4_logon_hours));
		}
		if (r->usri4_user_sid) {
			NDR_CHECK(ndr_push_domsid(ndr, NDR_SCALARS, r->usri4_user_sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_4(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_4 *r)
{
	uint32_t _ptr_usri4_logon_hours;
	TALLOC_CTX *_mem_save_usri4_logon_hours_0;
	uint32_t _ptr_usri4_user_sid;
	TALLOC_CTX *_mem_save_usri4_user_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_password));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_password_age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_priv));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_script_path));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_auth_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_parms));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_workstations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_last_logon));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_last_logoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_acct_expires));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_max_storage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri4_logon_hours));
		if (_ptr_usri4_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usri4_logon_hours);
		} else {
			r->usri4_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_bad_pw_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_num_logons));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_logon_server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_country_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_code_page));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri4_user_sid));
		if (_ptr_usri4_user_sid) {
			NDR_PULL_ALLOC(ndr, r->usri4_user_sid);
		} else {
			r->usri4_user_sid = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_primary_group_id));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_profile));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri4_home_dir_drive));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri4_password_expired));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri4_logon_hours) {
			_mem_save_usri4_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri4_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usri4_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri4_logon_hours_0, 0);
		}
		if (r->usri4_user_sid) {
			_mem_save_usri4_user_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri4_user_sid, 0);
			NDR_CHECK(ndr_pull_domsid(ndr, NDR_SCALARS, r->usri4_user_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri4_user_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_4(struct ndr_print *ndr, const char *name, const struct USER_INFO_4 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_4");
	ndr->depth++;
	ndr_print_string(ndr, "usri4_name", r->usri4_name);
	ndr_print_string(ndr, "usri4_password", r->usri4_password);
	ndr_print_uint32(ndr, "usri4_password_age", r->usri4_password_age);
	ndr_print_uint32(ndr, "usri4_priv", r->usri4_priv);
	ndr_print_string(ndr, "usri4_home_dir", r->usri4_home_dir);
	ndr_print_string(ndr, "usri4_comment", r->usri4_comment);
	ndr_print_uint32(ndr, "usri4_flags", r->usri4_flags);
	ndr_print_string(ndr, "usri4_script_path", r->usri4_script_path);
	ndr_print_uint32(ndr, "usri4_auth_flags", r->usri4_auth_flags);
	ndr_print_string(ndr, "usri4_full_name", r->usri4_full_name);
	ndr_print_string(ndr, "usri4_usr_comment", r->usri4_usr_comment);
	ndr_print_string(ndr, "usri4_parms", r->usri4_parms);
	ndr_print_string(ndr, "usri4_workstations", r->usri4_workstations);
	ndr_print_uint32(ndr, "usri4_last_logon", r->usri4_last_logon);
	ndr_print_uint32(ndr, "usri4_last_logoff", r->usri4_last_logoff);
	ndr_print_uint32(ndr, "usri4_acct_expires", r->usri4_acct_expires);
	ndr_print_uint32(ndr, "usri4_max_storage", r->usri4_max_storage);
	ndr_print_uint32(ndr, "usri4_units_per_week", r->usri4_units_per_week);
	ndr_print_ptr(ndr, "usri4_logon_hours", r->usri4_logon_hours);
	ndr->depth++;
	if (r->usri4_logon_hours) {
		ndr_print_uint8(ndr, "usri4_logon_hours", *r->usri4_logon_hours);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usri4_bad_pw_count", r->usri4_bad_pw_count);
	ndr_print_uint32(ndr, "usri4_num_logons", r->usri4_num_logons);
	ndr_print_string(ndr, "usri4_logon_server", r->usri4_logon_server);
	ndr_print_uint32(ndr, "usri4_country_code", r->usri4_country_code);
	ndr_print_uint32(ndr, "usri4_code_page", r->usri4_code_page);
	ndr_print_ptr(ndr, "usri4_user_sid", r->usri4_user_sid);
	ndr->depth++;
	if (r->usri4_user_sid) {
		ndr_print_domsid(ndr, "usri4_user_sid", r->usri4_user_sid);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usri4_primary_group_id", r->usri4_primary_group_id);
	ndr_print_string(ndr, "usri4_profile", r->usri4_profile);
	ndr_print_string(ndr, "usri4_home_dir_drive", r->usri4_home_dir_drive);
	ndr_print_uint32(ndr, "usri4_password_expired", r->usri4_password_expired);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_10(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_10 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri10_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri10_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri10_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri10_full_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_10(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_10 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri10_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri10_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri10_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri10_full_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_10(struct ndr_print *ndr, const char *name, const struct USER_INFO_10 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_10");
	ndr->depth++;
	ndr_print_string(ndr, "usri10_name", r->usri10_name);
	ndr_print_string(ndr, "usri10_comment", r->usri10_comment);
	ndr_print_string(ndr, "usri10_usr_comment", r->usri10_usr_comment);
	ndr_print_string(ndr, "usri10_full_name", r->usri10_full_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_11(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_11 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_full_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_priv));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_auth_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_password_age));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_parms));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_last_logon));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_last_logoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_bad_pw_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_num_logons));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_logon_server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_country_code));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri11_workstations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_max_storage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri11_logon_hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri11_code_page));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri11_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usri11_logon_hours));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_11(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_11 *r)
{
	uint32_t _ptr_usri11_logon_hours;
	TALLOC_CTX *_mem_save_usri11_logon_hours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_full_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_priv));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_auth_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_password_age));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_parms));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_last_logon));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_last_logoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_bad_pw_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_num_logons));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_logon_server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_country_code));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri11_workstations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_max_storage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri11_logon_hours));
		if (_ptr_usri11_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usri11_logon_hours);
		} else {
			r->usri11_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri11_code_page));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri11_logon_hours) {
			_mem_save_usri11_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri11_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usri11_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri11_logon_hours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_11(struct ndr_print *ndr, const char *name, const struct USER_INFO_11 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_11");
	ndr->depth++;
	ndr_print_string(ndr, "usri11_name", r->usri11_name);
	ndr_print_string(ndr, "usri11_comment", r->usri11_comment);
	ndr_print_string(ndr, "usri11_usr_comment", r->usri11_usr_comment);
	ndr_print_string(ndr, "usri11_full_name", r->usri11_full_name);
	ndr_print_uint32(ndr, "usri11_priv", r->usri11_priv);
	ndr_print_uint32(ndr, "usri11_auth_flags", r->usri11_auth_flags);
	ndr_print_uint32(ndr, "usri11_password_age", r->usri11_password_age);
	ndr_print_string(ndr, "usri11_home_dir", r->usri11_home_dir);
	ndr_print_string(ndr, "usri11_parms", r->usri11_parms);
	ndr_print_uint32(ndr, "usri11_last_logon", r->usri11_last_logon);
	ndr_print_uint32(ndr, "usri11_last_logoff", r->usri11_last_logoff);
	ndr_print_uint32(ndr, "usri11_bad_pw_count", r->usri11_bad_pw_count);
	ndr_print_uint32(ndr, "usri11_num_logons", r->usri11_num_logons);
	ndr_print_string(ndr, "usri11_logon_server", r->usri11_logon_server);
	ndr_print_uint32(ndr, "usri11_country_code", r->usri11_country_code);
	ndr_print_string(ndr, "usri11_workstations", r->usri11_workstations);
	ndr_print_uint32(ndr, "usri11_max_storage", r->usri11_max_storage);
	ndr_print_uint32(ndr, "usri11_units_per_week", r->usri11_units_per_week);
	ndr_print_ptr(ndr, "usri11_logon_hours", r->usri11_logon_hours);
	ndr->depth++;
	if (r->usri11_logon_hours) {
		ndr_print_uint8(ndr, "usri11_logon_hours", *r->usri11_logon_hours);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usri11_code_page", r->usri11_code_page);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_20(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_20 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri20_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri20_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri20_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri20_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri20_user_id));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_20(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_20 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri20_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri20_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri20_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri20_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri20_user_id));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_20(struct ndr_print *ndr, const char *name, const struct USER_INFO_20 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_20");
	ndr->depth++;
	ndr_print_string(ndr, "usri20_name", r->usri20_name);
	ndr_print_string(ndr, "usri20_full_name", r->usri20_full_name);
	ndr_print_string(ndr, "usri20_comment", r->usri20_comment);
	ndr_print_uint32(ndr, "usri20_flags", r->usri20_flags);
	ndr_print_uint32(ndr, "usri20_user_id", r->usri20_user_id);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_21(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_21 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 1));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->usri21_password, ENCRYPTED_PWLEN));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_21(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_21 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 1));
		NDR_PULL_ALLOC_N(ndr, r->usri21_password, ENCRYPTED_PWLEN);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->usri21_password, ENCRYPTED_PWLEN));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_21(struct ndr_print *ndr, const char *name, const struct USER_INFO_21 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_21");
	ndr->depth++;
	ndr_print_array_uint8(ndr, "usri21_password", r->usri21_password, ENCRYPTED_PWLEN);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_22(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_22 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_name));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->usri22_password, ENCRYPTED_PWLEN));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_password_age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_priv));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_script_path));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_auth_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_parms));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_workstations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_last_logon));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_last_logoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_acct_expires));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_max_storage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri22_logon_hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_bad_pw_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_num_logons));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri22_logon_server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_country_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri22_code_page));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri22_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usri22_logon_hours));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_22(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_22 *r)
{
	uint32_t _ptr_usri22_logon_hours;
	TALLOC_CTX *_mem_save_usri22_logon_hours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_name));
		NDR_PULL_ALLOC_N(ndr, r->usri22_password, ENCRYPTED_PWLEN);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->usri22_password, ENCRYPTED_PWLEN));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_password_age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_priv));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_script_path));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_auth_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_parms));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_workstations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_last_logon));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_last_logoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_acct_expires));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_max_storage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri22_logon_hours));
		if (_ptr_usri22_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usri22_logon_hours);
		} else {
			r->usri22_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_bad_pw_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_num_logons));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri22_logon_server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_country_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri22_code_page));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri22_logon_hours) {
			_mem_save_usri22_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri22_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usri22_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri22_logon_hours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_22(struct ndr_print *ndr, const char *name, const struct USER_INFO_22 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_22");
	ndr->depth++;
	ndr_print_string(ndr, "usri22_name", r->usri22_name);
	ndr_print_array_uint8(ndr, "usri22_password", r->usri22_password, ENCRYPTED_PWLEN);
	ndr_print_uint32(ndr, "usri22_password_age", r->usri22_password_age);
	ndr_print_uint32(ndr, "usri22_priv", r->usri22_priv);
	ndr_print_string(ndr, "usri22_home_dir", r->usri22_home_dir);
	ndr_print_string(ndr, "usri22_comment", r->usri22_comment);
	ndr_print_uint32(ndr, "usri22_flags", r->usri22_flags);
	ndr_print_uint32(ndr, "usri22_script_path", r->usri22_script_path);
	ndr_print_uint32(ndr, "usri22_auth_flags", r->usri22_auth_flags);
	ndr_print_string(ndr, "usri22_full_name", r->usri22_full_name);
	ndr_print_string(ndr, "usri22_usr_comment", r->usri22_usr_comment);
	ndr_print_string(ndr, "usri22_parms", r->usri22_parms);
	ndr_print_string(ndr, "usri22_workstations", r->usri22_workstations);
	ndr_print_uint32(ndr, "usri22_last_logon", r->usri22_last_logon);
	ndr_print_uint32(ndr, "usri22_last_logoff", r->usri22_last_logoff);
	ndr_print_uint32(ndr, "usri22_acct_expires", r->usri22_acct_expires);
	ndr_print_uint32(ndr, "usri22_max_storage", r->usri22_max_storage);
	ndr_print_uint32(ndr, "usri22_units_per_week", r->usri22_units_per_week);
	ndr_print_ptr(ndr, "usri22_logon_hours", r->usri22_logon_hours);
	ndr->depth++;
	if (r->usri22_logon_hours) {
		ndr_print_uint8(ndr, "usri22_logon_hours", *r->usri22_logon_hours);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usri22_bad_pw_count", r->usri22_bad_pw_count);
	ndr_print_uint32(ndr, "usri22_num_logons", r->usri22_num_logons);
	ndr_print_string(ndr, "usri22_logon_server", r->usri22_logon_server);
	ndr_print_uint32(ndr, "usri22_country_code", r->usri22_country_code);
	ndr_print_uint32(ndr, "usri22_code_page", r->usri22_code_page);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_23(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_23 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri23_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri23_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri23_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri23_flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri23_user_sid));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri23_user_sid) {
			NDR_CHECK(ndr_push_domsid(ndr, NDR_SCALARS, r->usri23_user_sid));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_23(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_23 *r)
{
	uint32_t _ptr_usri23_user_sid;
	TALLOC_CTX *_mem_save_usri23_user_sid_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri23_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri23_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri23_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri23_flags));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri23_user_sid));
		if (_ptr_usri23_user_sid) {
			NDR_PULL_ALLOC(ndr, r->usri23_user_sid);
		} else {
			r->usri23_user_sid = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri23_user_sid) {
			_mem_save_usri23_user_sid_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri23_user_sid, 0);
			NDR_CHECK(ndr_pull_domsid(ndr, NDR_SCALARS, r->usri23_user_sid));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri23_user_sid_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_23(struct ndr_print *ndr, const char *name, const struct USER_INFO_23 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_23");
	ndr->depth++;
	ndr_print_string(ndr, "usri23_name", r->usri23_name);
	ndr_print_string(ndr, "usri23_full_name", r->usri23_full_name);
	ndr_print_string(ndr, "usri23_comment", r->usri23_comment);
	ndr_print_uint32(ndr, "usri23_flags", r->usri23_flags);
	ndr_print_ptr(ndr, "usri23_user_sid", r->usri23_user_sid);
	ndr->depth++;
	if (r->usri23_user_sid) {
		ndr_print_domsid(ndr, "usri23_user_sid", r->usri23_user_sid);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1003(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1003 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1003_password));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1003(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1003 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1003_password));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1003(struct ndr_print *ndr, const char *name, const struct USER_INFO_1003 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1003");
	ndr->depth++;
	ndr_print_string(ndr, "usri1003_password", r->usri1003_password);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1005(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1005 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1005_priv));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1005(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1005 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1005_priv));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1005(struct ndr_print *ndr, const char *name, const struct USER_INFO_1005 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1005");
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1005_priv", r->usri1005_priv);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1006(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1006 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1006_home_dir));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1006(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1006 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1006_home_dir));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1006(struct ndr_print *ndr, const char *name, const struct USER_INFO_1006 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1006");
	ndr->depth++;
	ndr_print_string(ndr, "usri1006_home_dir", r->usri1006_home_dir);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1007(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1007 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1007_comment));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1007(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1007 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1007_comment));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1007(struct ndr_print *ndr, const char *name, const struct USER_INFO_1007 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1007");
	ndr->depth++;
	ndr_print_string(ndr, "usri1007_comment", r->usri1007_comment);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1008(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1008 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1008_flags));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1008(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1008 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1008_flags));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1008(struct ndr_print *ndr, const char *name, const struct USER_INFO_1008 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1008");
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1008_flags", r->usri1008_flags);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1009(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1009 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1009_script_path));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1009(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1009 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1009_script_path));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1009(struct ndr_print *ndr, const char *name, const struct USER_INFO_1009 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1009");
	ndr->depth++;
	ndr_print_string(ndr, "usri1009_script_path", r->usri1009_script_path);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1010(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1010 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1010_auth_flags));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1010(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1010 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1010_auth_flags));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1010(struct ndr_print *ndr, const char *name, const struct USER_INFO_1010 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1010");
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1010_auth_flags", r->usri1010_auth_flags);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1011(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1011 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1011_full_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1011(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1011 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1011_full_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1011(struct ndr_print *ndr, const char *name, const struct USER_INFO_1011 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1011");
	ndr->depth++;
	ndr_print_string(ndr, "usri1011_full_name", r->usri1011_full_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1012(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1012 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1012_usr_comment));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1012(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1012 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1012_usr_comment));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1012(struct ndr_print *ndr, const char *name, const struct USER_INFO_1012 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1012");
	ndr->depth++;
	ndr_print_string(ndr, "usri1012_usr_comment", r->usri1012_usr_comment);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1013(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1013 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1013_parms));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1013(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1013 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1013_parms));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1013(struct ndr_print *ndr, const char *name, const struct USER_INFO_1013 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1013");
	ndr->depth++;
	ndr_print_string(ndr, "usri1013_parms", r->usri1013_parms);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1014(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1014 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1014_workstations));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1014(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1014 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1014_workstations));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1014(struct ndr_print *ndr, const char *name, const struct USER_INFO_1014 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1014");
	ndr->depth++;
	ndr_print_string(ndr, "usri1014_workstations", r->usri1014_workstations);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1017(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1017 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1017_acct_expires));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1017(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1017 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1017_acct_expires));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1017(struct ndr_print *ndr, const char *name, const struct USER_INFO_1017 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1017");
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1017_acct_expires", r->usri1017_acct_expires);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1018(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1018 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1018_max_storage));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1018(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1018 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1018_max_storage));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1018(struct ndr_print *ndr, const char *name, const struct USER_INFO_1018 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1018");
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1018_max_storage", r->usri1018_max_storage);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1020(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1020 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1020_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usri1020_logon_hours));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri1020_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usri1020_logon_hours));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1020(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1020 *r)
{
	uint32_t _ptr_usri1020_logon_hours;
	TALLOC_CTX *_mem_save_usri1020_logon_hours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1020_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usri1020_logon_hours));
		if (_ptr_usri1020_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usri1020_logon_hours);
		} else {
			r->usri1020_logon_hours = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usri1020_logon_hours) {
			_mem_save_usri1020_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usri1020_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usri1020_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usri1020_logon_hours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1020(struct ndr_print *ndr, const char *name, const struct USER_INFO_1020 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1020");
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1020_units_per_week", r->usri1020_units_per_week);
	ndr_print_ptr(ndr, "usri1020_logon_hours", r->usri1020_logon_hours);
	ndr->depth++;
	if (r->usri1020_logon_hours) {
		ndr_print_uint8(ndr, "usri1020_logon_hours", *r->usri1020_logon_hours);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1023(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1023 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1023_logon_server));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1023(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1023 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1023_logon_server));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1023(struct ndr_print *ndr, const char *name, const struct USER_INFO_1023 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1023");
	ndr->depth++;
	ndr_print_string(ndr, "usri1023_logon_server", r->usri1023_logon_server);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1024(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1024 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1024_country_code));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1024(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1024 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1024_country_code));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1024(struct ndr_print *ndr, const char *name, const struct USER_INFO_1024 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1024");
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1024_country_code", r->usri1024_country_code);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1025(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1025 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1025_code_page));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1025(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1025 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1025_code_page));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1025(struct ndr_print *ndr, const char *name, const struct USER_INFO_1025 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1025");
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1025_code_page", r->usri1025_code_page);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1051(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1051 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1051_primary_group_id));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1051(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1051 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1051_primary_group_id));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1051(struct ndr_print *ndr, const char *name, const struct USER_INFO_1051 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1051");
	ndr->depth++;
	ndr_print_uint32(ndr, "usri1051_primary_group_id", r->usri1051_primary_group_id);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1052(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1052 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1052_profile));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1052(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1052 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1052_profile));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1052(struct ndr_print *ndr, const char *name, const struct USER_INFO_1052 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1052");
	ndr->depth++;
	ndr_print_string(ndr, "usri1052_profile", r->usri1052_profile);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_1053(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_1053 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1053_home_dir_drive));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_1053(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_1053 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1053_home_dir_drive));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_1053(struct ndr_print *ndr, const char *name, const struct USER_INFO_1053 *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_1053");
	ndr->depth++;
	ndr_print_string(ndr, "usri1053_home_dir_drive", r->usri1053_home_dir_drive);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_USER_INFO_X(struct ndr_push *ndr, int ndr_flags, const struct USER_INFO_X *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_password));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_password_age));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_priv));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_home_dir));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_script_path));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_auth_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_full_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_usr_comment));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_parms));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_workstations));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_last_logon));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_last_logoff));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_acct_expires));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_max_storage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_units_per_week));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->usriX_logon_hours));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_bad_pw_count));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_num_logons));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_logon_server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_country_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_code_page));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_profile));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usriX_home_dir_drive));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_user_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_primary_group_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usriX_password_expired));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usriX_logon_hours) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->usriX_logon_hours));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_USER_INFO_X(struct ndr_pull *ndr, int ndr_flags, struct USER_INFO_X *r)
{
	uint32_t _ptr_usriX_logon_hours;
	TALLOC_CTX *_mem_save_usriX_logon_hours_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_password));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_password_age));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_priv));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_home_dir));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_script_path));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_auth_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_full_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_usr_comment));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_parms));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_workstations));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_last_logon));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_last_logoff));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_acct_expires));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_max_storage));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_units_per_week));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_usriX_logon_hours));
		if (_ptr_usriX_logon_hours) {
			NDR_PULL_ALLOC(ndr, r->usriX_logon_hours);
		} else {
			r->usriX_logon_hours = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_bad_pw_count));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_num_logons));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_logon_server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_country_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_code_page));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_profile));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usriX_home_dir_drive));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_user_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_primary_group_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usriX_password_expired));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->usriX_logon_hours) {
			_mem_save_usriX_logon_hours_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->usriX_logon_hours, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->usriX_logon_hours));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_usriX_logon_hours_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_USER_INFO_X(struct ndr_print *ndr, const char *name, const struct USER_INFO_X *r)
{
	ndr_print_struct(ndr, name, "USER_INFO_X");
	ndr->depth++;
	ndr_print_string(ndr, "usriX_name", r->usriX_name);
	ndr_print_string(ndr, "usriX_password", r->usriX_password);
	ndr_print_uint32(ndr, "usriX_password_age", r->usriX_password_age);
	ndr_print_uint32(ndr, "usriX_priv", r->usriX_priv);
	ndr_print_string(ndr, "usriX_home_dir", r->usriX_home_dir);
	ndr_print_string(ndr, "usriX_comment", r->usriX_comment);
	ndr_print_uint32(ndr, "usriX_flags", r->usriX_flags);
	ndr_print_string(ndr, "usriX_script_path", r->usriX_script_path);
	ndr_print_uint32(ndr, "usriX_auth_flags", r->usriX_auth_flags);
	ndr_print_string(ndr, "usriX_full_name", r->usriX_full_name);
	ndr_print_string(ndr, "usriX_usr_comment", r->usriX_usr_comment);
	ndr_print_string(ndr, "usriX_parms", r->usriX_parms);
	ndr_print_string(ndr, "usriX_workstations", r->usriX_workstations);
	ndr_print_uint32(ndr, "usriX_last_logon", r->usriX_last_logon);
	ndr_print_uint32(ndr, "usriX_last_logoff", r->usriX_last_logoff);
	ndr_print_uint32(ndr, "usriX_acct_expires", r->usriX_acct_expires);
	ndr_print_uint32(ndr, "usriX_max_storage", r->usriX_max_storage);
	ndr_print_uint32(ndr, "usriX_units_per_week", r->usriX_units_per_week);
	ndr_print_ptr(ndr, "usriX_logon_hours", r->usriX_logon_hours);
	ndr->depth++;
	if (r->usriX_logon_hours) {
		ndr_print_uint8(ndr, "usriX_logon_hours", *r->usriX_logon_hours);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "usriX_bad_pw_count", r->usriX_bad_pw_count);
	ndr_print_uint32(ndr, "usriX_num_logons", r->usriX_num_logons);
	ndr_print_string(ndr, "usriX_logon_server", r->usriX_logon_server);
	ndr_print_uint32(ndr, "usriX_country_code", r->usriX_country_code);
	ndr_print_uint32(ndr, "usriX_code_page", r->usriX_code_page);
	ndr_print_string(ndr, "usriX_profile", r->usriX_profile);
	ndr_print_string(ndr, "usriX_home_dir_drive", r->usriX_home_dir_drive);
	ndr_print_uint32(ndr, "usriX_user_id", r->usriX_user_id);
	ndr_print_uint32(ndr, "usriX_primary_group_id", r->usriX_primary_group_id);
	ndr_print_uint32(ndr, "usriX_password_expired", r->usriX_password_expired);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_GROUP_USERS_INFO_0(struct ndr_push *ndr, int ndr_flags, const struct GROUP_USERS_INFO_0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->grui0_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_GROUP_USERS_INFO_0(struct ndr_pull *ndr, int ndr_flags, struct GROUP_USERS_INFO_0 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->grui0_name));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GROUP_USERS_INFO_0(struct ndr_print *ndr, const char *name, const struct GROUP_USERS_INFO_0 *r)
{
	ndr_print_struct(ndr, name, "GROUP_USERS_INFO_0");
	ndr->depth++;
	ndr_print_string(ndr, "grui0_name", r->grui0_name);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_GROUP_USERS_INFO_1(struct ndr_push *ndr, int ndr_flags, const struct GROUP_USERS_INFO_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->grui1_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->grui1_attributes));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_GROUP_USERS_INFO_1(struct ndr_pull *ndr, int ndr_flags, struct GROUP_USERS_INFO_1 *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->grui1_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->grui1_attributes));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_GROUP_USERS_INFO_1(struct ndr_print *ndr, const char *name, const struct GROUP_USERS_INFO_1 *r)
{
	ndr_print_struct(ndr, name, "GROUP_USERS_INFO_1");
	ndr->depth++;
	ndr_print_string(ndr, "grui1_name", r->grui1_name);
	ndr_print_uint32(ndr, "grui1_attributes", r->grui1_attributes);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_NET_DISPLAY_USER(struct ndr_push *ndr, int ndr_flags, const struct NET_DISPLAY_USER *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1_flags));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri1_full_name));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1_user_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri1_next_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NET_DISPLAY_USER(struct ndr_pull *ndr, int ndr_flags, struct NET_DISPLAY_USER *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1_flags));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri1_full_name));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1_user_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri1_next_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NET_DISPLAY_USER(struct ndr_print *ndr, const char *name, const struct NET_DISPLAY_USER *r)
{
	ndr_print_struct(ndr, name, "NET_DISPLAY_USER");
	ndr->depth++;
	ndr_print_string(ndr, "usri1_name", r->usri1_name);
	ndr_print_string(ndr, "usri1_comment", r->usri1_comment);
	ndr_print_uint32(ndr, "usri1_flags", r->usri1_flags);
	ndr_print_string(ndr, "usri1_full_name", r->usri1_full_name);
	ndr_print_uint32(ndr, "usri1_user_id", r->usri1_user_id);
	ndr_print_uint32(ndr, "usri1_next_index", r->usri1_next_index);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_NET_DISPLAY_MACHINE(struct ndr_push *ndr, int ndr_flags, const struct NET_DISPLAY_MACHINE *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->usri2_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_user_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->usri2_next_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NET_DISPLAY_MACHINE(struct ndr_pull *ndr, int ndr_flags, struct NET_DISPLAY_MACHINE *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->usri2_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_user_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->usri2_next_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NET_DISPLAY_MACHINE(struct ndr_print *ndr, const char *name, const struct NET_DISPLAY_MACHINE *r)
{
	ndr_print_struct(ndr, name, "NET_DISPLAY_MACHINE");
	ndr->depth++;
	ndr_print_string(ndr, "usri2_name", r->usri2_name);
	ndr_print_string(ndr, "usri2_comment", r->usri2_comment);
	ndr_print_uint32(ndr, "usri2_flags", r->usri2_flags);
	ndr_print_uint32(ndr, "usri2_user_id", r->usri2_user_id);
	ndr_print_uint32(ndr, "usri2_next_index", r->usri2_next_index);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_NET_DISPLAY_GROUP(struct ndr_push *ndr, int ndr_flags, const struct NET_DISPLAY_GROUP *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->grpi3_name));
		NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->grpi3_comment));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->grpi3_group_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->grpi3_attributes));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->grpi3_next_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NET_DISPLAY_GROUP(struct ndr_pull *ndr, int ndr_flags, struct NET_DISPLAY_GROUP *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->grpi3_name));
		NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->grpi3_comment));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->grpi3_group_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->grpi3_attributes));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->grpi3_next_index));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NET_DISPLAY_GROUP(struct ndr_print *ndr, const char *name, const struct NET_DISPLAY_GROUP *r)
{
	ndr_print_struct(ndr, name, "NET_DISPLAY_GROUP");
	ndr->depth++;
	ndr_print_string(ndr, "grpi3_name", r->grpi3_name);
	ndr_print_string(ndr, "grpi3_comment", r->grpi3_comment);
	ndr_print_uint32(ndr, "grpi3_group_id", r->grpi3_group_id);
	ndr_print_uint32(ndr, "grpi3_attributes", r->grpi3_attributes);
	ndr_print_uint32(ndr, "grpi3_next_index", r->grpi3_next_index);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SHARE_INFO_1005_FLAGS(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SHARE_INFO_1005_FLAGS(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SHARE_INFO_1005_FLAGS(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHI1005_FLAGS_DFS", SHI1005_FLAGS_DFS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHI1005_FLAGS_DFS_ROOT", SHI1005_FLAGS_DFS_ROOT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CSC_CACHE_MANUAL_REINT", CSC_CACHE_MANUAL_REINT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CSC_CACHE_AUTO_REINT", CSC_CACHE_AUTO_REINT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CSC_CACHE_VDO", CSC_CACHE_VDO, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CSC_CACHE_NONE", CSC_CACHE_NONE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHI1005_FLAGS_RESTRICT_EXCLUSIVE_OPENS", SHI1005_FLAGS_RESTRICT_EXCLUSIVE_OPENS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHI1005_FLAGS_FORCE_SHARED_DELETE", SHI1005_FLAGS_FORCE_SHARED_DELETE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHI1005_FLAGS_ALLOW_NAMESPACE_CACHING", SHI1005_FLAGS_ALLOW_NAMESPACE_CACHING, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SHI1005_FLAGS_ACCESS_BASED_DIRECTORY_ENUM", SHI1005_FLAGS_ACCESS_BASED_DIRECTORY_ENUM, r);
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetJoinDomain(struct ndr_print *ndr, const char *name, int flags, const struct NetJoinDomain *r)
{
	ndr_print_struct(ndr, name, "NetJoinDomain");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetJoinDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "server", r->in.server);
		ndr->depth++;
		if (r->in.server) {
			ndr_print_string(ndr, "server", r->in.server);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain", r->in.domain);
		ndr->depth++;
		ndr_print_string(ndr, "domain", r->in.domain);
		ndr->depth--;
		ndr_print_ptr(ndr, "account_ou", r->in.account_ou);
		ndr->depth++;
		if (r->in.account_ou) {
			ndr_print_string(ndr, "account_ou", r->in.account_ou);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account", r->in.account);
		ndr->depth++;
		if (r->in.account) {
			ndr_print_string(ndr, "account", r->in.account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_string(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr_print_NetJoinFlags(ndr, "join_flags", r->in.join_flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetJoinDomain");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUnjoinDomain(struct ndr_print *ndr, const char *name, int flags, const struct NetUnjoinDomain *r)
{
	ndr_print_struct(ndr, name, "NetUnjoinDomain");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUnjoinDomain");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "account", r->in.account);
		ndr->depth++;
		if (r->in.account) {
			ndr_print_string(ndr, "account", r->in.account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_string(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr_print_NetJoinFlags(ndr, "unjoin_flags", r->in.unjoin_flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUnjoinDomain");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGetJoinInformation(struct ndr_print *ndr, const char *name, int flags, const struct NetGetJoinInformation *r)
{
	ndr_print_struct(ndr, name, "NetGetJoinInformation");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGetJoinInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGetJoinInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "name_buffer", r->out.name_buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "name_buffer", *r->out.name_buffer);
		ndr->depth++;
		if (*r->out.name_buffer) {
			ndr_print_string(ndr, "name_buffer", *r->out.name_buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "name_type", r->out.name_type);
		ndr->depth++;
		ndr_print_uint16(ndr, "name_type", *r->out.name_type);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGetJoinableOUs(struct ndr_print *ndr, const char *name, int flags, const struct NetGetJoinableOUs *r)
{
	ndr_print_struct(ndr, name, "NetGetJoinableOUs");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGetJoinableOUs");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain", r->in.domain);
		ndr->depth++;
		ndr_print_string(ndr, "domain", r->in.domain);
		ndr->depth--;
		ndr_print_ptr(ndr, "account", r->in.account);
		ndr->depth++;
		if (r->in.account) {
			ndr_print_string(ndr, "account", r->in.account);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_string(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGetJoinableOUs");
		ndr->depth++;
		ndr_print_ptr(ndr, "ou_count", r->out.ou_count);
		ndr->depth++;
		ndr_print_uint32(ndr, "ou_count", *r->out.ou_count);
		ndr->depth--;
		ndr_print_ptr(ndr, "ous", r->out.ous);
		ndr->depth++;
		ndr_print_ptr(ndr, "ous", *r->out.ous);
		ndr->depth++;
		if (*r->out.ous) {
			ndr_print_ptr(ndr, "ous", **r->out.ous);
			ndr->depth++;
			if (**r->out.ous) {
				ndr_print_string(ndr, "ous", **r->out.ous);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetRenameMachineInDomain(struct ndr_print *ndr, const char *name, int flags, const struct NetRenameMachineInDomain *r)
{
	ndr_print_struct(ndr, name, "NetRenameMachineInDomain");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetRenameMachineInDomain");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "new_machine_name", r->in.new_machine_name);
		ndr_print_string(ndr, "account", r->in.account);
		ndr_print_string(ndr, "password", r->in.password);
		ndr_print_uint32(ndr, "rename_options", r->in.rename_options);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetRenameMachineInDomain");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetServerGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetServerGetInfo *r)
{
	ndr_print_struct(ndr, name, "NetServerGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetServerGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetServerGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetServerSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetServerSetInfo *r)
{
	ndr_print_struct(ndr, name, "NetServerSetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetServerSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetServerSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_error", r->out.parm_error);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_error", *r->out.parm_error);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGetDCName(struct ndr_print *ndr, const char *name, int flags, const struct NetGetDCName *r)
{
	ndr_print_struct(ndr, name, "NetGetDCName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGetDCName");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		if (r->in.domain_name) {
			ndr_print_string(ndr, "domain_name", r->in.domain_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGetDCName");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGetAnyDCName(struct ndr_print *ndr, const char *name, int flags, const struct NetGetAnyDCName *r)
{
	ndr_print_struct(ndr, name, "NetGetAnyDCName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGetAnyDCName");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		if (r->in.domain_name) {
			ndr_print_string(ndr, "domain_name", r->in.domain_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGetAnyDCName");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_DsGetDcName(struct ndr_print *ndr, const char *name, int flags, const struct DsGetDcName *r)
{
	ndr_print_struct(ndr, name, "DsGetDcName");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "DsGetDcName");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_name", r->in.domain_name);
		ndr->depth++;
		ndr_print_string(ndr, "domain_name", r->in.domain_name);
		ndr->depth--;
		ndr_print_ptr(ndr, "domain_guid", r->in.domain_guid);
		ndr->depth++;
		if (r->in.domain_guid) {
			ndr_print_GUID(ndr, "domain_guid", r->in.domain_guid);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "site_name", r->in.site_name);
		ndr->depth++;
		if (r->in.site_name) {
			ndr_print_string(ndr, "site_name", r->in.site_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "DsGetDcName");
		ndr->depth++;
		ndr_print_ptr(ndr, "dc_info", r->out.dc_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "dc_info", *r->out.dc_info);
		ndr->depth++;
		if (*r->out.dc_info) {
			ndr_print_DOMAIN_CONTROLLER_INFO(ndr, "dc_info", *r->out.dc_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserAdd(struct ndr_print *ndr, const char *name, int flags, const struct NetUserAdd *r)
{
	ndr_print_struct(ndr, name, "NetUserAdd");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_error", r->out.parm_error);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_error", *r->out.parm_error);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserDel(struct ndr_print *ndr, const char *name, int flags, const struct NetUserDel *r)
{
	ndr_print_struct(ndr, name, "NetUserDel");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserDel");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "user_name", r->in.user_name);
		ndr->depth++;
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserDel");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserEnum(struct ndr_print *ndr, const char *name, int flags, const struct NetUserEnum *r)
{
	ndr_print_struct(ndr, name, "NetUserEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "filter", r->in.filter);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserChangePassword(struct ndr_print *ndr, const char *name, int flags, const struct NetUserChangePassword *r)
{
	ndr_print_struct(ndr, name, "NetUserChangePassword");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserChangePassword");
		ndr->depth++;
		ndr_print_string(ndr, "domain_name", r->in.domain_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_string(ndr, "old_password", r->in.old_password);
		ndr_print_string(ndr, "new_password", r->in.new_password);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserChangePassword");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetUserGetInfo *r)
{
	ndr_print_struct(ndr, name, "NetUserGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetUserSetInfo *r)
{
	ndr_print_struct(ndr, name, "NetUserSetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserSetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserGetGroups(struct ndr_print *ndr, const char *name, int flags, const struct NetUserGetGroups *r)
{
	ndr_print_struct(ndr, name, "NetUserGetGroups");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserGetGroups");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserGetGroups");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserSetGroups(struct ndr_print *ndr, const char *name, int flags, const struct NetUserSetGroups *r)
{
	ndr_print_struct(ndr, name, "NetUserSetGroups");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserSetGroups");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_entries", r->in.num_entries);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserSetGroups");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserGetLocalGroups(struct ndr_print *ndr, const char *name, int flags, const struct NetUserGetLocalGroups *r)
{
	ndr_print_struct(ndr, name, "NetUserGetLocalGroups");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserGetLocalGroups");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserGetLocalGroups");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserModalsGet(struct ndr_print *ndr, const char *name, int flags, const struct NetUserModalsGet *r)
{
	ndr_print_struct(ndr, name, "NetUserModalsGet");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserModalsGet");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserModalsGet");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetUserModalsSet(struct ndr_print *ndr, const char *name, int flags, const struct NetUserModalsSet *r)
{
	ndr_print_struct(ndr, name, "NetUserModalsSet");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetUserModalsSet");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetUserModalsSet");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetQueryDisplayInformation(struct ndr_print *ndr, const char *name, int flags, const struct NetQueryDisplayInformation *r)
{
	ndr_print_struct(ndr, name, "NetQueryDisplayInformation");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetQueryDisplayInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_name", r->in.server_name);
		ndr->depth++;
		if (r->in.server_name) {
			ndr_print_string(ndr, "server_name", r->in.server_name);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "idx", r->in.idx);
		ndr_print_uint32(ndr, "entries_requested", r->in.entries_requested);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetQueryDisplayInformation");
		ndr->depth++;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupAdd(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupAdd *r)
{
	ndr_print_struct(ndr, name, "NetGroupAdd");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupAdd");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupDel(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupDel *r)
{
	ndr_print_struct(ndr, name, "NetGroupDel");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupDel");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupDel");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupEnum(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupEnum *r)
{
	ndr_print_struct(ndr, name, "NetGroupEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupEnum");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupSetInfo *r)
{
	ndr_print_struct(ndr, name, "NetGroupSetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupSetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupGetInfo *r)
{
	ndr_print_struct(ndr, name, "NetGroupGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupAddUser(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupAddUser *r)
{
	ndr_print_struct(ndr, name, "NetGroupAddUser");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupAddUser");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupAddUser");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupDelUser(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupDelUser *r)
{
	ndr_print_struct(ndr, name, "NetGroupDelUser");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupDelUser");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupDelUser");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupGetUsers(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupGetUsers *r)
{
	ndr_print_struct(ndr, name, "NetGroupGetUsers");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupGetUsers");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupGetUsers");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetGroupSetUsers(struct ndr_print *ndr, const char *name, int flags, const struct NetGroupSetUsers *r)
{
	ndr_print_struct(ndr, name, "NetGroupSetUsers");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetGroupSetUsers");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr_print_uint32(ndr, "num_entries", r->in.num_entries);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetGroupSetUsers");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupAdd(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupAdd *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupAdd");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupAdd");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupDel(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupDel *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupDel");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupDel");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupDel");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupGetInfo *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupSetInfo *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupSetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupSetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupEnum(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupEnum *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupEnum");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupAddMembers(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupAddMembers *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupAddMembers");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupAddMembers");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr_print_uint32(ndr, "total_entries", r->in.total_entries);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupAddMembers");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupDelMembers(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupDelMembers *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupDelMembers");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupDelMembers");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr_print_uint32(ndr, "total_entries", r->in.total_entries);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupDelMembers");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupGetMembers(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupGetMembers *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupGetMembers");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupGetMembers");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "local_group_name", r->in.local_group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupGetMembers");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetLocalGroupSetMembers(struct ndr_print *ndr, const char *name, int flags, const struct NetLocalGroupSetMembers *r)
{
	ndr_print_struct(ndr, name, "NetLocalGroupSetMembers");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetLocalGroupSetMembers");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "group_name", r->in.group_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr_print_uint32(ndr, "total_entries", r->in.total_entries);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetLocalGroupSetMembers");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetRemoteTOD(struct ndr_print *ndr, const char *name, int flags, const struct NetRemoteTOD *r)
{
	ndr_print_struct(ndr, name, "NetRemoteTOD");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetRemoteTOD");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetRemoteTOD");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetShareAdd(struct ndr_print *ndr, const char *name, int flags, const struct NetShareAdd *r)
{
	ndr_print_struct(ndr, name, "NetShareAdd");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetShareAdd");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetShareAdd");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetShareDel(struct ndr_print *ndr, const char *name, int flags, const struct NetShareDel *r)
{
	ndr_print_struct(ndr, name, "NetShareDel");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetShareDel");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "net_name", r->in.net_name);
		ndr_print_uint32(ndr, "reserved", r->in.reserved);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetShareDel");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetShareEnum(struct ndr_print *ndr, const char *name, int flags, const struct NetShareEnum *r)
{
	ndr_print_struct(ndr, name, "NetShareEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetShareEnum");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetShareEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetShareGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetShareGetInfo *r)
{
	ndr_print_struct(ndr, name, "NetShareGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetShareGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "net_name", r->in.net_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetShareGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetShareSetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetShareSetInfo *r)
{
	ndr_print_struct(ndr, name, "NetShareSetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetShareSetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "net_name", r->in.net_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_uint8(ndr, "buffer", *r->in.buffer);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetShareSetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "parm_err", r->out.parm_err);
		ndr->depth++;
		ndr_print_uint32(ndr, "parm_err", *r->out.parm_err);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetFileClose(struct ndr_print *ndr, const char *name, int flags, const struct NetFileClose *r)
{
	ndr_print_struct(ndr, name, "NetFileClose");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetFileClose");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "fileid", r->in.fileid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetFileClose");
		ndr->depth++;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetFileGetInfo(struct ndr_print *ndr, const char *name, int flags, const struct NetFileGetInfo *r)
{
	ndr_print_struct(ndr, name, "NetFileGetInfo");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetFileGetInfo");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_uint32(ndr, "fileid", r->in.fileid);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetFileGetInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ void ndr_print_NetFileEnum(struct ndr_print *ndr, const char *name, int flags, const struct NetFileEnum *r)
{
	ndr_print_struct(ndr, name, "NetFileEnum");
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "NetFileEnum");
		ndr->depth++;
		ndr_print_string(ndr, "server_name", r->in.server_name);
		ndr_print_string(ndr, "base_path", r->in.base_path);
		ndr_print_string(ndr, "user_name", r->in.user_name);
		ndr_print_uint32(ndr, "level", r->in.level);
		ndr_print_uint32(ndr, "prefmaxlen", r->in.prefmaxlen);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "NetFileEnum");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", *r->out.buffer);
		ndr->depth++;
		if (*r->out.buffer) {
			ndr_print_uint8(ndr, "buffer", **r->out.buffer);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "entries_read", r->out.entries_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "entries_read", *r->out.entries_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "total_entries", r->out.total_entries);
		ndr->depth++;
		ndr_print_uint32(ndr, "total_entries", *r->out.total_entries);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		ndr->depth--;
		ndr_print_NET_API_STATUS(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

