/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSWebKitCSSKeyframeRule.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "KURL.h"
#include "WebKitCSSKeyframeRule.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebKitCSSKeyframeRule)

/* Hash table */

static const HashTableValue JSWebKitCSSKeyframeRuleTableValues[4] =
{
    { "keyText", DontDelete, (intptr_t)jsWebKitCSSKeyframeRuleKeyText, (intptr_t)setJSWebKitCSSKeyframeRuleKeyText },
    { "style", DontDelete|ReadOnly, (intptr_t)jsWebKitCSSKeyframeRuleStyle, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsWebKitCSSKeyframeRuleConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSWebKitCSSKeyframeRuleTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSWebKitCSSKeyframeRuleTableValues, 0 };
#else
    { 9, 7, JSWebKitCSSKeyframeRuleTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSWebKitCSSKeyframeRuleConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSWebKitCSSKeyframeRuleConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWebKitCSSKeyframeRuleConstructorTableValues, 0 };
#else
    { 1, 0, JSWebKitCSSKeyframeRuleConstructorTableValues, 0 };
#endif

class JSWebKitCSSKeyframeRuleConstructor : public DOMObject {
public:
    JSWebKitCSSKeyframeRuleConstructor(ExecState* exec)
        : DOMObject(JSWebKitCSSKeyframeRuleConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSWebKitCSSKeyframeRulePrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSWebKitCSSKeyframeRuleConstructor::s_info = { "WebKitCSSKeyframeRuleConstructor", 0, &JSWebKitCSSKeyframeRuleConstructorTable, 0 };

bool JSWebKitCSSKeyframeRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitCSSKeyframeRuleConstructor, DOMObject>(exec, &JSWebKitCSSKeyframeRuleConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSWebKitCSSKeyframeRulePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSWebKitCSSKeyframeRulePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWebKitCSSKeyframeRulePrototypeTableValues, 0 };
#else
    { 1, 0, JSWebKitCSSKeyframeRulePrototypeTableValues, 0 };
#endif

const ClassInfo JSWebKitCSSKeyframeRulePrototype::s_info = { "WebKitCSSKeyframeRulePrototype", 0, &JSWebKitCSSKeyframeRulePrototypeTable, 0 };

JSObject* JSWebKitCSSKeyframeRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitCSSKeyframeRule>(exec, globalObject);
}

const ClassInfo JSWebKitCSSKeyframeRule::s_info = { "WebKitCSSKeyframeRule", &JSCSSRule::s_info, &JSWebKitCSSKeyframeRuleTable, 0 };

JSWebKitCSSKeyframeRule::JSWebKitCSSKeyframeRule(PassRefPtr<Structure> structure, PassRefPtr<WebKitCSSKeyframeRule> impl)
    : JSCSSRule(structure, impl)
{
}

JSObject* JSWebKitCSSKeyframeRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSWebKitCSSKeyframeRulePrototype(JSWebKitCSSKeyframeRulePrototype::createStructure(JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSWebKitCSSKeyframeRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitCSSKeyframeRule, Base>(exec, &JSWebKitCSSKeyframeRuleTable, this, propertyName, slot);
}

JSValuePtr jsWebKitCSSKeyframeRuleKeyText(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WebKitCSSKeyframeRule* imp = static_cast<WebKitCSSKeyframeRule*>(static_cast<JSWebKitCSSKeyframeRule*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->keyText());
}

JSValuePtr jsWebKitCSSKeyframeRuleStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WebKitCSSKeyframeRule* imp = static_cast<WebKitCSSKeyframeRule*>(static_cast<JSWebKitCSSKeyframeRule*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValuePtr jsWebKitCSSKeyframeRuleConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSWebKitCSSKeyframeRule*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSWebKitCSSKeyframeRule::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSWebKitCSSKeyframeRule, Base>(exec, propertyName, value, &JSWebKitCSSKeyframeRuleTable, this, slot);
}

void setJSWebKitCSSKeyframeRuleKeyText(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    WebKitCSSKeyframeRule* imp = static_cast<WebKitCSSKeyframeRule*>(static_cast<JSWebKitCSSKeyframeRule*>(thisObject)->impl());
    imp->setKeyText(value->toString(exec));
}

JSValuePtr JSWebKitCSSKeyframeRule::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSWebKitCSSKeyframeRuleConstructor>(exec);
}


}
