/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSWebKitAnimationEvent.h"

#include <wtf/GetPtr.h>

#include "KURL.h"
#include "WebKitAnimationEvent.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebKitAnimationEvent)

/* Hash table */

static const HashTableValue JSWebKitAnimationEventTableValues[4] =
{
    { "animationName", DontDelete|ReadOnly, (intptr_t)jsWebKitAnimationEventAnimationName, (intptr_t)0 },
    { "elapsedTime", DontDelete|ReadOnly, (intptr_t)jsWebKitAnimationEventElapsedTime, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsWebKitAnimationEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSWebKitAnimationEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSWebKitAnimationEventTableValues, 0 };
#else
    { 9, 7, JSWebKitAnimationEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSWebKitAnimationEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSWebKitAnimationEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWebKitAnimationEventConstructorTableValues, 0 };
#else
    { 1, 0, JSWebKitAnimationEventConstructorTableValues, 0 };
#endif

class JSWebKitAnimationEventConstructor : public DOMObject {
public:
    JSWebKitAnimationEventConstructor(ExecState* exec)
        : DOMObject(JSWebKitAnimationEventConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSWebKitAnimationEventPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSWebKitAnimationEventConstructor::s_info = { "WebKitAnimationEventConstructor", 0, &JSWebKitAnimationEventConstructorTable, 0 };

bool JSWebKitAnimationEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitAnimationEventConstructor, DOMObject>(exec, &JSWebKitAnimationEventConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSWebKitAnimationEventPrototypeTableValues[2] =
{
    { "initWebKitAnimationEvent", DontDelete|Function, (intptr_t)jsWebKitAnimationEventPrototypeFunctionInitWebKitAnimationEvent, (intptr_t)5 },
    { 0, 0, 0, 0 }
};

static const HashTable JSWebKitAnimationEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWebKitAnimationEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSWebKitAnimationEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSWebKitAnimationEventPrototype::s_info = { "WebKitAnimationEventPrototype", 0, &JSWebKitAnimationEventPrototypeTable, 0 };

JSObject* JSWebKitAnimationEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitAnimationEvent>(exec, globalObject);
}

bool JSWebKitAnimationEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSWebKitAnimationEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSWebKitAnimationEvent::s_info = { "WebKitAnimationEvent", &JSEvent::s_info, &JSWebKitAnimationEventTable, 0 };

JSWebKitAnimationEvent::JSWebKitAnimationEvent(PassRefPtr<Structure> structure, PassRefPtr<WebKitAnimationEvent> impl)
    : JSEvent(structure, impl)
{
}

JSObject* JSWebKitAnimationEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSWebKitAnimationEventPrototype(JSWebKitAnimationEventPrototype::createStructure(JSEventPrototype::self(exec, globalObject)));
}

bool JSWebKitAnimationEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitAnimationEvent, Base>(exec, &JSWebKitAnimationEventTable, this, propertyName, slot);
}

JSValuePtr jsWebKitAnimationEventAnimationName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WebKitAnimationEvent* imp = static_cast<WebKitAnimationEvent*>(static_cast<JSWebKitAnimationEvent*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->animationName());
}

JSValuePtr jsWebKitAnimationEventElapsedTime(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    WebKitAnimationEvent* imp = static_cast<WebKitAnimationEvent*>(static_cast<JSWebKitAnimationEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->elapsedTime());
}

JSValuePtr jsWebKitAnimationEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSWebKitAnimationEvent*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSWebKitAnimationEvent::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSWebKitAnimationEventConstructor>(exec);
}

JSValuePtr jsWebKitAnimationEventPrototypeFunctionInitWebKitAnimationEvent(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSWebKitAnimationEvent::s_info))
        return throwError(exec, TypeError);
    JSWebKitAnimationEvent* castedThisObj = static_cast<JSWebKitAnimationEvent*>(asObject(thisValue));
    WebKitAnimationEvent* imp = static_cast<WebKitAnimationEvent*>(castedThisObj->impl());
    const UString& typeArg = args.at(exec, 0)->toString(exec);
    bool canBubbleArg = args.at(exec, 1)->toBoolean(exec);
    bool cancelableArg = args.at(exec, 2)->toBoolean(exec);
    const UString& animationNameArg = args.at(exec, 3)->toString(exec);
    double elapsedTimeArg = args.at(exec, 4)->toNumber(exec);

    imp->initWebKitAnimationEvent(typeArg, canBubbleArg, cancelableArg, animationNameArg, elapsedTimeArg);
    return jsUndefined();
}


}
