/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGTextElement.h"

#include <wtf/GetPtr.h>

#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "SVGElement.h"
#include "SVGTextElement.h"

#include <runtime/Error.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGTextElement)

/* Hash table */

static const HashTableValue JSSVGTextElementTableValues[4] =
{
    { "transform", DontDelete|ReadOnly, (intptr_t)jsSVGTextElementTransform, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGTextElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGTextElementFarthestViewportElement, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGTextElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSSVGTextElementTableValues, 0 };
#else
    { 8, 7, JSSVGTextElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGTextElementPrototypeTableValues[5] =
{
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGTextElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGTextElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGTextElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGTextElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGTextElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGTextElementPrototypeTableValues, 0 };
#else
    { 8, 7, JSSVGTextElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGTextElementPrototype::s_info = { "SVGTextElementPrototype", 0, &JSSVGTextElementPrototypeTable, 0 };

JSObject* JSSVGTextElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTextElement>(exec, globalObject);
}

bool JSSVGTextElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGTextElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGTextElement::s_info = { "SVGTextElement", &JSSVGTextPositioningElement::s_info, &JSSVGTextElementTable, 0 };

JSSVGTextElement::JSSVGTextElement(PassRefPtr<Structure> structure, PassRefPtr<SVGTextElement> impl)
    : JSSVGTextPositioningElement(structure, impl)
{
}

JSObject* JSSVGTextElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGTextElementPrototype(JSSVGTextElementPrototype::createStructure(JSSVGTextPositioningElementPrototype::self(exec, globalObject)));
}

bool JSSVGTextElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextElement, Base>(exec, &JSSVGTextElementTable, this, propertyName, slot);
}

JSValuePtr jsSVGTextElementTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGTextElement* imp = static_cast<SVGTextElement*>(static_cast<JSSVGTextElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGTextElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGTextElement* imp = static_cast<SVGTextElement*>(static_cast<JSSVGTextElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
}

JSValuePtr jsSVGTextElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGTextElement* imp = static_cast<SVGTextElement*>(static_cast<JSSVGTextElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
}

JSValuePtr jsSVGTextElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTextElement::s_info))
        return throwError(exec, TypeError);
    JSSVGTextElement* castedThisObj = static_cast<JSSVGTextElement*>(asObject(thisValue));
    SVGTextElement* imp = static_cast<SVGTextElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), imp);
    return result;
}

JSValuePtr jsSVGTextElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTextElement::s_info))
        return throwError(exec, TypeError);
    JSSVGTextElement* castedThisObj = static_cast<JSSVGTextElement*>(asObject(thisValue));
    SVGTextElement* imp = static_cast<SVGTextElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getCTM()).get(), imp);
    return result;
}

JSValuePtr jsSVGTextElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTextElement::s_info))
        return throwError(exec, TypeError);
    JSSVGTextElement* castedThisObj = static_cast<JSSVGTextElement*>(asObject(thisValue));
    SVGTextElement* imp = static_cast<SVGTextElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getScreenCTM()).get(), imp);
    return result;
}

JSValuePtr jsSVGTextElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTextElement::s_info))
        return throwError(exec, TypeError);
    JSSVGTextElement* castedThisObj = static_cast<JSSVGTextElement*>(asObject(thisValue));
    SVGTextElement* imp = static_cast<SVGTextElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(exec, 0));


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getTransformToElement(element, ec)).get(), imp);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
