/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(VIDEO)

#include "JSHTMLSourceElement.h"

#include <wtf/GetPtr.h>

#include "HTMLSourceElement.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLSourceElement)

/* Hash table */

static const HashTableValue JSHTMLSourceElementTableValues[5] =
{
    { "src", DontDelete, (intptr_t)jsHTMLSourceElementSrc, (intptr_t)setJSHTMLSourceElementSrc },
    { "type", DontDelete, (intptr_t)jsHTMLSourceElementType, (intptr_t)setJSHTMLSourceElementType },
    { "media", DontDelete, (intptr_t)jsHTMLSourceElementMedia, (intptr_t)setJSHTMLSourceElementMedia },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLSourceElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLSourceElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSHTMLSourceElementTableValues, 0 };
#else
    { 9, 7, JSHTMLSourceElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLSourceElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLSourceElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLSourceElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLSourceElementConstructorTableValues, 0 };
#endif

class JSHTMLSourceElementConstructor : public DOMObject {
public:
    JSHTMLSourceElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLSourceElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLSourceElementPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLSourceElementConstructor::s_info = { "HTMLSourceElementConstructor", 0, &JSHTMLSourceElementConstructorTable, 0 };

bool JSHTMLSourceElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLSourceElementConstructor, DOMObject>(exec, &JSHTMLSourceElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLSourceElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLSourceElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLSourceElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLSourceElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLSourceElementPrototype::s_info = { "HTMLSourceElementPrototype", 0, &JSHTMLSourceElementPrototypeTable, 0 };

JSObject* JSHTMLSourceElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLSourceElement>(exec, globalObject);
}

const ClassInfo JSHTMLSourceElement::s_info = { "HTMLSourceElement", &JSHTMLElement::s_info, &JSHTMLSourceElementTable, 0 };

JSHTMLSourceElement::JSHTMLSourceElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLSourceElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLSourceElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLSourceElementPrototype(JSHTMLSourceElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLSourceElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLSourceElement, Base>(exec, &JSHTMLSourceElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLSourceElementSrc(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLSourceElement* imp = static_cast<HTMLSourceElement*>(static_cast<JSHTMLSourceElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->src());
}

JSValuePtr jsHTMLSourceElementType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLSourceElement* imp = static_cast<HTMLSourceElement*>(static_cast<JSHTMLSourceElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->type());
}

JSValuePtr jsHTMLSourceElementMedia(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLSourceElement* imp = static_cast<HTMLSourceElement*>(static_cast<JSHTMLSourceElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->media());
}

JSValuePtr jsHTMLSourceElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLSourceElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLSourceElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLSourceElement, Base>(exec, propertyName, value, &JSHTMLSourceElementTable, this, slot);
}

void setJSHTMLSourceElementSrc(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLSourceElement* imp = static_cast<HTMLSourceElement*>(static_cast<JSHTMLSourceElement*>(thisObject)->impl());
    imp->setSrc(value->toString(exec));
}

void setJSHTMLSourceElementType(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLSourceElement* imp = static_cast<HTMLSourceElement*>(static_cast<JSHTMLSourceElement*>(thisObject)->impl());
    imp->setType(value->toString(exec));
}

void setJSHTMLSourceElementMedia(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLSourceElement* imp = static_cast<HTMLSourceElement*>(static_cast<JSHTMLSourceElement*>(thisObject)->impl());
    imp->setMedia(value->toString(exec));
}

JSValuePtr JSHTMLSourceElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLSourceElementConstructor>(exec);
}


}

#endif // ENABLE(VIDEO)
