/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: ProgressBarHelper.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _XMLOFF_PROGRESSBARHELPER_HXX
#define _XMLOFF_PROGRESSBARHELPER_HXX

#include "sal/config.h"
#include "xmloff/dllapi.h"
#include <com/sun/star/task/XStatusIndicator.hpp>
#include <com/sun/star/frame/XModel.hpp>

#define XML_PROGRESSRANGE	"ProgressRange"
#define XML_PROGRESSMAX		"ProgressMax"
#define XML_PROGRESSCURRENT	"ProgressCurrent"
#define XML_PROGRESSREPEAT  "ProgressRepeat"

class XMLOFF_DLLPUBLIC ProgressBarHelper
{
			::com::sun::star::uno::Reference < ::com::sun::star::task::XStatusIndicator > 	xStatusIndicator;
			sal_Int32																		nRange;
			sal_Int32																		nReference;
			sal_Int32																		nValue;
			double																			fOldPercent;
			sal_Bool																		bStrict;
            // #96469#; if the value goes over the Range the progressbar starts again
            sal_Bool                                                                        bRepeat;

#ifndef PRODUCT
			sal_Bool																		bFailure;
#endif
public:
			ProgressBarHelper(const ::com::sun::star::uno::Reference < ::com::sun::star::task::XStatusIndicator>& xStatusIndicator,
								const sal_Bool bStrict);
			~ProgressBarHelper();

			void SetText(::rtl::OUString& rText) { if (xStatusIndicator.is()) xStatusIndicator->setText(rText); }
			void SetRange(sal_Int32 nVal) { nRange = nVal; }
			void SetReference(sal_Int32 nVal) { nReference = nVal; }
			void SetValue(sal_Int32 nValue);
            void SetRepeat(sal_Bool bValue) { bRepeat = bValue; }
			inline void Increment(sal_Int32 nInc = 1) { SetValue( nValue+nInc ); }
            void End() { if (xStatusIndicator.is()) xStatusIndicator->end(); }

			// set the new reference and returns the new value which gives the
			// Progress Bar the sam position as before
			sal_Int32 ChangeReference(sal_Int32 nNewReference);

			sal_Int32 GetReference() { return nReference; }
			sal_Int32 GetValue() { return nValue; }
            sal_Bool GetRepeat() { return bRepeat; }
};

#endif

