/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: ucbprops.hxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _UCBPROPS_HXX
#define _UCBPROPS_HXX

#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/lang/XTypeProvider.hpp>
#include <com/sun/star/lang/XServiceInfo.hpp>
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#include <cppuhelper/weak.hxx>
#include <osl/mutex.hxx>
#include <ucbhelper/macros.hxx>

//=========================================================================

#define PROPERTIES_MANAGER_SERVICE_NAME "com.sun.star.ucb.PropertiesManager"

//============================================================================
//
// class UcbPropertiesManager.
//
//============================================================================

class UcbPropertiesManager :
				public cppu::OWeakObject,
				public com::sun::star::lang::XTypeProvider,
				public com::sun::star::lang::XServiceInfo,
				public com::sun::star::beans::XPropertySetInfo
{
	com::sun::star::uno::Sequence< com::sun::star::beans::Property >*
								m_pProps;
	osl::Mutex					m_aMutex;

private:
    sal_Bool queryProperty( const rtl::OUString& rName,
							com::sun::star::beans::Property& rProp );

public:
	UcbPropertiesManager( const com::sun::star::uno::Reference<
							com::sun::star::lang::XMultiServiceFactory >&
								rxSMgr );
	virtual ~UcbPropertiesManager();

	// XInterface
	XINTERFACE_DECL()

	// XTypeProvider
	XTYPEPROVIDER_DECL()

    // XServiceInfo
	XSERVICEINFO_DECL()

	// XPropertySetInfo
    virtual com::sun::star::uno::Sequence<
				com::sun::star::beans::Property > SAL_CALL
	getProperties()
		throw( com::sun::star::uno::RuntimeException );
    virtual com::sun::star::beans::Property SAL_CALL
	getPropertyByName( const rtl::OUString& aName )
		throw( com::sun::star::beans::UnknownPropertyException,
			   com::sun::star::uno::RuntimeException );
    virtual sal_Bool SAL_CALL
	hasPropertyByName( const rtl::OUString& Name )
		throw( com::sun::star::uno::RuntimeException );
};

#endif /* !_UCBPROPS_HXX */

