/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: toolboxdocumenthandler.hxx,v $
 * $Revision: 1.6 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef __FRAMEWORK_CLASSES_TOOLBOXDOCUMENTHANDLER_HXX_
#define __FRAMEWORK_CLASSES_TOOLBOXDOCUMENTHANDLER_HXX_

#include <classes/toolboxconfiguration.hxx>

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef __COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________
#include <threadhelp/threadhelpbase.hxx>
#include <rtl/ustring.hxx>
#include <cppuhelper/weak.hxx>

#ifndef __SGI_STL_HASH_MAP
#include <hash_map>
#endif
#include <stdtypes.h>

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//*****************************************************************************************************************
// Hash code function for using in all hash maps of follow implementation.

class OReadToolBoxDocumentHandler : public ::com::sun::star::xml::sax::XDocumentHandler,
									private ThreadHelpBase,	// Struct for right initalization of lock member! Must be first of baseclasses.
									public ::cppu::OWeakObject
{
	public:
		enum ToolBox_XML_Entry
		{
			TB_ELEMENT_TOOLBAR,
			TB_ELEMENT_TOOLBARITEM,
			TB_ELEMENT_TOOLBARSPACE,
			TB_ELEMENT_TOOLBARBREAK,
			TB_ELEMENT_TOOLBARSEPARATOR,
			TB_ATTRIBUTE_TEXT,
			TB_ATTRIBUTE_BITMAP,
			TB_ATTRIBUTE_URL,
			TB_ATTRIBUTE_ITEMBITS,
			TB_ATTRIBUTE_VISIBLE,
			TB_ATTRIBUTE_WIDTH,
			TB_ATTRIBUTE_USER,
			TB_ATTRIBUTE_HELPID,
			TB_ATTRIBUTE_STYLE,
			TB_XML_ENTRY_COUNT
		};

		enum ToolBox_XML_Namespace
		{
			TB_NS_TOOLBAR,
			TB_NS_XLINK,
			TB_XML_NAMESPACES_COUNT
		};
		
		OReadToolBoxDocumentHandler( ToolBoxDescriptor& aToolBoxItems );
		virtual ~OReadToolBoxDocumentHandler();

		// XInterface
		virtual void SAL_CALL acquire() throw()
			{ OWeakObject::acquire(); }
		virtual void SAL_CALL release() throw()
			{ OWeakObject::release(); }
		virtual ::com::sun::star::uno::Any SAL_CALL queryInterface(
			const ::com::sun::star::uno::Type & rType ) throw( ::com::sun::star::uno::RuntimeException );

		// XDocumentHandler
		virtual void SAL_CALL startDocument(void)
		throw (	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL endDocument(void)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL startElement(
			const rtl::OUString& aName,
			const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList > &xAttribs)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL endElement(const rtl::OUString& aName)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL characters(const rtl::OUString& aChars)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL ignorableWhitespace(const rtl::OUString& aWhitespaces)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL processingInstruction(const rtl::OUString& aTarget,
													const rtl::OUString& aData)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

		virtual void SAL_CALL setDocumentLocator(
			const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XLocator > &xLocator)
		throw(	::com::sun::star::xml::sax::SAXException,
				::com::sun::star::uno::RuntimeException );

	private:
		::rtl::OUString getErrorLineString();

		class ToolBoxHashMap : public ::std::hash_map<	::rtl::OUString					,
														ToolBox_XML_Entry				,
														OUStringHashCode				,
														::std::equal_to< ::rtl::OUString >	>
		{
			public:
				inline void free()
				{
					ToolBoxHashMap().swap( *this );
				}
		};

		sal_Bool																	m_bToolBarStartFound;
		sal_Bool																	m_bToolBarEndFound;
		sal_Bool																	m_bToolBarItemStartFound;
		sal_Bool																	m_bToolBarSpaceStartFound;
		sal_Bool																	m_bToolBarBreakStartFound;
		sal_Bool																	m_bToolBarSeparatorStartFound;
		ToolBoxHashMap																m_aToolBoxMap;
		ToolBoxDescriptor&															m_aToolBoxItems;
		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XLocator >	m_xLocator;
		
		sal_Int32																	m_nHashCode_Style_Radio;
		sal_Int32																	m_nHashCode_Style_Auto;
		sal_Int32																	m_nHashCode_Style_Left;
		sal_Int32																	m_nHashCode_Style_AutoSize;
		sal_Int32																	m_nHashCode_Style_DropDown;
		sal_Int32																	m_nHashCode_Style_Repeat;
};

class OWriteToolBoxDocumentHandler : private ThreadHelpBase // Struct for right initalization of lock member! Must be first of baseclasses.
{
	public:
		OWriteToolBoxDocumentHandler(
			const ToolBoxDescriptor& aToolBoxItems,
			::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler > );
		virtual ~OWriteToolBoxDocumentHandler();

		void WriteToolBoxDocument() throw
			( ::com::sun::star::xml::sax::SAXException,
			  ::com::sun::star::uno::RuntimeException );
	
	protected:
		virtual void WriteToolBoxItem( const ToolBoxItemDescriptor* ) throw
			( ::com::sun::star::xml::sax::SAXException,
			  ::com::sun::star::uno::RuntimeException );

		virtual void WriteToolBoxSpace() throw
			( ::com::sun::star::xml::sax::SAXException,
			  ::com::sun::star::uno::RuntimeException );
		
		virtual void WriteToolBoxBreak() throw
			( ::com::sun::star::xml::sax::SAXException,
			  ::com::sun::star::uno::RuntimeException );
		
		virtual void WriteToolBoxSeparator() throw
			( ::com::sun::star::xml::sax::SAXException,
			  ::com::sun::star::uno::RuntimeException );

		const ToolBoxDescriptor&															m_aToolBoxItems;
		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XDocumentHandler >	m_xWriteDocumentHandler;
		::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >		m_xEmptyList;
		::rtl::OUString																		m_aXMLToolbarNS;
		::rtl::OUString																		m_aXMLXlinkNS;
		::rtl::OUString																		m_aAttributeType;
		::rtl::OUString																		m_aAttributeURL;
};

} // namespace framework

#endif
