/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XFocusListener;
import com.sun.star.awt.XKeyListener;
import com.sun.star.awt.XMouseListener;
import com.sun.star.awt.XMouseMotionListener;
import com.sun.star.awt.XPaintListener;
import com.sun.star.awt.XWindowListener;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.media.XPlayerWindow;
import com.sun.star.media.ZoomLevel;
import com.sun.star.uno.AnyConverter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.media.Player;

public class PlayerWindow
implements KeyListener,
MouseListener,
MouseMotionListener,
FocusListener,
XServiceInfo,
XPlayerWindow {
    private XMultiServiceFactory maFactory;
    private WindowAdapter maFrame;
    private Player maPlayer;
    private ZoomLevel meZoomLevel = ZoomLevel.ORIGINAL;
    private boolean mbShowControls = false;
    private static final String s_implName = "com.sun.star.comp.PlayerWindow_Java";
    private static final String s_serviceName = "com.sun.star.media.PlayerWindow_Java";

    public PlayerWindow(XMultiServiceFactory xMultiServiceFactory, Object[] objectArray, Player player) {
        this.maFactory = xMultiServiceFactory;
        try {
            if (objectArray.length > 1) {
                Component component;
                Rectangle rectangle = (Rectangle)objectArray[1];
                this.maFrame = new WindowAdapter(AnyConverter.toInt((Object)objectArray[0]));
                this.maFrame.setPosSize(rectangle.X, rectangle.Y, rectangle.Width, rectangle.Height, (short)0);
                if (objectArray.length > 2) {
                    this.mbShowControls = AnyConverter.toBoolean((Object)objectArray[2]);
                }
                Panel panel = new Panel(new BorderLayout());
                panel.setLayout(null);
                panel.setBackground(Color.black);
                panel.addKeyListener(this);
                panel.addMouseListener(this);
                panel.addMouseMotionListener(this);
                if (this.mbShowControls) {
                    component = player.getControlPanelComponent();
                    if (component != null) {
                        panel.add(component);
                    } else {
                        this.mbShowControls = false;
                    }
                }
                if ((component = player.getVisualComponent()) != null) {
                    component.addKeyListener(this);
                    component.addMouseListener(this);
                    component.addMouseMotionListener(this);
                    component.addFocusListener(this);
                    panel.add(component);
                } else {
                    this.meZoomLevel = ZoomLevel.NOT_AVAILABLE;
                }
                if (this.maFrame.getJavaFrame() != null) {
                    this.maFrame.getJavaFrame().add(panel);
                }
                this.LayoutComponents();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected synchronized void LayoutComponents() {
        if (this.maFrame.getJavaFrame() != null) {
            Dimension dimension;
            Component component;
            Panel panel = (Panel)this.maFrame.getJavaFrame().getComponent(0);
            int n = this.maFrame.getJavaFrame().getWidth();
            int n2 = this.maFrame.getJavaFrame().getHeight();
            int n3 = 0;
            panel.setBounds(0, 0, n, n2);
            if (this.mbShowControls && (component = panel.getComponent(0)) != null) {
                dimension = component.getPreferredSize();
                n3 = Math.min(n2, dimension.height);
                component.setBounds(0, n2 - n3, n, n3);
            }
            if (ZoomLevel.NOT_AVAILABLE != this.meZoomLevel) {
                component = panel.getComponent(this.mbShowControls ? 1 : 0);
                if (component != null) {
                    dimension = component.getPreferredSize();
                    int n4 = n;
                    int n5 = n2 - n3;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 0;
                    boolean bl = false;
                    boolean bl2 = false;
                    if (ZoomLevel.ORIGINAL == this.meZoomLevel) {
                        bl2 = true;
                    } else if (ZoomLevel.ZOOM_1_TO_4 == this.meZoomLevel) {
                        dimension.width >>= 2;
                        dimension.height >>= 2;
                        bl2 = true;
                    } else if (ZoomLevel.ZOOM_1_TO_2 == this.meZoomLevel) {
                        dimension.width >>= 1;
                        dimension.height >>= 1;
                        bl2 = true;
                    } else if (ZoomLevel.ZOOM_2_TO_1 == this.meZoomLevel) {
                        dimension.width <<= 1;
                        dimension.height <<= 1;
                        bl2 = true;
                    } else if (ZoomLevel.ZOOM_4_TO_1 == this.meZoomLevel) {
                        dimension.width <<= 2;
                        dimension.height <<= 2;
                        bl2 = true;
                    } else if (ZoomLevel.FIT_TO_WINDOW == this.meZoomLevel) {
                        n8 = n4;
                        n9 = n5;
                        bl = true;
                    }
                    if (bl2 && dimension.width <= n4 && dimension.height <= n5) {
                        n6 = n4 - dimension.width >> 1;
                        n7 = n5 - dimension.height >> 1;
                        n8 = dimension.width;
                        n9 = dimension.height;
                        bl = true;
                    }
                    if (!bl) {
                        if (dimension.width > 0 && dimension.height > 0 && n4 > 0 && n5 > 0) {
                            double d = (double)dimension.width / (double)dimension.height;
                            if (d < (double)n4 / (double)n5) {
                                n4 = (int)((double)n5 * d);
                            } else {
                                n5 = (int)((double)n4 / d);
                            }
                            n6 = n - n4 >> 1;
                            n7 = n2 - n3 - n5 >> 1;
                            n8 = n4;
                            n9 = n5;
                        } else {
                            n9 = 0;
                            n8 = 0;
                            n7 = 0;
                            n6 = 0;
                        }
                    }
                    component.setBounds(n6, n7, n8, n9);
                    component.requestFocus();
                } else {
                    panel.requestFocus();
                }
            } else {
                panel.requestFocus();
            }
        }
    }

    private void implFireMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() != null && mouseEvent.getSource() instanceof Component) {
            mouseEvent.translatePoint(((Component)mouseEvent.getSource()).getX(), ((Component)mouseEvent.getSource()).getY());
        }
        this.maFrame.fireMouseEvent(mouseEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.maFrame.fireKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.maFrame.fireKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.maFrame.fireKeyEvent(keyEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.implFireMouseEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.implFireMouseEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.implFireMouseEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.implFireMouseEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.implFireMouseEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.implFireMouseEvent(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.implFireMouseEvent(mouseEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.maFrame.getJavaFrame() != null) {
            this.maFrame.fireFocusEvent(focusEvent);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.maFrame.getJavaFrame() != null) {
            this.maFrame.fireFocusEvent(focusEvent);
        }
    }

    public synchronized void update() {
        if (this.maFrame.getJavaFrame() != null) {
            this.maFrame.getJavaFrame().repaint();
        }
    }

    public synchronized boolean setZoomLevel(ZoomLevel zoomLevel) {
        boolean bl = false;
        if (ZoomLevel.NOT_AVAILABLE != this.meZoomLevel && ZoomLevel.NOT_AVAILABLE != zoomLevel) {
            if (zoomLevel != this.meZoomLevel) {
                this.meZoomLevel = zoomLevel;
                this.LayoutComponents();
            }
            bl = true;
        }
        return bl;
    }

    public synchronized ZoomLevel getZoomLevel() {
        return this.meZoomLevel;
    }

    public synchronized void setPointerType(int n) {
        if (this.maFrame.getJavaFrame() != null) {
            int n2;
            switch (n) {
                case 5: {
                    n2 = 1;
                    break;
                }
                case 27: {
                    n2 = 12;
                    break;
                }
                case 6: {
                    n2 = 13;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            this.maFrame.getJavaFrame().setCursor(Cursor.getPredefinedCursor(n2));
        }
    }

    public synchronized void dispose() {
        if (this.maFrame != null) {
            Panel panel = (Panel)this.maFrame.getJavaFrame().getComponent(0);
            if (panel != null && panel.getComponent(0) != null) {
                panel.getComponent(0).removeFocusListener(this);
            }
            if (this.maFrame.getJavaFrame() != null) {
                this.maFrame.getJavaFrame().dispose();
            }
            this.maFrame.fireDisposingEvent();
        }
        this.maFrame = null;
    }

    public synchronized void setPosSize(int n, int n2, int n3, int n4, short s) {
        if (this.maFrame != null) {
            this.maFrame.setPosSize(n, n2, n3, n4, s);
            this.LayoutComponents();
        }
    }

    public synchronized Rectangle getPosSize() {
        return this.maFrame != null ? this.maFrame.getPosSize() : new Rectangle();
    }

    public synchronized void setVisible(boolean bl) {
        if (this.maFrame != null) {
            this.maFrame.setVisible(bl);
        }
    }

    public synchronized void setEnable(boolean bl) {
        if (this.maFrame != null) {
            this.maFrame.setEnable(bl);
        }
    }

    public synchronized void setFocus() {
        if (this.maFrame != null) {
            this.maFrame.setFocus();
        }
    }

    public synchronized void addEventListener(XEventListener xEventListener) {
        if (this.maFrame != null) {
            this.maFrame.addEventListener(xEventListener);
        }
    }

    public synchronized void removeEventListener(XEventListener xEventListener) {
        if (this.maFrame != null) {
            this.maFrame.removeEventListener(xEventListener);
        }
    }

    public synchronized void addWindowListener(XWindowListener xWindowListener) {
        if (this.maFrame != null) {
            this.maFrame.addWindowListener(xWindowListener);
        }
    }

    public synchronized void removeWindowListener(XWindowListener xWindowListener) {
        if (this.maFrame != null) {
            this.maFrame.removeWindowListener(xWindowListener);
        }
    }

    public synchronized void addFocusListener(XFocusListener xFocusListener) {
        if (this.maFrame != null) {
            this.maFrame.addFocusListener(xFocusListener);
        }
    }

    public synchronized void removeFocusListener(XFocusListener xFocusListener) {
        if (this.maFrame != null) {
            this.maFrame.removeFocusListener(xFocusListener);
        }
    }

    public synchronized void addKeyListener(XKeyListener xKeyListener) {
        if (this.maFrame != null) {
            this.maFrame.addKeyListener(xKeyListener);
        }
    }

    public synchronized void removeKeyListener(XKeyListener xKeyListener) {
        if (this.maFrame != null) {
            this.maFrame.removeKeyListener(xKeyListener);
        }
    }

    public synchronized void addMouseListener(XMouseListener xMouseListener) {
        if (this.maFrame != null) {
            this.maFrame.addMouseListener(xMouseListener);
        }
    }

    public synchronized void removeMouseListener(XMouseListener xMouseListener) {
        if (this.maFrame != null) {
            this.maFrame.removeMouseListener(xMouseListener);
        }
    }

    public synchronized void addMouseMotionListener(XMouseMotionListener xMouseMotionListener) {
        if (this.maFrame != null) {
            this.maFrame.addMouseMotionListener(xMouseMotionListener);
        }
    }

    public synchronized void removeMouseMotionListener(XMouseMotionListener xMouseMotionListener) {
        if (this.maFrame != null) {
            this.maFrame.removeMouseMotionListener(xMouseMotionListener);
        }
    }

    public synchronized void addPaintListener(XPaintListener xPaintListener) {
        if (this.maFrame != null) {
            this.maFrame.addPaintListener(xPaintListener);
        }
    }

    public synchronized void removePaintListener(XPaintListener xPaintListener) {
        if (this.maFrame != null) {
            this.maFrame.removePaintListener(xPaintListener);
        }
    }

    public synchronized String getImplementationName() {
        return s_implName;
    }

    public synchronized String[] getSupportedServiceNames() {
        return new String[]{s_serviceName};
    }

    public synchronized boolean supportsService(String string) {
        return string.equals(s_serviceName);
    }
}

