/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CComponent;
import apple.awt.CToolkit;
import apple.awt.MyCScrollPane;
import apple.awt.PeerImpl;
import com.apple.eawt.CocoaComponent;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.peer.CanvasPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.WindowPeer;
import java.util.Date;
import jep.AppletFrame;
import jep.AppletHandlerFactory;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;

public class MyCToolkit
extends CToolkit {
    private static boolean showDebugInfo = false;

    public MyCToolkit() {
        if (showDebugInfo) {
            System.err.println("Calling MyCToolkit()");
        }
        AppletHandlerFactory.resetMainEventQueue();
    }

    public FramePeer createFrame(Frame frame) {
        if (frame == null) {
            return super.createFrame(frame);
        }
        FramePeer framePeer = null;
        if (frame instanceof AppletFrame) {
            try {
                Object[] objectArray = new Object[]{frame, frame};
                framePeer = (FramePeer)AppletHandlerFactory.myCAppletFrameCreateNew.invoke(null, objectArray);
            }
            catch (Throwable throwable) {
                System.err.println("MyCToolkit createFrame(): exception: " + throwable.getMessage());
                throwable.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(frame, framePeer);
        } else {
            framePeer = super.createFrame(frame);
            AppletFrame appletFrame = AppletFrame.getCurrentAppletFrame();
            if (appletFrame != null) {
                appletFrame.addChildWindow(frame);
            }
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createFrame(): Frame " + framePeer.toString() + " thread " + Thread.currentThread().toString());
        }
        return framePeer;
    }

    public WindowPeer createWindow(Window window) {
        AppletFrame appletFrame;
        WindowPeer windowPeer = super.createWindow(window);
        if (window != null && (appletFrame = AppletFrame.getCurrentAppletFrame()) != null) {
            appletFrame.addChildWindow(window);
        }
        return windowPeer;
    }

    public DialogPeer createDialog(Dialog dialog) {
        AppletFrame appletFrame;
        DialogPeer dialogPeer = super.createDialog(dialog);
        if (dialog != null && (appletFrame = AppletFrame.getCurrentAppletFrame()) != null) {
            appletFrame.addChildWindow(dialog);
        }
        return dialogPeer;
    }

    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        AppletFrame appletFrame;
        FileDialogPeer fileDialogPeer = super.createFileDialog(fileDialog);
        if (fileDialog != null && (appletFrame = AppletFrame.getCurrentAppletFrame()) != null) {
            appletFrame.addChildWindow(fileDialog);
        }
        return fileDialogPeer;
    }

    public PanelPeer createPanel(Panel panel) {
        Object object;
        if (panel == null) {
            return super.createPanel(panel);
        }
        Container container = panel;
        while ((object = container.getParent()) != null) {
            container = object;
        }
        object = null;
        if (container instanceof AppletFrame) {
            try {
                Object[] objectArray = new Object[]{panel, container};
                object = (PanelPeer)AppletHandlerFactory.myCPanelCreateNew.invoke(null, objectArray);
            }
            catch (Throwable throwable) {
                System.err.println("MyCToolkit createPanel(): exception: " + throwable.getMessage());
                throwable.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(panel, object);
        } else {
            object = super.createPanel(panel);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createPanel(): Panel " + object.toString() + " thread " + Thread.currentThread().toString());
        }
        return object;
    }

    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        Object object;
        if (scrollPane == null) {
            return super.createScrollPane(scrollPane);
        }
        Container container = scrollPane;
        while ((object = container.getParent()) != null) {
            container = object;
        }
        object = null;
        if (container instanceof AppletFrame) {
            try {
                Object[] objectArray = new Object[]{scrollPane, container};
                object = (ScrollPanePeer)AppletHandlerFactory.myCScrollPaneCreateNew.invoke(null, objectArray);
            }
            catch (Throwable throwable) {
                System.err.println("MyCToolkit createScrollPane(): exception: " + throwable.getMessage());
                throwable.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(scrollPane, object);
        } else {
            object = super.createScrollPane(scrollPane);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createScrollPane(): ScrollPane " + object.toString() + " thread " + Thread.currentThread().toString());
        }
        return object;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        Object object;
        if (canvas == null) {
            return super.createCanvas(canvas);
        }
        Component component = canvas;
        while ((object = component.getParent()) != null) {
            component = object;
        }
        object = null;
        long l = 0L;
        if (component instanceof AppletFrame) {
            if (canvas instanceof CocoaComponent) {
                l = ((CocoaComponent)canvas).createNSView();
            }
            try {
                Object[] objectArray = new Object[]{canvas, new Long(l), component};
                object = (CanvasPeer)AppletHandlerFactory.myCCanvasCreateNew.invoke(null, objectArray);
            }
            catch (Throwable throwable) {
                System.err.println("MyCToolkit createCanvas(): exception: " + throwable.getMessage());
                throwable.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(canvas, object);
        } else {
            object = super.createCanvas(canvas);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createCanvas(): (nsView is 0x" + Long.toHexString(l) + ") Canvas " + object.toString() + " thread " + Thread.currentThread().toString());
        }
        return object;
    }

    public LabelPeer createLabel(Label label) {
        Object object;
        if (label == null || !AppletHandlerFactory.isJava142Tiger()) {
            return super.createLabel(label);
        }
        Component component = label;
        while ((object = component.getParent()) != null) {
            component = object;
        }
        object = null;
        if (component instanceof AppletFrame) {
            try {
                Object[] objectArray = new Object[]{label, component};
                object = (LabelPeer)AppletHandlerFactory.myCLabelCreateNew.invoke(null, objectArray);
            }
            catch (Throwable throwable) {
                System.err.println("MyCToolkit createLabel(): exception: " + throwable.getMessage());
                throwable.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(label, object);
        } else {
            object = super.createLabel(label);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createLabel(): Label " + object.toString() + " thread " + Thread.currentThread().toString());
        }
        return object;
    }

    public static boolean postMouseMovedEvent(Object object, int n, int n2, long l) {
        if (object instanceof CComponent) {
            Object object2;
            Component component = MyCToolkit.getPeerTarget((PeerImpl)((CComponent)object));
            while ((object2 = component.getParent()) != null) {
                component = object2;
            }
            if (!(component instanceof AppletFrame)) {
                return false;
            }
            if (((AppletFrame)component).destroying) {
                return true;
            }
            object2 = null;
            Component component2 = null;
            Applet applet = ((AppletFrame)component).getApplet();
            component2 = applet != null ? applet : component;
            object2 = SunToolkit.targetToAppContext(component2);
            boolean bl = AppContext.getAppContext().equals(object2);
            if (bl && !AppletHandlerFactory.isMainThread()) {
                ((CComponent)object).postEvent((AWTEvent)new MouseEvent(MyCToolkit.getPeerTarget((PeerImpl)((CComponent)object)), 503, l, 0, n, n2, 0, false));
            } else {
                SunToolkit.postEvent((AppContext)object2, new PeerEvent(applet, new PostMouseMovedEvent((CComponent)object, n, n2, l), 1L));
            }
            return true;
        }
        return false;
    }

    public static void setScrollPanePosition(Object object, int n, int n2) {
        Object object2;
        if (!(object instanceof MyCScrollPane)) {
            return;
        }
        MyCScrollPane myCScrollPane = (MyCScrollPane)((Object)object);
        ScrollPane scrollPane = (ScrollPane)MyCToolkit.getPeerTarget((PeerImpl)myCScrollPane);
        if (scrollPane == null) {
            return;
        }
        Container container = scrollPane;
        while ((object2 = container.getParent()) != null) {
            container = object2;
        }
        if (!(container instanceof AppletFrame)) {
            return;
        }
        if (((AppletFrame)container).destroying) {
            return;
        }
        object2 = null;
        Container container2 = null;
        Applet applet = ((AppletFrame)container).getApplet();
        container2 = applet != null ? applet : container;
        object2 = SunToolkit.targetToAppContext(container2);
        boolean bl = AppContext.getAppContext().equals(object2);
        if (bl && !AppletHandlerFactory.isMainThread()) {
            Point point = scrollPane.getScrollPosition();
            if (point.x != n || point.y != n2) {
                myCScrollPane.setSkipNextScrollView();
                scrollPane.setScrollPosition(n, n2);
            }
        } else {
            SunToolkit.postEvent((AppContext)object2, new PeerEvent(applet, new SetScrollPanePosition((AppletFrame)container, myCScrollPane, n, n2), 1L));
        }
    }

    public static void printStackTrace() {
        System.err.print(new Date() + " ");
        Throwable throwable = new Throwable();
        throwable.fillInStackTrace();
        throwable.printStackTrace();
    }

    public static String getJavaThread() {
        return Thread.currentThread().toString();
    }

    public static Component getPeerTarget(PeerImpl peerImpl) {
        if (peerImpl == null) {
            return null;
        }
        if (AppletHandlerFactory.getOSXVersion() >= 4192) {
            try {
                return (Component)peerImpl.getClass().getMethod("getTarget", null).invoke((Object)peerImpl, (Object[])null);
            }
            catch (Throwable throwable) {
                System.err.println("MyCToolkit.getPeerTarget(): exception: " + throwable.getMessage());
                throwable.printStackTrace();
                return null;
            }
        }
        return peerImpl.fTarget;
    }

    public static long getPeerCocoaParentView(Object object) {
        Container container;
        if (object == null || !(object instanceof CComponent)) {
            return 0L;
        }
        Component component = MyCToolkit.getPeerTarget((PeerImpl)((CComponent)object));
        if (component == null) {
            return 0L;
        }
        while ((container = component.getParent()) != null) {
            component = container;
        }
        if (!(component instanceof AppletFrame)) {
            return 0L;
        }
        return ((AppletFrame)component).getCocoaParentView();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " (jep)";
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("jep.debuginfo", "false"))) {
            showDebugInfo = true;
        }
    }

    private static class SetScrollPanePosition
    implements Runnable {
        private final AppletFrame frame;
        private final MyCScrollPane scrollPanePeer;
        private final int x;
        private final int y;

        SetScrollPanePosition(AppletFrame appletFrame, MyCScrollPane myCScrollPane, int n, int n2) {
            this.frame = appletFrame;
            this.scrollPanePeer = myCScrollPane;
            this.x = n;
            this.y = n2;
        }

        public void run() {
            ScrollPane scrollPane = (ScrollPane)MyCToolkit.getPeerTarget((PeerImpl)this.scrollPanePeer);
            Point point = scrollPane.getScrollPosition();
            if (point.x == this.x && point.y == this.y) {
                return;
            }
            this.scrollPanePeer.setSkipNextScrollView();
            this.frame.validateClips();
            scrollPane.setScrollPosition(this.x, this.y);
        }
    }

    private static class PostMouseMovedEvent
    implements Runnable {
        private final CComponent peer;
        private final int x;
        private final int y;
        private final long when;

        PostMouseMovedEvent(CComponent cComponent, int n, int n2, long l) {
            this.peer = cComponent;
            this.x = n;
            this.y = n2;
            this.when = l;
        }

        public void run() {
            this.peer.postEvent((AWTEvent)new MouseEvent(MyCToolkit.getPeerTarget((PeerImpl)this.peer), 503, this.when, 0, this.x, this.y, 0, false));
        }
    }
}

