//
// mcspdu.cxx
//
// Code automatically generated by asnparse.
//

#ifdef P_USE_PRAGMA
#pragma implementation "mcs.h"
#endif

#include <ptlib.h>
#include "asn/mcs.h"

#define new PNEW


#if ! H323_DISABLE_MCS

//
// ChannelId
//

MCS_ChannelId::MCS_ChannelId(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Integer(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 0, 65535);
}


MCS_ChannelId & MCS_ChannelId::operator=(int v)
{
  SetValue(v);
  return *this;
}


MCS_ChannelId & MCS_ChannelId::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * MCS_ChannelId::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_ChannelId::Class()), PInvalidCast);
#endif
  return new MCS_ChannelId(*this);
}


//
// StaticChannelId
//

MCS_StaticChannelId::MCS_StaticChannelId(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Integer(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1, 1000);
}


MCS_StaticChannelId & MCS_StaticChannelId::operator=(int v)
{
  SetValue(v);
  return *this;
}


MCS_StaticChannelId & MCS_StaticChannelId::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * MCS_StaticChannelId::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_StaticChannelId::Class()), PInvalidCast);
#endif
  return new MCS_StaticChannelId(*this);
}


//
// DynamicChannelId
//

MCS_DynamicChannelId::MCS_DynamicChannelId(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Integer(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1001, 65535);
}


MCS_DynamicChannelId & MCS_DynamicChannelId::operator=(int v)
{
  SetValue(v);
  return *this;
}


MCS_DynamicChannelId & MCS_DynamicChannelId::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * MCS_DynamicChannelId::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_DynamicChannelId::Class()), PInvalidCast);
#endif
  return new MCS_DynamicChannelId(*this);
}


//
// UserId
//

MCS_UserId::MCS_UserId(unsigned tag, PASN_Object::TagClass tagClass)
  : MCS_DynamicChannelId(tag, tagClass)
{
}


MCS_UserId & MCS_UserId::operator=(int v)
{
  SetValue(v);
  return *this;
}


MCS_UserId & MCS_UserId::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * MCS_UserId::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_UserId::Class()), PInvalidCast);
#endif
  return new MCS_UserId(*this);
}


//
// PrivateChannelId
//

MCS_PrivateChannelId::MCS_PrivateChannelId(unsigned tag, PASN_Object::TagClass tagClass)
  : MCS_DynamicChannelId(tag, tagClass)
{
}


MCS_PrivateChannelId & MCS_PrivateChannelId::operator=(int v)
{
  SetValue(v);
  return *this;
}


MCS_PrivateChannelId & MCS_PrivateChannelId::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * MCS_PrivateChannelId::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_PrivateChannelId::Class()), PInvalidCast);
#endif
  return new MCS_PrivateChannelId(*this);
}


//
// AssignedChannelId
//

MCS_AssignedChannelId::MCS_AssignedChannelId(unsigned tag, PASN_Object::TagClass tagClass)
  : MCS_DynamicChannelId(tag, tagClass)
{
}


MCS_AssignedChannelId & MCS_AssignedChannelId::operator=(int v)
{
  SetValue(v);
  return *this;
}


MCS_AssignedChannelId & MCS_AssignedChannelId::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * MCS_AssignedChannelId::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_AssignedChannelId::Class()), PInvalidCast);
#endif
  return new MCS_AssignedChannelId(*this);
}


//
// TokenId
//

MCS_TokenId::MCS_TokenId(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Integer(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1, 65535);
}


MCS_TokenId & MCS_TokenId::operator=(int v)
{
  SetValue(v);
  return *this;
}


MCS_TokenId & MCS_TokenId::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * MCS_TokenId::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TokenId::Class()), PInvalidCast);
#endif
  return new MCS_TokenId(*this);
}


#ifndef PASN_NOPRINTON
const static PASN_Names Names_MCS_TokenStatus[]={
        {"notInUse",0}
       ,{"selfGrabbed",1}
       ,{"otherGrabbed",2}
       ,{"selfInhibited",3}
       ,{"otherInhibited",4}
       ,{"selfRecipient",5}
       ,{"selfGiving",6}
       ,{"otherGiving",7}
};
#endif
//
// TokenStatus
//

MCS_TokenStatus::MCS_TokenStatus(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Enumeration(tag, tagClass, 7, PFalse
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_MCS_TokenStatus,8
#endif
    )
{
}


MCS_TokenStatus & MCS_TokenStatus::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * MCS_TokenStatus::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TokenStatus::Class()), PInvalidCast);
#endif
  return new MCS_TokenStatus(*this);
}


#ifndef PASN_NOPRINTON
const static PASN_Names Names_MCS_DataPriority[]={
        {"top",0}
       ,{"high",1}
       ,{"medium",2}
       ,{"low",3}
};
#endif
//
// DataPriority
//

MCS_DataPriority::MCS_DataPriority(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Enumeration(tag, tagClass, 3, PFalse
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_MCS_DataPriority,4
#endif
    )
{
}


MCS_DataPriority & MCS_DataPriority::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * MCS_DataPriority::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_DataPriority::Class()), PInvalidCast);
#endif
  return new MCS_DataPriority(*this);
}


//
// Segmentation
//

MCS_Segmentation::MCS_Segmentation(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_BitString(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 2);
}


PObject * MCS_Segmentation::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_Segmentation::Class()), PInvalidCast);
#endif
  return new MCS_Segmentation(*this);
}


//
// DomainParameters
//

MCS_DomainParameters::MCS_DomainParameters(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
  m_maxChannelIds.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
  m_maxUserIds.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
  m_maxTokenIds.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
  m_numPriorities.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
  m_minThroughput.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
  m_maxHeight.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
  m_maxMCSPDUsize.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
  m_protocolVersion.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
}


#ifndef PASN_NOPRINTON
void MCS_DomainParameters::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+16) << "maxChannelIds = " << setprecision(indent) << m_maxChannelIds << '\n';
  strm << setw(indent+13) << "maxUserIds = " << setprecision(indent) << m_maxUserIds << '\n';
  strm << setw(indent+14) << "maxTokenIds = " << setprecision(indent) << m_maxTokenIds << '\n';
  strm << setw(indent+16) << "numPriorities = " << setprecision(indent) << m_numPriorities << '\n';
  strm << setw(indent+16) << "minThroughput = " << setprecision(indent) << m_minThroughput << '\n';
  strm << setw(indent+12) << "maxHeight = " << setprecision(indent) << m_maxHeight << '\n';
  strm << setw(indent+16) << "maxMCSPDUsize = " << setprecision(indent) << m_maxMCSPDUsize << '\n';
  strm << setw(indent+18) << "protocolVersion = " << setprecision(indent) << m_protocolVersion << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_DomainParameters::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_DomainParameters), PInvalidCast);
#endif
  const MCS_DomainParameters & other = (const MCS_DomainParameters &)obj;

  Comparison result;

  if ((result = m_maxChannelIds.Compare(other.m_maxChannelIds)) != EqualTo)
    return result;
  if ((result = m_maxUserIds.Compare(other.m_maxUserIds)) != EqualTo)
    return result;
  if ((result = m_maxTokenIds.Compare(other.m_maxTokenIds)) != EqualTo)
    return result;
  if ((result = m_numPriorities.Compare(other.m_numPriorities)) != EqualTo)
    return result;
  if ((result = m_minThroughput.Compare(other.m_minThroughput)) != EqualTo)
    return result;
  if ((result = m_maxHeight.Compare(other.m_maxHeight)) != EqualTo)
    return result;
  if ((result = m_maxMCSPDUsize.Compare(other.m_maxMCSPDUsize)) != EqualTo)
    return result;
  if ((result = m_protocolVersion.Compare(other.m_protocolVersion)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_DomainParameters::GetDataLength() const
{
  PINDEX length = 0;
  length += m_maxChannelIds.GetObjectLength();
  length += m_maxUserIds.GetObjectLength();
  length += m_maxTokenIds.GetObjectLength();
  length += m_numPriorities.GetObjectLength();
  length += m_minThroughput.GetObjectLength();
  length += m_maxHeight.GetObjectLength();
  length += m_maxMCSPDUsize.GetObjectLength();
  length += m_protocolVersion.GetObjectLength();
  return length;
}


PBoolean MCS_DomainParameters::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_maxChannelIds.Decode(strm))
    return PFalse;
  if (!m_maxUserIds.Decode(strm))
    return PFalse;
  if (!m_maxTokenIds.Decode(strm))
    return PFalse;
  if (!m_numPriorities.Decode(strm))
    return PFalse;
  if (!m_minThroughput.Decode(strm))
    return PFalse;
  if (!m_maxHeight.Decode(strm))
    return PFalse;
  if (!m_maxMCSPDUsize.Decode(strm))
    return PFalse;
  if (!m_protocolVersion.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_DomainParameters::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_maxChannelIds.Encode(strm);
  m_maxUserIds.Encode(strm);
  m_maxTokenIds.Encode(strm);
  m_numPriorities.Encode(strm);
  m_minThroughput.Encode(strm);
  m_maxHeight.Encode(strm);
  m_maxMCSPDUsize.Encode(strm);
  m_protocolVersion.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_DomainParameters::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_DomainParameters::Class()), PInvalidCast);
#endif
  return new MCS_DomainParameters(*this);
}


//
// Connect-Initial
//

MCS_Connect_Initial::MCS_Connect_Initial(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_Connect_Initial::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+24) << "callingDomainSelector = " << setprecision(indent) << m_callingDomainSelector << '\n';
  strm << setw(indent+23) << "calledDomainSelector = " << setprecision(indent) << m_calledDomainSelector << '\n';
  strm << setw(indent+13) << "upwardFlag = " << setprecision(indent) << m_upwardFlag << '\n';
  strm << setw(indent+19) << "targetParameters = " << setprecision(indent) << m_targetParameters << '\n';
  strm << setw(indent+20) << "minimumParameters = " << setprecision(indent) << m_minimumParameters << '\n';
  strm << setw(indent+20) << "maximumParameters = " << setprecision(indent) << m_maximumParameters << '\n';
  strm << setw(indent+11) << "userData = " << setprecision(indent) << m_userData << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_Connect_Initial::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_Connect_Initial), PInvalidCast);
#endif
  const MCS_Connect_Initial & other = (const MCS_Connect_Initial &)obj;

  Comparison result;

  if ((result = m_callingDomainSelector.Compare(other.m_callingDomainSelector)) != EqualTo)
    return result;
  if ((result = m_calledDomainSelector.Compare(other.m_calledDomainSelector)) != EqualTo)
    return result;
  if ((result = m_upwardFlag.Compare(other.m_upwardFlag)) != EqualTo)
    return result;
  if ((result = m_targetParameters.Compare(other.m_targetParameters)) != EqualTo)
    return result;
  if ((result = m_minimumParameters.Compare(other.m_minimumParameters)) != EqualTo)
    return result;
  if ((result = m_maximumParameters.Compare(other.m_maximumParameters)) != EqualTo)
    return result;
  if ((result = m_userData.Compare(other.m_userData)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_Connect_Initial::GetDataLength() const
{
  PINDEX length = 0;
  length += m_callingDomainSelector.GetObjectLength();
  length += m_calledDomainSelector.GetObjectLength();
  length += m_upwardFlag.GetObjectLength();
  length += m_targetParameters.GetObjectLength();
  length += m_minimumParameters.GetObjectLength();
  length += m_maximumParameters.GetObjectLength();
  length += m_userData.GetObjectLength();
  return length;
}


PBoolean MCS_Connect_Initial::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_callingDomainSelector.Decode(strm))
    return PFalse;
  if (!m_calledDomainSelector.Decode(strm))
    return PFalse;
  if (!m_upwardFlag.Decode(strm))
    return PFalse;
  if (!m_targetParameters.Decode(strm))
    return PFalse;
  if (!m_minimumParameters.Decode(strm))
    return PFalse;
  if (!m_maximumParameters.Decode(strm))
    return PFalse;
  if (!m_userData.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_Connect_Initial::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_callingDomainSelector.Encode(strm);
  m_calledDomainSelector.Encode(strm);
  m_upwardFlag.Encode(strm);
  m_targetParameters.Encode(strm);
  m_minimumParameters.Encode(strm);
  m_maximumParameters.Encode(strm);
  m_userData.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_Connect_Initial::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_Connect_Initial::Class()), PInvalidCast);
#endif
  return new MCS_Connect_Initial(*this);
}


//
// Connect-Additional
//

MCS_Connect_Additional::MCS_Connect_Additional(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
  m_calledConnectId.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
}


#ifndef PASN_NOPRINTON
void MCS_Connect_Additional::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+18) << "calledConnectId = " << setprecision(indent) << m_calledConnectId << '\n';
  strm << setw(indent+15) << "dataPriority = " << setprecision(indent) << m_dataPriority << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_Connect_Additional::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_Connect_Additional), PInvalidCast);
#endif
  const MCS_Connect_Additional & other = (const MCS_Connect_Additional &)obj;

  Comparison result;

  if ((result = m_calledConnectId.Compare(other.m_calledConnectId)) != EqualTo)
    return result;
  if ((result = m_dataPriority.Compare(other.m_dataPriority)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_Connect_Additional::GetDataLength() const
{
  PINDEX length = 0;
  length += m_calledConnectId.GetObjectLength();
  length += m_dataPriority.GetObjectLength();
  return length;
}


PBoolean MCS_Connect_Additional::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_calledConnectId.Decode(strm))
    return PFalse;
  if (!m_dataPriority.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_Connect_Additional::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_calledConnectId.Encode(strm);
  m_dataPriority.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_Connect_Additional::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_Connect_Additional::Class()), PInvalidCast);
#endif
  return new MCS_Connect_Additional(*this);
}


//
// PDin
//

MCS_PDin::MCS_PDin(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
  m_heightLimit.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
}


#ifndef PASN_NOPRINTON
void MCS_PDin::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+14) << "heightLimit = " << setprecision(indent) << m_heightLimit << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_PDin::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_PDin), PInvalidCast);
#endif
  const MCS_PDin & other = (const MCS_PDin &)obj;

  Comparison result;

  if ((result = m_heightLimit.Compare(other.m_heightLimit)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_PDin::GetDataLength() const
{
  PINDEX length = 0;
  length += m_heightLimit.GetObjectLength();
  return length;
}


PBoolean MCS_PDin::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_heightLimit.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_PDin::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_heightLimit.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_PDin::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_PDin::Class()), PInvalidCast);
#endif
  return new MCS_PDin(*this);
}


//
// EDrq
//

MCS_EDrq::MCS_EDrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
  m_subHeight.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
  m_subInterval.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
}


#ifndef PASN_NOPRINTON
void MCS_EDrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "subHeight = " << setprecision(indent) << m_subHeight << '\n';
  strm << setw(indent+14) << "subInterval = " << setprecision(indent) << m_subInterval << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_EDrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_EDrq), PInvalidCast);
#endif
  const MCS_EDrq & other = (const MCS_EDrq &)obj;

  Comparison result;

  if ((result = m_subHeight.Compare(other.m_subHeight)) != EqualTo)
    return result;
  if ((result = m_subInterval.Compare(other.m_subInterval)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_EDrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_subHeight.GetObjectLength();
  length += m_subInterval.GetObjectLength();
  return length;
}


PBoolean MCS_EDrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_subHeight.Decode(strm))
    return PFalse;
  if (!m_subInterval.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_EDrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_subHeight.Encode(strm);
  m_subInterval.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_EDrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_EDrq::Class()), PInvalidCast);
#endif
  return new MCS_EDrq(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_MCS_ChannelAttributes[]={
      {"static",0}
     ,{"userId",1}
     ,{"private",2}
     ,{"assigned",3}
};
#endif
//
// ChannelAttributes
//

MCS_ChannelAttributes::MCS_ChannelAttributes(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, PFalse
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_MCS_ChannelAttributes,4
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_ChannelAttributes::operator MCS_ChannelAttributes_static &() const
#else
MCS_ChannelAttributes::operator MCS_ChannelAttributes_static &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_ChannelAttributes_static), PInvalidCast);
#endif
  return *(MCS_ChannelAttributes_static *)choice;
}


MCS_ChannelAttributes::operator const MCS_ChannelAttributes_static &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_ChannelAttributes_static), PInvalidCast);
#endif
  return *(MCS_ChannelAttributes_static *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_ChannelAttributes::operator MCS_ChannelAttributes_userId &() const
#else
MCS_ChannelAttributes::operator MCS_ChannelAttributes_userId &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_ChannelAttributes_userId), PInvalidCast);
#endif
  return *(MCS_ChannelAttributes_userId *)choice;
}


MCS_ChannelAttributes::operator const MCS_ChannelAttributes_userId &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_ChannelAttributes_userId), PInvalidCast);
#endif
  return *(MCS_ChannelAttributes_userId *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_ChannelAttributes::operator MCS_ChannelAttributes_private &() const
#else
MCS_ChannelAttributes::operator MCS_ChannelAttributes_private &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_ChannelAttributes_private), PInvalidCast);
#endif
  return *(MCS_ChannelAttributes_private *)choice;
}


MCS_ChannelAttributes::operator const MCS_ChannelAttributes_private &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_ChannelAttributes_private), PInvalidCast);
#endif
  return *(MCS_ChannelAttributes_private *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_ChannelAttributes::operator MCS_ChannelAttributes_assigned &() const
#else
MCS_ChannelAttributes::operator MCS_ChannelAttributes_assigned &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_ChannelAttributes_assigned), PInvalidCast);
#endif
  return *(MCS_ChannelAttributes_assigned *)choice;
}


MCS_ChannelAttributes::operator const MCS_ChannelAttributes_assigned &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_ChannelAttributes_assigned), PInvalidCast);
#endif
  return *(MCS_ChannelAttributes_assigned *)choice;
}


PBoolean MCS_ChannelAttributes::CreateObject()
{
  switch (tag) {
    case e_static :
      choice = new MCS_ChannelAttributes_static();
      return PTrue;
    case e_userId :
      choice = new MCS_ChannelAttributes_userId();
      return PTrue;
    case e_private :
      choice = new MCS_ChannelAttributes_private();
      return PTrue;
    case e_assigned :
      choice = new MCS_ChannelAttributes_assigned();
      return PTrue;
  }

  choice = NULL;
  return PFalse;
}


PObject * MCS_ChannelAttributes::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_ChannelAttributes::Class()), PInvalidCast);
#endif
  return new MCS_ChannelAttributes(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_MCS_TokenAttributes[]={
      {"grabbed",0}
     ,{"inhibited",1}
     ,{"giving",2}
     ,{"ungivable",3}
     ,{"given",4}
};
#endif
//
// TokenAttributes
//

MCS_TokenAttributes::MCS_TokenAttributes(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 5, PFalse
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_MCS_TokenAttributes,5
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_TokenAttributes::operator MCS_TokenAttributes_grabbed &() const
#else
MCS_TokenAttributes::operator MCS_TokenAttributes_grabbed &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TokenAttributes_grabbed), PInvalidCast);
#endif
  return *(MCS_TokenAttributes_grabbed *)choice;
}


MCS_TokenAttributes::operator const MCS_TokenAttributes_grabbed &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TokenAttributes_grabbed), PInvalidCast);
#endif
  return *(MCS_TokenAttributes_grabbed *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_TokenAttributes::operator MCS_TokenAttributes_inhibited &() const
#else
MCS_TokenAttributes::operator MCS_TokenAttributes_inhibited &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TokenAttributes_inhibited), PInvalidCast);
#endif
  return *(MCS_TokenAttributes_inhibited *)choice;
}


MCS_TokenAttributes::operator const MCS_TokenAttributes_inhibited &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TokenAttributes_inhibited), PInvalidCast);
#endif
  return *(MCS_TokenAttributes_inhibited *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_TokenAttributes::operator MCS_TokenAttributes_giving &() const
#else
MCS_TokenAttributes::operator MCS_TokenAttributes_giving &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TokenAttributes_giving), PInvalidCast);
#endif
  return *(MCS_TokenAttributes_giving *)choice;
}


MCS_TokenAttributes::operator const MCS_TokenAttributes_giving &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TokenAttributes_giving), PInvalidCast);
#endif
  return *(MCS_TokenAttributes_giving *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_TokenAttributes::operator MCS_TokenAttributes_ungivable &() const
#else
MCS_TokenAttributes::operator MCS_TokenAttributes_ungivable &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TokenAttributes_ungivable), PInvalidCast);
#endif
  return *(MCS_TokenAttributes_ungivable *)choice;
}


MCS_TokenAttributes::operator const MCS_TokenAttributes_ungivable &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TokenAttributes_ungivable), PInvalidCast);
#endif
  return *(MCS_TokenAttributes_ungivable *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_TokenAttributes::operator MCS_TokenAttributes_given &() const
#else
MCS_TokenAttributes::operator MCS_TokenAttributes_given &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TokenAttributes_given), PInvalidCast);
#endif
  return *(MCS_TokenAttributes_given *)choice;
}


MCS_TokenAttributes::operator const MCS_TokenAttributes_given &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TokenAttributes_given), PInvalidCast);
#endif
  return *(MCS_TokenAttributes_given *)choice;
}


PBoolean MCS_TokenAttributes::CreateObject()
{
  switch (tag) {
    case e_grabbed :
      choice = new MCS_TokenAttributes_grabbed();
      return PTrue;
    case e_inhibited :
      choice = new MCS_TokenAttributes_inhibited();
      return PTrue;
    case e_giving :
      choice = new MCS_TokenAttributes_giving();
      return PTrue;
    case e_ungivable :
      choice = new MCS_TokenAttributes_ungivable();
      return PTrue;
    case e_given :
      choice = new MCS_TokenAttributes_given();
      return PTrue;
  }

  choice = NULL;
  return PFalse;
}


PObject * MCS_TokenAttributes::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TokenAttributes::Class()), PInvalidCast);
#endif
  return new MCS_TokenAttributes(*this);
}


//
// AUrq
//

MCS_AUrq::MCS_AUrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_AUrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PINDEX MCS_AUrq::GetDataLength() const
{
  PINDEX length = 0;
  return length;
}


PBoolean MCS_AUrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;


  return UnknownExtensionsDecode(strm);
}


void MCS_AUrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);


  UnknownExtensionsEncode(strm);
}


PObject * MCS_AUrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_AUrq::Class()), PInvalidCast);
#endif
  return new MCS_AUrq(*this);
}


//
// CJrq
//

MCS_CJrq::MCS_CJrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_CJrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_CJrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_CJrq), PInvalidCast);
#endif
  const MCS_CJrq & other = (const MCS_CJrq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_CJrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_channelId.GetObjectLength();
  return length;
}


PBoolean MCS_CJrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_channelId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_CJrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_channelId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_CJrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_CJrq::Class()), PInvalidCast);
#endif
  return new MCS_CJrq(*this);
}


//
// CCrq
//

MCS_CCrq::MCS_CCrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_CCrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_CCrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_CCrq), PInvalidCast);
#endif
  const MCS_CCrq & other = (const MCS_CCrq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_CCrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  return length;
}


PBoolean MCS_CCrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_CCrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_CCrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_CCrq::Class()), PInvalidCast);
#endif
  return new MCS_CCrq(*this);
}


//
// CDrq
//

MCS_CDrq::MCS_CDrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_CDrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_CDrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_CDrq), PInvalidCast);
#endif
  const MCS_CDrq & other = (const MCS_CDrq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_CDrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_channelId.GetObjectLength();
  return length;
}


PBoolean MCS_CDrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_channelId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_CDrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_channelId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_CDrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_CDrq::Class()), PInvalidCast);
#endif
  return new MCS_CDrq(*this);
}


//
// CDin
//

MCS_CDin::MCS_CDin(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_CDin::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_CDin::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_CDin), PInvalidCast);
#endif
  const MCS_CDin & other = (const MCS_CDin &)obj;

  Comparison result;

  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_CDin::GetDataLength() const
{
  PINDEX length = 0;
  length += m_channelId.GetObjectLength();
  return length;
}


PBoolean MCS_CDin::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_channelId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_CDin::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_channelId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_CDin::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_CDin::Class()), PInvalidCast);
#endif
  return new MCS_CDin(*this);
}


//
// SDrq
//

MCS_SDrq::MCS_SDrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_SDrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent+15) << "dataPriority = " << setprecision(indent) << m_dataPriority << '\n';
  strm << setw(indent+15) << "segmentation = " << setprecision(indent) << m_segmentation << '\n';
  strm << setw(indent+11) << "userData = " << setprecision(indent) << m_userData << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_SDrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_SDrq), PInvalidCast);
#endif
  const MCS_SDrq & other = (const MCS_SDrq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;
  if ((result = m_dataPriority.Compare(other.m_dataPriority)) != EqualTo)
    return result;
  if ((result = m_segmentation.Compare(other.m_segmentation)) != EqualTo)
    return result;
  if ((result = m_userData.Compare(other.m_userData)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_SDrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_channelId.GetObjectLength();
  length += m_dataPriority.GetObjectLength();
  length += m_segmentation.GetObjectLength();
  length += m_userData.GetObjectLength();
  return length;
}


PBoolean MCS_SDrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_channelId.Decode(strm))
    return PFalse;
  if (!m_dataPriority.Decode(strm))
    return PFalse;
  if (!m_segmentation.Decode(strm))
    return PFalse;
  if (!m_userData.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_SDrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_channelId.Encode(strm);
  m_dataPriority.Encode(strm);
  m_segmentation.Encode(strm);
  m_userData.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_SDrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_SDrq::Class()), PInvalidCast);
#endif
  return new MCS_SDrq(*this);
}


//
// SDin
//

MCS_SDin::MCS_SDin(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_SDin::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent+15) << "dataPriority = " << setprecision(indent) << m_dataPriority << '\n';
  strm << setw(indent+15) << "segmentation = " << setprecision(indent) << m_segmentation << '\n';
  strm << setw(indent+11) << "userData = " << setprecision(indent) << m_userData << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_SDin::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_SDin), PInvalidCast);
#endif
  const MCS_SDin & other = (const MCS_SDin &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;
  if ((result = m_dataPriority.Compare(other.m_dataPriority)) != EqualTo)
    return result;
  if ((result = m_segmentation.Compare(other.m_segmentation)) != EqualTo)
    return result;
  if ((result = m_userData.Compare(other.m_userData)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_SDin::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_channelId.GetObjectLength();
  length += m_dataPriority.GetObjectLength();
  length += m_segmentation.GetObjectLength();
  length += m_userData.GetObjectLength();
  return length;
}


PBoolean MCS_SDin::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_channelId.Decode(strm))
    return PFalse;
  if (!m_dataPriority.Decode(strm))
    return PFalse;
  if (!m_segmentation.Decode(strm))
    return PFalse;
  if (!m_userData.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_SDin::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_channelId.Encode(strm);
  m_dataPriority.Encode(strm);
  m_segmentation.Encode(strm);
  m_userData.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_SDin::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_SDin::Class()), PInvalidCast);
#endif
  return new MCS_SDin(*this);
}


//
// USrq
//

MCS_USrq::MCS_USrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_USrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent+15) << "dataPriority = " << setprecision(indent) << m_dataPriority << '\n';
  strm << setw(indent+15) << "segmentation = " << setprecision(indent) << m_segmentation << '\n';
  strm << setw(indent+11) << "userData = " << setprecision(indent) << m_userData << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_USrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_USrq), PInvalidCast);
#endif
  const MCS_USrq & other = (const MCS_USrq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;
  if ((result = m_dataPriority.Compare(other.m_dataPriority)) != EqualTo)
    return result;
  if ((result = m_segmentation.Compare(other.m_segmentation)) != EqualTo)
    return result;
  if ((result = m_userData.Compare(other.m_userData)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_USrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_channelId.GetObjectLength();
  length += m_dataPriority.GetObjectLength();
  length += m_segmentation.GetObjectLength();
  length += m_userData.GetObjectLength();
  return length;
}


PBoolean MCS_USrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_channelId.Decode(strm))
    return PFalse;
  if (!m_dataPriority.Decode(strm))
    return PFalse;
  if (!m_segmentation.Decode(strm))
    return PFalse;
  if (!m_userData.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_USrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_channelId.Encode(strm);
  m_dataPriority.Encode(strm);
  m_segmentation.Encode(strm);
  m_userData.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_USrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_USrq::Class()), PInvalidCast);
#endif
  return new MCS_USrq(*this);
}


//
// USin
//

MCS_USin::MCS_USin(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_USin::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent+15) << "dataPriority = " << setprecision(indent) << m_dataPriority << '\n';
  strm << setw(indent+15) << "segmentation = " << setprecision(indent) << m_segmentation << '\n';
  strm << setw(indent+11) << "userData = " << setprecision(indent) << m_userData << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_USin::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_USin), PInvalidCast);
#endif
  const MCS_USin & other = (const MCS_USin &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;
  if ((result = m_dataPriority.Compare(other.m_dataPriority)) != EqualTo)
    return result;
  if ((result = m_segmentation.Compare(other.m_segmentation)) != EqualTo)
    return result;
  if ((result = m_userData.Compare(other.m_userData)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_USin::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_channelId.GetObjectLength();
  length += m_dataPriority.GetObjectLength();
  length += m_segmentation.GetObjectLength();
  length += m_userData.GetObjectLength();
  return length;
}


PBoolean MCS_USin::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_channelId.Decode(strm))
    return PFalse;
  if (!m_dataPriority.Decode(strm))
    return PFalse;
  if (!m_segmentation.Decode(strm))
    return PFalse;
  if (!m_userData.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_USin::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_channelId.Encode(strm);
  m_dataPriority.Encode(strm);
  m_segmentation.Encode(strm);
  m_userData.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_USin::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_USin::Class()), PInvalidCast);
#endif
  return new MCS_USin(*this);
}


//
// TGrq
//

MCS_TGrq::MCS_TGrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TGrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TGrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TGrq), PInvalidCast);
#endif
  const MCS_TGrq & other = (const MCS_TGrq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TGrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  return length;
}


PBoolean MCS_TGrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TGrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TGrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TGrq::Class()), PInvalidCast);
#endif
  return new MCS_TGrq(*this);
}


//
// TIrq
//

MCS_TIrq::MCS_TIrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TIrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TIrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TIrq), PInvalidCast);
#endif
  const MCS_TIrq & other = (const MCS_TIrq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TIrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  return length;
}


PBoolean MCS_TIrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TIrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TIrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TIrq::Class()), PInvalidCast);
#endif
  return new MCS_TIrq(*this);
}


//
// TVrq
//

MCS_TVrq::MCS_TVrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TVrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent+12) << "recipient = " << setprecision(indent) << m_recipient << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TVrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TVrq), PInvalidCast);
#endif
  const MCS_TVrq & other = (const MCS_TVrq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;
  if ((result = m_recipient.Compare(other.m_recipient)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TVrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  length += m_recipient.GetObjectLength();
  return length;
}


PBoolean MCS_TVrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;
  if (!m_recipient.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TVrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);
  m_recipient.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TVrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TVrq::Class()), PInvalidCast);
#endif
  return new MCS_TVrq(*this);
}


//
// TVin
//

MCS_TVin::MCS_TVin(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TVin::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent+12) << "recipient = " << setprecision(indent) << m_recipient << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TVin::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TVin), PInvalidCast);
#endif
  const MCS_TVin & other = (const MCS_TVin &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;
  if ((result = m_recipient.Compare(other.m_recipient)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TVin::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  length += m_recipient.GetObjectLength();
  return length;
}


PBoolean MCS_TVin::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;
  if (!m_recipient.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TVin::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);
  m_recipient.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TVin::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TVin::Class()), PInvalidCast);
#endif
  return new MCS_TVin(*this);
}


//
// TPrq
//

MCS_TPrq::MCS_TPrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TPrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TPrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TPrq), PInvalidCast);
#endif
  const MCS_TPrq & other = (const MCS_TPrq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TPrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  return length;
}


PBoolean MCS_TPrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TPrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TPrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TPrq::Class()), PInvalidCast);
#endif
  return new MCS_TPrq(*this);
}


//
// TPin
//

MCS_TPin::MCS_TPin(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TPin::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TPin::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TPin), PInvalidCast);
#endif
  const MCS_TPin & other = (const MCS_TPin &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TPin::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  return length;
}


PBoolean MCS_TPin::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TPin::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TPin::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TPin::Class()), PInvalidCast);
#endif
  return new MCS_TPin(*this);
}


//
// TRrq
//

MCS_TRrq::MCS_TRrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TRrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TRrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TRrq), PInvalidCast);
#endif
  const MCS_TRrq & other = (const MCS_TRrq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TRrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  return length;
}


PBoolean MCS_TRrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TRrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TRrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TRrq::Class()), PInvalidCast);
#endif
  return new MCS_TRrq(*this);
}


//
// TTrq
//

MCS_TTrq::MCS_TTrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TTrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TTrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TTrq), PInvalidCast);
#endif
  const MCS_TTrq & other = (const MCS_TTrq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TTrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  return length;
}


PBoolean MCS_TTrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TTrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TTrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TTrq::Class()), PInvalidCast);
#endif
  return new MCS_TTrq(*this);
}


//
// TTcf
//

MCS_TTcf::MCS_TTcf(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TTcf::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent+14) << "tokenStatus = " << setprecision(indent) << m_tokenStatus << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TTcf::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TTcf), PInvalidCast);
#endif
  const MCS_TTcf & other = (const MCS_TTcf &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;
  if ((result = m_tokenStatus.Compare(other.m_tokenStatus)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TTcf::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  length += m_tokenStatus.GetObjectLength();
  return length;
}


PBoolean MCS_TTcf::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;
  if (!m_tokenStatus.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TTcf::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);
  m_tokenStatus.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TTcf::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TTcf::Class()), PInvalidCast);
#endif
  return new MCS_TTcf(*this);
}


#ifndef PASN_NOPRINTON
const static PASN_Names Names_MCS_Reason[]={
        {"rn-domain-disconnected",0}
       ,{"rn-provider-initiated",1}
       ,{"rn-token-purged",2}
       ,{"rn-user-requested",3}
       ,{"rn-channel-purged",4}
};
#endif
//
// Reason
//

MCS_Reason::MCS_Reason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Enumeration(tag, tagClass, 4, PFalse
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_MCS_Reason,5
#endif
    )
{
}


MCS_Reason & MCS_Reason::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * MCS_Reason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_Reason::Class()), PInvalidCast);
#endif
  return new MCS_Reason(*this);
}


#ifndef PASN_NOPRINTON
const static PASN_Names Names_MCS_Result[]={
        {"rt-successful",0}
       ,{"rt-domain-merging",1}
       ,{"rt-domain-not-hierarchical",2}
       ,{"rt-no-such-channel",3}
       ,{"rt-no-such-domain",4}
       ,{"rt-no-such-user",5}
       ,{"rt-not-admitted",6}
       ,{"rt-other-user-id",7}
       ,{"rt-parameters-unacceptable",8}
       ,{"rt-token-not-available",9}
       ,{"rt-token-not-possessed",10}
       ,{"rt-too-many-channels",11}
       ,{"rt-too-many-tokens",12}
       ,{"rt-too-many-users",13}
       ,{"rt-unspecified-failure",14}
       ,{"rt-user-rejected",15}
};
#endif
//
// Result
//

MCS_Result::MCS_Result(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Enumeration(tag, tagClass, 15, PFalse
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_MCS_Result,16
#endif
    )
{
}


MCS_Result & MCS_Result::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * MCS_Result::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_Result::Class()), PInvalidCast);
#endif
  return new MCS_Result(*this);
}


#ifndef PASN_NOPRINTON
const static PASN_Names Names_MCS_Diagnostic[]={
        {"dc-inconsistent-merge",0}
       ,{"dc-forbidden-PDU-downward",1}
       ,{"dc-forbidden-PDU-upward",2}
       ,{"dc-invalid-BER-encoding",3}
       ,{"dc-invalid-PER-encoding",4}
       ,{"dc-misrouted-user",5}
       ,{"dc-unrequested-confirm",6}
       ,{"dc-wrong-transport-priority",7}
       ,{"dc-channel-id-conflict",8}
       ,{"dc-token-id-conflict",9}
       ,{"dc-not-user-id-channel",10}
       ,{"dc-too-many-channels",11}
       ,{"dc-too-many-tokens",12}
       ,{"dc-too-many-users",13}
};
#endif
//
// Diagnostic
//

MCS_Diagnostic::MCS_Diagnostic(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Enumeration(tag, tagClass, 13, PFalse
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_MCS_Diagnostic,14
#endif
    )
{
}


MCS_Diagnostic & MCS_Diagnostic::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * MCS_Diagnostic::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_Diagnostic::Class()), PInvalidCast);
#endif
  return new MCS_Diagnostic(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_MCS_ConnectMCSPDU[]={
      {"connect_initial",101}
     ,{"connect_response",102}
     ,{"connect_additional",103}
     ,{"connect_result",104}
};
#endif
//
// ConnectMCSPDU
//

MCS_ConnectMCSPDU::MCS_ConnectMCSPDU(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, PFalse
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_MCS_ConnectMCSPDU,4
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_ConnectMCSPDU::operator MCS_Connect_Initial &() const
#else
MCS_ConnectMCSPDU::operator MCS_Connect_Initial &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_Connect_Initial), PInvalidCast);
#endif
  return *(MCS_Connect_Initial *)choice;
}


MCS_ConnectMCSPDU::operator const MCS_Connect_Initial &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_Connect_Initial), PInvalidCast);
#endif
  return *(MCS_Connect_Initial *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_ConnectMCSPDU::operator MCS_Connect_Response &() const
#else
MCS_ConnectMCSPDU::operator MCS_Connect_Response &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_Connect_Response), PInvalidCast);
#endif
  return *(MCS_Connect_Response *)choice;
}


MCS_ConnectMCSPDU::operator const MCS_Connect_Response &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_Connect_Response), PInvalidCast);
#endif
  return *(MCS_Connect_Response *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_ConnectMCSPDU::operator MCS_Connect_Additional &() const
#else
MCS_ConnectMCSPDU::operator MCS_Connect_Additional &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_Connect_Additional), PInvalidCast);
#endif
  return *(MCS_Connect_Additional *)choice;
}


MCS_ConnectMCSPDU::operator const MCS_Connect_Additional &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_Connect_Additional), PInvalidCast);
#endif
  return *(MCS_Connect_Additional *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_ConnectMCSPDU::operator MCS_Connect_Result &() const
#else
MCS_ConnectMCSPDU::operator MCS_Connect_Result &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_Connect_Result), PInvalidCast);
#endif
  return *(MCS_Connect_Result *)choice;
}


MCS_ConnectMCSPDU::operator const MCS_Connect_Result &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_Connect_Result), PInvalidCast);
#endif
  return *(MCS_Connect_Result *)choice;
}


PBoolean MCS_ConnectMCSPDU::CreateObject()
{
  switch (tag) {
    case e_connect_initial :
      choice = new MCS_Connect_Initial();
      return PTrue;
    case e_connect_response :
      choice = new MCS_Connect_Response();
      return PTrue;
    case e_connect_additional :
      choice = new MCS_Connect_Additional();
      return PTrue;
    case e_connect_result :
      choice = new MCS_Connect_Result();
      return PTrue;
  }

  choice = NULL;
  return PFalse;
}


PObject * MCS_ConnectMCSPDU::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_ConnectMCSPDU::Class()), PInvalidCast);
#endif
  return new MCS_ConnectMCSPDU(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_MCS_DomainMCSPDU[]={
      {"pdin",0}
     ,{"edrq",1}
     ,{"mcrq",2}
     ,{"mccf",3}
     ,{"pcin",4}
     ,{"mtrq",5}
     ,{"mtcf",6}
     ,{"ptin",7}
     ,{"dpum",8}
     ,{"rjum",9}
     ,{"aurq",10}
     ,{"aucf",11}
     ,{"durq",12}
     ,{"duin",13}
     ,{"cjrq",14}
     ,{"cjcf",15}
     ,{"clrq",16}
     ,{"ccrq",17}
     ,{"cccf",18}
     ,{"cdrq",19}
     ,{"cdin",20}
     ,{"carq",21}
     ,{"cain",22}
     ,{"cerq",23}
     ,{"cein",24}
     ,{"sdrq",25}
     ,{"sdin",26}
     ,{"usrq",27}
     ,{"usin",28}
     ,{"tgrq",29}
     ,{"tgcf",30}
     ,{"tirq",31}
     ,{"ticf",32}
     ,{"tvrq",33}
     ,{"tvin",34}
     ,{"tvrs",35}
     ,{"tvcf",36}
     ,{"tprq",37}
     ,{"tpin",38}
     ,{"trrq",39}
     ,{"trcf",40}
     ,{"ttrq",41}
     ,{"ttcf",42}
};
#endif
//
// DomainMCSPDU
//

MCS_DomainMCSPDU::MCS_DomainMCSPDU(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 43, PFalse
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_MCS_DomainMCSPDU,43
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_PDin &() const
#else
MCS_DomainMCSPDU::operator MCS_PDin &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_PDin), PInvalidCast);
#endif
  return *(MCS_PDin *)choice;
}


MCS_DomainMCSPDU::operator const MCS_PDin &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_PDin), PInvalidCast);
#endif
  return *(MCS_PDin *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_EDrq &() const
#else
MCS_DomainMCSPDU::operator MCS_EDrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_EDrq), PInvalidCast);
#endif
  return *(MCS_EDrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_EDrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_EDrq), PInvalidCast);
#endif
  return *(MCS_EDrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_MCrq &() const
#else
MCS_DomainMCSPDU::operator MCS_MCrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_MCrq), PInvalidCast);
#endif
  return *(MCS_MCrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_MCrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_MCrq), PInvalidCast);
#endif
  return *(MCS_MCrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_MCcf &() const
#else
MCS_DomainMCSPDU::operator MCS_MCcf &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_MCcf), PInvalidCast);
#endif
  return *(MCS_MCcf *)choice;
}


MCS_DomainMCSPDU::operator const MCS_MCcf &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_MCcf), PInvalidCast);
#endif
  return *(MCS_MCcf *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_PCin &() const
#else
MCS_DomainMCSPDU::operator MCS_PCin &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_PCin), PInvalidCast);
#endif
  return *(MCS_PCin *)choice;
}


MCS_DomainMCSPDU::operator const MCS_PCin &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_PCin), PInvalidCast);
#endif
  return *(MCS_PCin *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_MTrq &() const
#else
MCS_DomainMCSPDU::operator MCS_MTrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_MTrq), PInvalidCast);
#endif
  return *(MCS_MTrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_MTrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_MTrq), PInvalidCast);
#endif
  return *(MCS_MTrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_MTcf &() const
#else
MCS_DomainMCSPDU::operator MCS_MTcf &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_MTcf), PInvalidCast);
#endif
  return *(MCS_MTcf *)choice;
}


MCS_DomainMCSPDU::operator const MCS_MTcf &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_MTcf), PInvalidCast);
#endif
  return *(MCS_MTcf *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_PTin &() const
#else
MCS_DomainMCSPDU::operator MCS_PTin &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_PTin), PInvalidCast);
#endif
  return *(MCS_PTin *)choice;
}


MCS_DomainMCSPDU::operator const MCS_PTin &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_PTin), PInvalidCast);
#endif
  return *(MCS_PTin *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_DPum &() const
#else
MCS_DomainMCSPDU::operator MCS_DPum &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_DPum), PInvalidCast);
#endif
  return *(MCS_DPum *)choice;
}


MCS_DomainMCSPDU::operator const MCS_DPum &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_DPum), PInvalidCast);
#endif
  return *(MCS_DPum *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_RJum &() const
#else
MCS_DomainMCSPDU::operator MCS_RJum &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_RJum), PInvalidCast);
#endif
  return *(MCS_RJum *)choice;
}


MCS_DomainMCSPDU::operator const MCS_RJum &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_RJum), PInvalidCast);
#endif
  return *(MCS_RJum *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_AUrq &() const
#else
MCS_DomainMCSPDU::operator MCS_AUrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_AUrq), PInvalidCast);
#endif
  return *(MCS_AUrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_AUrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_AUrq), PInvalidCast);
#endif
  return *(MCS_AUrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_AUcf &() const
#else
MCS_DomainMCSPDU::operator MCS_AUcf &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_AUcf), PInvalidCast);
#endif
  return *(MCS_AUcf *)choice;
}


MCS_DomainMCSPDU::operator const MCS_AUcf &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_AUcf), PInvalidCast);
#endif
  return *(MCS_AUcf *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_DUrq &() const
#else
MCS_DomainMCSPDU::operator MCS_DUrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_DUrq), PInvalidCast);
#endif
  return *(MCS_DUrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_DUrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_DUrq), PInvalidCast);
#endif
  return *(MCS_DUrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_DUin &() const
#else
MCS_DomainMCSPDU::operator MCS_DUin &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_DUin), PInvalidCast);
#endif
  return *(MCS_DUin *)choice;
}


MCS_DomainMCSPDU::operator const MCS_DUin &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_DUin), PInvalidCast);
#endif
  return *(MCS_DUin *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_CJrq &() const
#else
MCS_DomainMCSPDU::operator MCS_CJrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CJrq), PInvalidCast);
#endif
  return *(MCS_CJrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_CJrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CJrq), PInvalidCast);
#endif
  return *(MCS_CJrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_CJcf &() const
#else
MCS_DomainMCSPDU::operator MCS_CJcf &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CJcf), PInvalidCast);
#endif
  return *(MCS_CJcf *)choice;
}


MCS_DomainMCSPDU::operator const MCS_CJcf &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CJcf), PInvalidCast);
#endif
  return *(MCS_CJcf *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_CLrq &() const
#else
MCS_DomainMCSPDU::operator MCS_CLrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CLrq), PInvalidCast);
#endif
  return *(MCS_CLrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_CLrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CLrq), PInvalidCast);
#endif
  return *(MCS_CLrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_CCrq &() const
#else
MCS_DomainMCSPDU::operator MCS_CCrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CCrq), PInvalidCast);
#endif
  return *(MCS_CCrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_CCrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CCrq), PInvalidCast);
#endif
  return *(MCS_CCrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_CCcf &() const
#else
MCS_DomainMCSPDU::operator MCS_CCcf &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CCcf), PInvalidCast);
#endif
  return *(MCS_CCcf *)choice;
}


MCS_DomainMCSPDU::operator const MCS_CCcf &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CCcf), PInvalidCast);
#endif
  return *(MCS_CCcf *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_CDrq &() const
#else
MCS_DomainMCSPDU::operator MCS_CDrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CDrq), PInvalidCast);
#endif
  return *(MCS_CDrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_CDrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CDrq), PInvalidCast);
#endif
  return *(MCS_CDrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_CDin &() const
#else
MCS_DomainMCSPDU::operator MCS_CDin &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CDin), PInvalidCast);
#endif
  return *(MCS_CDin *)choice;
}


MCS_DomainMCSPDU::operator const MCS_CDin &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CDin), PInvalidCast);
#endif
  return *(MCS_CDin *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_CArq &() const
#else
MCS_DomainMCSPDU::operator MCS_CArq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CArq), PInvalidCast);
#endif
  return *(MCS_CArq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_CArq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CArq), PInvalidCast);
#endif
  return *(MCS_CArq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_CAin &() const
#else
MCS_DomainMCSPDU::operator MCS_CAin &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CAin), PInvalidCast);
#endif
  return *(MCS_CAin *)choice;
}


MCS_DomainMCSPDU::operator const MCS_CAin &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CAin), PInvalidCast);
#endif
  return *(MCS_CAin *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_CErq &() const
#else
MCS_DomainMCSPDU::operator MCS_CErq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CErq), PInvalidCast);
#endif
  return *(MCS_CErq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_CErq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CErq), PInvalidCast);
#endif
  return *(MCS_CErq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_CEin &() const
#else
MCS_DomainMCSPDU::operator MCS_CEin &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CEin), PInvalidCast);
#endif
  return *(MCS_CEin *)choice;
}


MCS_DomainMCSPDU::operator const MCS_CEin &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_CEin), PInvalidCast);
#endif
  return *(MCS_CEin *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_SDrq &() const
#else
MCS_DomainMCSPDU::operator MCS_SDrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_SDrq), PInvalidCast);
#endif
  return *(MCS_SDrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_SDrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_SDrq), PInvalidCast);
#endif
  return *(MCS_SDrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_SDin &() const
#else
MCS_DomainMCSPDU::operator MCS_SDin &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_SDin), PInvalidCast);
#endif
  return *(MCS_SDin *)choice;
}


MCS_DomainMCSPDU::operator const MCS_SDin &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_SDin), PInvalidCast);
#endif
  return *(MCS_SDin *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_USrq &() const
#else
MCS_DomainMCSPDU::operator MCS_USrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_USrq), PInvalidCast);
#endif
  return *(MCS_USrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_USrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_USrq), PInvalidCast);
#endif
  return *(MCS_USrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_USin &() const
#else
MCS_DomainMCSPDU::operator MCS_USin &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_USin), PInvalidCast);
#endif
  return *(MCS_USin *)choice;
}


MCS_DomainMCSPDU::operator const MCS_USin &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_USin), PInvalidCast);
#endif
  return *(MCS_USin *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TGrq &() const
#else
MCS_DomainMCSPDU::operator MCS_TGrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TGrq), PInvalidCast);
#endif
  return *(MCS_TGrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TGrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TGrq), PInvalidCast);
#endif
  return *(MCS_TGrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TGcf &() const
#else
MCS_DomainMCSPDU::operator MCS_TGcf &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TGcf), PInvalidCast);
#endif
  return *(MCS_TGcf *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TGcf &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TGcf), PInvalidCast);
#endif
  return *(MCS_TGcf *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TIrq &() const
#else
MCS_DomainMCSPDU::operator MCS_TIrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TIrq), PInvalidCast);
#endif
  return *(MCS_TIrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TIrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TIrq), PInvalidCast);
#endif
  return *(MCS_TIrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TIcf &() const
#else
MCS_DomainMCSPDU::operator MCS_TIcf &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TIcf), PInvalidCast);
#endif
  return *(MCS_TIcf *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TIcf &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TIcf), PInvalidCast);
#endif
  return *(MCS_TIcf *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TVrq &() const
#else
MCS_DomainMCSPDU::operator MCS_TVrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TVrq), PInvalidCast);
#endif
  return *(MCS_TVrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TVrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TVrq), PInvalidCast);
#endif
  return *(MCS_TVrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TVin &() const
#else
MCS_DomainMCSPDU::operator MCS_TVin &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TVin), PInvalidCast);
#endif
  return *(MCS_TVin *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TVin &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TVin), PInvalidCast);
#endif
  return *(MCS_TVin *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TVrs &() const
#else
MCS_DomainMCSPDU::operator MCS_TVrs &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TVrs), PInvalidCast);
#endif
  return *(MCS_TVrs *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TVrs &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TVrs), PInvalidCast);
#endif
  return *(MCS_TVrs *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TVcf &() const
#else
MCS_DomainMCSPDU::operator MCS_TVcf &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TVcf), PInvalidCast);
#endif
  return *(MCS_TVcf *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TVcf &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TVcf), PInvalidCast);
#endif
  return *(MCS_TVcf *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TPrq &() const
#else
MCS_DomainMCSPDU::operator MCS_TPrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TPrq), PInvalidCast);
#endif
  return *(MCS_TPrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TPrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TPrq), PInvalidCast);
#endif
  return *(MCS_TPrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TPin &() const
#else
MCS_DomainMCSPDU::operator MCS_TPin &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TPin), PInvalidCast);
#endif
  return *(MCS_TPin *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TPin &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TPin), PInvalidCast);
#endif
  return *(MCS_TPin *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TRrq &() const
#else
MCS_DomainMCSPDU::operator MCS_TRrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TRrq), PInvalidCast);
#endif
  return *(MCS_TRrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TRrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TRrq), PInvalidCast);
#endif
  return *(MCS_TRrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TRcf &() const
#else
MCS_DomainMCSPDU::operator MCS_TRcf &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TRcf), PInvalidCast);
#endif
  return *(MCS_TRcf *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TRcf &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TRcf), PInvalidCast);
#endif
  return *(MCS_TRcf *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TTrq &() const
#else
MCS_DomainMCSPDU::operator MCS_TTrq &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TTrq), PInvalidCast);
#endif
  return *(MCS_TTrq *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TTrq &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TTrq), PInvalidCast);
#endif
  return *(MCS_TTrq *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
MCS_DomainMCSPDU::operator MCS_TTcf &() const
#else
MCS_DomainMCSPDU::operator MCS_TTcf &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TTcf), PInvalidCast);
#endif
  return *(MCS_TTcf *)choice;
}


MCS_DomainMCSPDU::operator const MCS_TTcf &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), MCS_TTcf), PInvalidCast);
#endif
  return *(MCS_TTcf *)choice;
}


PBoolean MCS_DomainMCSPDU::CreateObject()
{
  switch (tag) {
    case e_pdin :
      choice = new MCS_PDin();
      return PTrue;
    case e_edrq :
      choice = new MCS_EDrq();
      return PTrue;
    case e_mcrq :
      choice = new MCS_MCrq();
      return PTrue;
    case e_mccf :
      choice = new MCS_MCcf();
      return PTrue;
    case e_pcin :
      choice = new MCS_PCin();
      return PTrue;
    case e_mtrq :
      choice = new MCS_MTrq();
      return PTrue;
    case e_mtcf :
      choice = new MCS_MTcf();
      return PTrue;
    case e_ptin :
      choice = new MCS_PTin();
      return PTrue;
    case e_dpum :
      choice = new MCS_DPum();
      return PTrue;
    case e_rjum :
      choice = new MCS_RJum();
      return PTrue;
    case e_aurq :
      choice = new MCS_AUrq();
      return PTrue;
    case e_aucf :
      choice = new MCS_AUcf();
      return PTrue;
    case e_durq :
      choice = new MCS_DUrq();
      return PTrue;
    case e_duin :
      choice = new MCS_DUin();
      return PTrue;
    case e_cjrq :
      choice = new MCS_CJrq();
      return PTrue;
    case e_cjcf :
      choice = new MCS_CJcf();
      return PTrue;
    case e_clrq :
      choice = new MCS_CLrq();
      return PTrue;
    case e_ccrq :
      choice = new MCS_CCrq();
      return PTrue;
    case e_cccf :
      choice = new MCS_CCcf();
      return PTrue;
    case e_cdrq :
      choice = new MCS_CDrq();
      return PTrue;
    case e_cdin :
      choice = new MCS_CDin();
      return PTrue;
    case e_carq :
      choice = new MCS_CArq();
      return PTrue;
    case e_cain :
      choice = new MCS_CAin();
      return PTrue;
    case e_cerq :
      choice = new MCS_CErq();
      return PTrue;
    case e_cein :
      choice = new MCS_CEin();
      return PTrue;
    case e_sdrq :
      choice = new MCS_SDrq();
      return PTrue;
    case e_sdin :
      choice = new MCS_SDin();
      return PTrue;
    case e_usrq :
      choice = new MCS_USrq();
      return PTrue;
    case e_usin :
      choice = new MCS_USin();
      return PTrue;
    case e_tgrq :
      choice = new MCS_TGrq();
      return PTrue;
    case e_tgcf :
      choice = new MCS_TGcf();
      return PTrue;
    case e_tirq :
      choice = new MCS_TIrq();
      return PTrue;
    case e_ticf :
      choice = new MCS_TIcf();
      return PTrue;
    case e_tvrq :
      choice = new MCS_TVrq();
      return PTrue;
    case e_tvin :
      choice = new MCS_TVin();
      return PTrue;
    case e_tvrs :
      choice = new MCS_TVrs();
      return PTrue;
    case e_tvcf :
      choice = new MCS_TVcf();
      return PTrue;
    case e_tprq :
      choice = new MCS_TPrq();
      return PTrue;
    case e_tpin :
      choice = new MCS_TPin();
      return PTrue;
    case e_trrq :
      choice = new MCS_TRrq();
      return PTrue;
    case e_trcf :
      choice = new MCS_TRcf();
      return PTrue;
    case e_ttrq :
      choice = new MCS_TTrq();
      return PTrue;
    case e_ttcf :
      choice = new MCS_TTcf();
      return PTrue;
  }

  choice = NULL;
  return PFalse;
}


PObject * MCS_DomainMCSPDU::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_DomainMCSPDU::Class()), PInvalidCast);
#endif
  return new MCS_DomainMCSPDU(*this);
}


//
// ChannelAttributes_static
//

MCS_ChannelAttributes_static::MCS_ChannelAttributes_static(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_ChannelAttributes_static::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_ChannelAttributes_static::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_ChannelAttributes_static), PInvalidCast);
#endif
  const MCS_ChannelAttributes_static & other = (const MCS_ChannelAttributes_static &)obj;

  Comparison result;

  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_ChannelAttributes_static::GetDataLength() const
{
  PINDEX length = 0;
  length += m_channelId.GetObjectLength();
  return length;
}


PBoolean MCS_ChannelAttributes_static::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_channelId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_ChannelAttributes_static::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_channelId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_ChannelAttributes_static::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_ChannelAttributes_static::Class()), PInvalidCast);
#endif
  return new MCS_ChannelAttributes_static(*this);
}


//
// ChannelAttributes_userId
//

MCS_ChannelAttributes_userId::MCS_ChannelAttributes_userId(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_ChannelAttributes_userId::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "joined = " << setprecision(indent) << m_joined << '\n';
  strm << setw(indent+9) << "userId = " << setprecision(indent) << m_userId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_ChannelAttributes_userId::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_ChannelAttributes_userId), PInvalidCast);
#endif
  const MCS_ChannelAttributes_userId & other = (const MCS_ChannelAttributes_userId &)obj;

  Comparison result;

  if ((result = m_joined.Compare(other.m_joined)) != EqualTo)
    return result;
  if ((result = m_userId.Compare(other.m_userId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_ChannelAttributes_userId::GetDataLength() const
{
  PINDEX length = 0;
  length += m_joined.GetObjectLength();
  length += m_userId.GetObjectLength();
  return length;
}


PBoolean MCS_ChannelAttributes_userId::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_joined.Decode(strm))
    return PFalse;
  if (!m_userId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_ChannelAttributes_userId::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_joined.Encode(strm);
  m_userId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_ChannelAttributes_userId::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_ChannelAttributes_userId::Class()), PInvalidCast);
#endif
  return new MCS_ChannelAttributes_userId(*this);
}


//
// ChannelAttributes_assigned
//

MCS_ChannelAttributes_assigned::MCS_ChannelAttributes_assigned(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_ChannelAttributes_assigned::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_ChannelAttributes_assigned::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_ChannelAttributes_assigned), PInvalidCast);
#endif
  const MCS_ChannelAttributes_assigned & other = (const MCS_ChannelAttributes_assigned &)obj;

  Comparison result;

  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_ChannelAttributes_assigned::GetDataLength() const
{
  PINDEX length = 0;
  length += m_channelId.GetObjectLength();
  return length;
}


PBoolean MCS_ChannelAttributes_assigned::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_channelId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_ChannelAttributes_assigned::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_channelId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_ChannelAttributes_assigned::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_ChannelAttributes_assigned::Class()), PInvalidCast);
#endif
  return new MCS_ChannelAttributes_assigned(*this);
}


//
// ArrayOf_ChannelAttributes
//

MCS_ArrayOf_ChannelAttributes::MCS_ArrayOf_ChannelAttributes(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * MCS_ArrayOf_ChannelAttributes::CreateObject() const
{
  return new MCS_ChannelAttributes;
}


MCS_ChannelAttributes & MCS_ArrayOf_ChannelAttributes::operator[](PINDEX i) const
{
  return (MCS_ChannelAttributes &)array[i];
}


PObject * MCS_ArrayOf_ChannelAttributes::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_ArrayOf_ChannelAttributes::Class()), PInvalidCast);
#endif
  return new MCS_ArrayOf_ChannelAttributes(*this);
}


//
// ArrayOf_ChannelId
//

MCS_ArrayOf_ChannelId::MCS_ArrayOf_ChannelId(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * MCS_ArrayOf_ChannelId::CreateObject() const
{
  return new MCS_ChannelId;
}


MCS_ChannelId & MCS_ArrayOf_ChannelId::operator[](PINDEX i) const
{
  return (MCS_ChannelId &)array[i];
}


PObject * MCS_ArrayOf_ChannelId::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_ArrayOf_ChannelId::Class()), PInvalidCast);
#endif
  return new MCS_ArrayOf_ChannelId(*this);
}


//
// ArrayOf_UserId
//

MCS_ArrayOf_UserId::MCS_ArrayOf_UserId(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * MCS_ArrayOf_UserId::CreateObject() const
{
  return new MCS_UserId;
}


MCS_UserId & MCS_ArrayOf_UserId::operator[](PINDEX i) const
{
  return (MCS_UserId &)array[i];
}


PObject * MCS_ArrayOf_UserId::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_ArrayOf_UserId::Class()), PInvalidCast);
#endif
  return new MCS_ArrayOf_UserId(*this);
}


//
// TokenAttributes_grabbed
//

MCS_TokenAttributes_grabbed::MCS_TokenAttributes_grabbed(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TokenAttributes_grabbed::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent+10) << "grabber = " << setprecision(indent) << m_grabber << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TokenAttributes_grabbed::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TokenAttributes_grabbed), PInvalidCast);
#endif
  const MCS_TokenAttributes_grabbed & other = (const MCS_TokenAttributes_grabbed &)obj;

  Comparison result;

  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;
  if ((result = m_grabber.Compare(other.m_grabber)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TokenAttributes_grabbed::GetDataLength() const
{
  PINDEX length = 0;
  length += m_tokenId.GetObjectLength();
  length += m_grabber.GetObjectLength();
  return length;
}


PBoolean MCS_TokenAttributes_grabbed::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_tokenId.Decode(strm))
    return PFalse;
  if (!m_grabber.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TokenAttributes_grabbed::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_tokenId.Encode(strm);
  m_grabber.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TokenAttributes_grabbed::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TokenAttributes_grabbed::Class()), PInvalidCast);
#endif
  return new MCS_TokenAttributes_grabbed(*this);
}


//
// TokenAttributes_inhibited
//

MCS_TokenAttributes_inhibited::MCS_TokenAttributes_inhibited(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TokenAttributes_inhibited::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent+13) << "inhibitors = " << setprecision(indent) << m_inhibitors << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TokenAttributes_inhibited::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TokenAttributes_inhibited), PInvalidCast);
#endif
  const MCS_TokenAttributes_inhibited & other = (const MCS_TokenAttributes_inhibited &)obj;

  Comparison result;

  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;
  if ((result = m_inhibitors.Compare(other.m_inhibitors)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TokenAttributes_inhibited::GetDataLength() const
{
  PINDEX length = 0;
  length += m_tokenId.GetObjectLength();
  length += m_inhibitors.GetObjectLength();
  return length;
}


PBoolean MCS_TokenAttributes_inhibited::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_tokenId.Decode(strm))
    return PFalse;
  if (!m_inhibitors.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TokenAttributes_inhibited::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_tokenId.Encode(strm);
  m_inhibitors.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TokenAttributes_inhibited::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TokenAttributes_inhibited::Class()), PInvalidCast);
#endif
  return new MCS_TokenAttributes_inhibited(*this);
}


//
// TokenAttributes_giving
//

MCS_TokenAttributes_giving::MCS_TokenAttributes_giving(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TokenAttributes_giving::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent+10) << "grabber = " << setprecision(indent) << m_grabber << '\n';
  strm << setw(indent+12) << "recipient = " << setprecision(indent) << m_recipient << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TokenAttributes_giving::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TokenAttributes_giving), PInvalidCast);
#endif
  const MCS_TokenAttributes_giving & other = (const MCS_TokenAttributes_giving &)obj;

  Comparison result;

  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;
  if ((result = m_grabber.Compare(other.m_grabber)) != EqualTo)
    return result;
  if ((result = m_recipient.Compare(other.m_recipient)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TokenAttributes_giving::GetDataLength() const
{
  PINDEX length = 0;
  length += m_tokenId.GetObjectLength();
  length += m_grabber.GetObjectLength();
  length += m_recipient.GetObjectLength();
  return length;
}


PBoolean MCS_TokenAttributes_giving::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_tokenId.Decode(strm))
    return PFalse;
  if (!m_grabber.Decode(strm))
    return PFalse;
  if (!m_recipient.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TokenAttributes_giving::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_tokenId.Encode(strm);
  m_grabber.Encode(strm);
  m_recipient.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TokenAttributes_giving::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TokenAttributes_giving::Class()), PInvalidCast);
#endif
  return new MCS_TokenAttributes_giving(*this);
}


//
// TokenAttributes_ungivable
//

MCS_TokenAttributes_ungivable::MCS_TokenAttributes_ungivable(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TokenAttributes_ungivable::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent+10) << "grabber = " << setprecision(indent) << m_grabber << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TokenAttributes_ungivable::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TokenAttributes_ungivable), PInvalidCast);
#endif
  const MCS_TokenAttributes_ungivable & other = (const MCS_TokenAttributes_ungivable &)obj;

  Comparison result;

  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;
  if ((result = m_grabber.Compare(other.m_grabber)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TokenAttributes_ungivable::GetDataLength() const
{
  PINDEX length = 0;
  length += m_tokenId.GetObjectLength();
  length += m_grabber.GetObjectLength();
  return length;
}


PBoolean MCS_TokenAttributes_ungivable::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_tokenId.Decode(strm))
    return PFalse;
  if (!m_grabber.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TokenAttributes_ungivable::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_tokenId.Encode(strm);
  m_grabber.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TokenAttributes_ungivable::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TokenAttributes_ungivable::Class()), PInvalidCast);
#endif
  return new MCS_TokenAttributes_ungivable(*this);
}


//
// TokenAttributes_given
//

MCS_TokenAttributes_given::MCS_TokenAttributes_given(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TokenAttributes_given::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent+12) << "recipient = " << setprecision(indent) << m_recipient << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TokenAttributes_given::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TokenAttributes_given), PInvalidCast);
#endif
  const MCS_TokenAttributes_given & other = (const MCS_TokenAttributes_given &)obj;

  Comparison result;

  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;
  if ((result = m_recipient.Compare(other.m_recipient)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TokenAttributes_given::GetDataLength() const
{
  PINDEX length = 0;
  length += m_tokenId.GetObjectLength();
  length += m_recipient.GetObjectLength();
  return length;
}


PBoolean MCS_TokenAttributes_given::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_tokenId.Decode(strm))
    return PFalse;
  if (!m_recipient.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TokenAttributes_given::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_tokenId.Encode(strm);
  m_recipient.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TokenAttributes_given::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TokenAttributes_given::Class()), PInvalidCast);
#endif
  return new MCS_TokenAttributes_given(*this);
}


//
// ArrayOf_TokenAttributes
//

MCS_ArrayOf_TokenAttributes::MCS_ArrayOf_TokenAttributes(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * MCS_ArrayOf_TokenAttributes::CreateObject() const
{
  return new MCS_TokenAttributes;
}


MCS_TokenAttributes & MCS_ArrayOf_TokenAttributes::operator[](PINDEX i) const
{
  return (MCS_TokenAttributes &)array[i];
}


PObject * MCS_ArrayOf_TokenAttributes::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_ArrayOf_TokenAttributes::Class()), PInvalidCast);
#endif
  return new MCS_ArrayOf_TokenAttributes(*this);
}


//
// ArrayOf_TokenId
//

MCS_ArrayOf_TokenId::MCS_ArrayOf_TokenId(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * MCS_ArrayOf_TokenId::CreateObject() const
{
  return new MCS_TokenId;
}


MCS_TokenId & MCS_ArrayOf_TokenId::operator[](PINDEX i) const
{
  return (MCS_TokenId &)array[i];
}


PObject * MCS_ArrayOf_TokenId::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_ArrayOf_TokenId::Class()), PInvalidCast);
#endif
  return new MCS_ArrayOf_TokenId(*this);
}


//
// Connect-Response
//

MCS_Connect_Response::MCS_Connect_Response(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
  m_calledConnectId.SetConstraints(PASN_Object::FixedConstraint, 0, MaximumValue);
}


#ifndef PASN_NOPRINTON
void MCS_Connect_Response::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "result = " << setprecision(indent) << m_result << '\n';
  strm << setw(indent+18) << "calledConnectId = " << setprecision(indent) << m_calledConnectId << '\n';
  strm << setw(indent+19) << "domainParameters = " << setprecision(indent) << m_domainParameters << '\n';
  strm << setw(indent+11) << "userData = " << setprecision(indent) << m_userData << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_Connect_Response::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_Connect_Response), PInvalidCast);
#endif
  const MCS_Connect_Response & other = (const MCS_Connect_Response &)obj;

  Comparison result;

  if ((result = m_result.Compare(other.m_result)) != EqualTo)
    return result;
  if ((result = m_calledConnectId.Compare(other.m_calledConnectId)) != EqualTo)
    return result;
  if ((result = m_domainParameters.Compare(other.m_domainParameters)) != EqualTo)
    return result;
  if ((result = m_userData.Compare(other.m_userData)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_Connect_Response::GetDataLength() const
{
  PINDEX length = 0;
  length += m_result.GetObjectLength();
  length += m_calledConnectId.GetObjectLength();
  length += m_domainParameters.GetObjectLength();
  length += m_userData.GetObjectLength();
  return length;
}


PBoolean MCS_Connect_Response::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_result.Decode(strm))
    return PFalse;
  if (!m_calledConnectId.Decode(strm))
    return PFalse;
  if (!m_domainParameters.Decode(strm))
    return PFalse;
  if (!m_userData.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_Connect_Response::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_result.Encode(strm);
  m_calledConnectId.Encode(strm);
  m_domainParameters.Encode(strm);
  m_userData.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_Connect_Response::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_Connect_Response::Class()), PInvalidCast);
#endif
  return new MCS_Connect_Response(*this);
}


//
// Connect-Result
//

MCS_Connect_Result::MCS_Connect_Result(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_Connect_Result::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "result = " << setprecision(indent) << m_result << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_Connect_Result::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_Connect_Result), PInvalidCast);
#endif
  const MCS_Connect_Result & other = (const MCS_Connect_Result &)obj;

  Comparison result;

  if ((result = m_result.Compare(other.m_result)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_Connect_Result::GetDataLength() const
{
  PINDEX length = 0;
  length += m_result.GetObjectLength();
  return length;
}


PBoolean MCS_Connect_Result::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_result.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_Connect_Result::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_result.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_Connect_Result::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_Connect_Result::Class()), PInvalidCast);
#endif
  return new MCS_Connect_Result(*this);
}


//
// MCrq
//

MCS_MCrq::MCS_MCrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_MCrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+16) << "mergeChannels = " << setprecision(indent) << m_mergeChannels << '\n';
  strm << setw(indent+18) << "purgeChannelIds = " << setprecision(indent) << m_purgeChannelIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_MCrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_MCrq), PInvalidCast);
#endif
  const MCS_MCrq & other = (const MCS_MCrq &)obj;

  Comparison result;

  if ((result = m_mergeChannels.Compare(other.m_mergeChannels)) != EqualTo)
    return result;
  if ((result = m_purgeChannelIds.Compare(other.m_purgeChannelIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_MCrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_mergeChannels.GetObjectLength();
  length += m_purgeChannelIds.GetObjectLength();
  return length;
}


PBoolean MCS_MCrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_mergeChannels.Decode(strm))
    return PFalse;
  if (!m_purgeChannelIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_MCrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_mergeChannels.Encode(strm);
  m_purgeChannelIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_MCrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_MCrq::Class()), PInvalidCast);
#endif
  return new MCS_MCrq(*this);
}


//
// MCcf
//

MCS_MCcf::MCS_MCcf(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_MCcf::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+16) << "mergeChannels = " << setprecision(indent) << m_mergeChannels << '\n';
  strm << setw(indent+18) << "purgeChannelIds = " << setprecision(indent) << m_purgeChannelIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_MCcf::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_MCcf), PInvalidCast);
#endif
  const MCS_MCcf & other = (const MCS_MCcf &)obj;

  Comparison result;

  if ((result = m_mergeChannels.Compare(other.m_mergeChannels)) != EqualTo)
    return result;
  if ((result = m_purgeChannelIds.Compare(other.m_purgeChannelIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_MCcf::GetDataLength() const
{
  PINDEX length = 0;
  length += m_mergeChannels.GetObjectLength();
  length += m_purgeChannelIds.GetObjectLength();
  return length;
}


PBoolean MCS_MCcf::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_mergeChannels.Decode(strm))
    return PFalse;
  if (!m_purgeChannelIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_MCcf::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_mergeChannels.Encode(strm);
  m_purgeChannelIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_MCcf::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_MCcf::Class()), PInvalidCast);
#endif
  return new MCS_MCcf(*this);
}


//
// PCin
//

MCS_PCin::MCS_PCin(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_PCin::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+16) << "detachUserIds = " << setprecision(indent) << m_detachUserIds << '\n';
  strm << setw(indent+18) << "purgeChannelIds = " << setprecision(indent) << m_purgeChannelIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_PCin::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_PCin), PInvalidCast);
#endif
  const MCS_PCin & other = (const MCS_PCin &)obj;

  Comparison result;

  if ((result = m_detachUserIds.Compare(other.m_detachUserIds)) != EqualTo)
    return result;
  if ((result = m_purgeChannelIds.Compare(other.m_purgeChannelIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_PCin::GetDataLength() const
{
  PINDEX length = 0;
  length += m_detachUserIds.GetObjectLength();
  length += m_purgeChannelIds.GetObjectLength();
  return length;
}


PBoolean MCS_PCin::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_detachUserIds.Decode(strm))
    return PFalse;
  if (!m_purgeChannelIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_PCin::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_detachUserIds.Encode(strm);
  m_purgeChannelIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_PCin::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_PCin::Class()), PInvalidCast);
#endif
  return new MCS_PCin(*this);
}


//
// MTrq
//

MCS_MTrq::MCS_MTrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_MTrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+14) << "mergeTokens = " << setprecision(indent) << m_mergeTokens << '\n';
  strm << setw(indent+16) << "purgeTokenIds = " << setprecision(indent) << m_purgeTokenIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_MTrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_MTrq), PInvalidCast);
#endif
  const MCS_MTrq & other = (const MCS_MTrq &)obj;

  Comparison result;

  if ((result = m_mergeTokens.Compare(other.m_mergeTokens)) != EqualTo)
    return result;
  if ((result = m_purgeTokenIds.Compare(other.m_purgeTokenIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_MTrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_mergeTokens.GetObjectLength();
  length += m_purgeTokenIds.GetObjectLength();
  return length;
}


PBoolean MCS_MTrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_mergeTokens.Decode(strm))
    return PFalse;
  if (!m_purgeTokenIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_MTrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_mergeTokens.Encode(strm);
  m_purgeTokenIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_MTrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_MTrq::Class()), PInvalidCast);
#endif
  return new MCS_MTrq(*this);
}


//
// MTcf
//

MCS_MTcf::MCS_MTcf(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_MTcf::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+14) << "mergeTokens = " << setprecision(indent) << m_mergeTokens << '\n';
  strm << setw(indent+16) << "purgeTokenIds = " << setprecision(indent) << m_purgeTokenIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_MTcf::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_MTcf), PInvalidCast);
#endif
  const MCS_MTcf & other = (const MCS_MTcf &)obj;

  Comparison result;

  if ((result = m_mergeTokens.Compare(other.m_mergeTokens)) != EqualTo)
    return result;
  if ((result = m_purgeTokenIds.Compare(other.m_purgeTokenIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_MTcf::GetDataLength() const
{
  PINDEX length = 0;
  length += m_mergeTokens.GetObjectLength();
  length += m_purgeTokenIds.GetObjectLength();
  return length;
}


PBoolean MCS_MTcf::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_mergeTokens.Decode(strm))
    return PFalse;
  if (!m_purgeTokenIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_MTcf::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_mergeTokens.Encode(strm);
  m_purgeTokenIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_MTcf::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_MTcf::Class()), PInvalidCast);
#endif
  return new MCS_MTcf(*this);
}


//
// PTin
//

MCS_PTin::MCS_PTin(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_PTin::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+16) << "purgeTokenIds = " << setprecision(indent) << m_purgeTokenIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_PTin::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_PTin), PInvalidCast);
#endif
  const MCS_PTin & other = (const MCS_PTin &)obj;

  Comparison result;

  if ((result = m_purgeTokenIds.Compare(other.m_purgeTokenIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_PTin::GetDataLength() const
{
  PINDEX length = 0;
  length += m_purgeTokenIds.GetObjectLength();
  return length;
}


PBoolean MCS_PTin::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_purgeTokenIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_PTin::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_purgeTokenIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_PTin::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_PTin::Class()), PInvalidCast);
#endif
  return new MCS_PTin(*this);
}


//
// DPum
//

MCS_DPum::MCS_DPum(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_DPum::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "reason = " << setprecision(indent) << m_reason << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_DPum::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_DPum), PInvalidCast);
#endif
  const MCS_DPum & other = (const MCS_DPum &)obj;

  Comparison result;

  if ((result = m_reason.Compare(other.m_reason)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_DPum::GetDataLength() const
{
  PINDEX length = 0;
  length += m_reason.GetObjectLength();
  return length;
}


PBoolean MCS_DPum::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_reason.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_DPum::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_reason.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_DPum::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_DPum::Class()), PInvalidCast);
#endif
  return new MCS_DPum(*this);
}


//
// RJum
//

MCS_RJum::MCS_RJum(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_RJum::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+13) << "diagnostic = " << setprecision(indent) << m_diagnostic << '\n';
  strm << setw(indent+16) << "initialOctets = " << setprecision(indent) << m_initialOctets << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_RJum::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_RJum), PInvalidCast);
#endif
  const MCS_RJum & other = (const MCS_RJum &)obj;

  Comparison result;

  if ((result = m_diagnostic.Compare(other.m_diagnostic)) != EqualTo)
    return result;
  if ((result = m_initialOctets.Compare(other.m_initialOctets)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_RJum::GetDataLength() const
{
  PINDEX length = 0;
  length += m_diagnostic.GetObjectLength();
  length += m_initialOctets.GetObjectLength();
  return length;
}


PBoolean MCS_RJum::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_diagnostic.Decode(strm))
    return PFalse;
  if (!m_initialOctets.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_RJum::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_diagnostic.Encode(strm);
  m_initialOctets.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_RJum::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_RJum::Class()), PInvalidCast);
#endif
  return new MCS_RJum(*this);
}


//
// AUcf
//

MCS_AUcf::MCS_AUcf(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 1, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_AUcf::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "result = " << setprecision(indent) << m_result << '\n';
  if (HasOptionalField(e_initiator))
    strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_AUcf::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_AUcf), PInvalidCast);
#endif
  const MCS_AUcf & other = (const MCS_AUcf &)obj;

  Comparison result;

  if ((result = m_result.Compare(other.m_result)) != EqualTo)
    return result;
  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_AUcf::GetDataLength() const
{
  PINDEX length = 0;
  length += m_result.GetObjectLength();
  if (HasOptionalField(e_initiator))
    length += m_initiator.GetObjectLength();
  return length;
}


PBoolean MCS_AUcf::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_result.Decode(strm))
    return PFalse;
  if (HasOptionalField(e_initiator) && !m_initiator.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_AUcf::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_result.Encode(strm);
  if (HasOptionalField(e_initiator))
    m_initiator.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_AUcf::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_AUcf::Class()), PInvalidCast);
#endif
  return new MCS_AUcf(*this);
}


//
// DUrq
//

MCS_DUrq::MCS_DUrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_DUrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "reason = " << setprecision(indent) << m_reason << '\n';
  strm << setw(indent+10) << "userIds = " << setprecision(indent) << m_userIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_DUrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_DUrq), PInvalidCast);
#endif
  const MCS_DUrq & other = (const MCS_DUrq &)obj;

  Comparison result;

  if ((result = m_reason.Compare(other.m_reason)) != EqualTo)
    return result;
  if ((result = m_userIds.Compare(other.m_userIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_DUrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_reason.GetObjectLength();
  length += m_userIds.GetObjectLength();
  return length;
}


PBoolean MCS_DUrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_reason.Decode(strm))
    return PFalse;
  if (!m_userIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_DUrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_reason.Encode(strm);
  m_userIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_DUrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_DUrq::Class()), PInvalidCast);
#endif
  return new MCS_DUrq(*this);
}


//
// DUin
//

MCS_DUin::MCS_DUin(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_DUin::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "reason = " << setprecision(indent) << m_reason << '\n';
  strm << setw(indent+10) << "userIds = " << setprecision(indent) << m_userIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_DUin::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_DUin), PInvalidCast);
#endif
  const MCS_DUin & other = (const MCS_DUin &)obj;

  Comparison result;

  if ((result = m_reason.Compare(other.m_reason)) != EqualTo)
    return result;
  if ((result = m_userIds.Compare(other.m_userIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_DUin::GetDataLength() const
{
  PINDEX length = 0;
  length += m_reason.GetObjectLength();
  length += m_userIds.GetObjectLength();
  return length;
}


PBoolean MCS_DUin::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_reason.Decode(strm))
    return PFalse;
  if (!m_userIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_DUin::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_reason.Encode(strm);
  m_userIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_DUin::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_DUin::Class()), PInvalidCast);
#endif
  return new MCS_DUin(*this);
}


//
// CJcf
//

MCS_CJcf::MCS_CJcf(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 1, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_CJcf::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "result = " << setprecision(indent) << m_result << '\n';
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+12) << "requested = " << setprecision(indent) << m_requested << '\n';
  if (HasOptionalField(e_channelId))
    strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_CJcf::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_CJcf), PInvalidCast);
#endif
  const MCS_CJcf & other = (const MCS_CJcf &)obj;

  Comparison result;

  if ((result = m_result.Compare(other.m_result)) != EqualTo)
    return result;
  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_requested.Compare(other.m_requested)) != EqualTo)
    return result;
  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_CJcf::GetDataLength() const
{
  PINDEX length = 0;
  length += m_result.GetObjectLength();
  length += m_initiator.GetObjectLength();
  length += m_requested.GetObjectLength();
  if (HasOptionalField(e_channelId))
    length += m_channelId.GetObjectLength();
  return length;
}


PBoolean MCS_CJcf::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_result.Decode(strm))
    return PFalse;
  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_requested.Decode(strm))
    return PFalse;
  if (HasOptionalField(e_channelId) && !m_channelId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_CJcf::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_result.Encode(strm);
  m_initiator.Encode(strm);
  m_requested.Encode(strm);
  if (HasOptionalField(e_channelId))
    m_channelId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_CJcf::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_CJcf::Class()), PInvalidCast);
#endif
  return new MCS_CJcf(*this);
}


//
// CLrq
//

MCS_CLrq::MCS_CLrq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_CLrq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+13) << "channelIds = " << setprecision(indent) << m_channelIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_CLrq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_CLrq), PInvalidCast);
#endif
  const MCS_CLrq & other = (const MCS_CLrq &)obj;

  Comparison result;

  if ((result = m_channelIds.Compare(other.m_channelIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_CLrq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_channelIds.GetObjectLength();
  return length;
}


PBoolean MCS_CLrq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_channelIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_CLrq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_channelIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_CLrq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_CLrq::Class()), PInvalidCast);
#endif
  return new MCS_CLrq(*this);
}


//
// CCcf
//

MCS_CCcf::MCS_CCcf(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 1, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_CCcf::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "result = " << setprecision(indent) << m_result << '\n';
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  if (HasOptionalField(e_channelId))
    strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_CCcf::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_CCcf), PInvalidCast);
#endif
  const MCS_CCcf & other = (const MCS_CCcf &)obj;

  Comparison result;

  if ((result = m_result.Compare(other.m_result)) != EqualTo)
    return result;
  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_CCcf::GetDataLength() const
{
  PINDEX length = 0;
  length += m_result.GetObjectLength();
  length += m_initiator.GetObjectLength();
  if (HasOptionalField(e_channelId))
    length += m_channelId.GetObjectLength();
  return length;
}


PBoolean MCS_CCcf::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_result.Decode(strm))
    return PFalse;
  if (!m_initiator.Decode(strm))
    return PFalse;
  if (HasOptionalField(e_channelId) && !m_channelId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_CCcf::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_result.Encode(strm);
  m_initiator.Encode(strm);
  if (HasOptionalField(e_channelId))
    m_channelId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_CCcf::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_CCcf::Class()), PInvalidCast);
#endif
  return new MCS_CCcf(*this);
}


//
// CArq
//

MCS_CArq::MCS_CArq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_CArq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent+10) << "userIds = " << setprecision(indent) << m_userIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_CArq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_CArq), PInvalidCast);
#endif
  const MCS_CArq & other = (const MCS_CArq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;
  if ((result = m_userIds.Compare(other.m_userIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_CArq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_channelId.GetObjectLength();
  length += m_userIds.GetObjectLength();
  return length;
}


PBoolean MCS_CArq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_channelId.Decode(strm))
    return PFalse;
  if (!m_userIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_CArq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_channelId.Encode(strm);
  m_userIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_CArq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_CArq::Class()), PInvalidCast);
#endif
  return new MCS_CArq(*this);
}


//
// CAin
//

MCS_CAin::MCS_CAin(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_CAin::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent+10) << "userIds = " << setprecision(indent) << m_userIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_CAin::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_CAin), PInvalidCast);
#endif
  const MCS_CAin & other = (const MCS_CAin &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;
  if ((result = m_userIds.Compare(other.m_userIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_CAin::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_channelId.GetObjectLength();
  length += m_userIds.GetObjectLength();
  return length;
}


PBoolean MCS_CAin::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_channelId.Decode(strm))
    return PFalse;
  if (!m_userIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_CAin::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_channelId.Encode(strm);
  m_userIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_CAin::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_CAin::Class()), PInvalidCast);
#endif
  return new MCS_CAin(*this);
}


//
// CErq
//

MCS_CErq::MCS_CErq(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_CErq::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent+10) << "userIds = " << setprecision(indent) << m_userIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_CErq::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_CErq), PInvalidCast);
#endif
  const MCS_CErq & other = (const MCS_CErq &)obj;

  Comparison result;

  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;
  if ((result = m_userIds.Compare(other.m_userIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_CErq::GetDataLength() const
{
  PINDEX length = 0;
  length += m_initiator.GetObjectLength();
  length += m_channelId.GetObjectLength();
  length += m_userIds.GetObjectLength();
  return length;
}


PBoolean MCS_CErq::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_channelId.Decode(strm))
    return PFalse;
  if (!m_userIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_CErq::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_initiator.Encode(strm);
  m_channelId.Encode(strm);
  m_userIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_CErq::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_CErq::Class()), PInvalidCast);
#endif
  return new MCS_CErq(*this);
}


//
// CEin
//

MCS_CEin::MCS_CEin(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_CEin::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent+10) << "userIds = " << setprecision(indent) << m_userIds << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_CEin::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_CEin), PInvalidCast);
#endif
  const MCS_CEin & other = (const MCS_CEin &)obj;

  Comparison result;

  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;
  if ((result = m_userIds.Compare(other.m_userIds)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_CEin::GetDataLength() const
{
  PINDEX length = 0;
  length += m_channelId.GetObjectLength();
  length += m_userIds.GetObjectLength();
  return length;
}


PBoolean MCS_CEin::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_channelId.Decode(strm))
    return PFalse;
  if (!m_userIds.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_CEin::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_channelId.Encode(strm);
  m_userIds.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_CEin::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_CEin::Class()), PInvalidCast);
#endif
  return new MCS_CEin(*this);
}


//
// TGcf
//

MCS_TGcf::MCS_TGcf(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TGcf::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "result = " << setprecision(indent) << m_result << '\n';
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent+14) << "tokenStatus = " << setprecision(indent) << m_tokenStatus << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TGcf::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TGcf), PInvalidCast);
#endif
  const MCS_TGcf & other = (const MCS_TGcf &)obj;

  Comparison result;

  if ((result = m_result.Compare(other.m_result)) != EqualTo)
    return result;
  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;
  if ((result = m_tokenStatus.Compare(other.m_tokenStatus)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TGcf::GetDataLength() const
{
  PINDEX length = 0;
  length += m_result.GetObjectLength();
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  length += m_tokenStatus.GetObjectLength();
  return length;
}


PBoolean MCS_TGcf::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_result.Decode(strm))
    return PFalse;
  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;
  if (!m_tokenStatus.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TGcf::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_result.Encode(strm);
  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);
  m_tokenStatus.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TGcf::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TGcf::Class()), PInvalidCast);
#endif
  return new MCS_TGcf(*this);
}


//
// TIcf
//

MCS_TIcf::MCS_TIcf(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TIcf::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "result = " << setprecision(indent) << m_result << '\n';
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent+14) << "tokenStatus = " << setprecision(indent) << m_tokenStatus << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TIcf::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TIcf), PInvalidCast);
#endif
  const MCS_TIcf & other = (const MCS_TIcf &)obj;

  Comparison result;

  if ((result = m_result.Compare(other.m_result)) != EqualTo)
    return result;
  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;
  if ((result = m_tokenStatus.Compare(other.m_tokenStatus)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TIcf::GetDataLength() const
{
  PINDEX length = 0;
  length += m_result.GetObjectLength();
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  length += m_tokenStatus.GetObjectLength();
  return length;
}


PBoolean MCS_TIcf::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_result.Decode(strm))
    return PFalse;
  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;
  if (!m_tokenStatus.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TIcf::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_result.Encode(strm);
  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);
  m_tokenStatus.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TIcf::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TIcf::Class()), PInvalidCast);
#endif
  return new MCS_TIcf(*this);
}


//
// TVrs
//

MCS_TVrs::MCS_TVrs(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TVrs::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "result = " << setprecision(indent) << m_result << '\n';
  strm << setw(indent+12) << "recipient = " << setprecision(indent) << m_recipient << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TVrs::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TVrs), PInvalidCast);
#endif
  const MCS_TVrs & other = (const MCS_TVrs &)obj;

  Comparison result;

  if ((result = m_result.Compare(other.m_result)) != EqualTo)
    return result;
  if ((result = m_recipient.Compare(other.m_recipient)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TVrs::GetDataLength() const
{
  PINDEX length = 0;
  length += m_result.GetObjectLength();
  length += m_recipient.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  return length;
}


PBoolean MCS_TVrs::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_result.Decode(strm))
    return PFalse;
  if (!m_recipient.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TVrs::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_result.Encode(strm);
  m_recipient.Encode(strm);
  m_tokenId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TVrs::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TVrs::Class()), PInvalidCast);
#endif
  return new MCS_TVrs(*this);
}


//
// TVcf
//

MCS_TVcf::MCS_TVcf(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TVcf::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "result = " << setprecision(indent) << m_result << '\n';
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent+14) << "tokenStatus = " << setprecision(indent) << m_tokenStatus << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TVcf::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TVcf), PInvalidCast);
#endif
  const MCS_TVcf & other = (const MCS_TVcf &)obj;

  Comparison result;

  if ((result = m_result.Compare(other.m_result)) != EqualTo)
    return result;
  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;
  if ((result = m_tokenStatus.Compare(other.m_tokenStatus)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TVcf::GetDataLength() const
{
  PINDEX length = 0;
  length += m_result.GetObjectLength();
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  length += m_tokenStatus.GetObjectLength();
  return length;
}


PBoolean MCS_TVcf::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_result.Decode(strm))
    return PFalse;
  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;
  if (!m_tokenStatus.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TVcf::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_result.Encode(strm);
  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);
  m_tokenStatus.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TVcf::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TVcf::Class()), PInvalidCast);
#endif
  return new MCS_TVcf(*this);
}


//
// TRcf
//

MCS_TRcf::MCS_TRcf(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_TRcf::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "result = " << setprecision(indent) << m_result << '\n';
  strm << setw(indent+12) << "initiator = " << setprecision(indent) << m_initiator << '\n';
  strm << setw(indent+10) << "tokenId = " << setprecision(indent) << m_tokenId << '\n';
  strm << setw(indent+14) << "tokenStatus = " << setprecision(indent) << m_tokenStatus << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_TRcf::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_TRcf), PInvalidCast);
#endif
  const MCS_TRcf & other = (const MCS_TRcf &)obj;

  Comparison result;

  if ((result = m_result.Compare(other.m_result)) != EqualTo)
    return result;
  if ((result = m_initiator.Compare(other.m_initiator)) != EqualTo)
    return result;
  if ((result = m_tokenId.Compare(other.m_tokenId)) != EqualTo)
    return result;
  if ((result = m_tokenStatus.Compare(other.m_tokenStatus)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_TRcf::GetDataLength() const
{
  PINDEX length = 0;
  length += m_result.GetObjectLength();
  length += m_initiator.GetObjectLength();
  length += m_tokenId.GetObjectLength();
  length += m_tokenStatus.GetObjectLength();
  return length;
}


PBoolean MCS_TRcf::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_result.Decode(strm))
    return PFalse;
  if (!m_initiator.Decode(strm))
    return PFalse;
  if (!m_tokenId.Decode(strm))
    return PFalse;
  if (!m_tokenStatus.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_TRcf::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_result.Encode(strm);
  m_initiator.Encode(strm);
  m_tokenId.Encode(strm);
  m_tokenStatus.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_TRcf::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_TRcf::Class()), PInvalidCast);
#endif
  return new MCS_TRcf(*this);
}


//
// ChannelAttributes_private
//

MCS_ChannelAttributes_private::MCS_ChannelAttributes_private(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, PFalse, 0)
{
}


#ifndef PASN_NOPRINTON
void MCS_ChannelAttributes_private::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+9) << "joined = " << setprecision(indent) << m_joined << '\n';
  strm << setw(indent+12) << "channelId = " << setprecision(indent) << m_channelId << '\n';
  strm << setw(indent+10) << "manager = " << setprecision(indent) << m_manager << '\n';
  strm << setw(indent+11) << "admitted = " << setprecision(indent) << m_admitted << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison MCS_ChannelAttributes_private::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, MCS_ChannelAttributes_private), PInvalidCast);
#endif
  const MCS_ChannelAttributes_private & other = (const MCS_ChannelAttributes_private &)obj;

  Comparison result;

  if ((result = m_joined.Compare(other.m_joined)) != EqualTo)
    return result;
  if ((result = m_channelId.Compare(other.m_channelId)) != EqualTo)
    return result;
  if ((result = m_manager.Compare(other.m_manager)) != EqualTo)
    return result;
  if ((result = m_admitted.Compare(other.m_admitted)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX MCS_ChannelAttributes_private::GetDataLength() const
{
  PINDEX length = 0;
  length += m_joined.GetObjectLength();
  length += m_channelId.GetObjectLength();
  length += m_manager.GetObjectLength();
  length += m_admitted.GetObjectLength();
  return length;
}


PBoolean MCS_ChannelAttributes_private::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return PFalse;

  if (!m_joined.Decode(strm))
    return PFalse;
  if (!m_channelId.Decode(strm))
    return PFalse;
  if (!m_manager.Decode(strm))
    return PFalse;
  if (!m_admitted.Decode(strm))
    return PFalse;

  return UnknownExtensionsDecode(strm);
}


void MCS_ChannelAttributes_private::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_joined.Encode(strm);
  m_channelId.Encode(strm);
  m_manager.Encode(strm);
  m_admitted.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * MCS_ChannelAttributes_private::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(MCS_ChannelAttributes_private::Class()), PInvalidCast);
#endif
  return new MCS_ChannelAttributes_private(*this);
}


#endif // if ! H323_DISABLE_MCS


// End of mcspdu.cxx
