/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#include "config.h"

#include <QDebug>

#include "QtTapioca/Channel"
#include "QtTapioca/ChannelTarget"

#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusConnectionInterface>
#include <QtTelepathy/Client/Channel>

namespace QtTapioca {

class ChannelPrivate {
public:
    ChannelPrivate(Connection *connection,
                   const QString &serviceName,
                   const QString &objPath,
                   ChannelTarget *channelTarget)
        : conn(connection),
          target(channelTarget),
          join(false)
    {
        ch = new org::freedesktop::Telepathy::Channel(serviceName, objPath, QDBusConnection::sessionBus());
    }
    ~ChannelPrivate()
    {
        delete ch;
    }

    Connection *conn;
    org::freedesktop::Telepathy::Channel *ch;
    ChannelTarget* target;
    ContactGroup *cg;
    bool join;
};

}

using namespace QtTapioca;

Channel::Channel(Connection *conn, const QString &serviceName, const QString &objPath, Type type, ChannelTarget *target, QObject *parent)
    : DBusProxyObject(serviceName, objPath, parent),
      m_type(type),
      d(new ChannelPrivate(conn, serviceName, objPath, target))
{
    Q_ASSERT(d);

    QObject::connect(d->ch, SIGNAL(Closed()), this, SLOT(onClosed()));
}

Channel::~Channel()
{
    delete d;
}

void Channel::close()
{
    QDBusReply<void> reply = d->ch->Close();

    if (!reply.isValid())
        qDebug() << "error closing channel:" << reply.error().message();
}

void Channel::onClosed()
{
    emit closed();
    deleteLater();
}

/*
 * Returns the channel's target
 */
ChannelTarget *Channel::target() const
{
    return d->target;
}

ContactGroup *Channel::contactGroup() const
{
    return d->cg;
}

bool Channel::hasGroupSupport() const
{
    return (d->cg);
}

void Channel::join()
{
    d->join = true;
}
