/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2007 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_STREAM_H
#define QTTAPIOCA_STREAM_H

#include <QtCore/QList>
#include <QtCore/QObject>
#include <QtCore/QString>
#include <qglobal.h>

#include <QtTelepathy/Client/ChannelStreamedMedia>

namespace QtTapioca {

class Connection;
class StreamPrivate;

class Q_DECL_EXPORT Stream: public QObject {
    Q_OBJECT
    Q_DECLARE_PRIVATE(Stream)
    Q_ENUMS(Type)
    Q_ENUMS(StreamState)

public:
    enum Type {
        Audio = 0,
        Video
    };

    enum StreamState {
        Connecting = 0,
        Paused = 1,
        Playing = 2
    };

    ~Stream();

    void pause(bool value);
    Type type() const { return m_type; }
    StreamState state() const { return m_state; }

Q_SIGNALS:
    void streamError(Stream *stream, int code, const QString &message);
    void stateChanged(Stream *stream, Stream::StreamState newState);

private Q_SLOTS:
    void onStreamError(uint id, uint error, const QString &msg);
    void onStreamStateChanged(uint id, uint state);

protected:
    Stream(org::freedesktop::Telepathy::ChannelStreamedMedia *sm, uint id, uint contact, uint type, QObject *parent);
    Stream(org::freedesktop::Telepathy::ChannelStreamedMedia *sm, uint id, uint contact, uint type, uint state, uint direction, uint flags, QObject *parent);

    uint m_id;
    Type m_type;
    uint m_contact;
    uint m_direction;
    uint m_flags;
    StreamState m_state;

private:

    friend class StreamChannel;

    StreamPrivate *d;
};

} // namespace

#endif

