/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.repository.explore;

import info.aduna.text.ToStringComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.model.Resource;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.http.HTTPRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExploreContextsController
implements Controller {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String view;

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView result = new ModelAndView();
        result.setViewName(this.view);
        HashMap<String, List<Resource>> model = new HashMap<String, List<Resource>>();
        List<Resource> contexts = this.getContexts(request);
        Collections.sort(contexts, ToStringComparator.getInstance());
        model.put("contexts", contexts);
        result.addAllObjects(model);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Resource> getContexts(HttpServletRequest request) {
        ArrayList<Resource> result = null;
        HTTPRepository repo = (HTTPRepository)request.getSession().getAttribute("openrdf-repository");
        RepositoryConnection conn = null;
        try {
            conn = repo.getConnection();
            RepositoryResult<Resource> contexts = conn.getContextIDs();
            result = new ArrayList<Resource>();
            while (contexts.hasNext()) {
                result.add((Resource)contexts.next());
            }
        }
        catch (RepositoryException e) {
            this.logger.warn("Unable to retrieve contexts", (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (RepositoryException e) {
                    this.logger.debug("Unable to close connection...", (Throwable)e);
                }
            }
        }
        return result;
    }
}

