/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A skrooge plugin to print pages
 *
 * @author Stephane MANKOWSKI
 */
#include "skgprintplugin.h"
#include "skgprintpluginwidget.h"
#include "skrooge_print.h"
#include "skgtraces.h"
#include "skgmainpanel.h"

#include <kactioncollection.h>
#include <kstandardaction.h>

#include <QPrinter>
#include <QPrintDialog>
#include <QPainter>

K_PLUGIN_FACTORY(SKGPrintPluginFactory, registerPlugin<SKGPrintPlugin>();)
K_EXPORT_PLUGIN(SKGPrintPluginFactory("skrooge_print", "skrooge_print"))

SKGPrintPlugin::SKGPrintPlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
        SKGTRACEIN(10, "SKGPrintPlugin::SKGPrintPlugin");
}

SKGPrintPlugin::~SKGPrintPlugin()
{
        SKGTRACEIN(10, "SKGPrintPlugin::~SKGPrintPlugin");
        parent=NULL;
        currentBankDocument=NULL;
}

void SKGPrintPlugin::setupActions(SKGMainPanel* iParent, SKGDocument* iDocument, const QStringList& iArgument)
{
        SKGTRACEIN(10, "SKGPrintPlugin::setupActions");
        Q_UNUSED(iArgument);

        currentBankDocument=iDocument;
        parent=iParent;

        setComponentData( SKGPrintPluginFactory::componentData() );
        setXMLFile("skrooge_print.rc");

        KStandardAction::print(this, SLOT(actionPrint()), actionCollection());
        //TODO KStandardAction::printPreview(this, SLOT(actionPrintPreview()), actionCollection());

}

void SKGPrintPlugin::refresh()
{
        SKGTRACEIN(10, "SKGPrintPlugin::refresh");
}

void SKGPrintPlugin::close()
{
        SKGTRACEIN(10, "SKGPrintPlugin::close");
}

SKGTabWidget* SKGPrintPlugin::getWidget()
{
        SKGTRACEIN(10, "SKGPrintPlugin::getWidget");
        return new SKGPrintPluginWidget(parent, currentBankDocument);
}

QWidget* SKGPrintPlugin::getPreferenceWidget()
{
        SKGTRACEIN(10, "SKGPrintPlugin::getPreferenceWidget");
        /* QWidget* widget=new QWidget();
         ui.setupUi(widget);

         return widget;*/
        return NULL;
}

KConfigSkeleton* SKGPrintPlugin::getPreferenceSkeleton()
{
        return skrooge_print::self();
}

SKGError SKGPrintPlugin::savePreferences() const
{
        return SKGError();
}

QString SKGPrintPlugin::title() const
{
        return i18n("print");
}

QString SKGPrintPlugin::icon() const
{
        return "printer";
}

QString SKGPrintPlugin::statusTip () const
{
        return i18n("print");
}

QString SKGPrintPlugin::toolTip () const
{
        return i18n("print");
}

int SKGPrintPlugin::getOrder() const
{
        return 2;
}

QStringList SKGPrintPlugin::tips() const
{
        QStringList output;
        output.push_back(i18n("<p>... you can print all opened pages.</p>"));
        return output;
}

bool SKGPrintPlugin::isInContext() const
{
        return false;
}

void SKGPrintPlugin::actionPrint()
{
        SKGError err;
        SKGTRACEINRC(10, "SKGPrintPlugin::actionPrint",err);

        if (parent) {
                QPrinter printer(QPrinter::HighResolution);
                QPrintDialog dialog(&printer, parent);
                if (dialog.exec() == QDialog::Accepted) {
                        QApplication::setOverrideCursor(QCursor(Qt::WaitCursor));

                        QPainter painter;
                        if (!painter.begin(&printer)) {
                                err=SKGError(ERR_FAIL, i18n("Printer initialisation failed"));
                        } else {
                                KTabWidget* tabs=(KTabWidget*) parent->centralWidget();
                                int nbpages=tabs->count();
                                for (int i=0; i<nbpages; ++i) {
                                        SKGTabWidget* page=(SKGTabWidget*) tabs->widget(i);
                                        if (page) {
                                                QWidget* widget=page->getWidgetForPrint();
                                                if (widget) {
                                                        QImage image(widget->size(), QImage::Format_ARGB32);
                                                        QPainter painter2(&image);
                                                        widget->render(&painter2);

                                                        QRect rect = painter.viewport();
                                                        QSize size = image.size();
                                                        size.scale(rect.size(), Qt::KeepAspectRatio);
                                                        painter.setViewport(rect.x(), rect.y(), size.width(), size.height());
                                                        painter.setWindow(image.rect());
                                                        painter.drawImage(0, 0, image);

                                                        if (i<nbpages-1) {
                                                                if (!printer.newPage()) {
                                                                        err=SKGError(ERR_FAIL, i18n("Creation of new page failed"));
                                                                }
                                                        }
                                                }
                                        }
                                }
                                painter.end();
                        }
                        QApplication::restoreOverrideCursor();

                        //status bar
                        if (err.isSucceeded()) err=SKGError(0, i18n("Print successfully done."));
                        else err.addError(ERR_FAIL, i18n("Print failed"));
                }

                //Display error
                parent->displayErrorMessage(err);
        }
}

void SKGPrintPlugin::actionPrintPreview()
{
        SKGError err;
        SKGTRACEINRC(10, "SKGPrintPlugin::actionPrintPreview",err);
        QApplication::setOverrideCursor(QCursor(Qt::WaitCursor));
        /*err=currentBankDocument->save();
        QApplication::restoreOverrideCursor();

        //Refresh
        parent->refresh();

        //status bar
        if (err.isSucceeded()) err=SKGError(0, i18n("File successfully saved."));
        else err.addError(ERR_FAIL, i18n("Cannot save file"));*/

        //Display error
        if (parent) parent->displayErrorMessage(err);
}
#include "skgprintplugin.moc"
