/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is Skrooge plugin for bank management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbankplugin.h"
#include "skgbankpluginwidget.h"
#include "skrooge_bank.h"
#include "skgtraces.h"

K_PLUGIN_FACTORY(SKGBankPluginFactory, registerPlugin<SKGBankPlugin>();)
K_EXPORT_PLUGIN(SKGBankPluginFactory("skrooge_bank", "skrooge_bank"))

SKGBankPlugin::SKGBankPlugin(QObject* iParent, const QVariantList& /*iArg*/)
                :SKGInterfacePlugin(iParent), parent(NULL), currentBankDocument(NULL)
{
        SKGTRACEIN(10, "SKGBankPlugin::SKGBankPlugin");
}

SKGBankPlugin::~SKGBankPlugin()
{
        SKGTRACEIN(10, "SKGBankPlugin::~SKGBankPlugin");
        parent=NULL;
        currentBankDocument=NULL;
}

void SKGBankPlugin::setupActions(SKGMainPanel* iParent, SKGDocument* iDocument, const QStringList& iArgument)
{
        SKGTRACEIN(10, "SKGBankPlugin::setupActions");
        Q_UNUSED(iArgument);

        currentBankDocument=iDocument;
        parent=iParent;
}

void SKGBankPlugin::close()
{
        SKGTRACEIN(10, "SKGBankPlugin::close");
}

SKGTabWidget* SKGBankPlugin::getWidget()
{
        SKGTRACEIN(10, "SKGBankPlugin::getWidget");
        return new SKGBankPluginWidget(parent, (SKGDocumentBank*) currentBankDocument);
}

QWidget* SKGBankPlugin::getPreferenceWidget()
{
        SKGTRACEIN(10, "SKGBankPlugin::getPreferenceWidget");
        QWidget* widget=new QWidget();
        ui.setupUi(widget);

        return widget;
}

KConfigSkeleton* SKGBankPlugin::getPreferenceSkeleton()
{
        return skrooge_bank::self();
}

QString SKGBankPlugin::title() const
{
        return i18n("Bank and Account");
}

QString SKGBankPlugin::icon() const
{
        return "kwalletmanager";
}

QString SKGBankPlugin::statusTip () const
{
        return i18n("Bank and account management (creation, update ...)");
}

QString SKGBankPlugin::toolTip () const
{
        return i18n("Bank and account management");
}

QStringList SKGBankPlugin::tips() const
{
        QStringList output;
        output.push_back(i18n("<p>... you can associate a logo to yours banks.</p>"));
        return output;
}

int SKGBankPlugin::getOrder() const
{
        //Must be one of the first
        return 10;
}

bool SKGBankPlugin::isInContext() const
{
        return true;
}
#include "skgbankplugin.moc"
