/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@miraks.com    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A KLineEdit with calculator included for skrooge.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgcalculatoredit.h"
#include "skgservices.h"

#include <QDoubleValidator>
#include <QKeyEvent>
#include <QScriptEngine>

SKGCalculatorEdit::SKGCalculatorEdit(QWidget *parent)
                : KLineEdit(parent), lastValue(0), lastOperator(0)
{
        setMode(CALCULATOR);
}

SKGCalculatorEdit::~SKGCalculatorEdit()
{
}

double SKGCalculatorEdit::value() const
{
        return SKGServices::stringToDouble(text());
}

int SKGCalculatorEdit::sign() const
{
        QString t=text();
        if (t.count() && t[0]=='+') return 1;
        else if (t.count() && t[0]=='-') return -1;
        return 0;
}

SKGCalculatorEdit::Mode SKGCalculatorEdit::mode() const
{
        return currentMode;
}

void SKGCalculatorEdit::setMode (Mode iMode)
{
        currentMode=iMode;
        if (iMode==CALCULATOR) {
                QDoubleValidator* validator=new QDoubleValidator(this);
                setValidator(validator);
                setAlignment(Qt::AlignRight);
        } else {
                setValidator(NULL);
        }
}

void SKGCalculatorEdit::setValue (double iValue)
{
        setText(SKGServices::doubleToString(iValue));
}

void SKGCalculatorEdit::keyPressEvent( QKeyEvent * event )
{
        if (event) {
                int key=event->key();
                if (mode()==CALCULATOR) {
                        bool hasText=!text().isEmpty() && selectedText()!=text();

                        if (event->count()==1 && ((key==Qt::Key_Plus && hasText) || (key==Qt::Key_Minus && hasText) || key==Qt::Key_Asterisk || key==Qt::Key_Slash || key==Qt::Key_Return)) {
                                keyPressEvent(key);
                                event->accept();
                        } else KLineEdit::keyPressEvent(event);
                } else {
                        keyPressEvent(key);
                        KLineEdit::keyPressEvent(event);
                }
        }
}

void SKGCalculatorEdit::focusOutEvent ( QFocusEvent * event )
{
        keyPressEvent(Qt::Key_Return);
        KLineEdit::focusOutEvent(event);
}

void SKGCalculatorEdit::keyPressEvent(int key)
{
        if (mode()==CALCULATOR) {
                if (lastOperator!=0) {
                        if (lastOperator==Qt::Key_Plus) {
                                lastValue+=value();
                                setValue(lastValue);
                        } else if (lastOperator==Qt::Key_Minus) {
                                lastValue-=value();
                                setValue(lastValue);
                        } else if (lastOperator==Qt::Key_Asterisk) {
                                lastValue*=value();
                                setValue(lastValue);
                        } else if (lastOperator==Qt::Key_Slash && value()!=0) {
                                lastValue/=value();
                                setValue(lastValue);
                        }

                } else {
                        lastValue=value();
                }

                if (key==Qt::Key_Return) {
                        lastOperator=0;
                        lastValue=0;
                } else {
                        lastOperator=key;
                        setText("");
                }
        } else {
                if (key==Qt::Key_Return) {
                        QString t=text();
                        QScriptEngine myEngine;
                        QScriptValue result = myEngine.evaluate(t);
                        if (result.isNumber()) {
                                QString res;
                                if (t.length()>0 && t[0]=='+' && result.toNumber()>0) res='+';
                                res+=result.toString();
                                setText(res);
                        } else {
                                //TODO: display error
                        }

                }
        }
}

#include "skgcalculatoredit.moc"

